package com.ejianc.business.middlemeasurement.service;

import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;

import java.util.List;

/**
 * 月度机械设备租赁单
 *
 * @author generator
 *
 */
public interface IMechanicalleaseService extends IBaseService<MechanicalleaseEntity> {
    /**
     * 更新单据数据的归集状态
     * @param projectId  项目id
     * @param state     状态
     * @return
     */
    boolean updateSettlementState(Long projectId,Integer state,String monthStr);
    /***
     * @Description //TODO 查询单据数据是否被月度成本分析归集
     *
     * @param projectId 项目id
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean queryIsSettlement(Long projectId,String monthStr);

    MechanicalleasedetailVO queryCumulative(Long projectId, Long contractId,String equipmentCode);

    List<MechanicalleasedetailVO> querySumById(List<MechanicalleasedetailVO> vos);
}
