package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.ConsultotherEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetotalEntity;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.MechanicalleaseMapper;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;

import java.util.List;

/**
 * 月度机械设备租赁单
 *
 * @author generator
 *
 */
@Service("mechanicalleaseService")
public class MechanicalleaseServiceImpl extends BaseServiceImpl<MechanicalleaseMapper, MechanicalleaseEntity> implements IMechanicalleaseService{
    @Autowired
    private IMechanicalleaseService service;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<MechanicalleaseEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( settlement_time, '%Y-%m' )",monthStr);
        List<MechanicalleaseEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (MechanicalleaseEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<MechanicalleaseEntity> query = new LambdaQueryWrapper<MechanicalleaseEntity>()
                .eq(MechanicalleaseEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(settlement_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(MechanicalleaseEntity::getIsSettlement)
                        .or().eq(MechanicalleaseEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("月度机械设备租赁单有往期未归集的数据");
        LambdaQueryWrapper<MechanicalleaseEntity> query1 = new LambdaQueryWrapper<MechanicalleaseEntity>()
                .eq(MechanicalleaseEntity::getProjectId, projectId)
                .ne(MechanicalleaseEntity::getBillState, 3)
                .ne(MechanicalleaseEntity::getBillState, 1)
                .apply("DATE_FORMAT(settlement_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("月度机械设备租赁单有本期审批未通过的数据");
        return true;
    }

    @Override
    public List<MechanicalleasedetailVO> querySumById(List<MechanicalleasedetailVO> list) {
        if (CollectionUtils.isNotEmpty(list)){
            for (MechanicalleasedetailVO mechanicalleasedetailVO : list){


            }

        }
        return null;
    }

    @Override
    public MechanicalleasedetailVO queryCumulative(Long projectId, Long contractId, String equipmentCode) {
        MechanicalleasedetailVO vo = baseMapper.queryCumulative(projectId, contractId, equipmentCode);
        return vo;
    }
}
