package com.ejianc.business.middlemeasurement.controller.api;


import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/11/28
 * @description:查询分包月度报量及申请报告相关api
 */
@RestController
@RequestMapping("/api/subcontractingvolume")
public class SubcontractingvolumeApiController implements Serializable {
    @Autowired
    private ISubcontractingvolumeService service;
    /**
     * 根据合同id查询所有的分包月度报量及申请报告的子表数据
     * 查到数据汇总累计工程量，汇总累计含税金额和不含税金额
     * 本期相关数据只查询不汇总
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/querySubcontractingvolumeDetailByContractId", method = RequestMethod.GET)
    public CommonResponse<List<SettlementBookStatementDetailVO>> querySubcontractingvolumeDetailByContractId(@RequestParam(value = "contractId") Long contractId) {
        List<SettlementBookStatementDetailVO> settlementBookStatementDetailVOS = service.querySubcontractingvolumeDetailByContractId(contractId);
        return CommonResponse.success("查询分包月度报量子表成功",settlementBookStatementDetailVOS);
    }
    /**
     * 根据合同id查询所有的分包月度报量及申请报告的物资节超子表数据
     * 查到数据汇总数量相关数据
     * @param contractId 合同id
     * @return
     */
    @RequestMapping(value = "/querySubcontractingvolumeByContractId", method = RequestMethod.GET)
    public CommonResponse<List<SettlementBookMaterialDetailVO>> querySubcontractingvolumeByContractId(@RequestParam(value = "contractId") Long contractId) {
        List<SettlementBookMaterialDetailVO> settlementBookMaterialDetailVOS = service.querySubcontractingvolumeMaterialByContractId(contractId);
        int sort = 1;
        for (SettlementBookMaterialDetailVO settlementBookMaterialDetailVO : settlementBookMaterialDetailVOS) {
            settlementBookMaterialDetailVO.setId(IdWorker.getId());
            settlementBookMaterialDetailVO.setSort(Long.valueOf(sort));
            sort++;
        }
        return CommonResponse.success("查询分包月度报量物资节超成功",settlementBookMaterialDetailVOS);
    }
    /**
     * 根据合同id查询以往所有的分包月度报量及申请报告的其他扣款数据
     * @param contractId 合同id
     * @return
     */
    @RequestMapping(value = "/querySubcontractingvolumeOtherByContractId", method = RequestMethod.GET)
    public CommonResponse<List<SettlementBookOtherDetailVO>> querySubcontractingvolumeOtherByContractId(@RequestParam(value = "contractId") Long contractId){
        List<SettlementBookOtherDetailVO> settlementBookOtherDetailVOS = service.querySubcontractingvolumeOtherByContractId(contractId);
        int sort = 1;
        for (SettlementBookOtherDetailVO settlementBookOtherDetailVO : settlementBookOtherDetailVOS) {
            settlementBookOtherDetailVO.setSort(Long.valueOf(sort));
            sort++;
        }
        return CommonResponse.success("查询分包月度报量其他扣款成功",settlementBookOtherDetailVOS);
    }
}
