package com.ejianc.business.middlemeasurement.service;

import com.ejianc.business.middlemeasurement.vo.ConsultotherVO;
import com.ejianc.business.middlemeasurement.vo.ConsultotherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinalOtherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinaldetailVO;
import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.middlemeasurement.bean.ConsultotherEntity;

import java.util.List;

/**
 * 咨询及其他类合同过程结算单
 * 
 * @author generator
 * 
 */
public interface IConsultotherService extends IBaseService<ConsultotherEntity> {
    /**
     * 根据合同id查询咨询类合价和金额
     * @param projectId
     * @return
     */
    List<CostManageVO> queryConsultother(Long projectId,String monthStr);
    /**
     * 根据合同id和月份查询咨询类合价和金额
     * @param projectId
     * @param monthStr
     * @return
     */

    List<CostManageVO> queryConsultotherMonth(Long projectId,String monthStr);

    /**
     * 查询资讯类往期数据
     * @param vo
     * @return
     */
    ConsultotherdetailVO queryConsultotherPastData(ConsultotherdetailVO vo);

    /**
     * 根据合同id和报量时间查询其他扣款往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    List<ConsultfinalOtherdetailVO> queryConsultOtherDetailCumPast(Long contractId, String date);


    /**
     * 根据合同id和报量时间查询子表往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    List<ConsultfinaldetailVO> queryConsultDetailCumPast(Long contractId, String date);

   /***
    * @Description //TODO 更新单据的是否归集状态字段数据
    *
    * @param projectId 项目id
    * @param state 需要更新的是否归集状态
    * @param monthStr 月份时间范围
    * @return boolean
    * @createDate 2023/1/12
    * @author yupengjie
    **/
    boolean updateSettlementState(Long projectId,Integer state,String monthStr);
   /***
    * @Description //TODO 查询单据数据是否被月度成本分析归集
    *
    * @param projectId 项目id
    * @param monthStr  月份时间范围
    * @return boolean
    * @createDate 2023/1/12
    * @author yupengjie
    **/
    boolean queryIsSettlement(Long projectId,String monthStr);
    /***
     * @Description //TODO
     * 查询咨询类过程结算单的计价明细的往期数据
     * @param contractId 合同id
     * @param monthStr   报量日期  日期格式化为 yyyy-MM
     * @param subitemName  编码名称
     * @param spec    规格及特征
     * @param unit   单位
     * @param unitprice  除税单价
     * @param taxUnitprice  含税单价
     * @return java.util.List<com.ejianc.business.middlemeasurement.vo.ConsultotherdetailVO>
     * @createDate 2023/2/3
     * @author yupengjie
     **/
    List<ConsultotherdetailVO> queryConsultotherdetail(String contractId,String monthStr,String subitemName,String spec,String unit,String unitprice,String taxUnitprice);
}
