package com.ejianc.business.middlemeasurement.service;

import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodedetailEntity;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import com.ejianc.foundation.middlemeasurement.vo.DesignSettlementDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodeEntity;

import java.math.BigDecimal;
import java.util.List;

/**
 * 设计分包节点报量申请
 * 
 * @author generator
 * 
 */
public interface IDesignsubcontractnodeService extends IBaseService<DesignsubcontractnodeEntity> {
    /**
     * 根据合同id查询设计分包节点申请报量合价和金额
     * @param projectId
     * @return
     */
    List<CostManageVO> queryDesign(Long projectId,String monthStr);

    /**
     * 根据合同id和月份查询计分包节点申请报量合价和金额
     * @param projectId
     * @param monthStr
     * @return
     */
    List<CostManageVO> queryDesignMonth(Long projectId,String monthStr);

    /**
     * 根据合同id和结算日期查询往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    List<DesignSettlementDetailVO> queryDesignDetailCumPast(Long contractId, String date);

    /**
     * 更新单据数据的归集状态
     * @param projectId  项目id
     * @param state     状态
     * @return
     */
    boolean updateSettlementState(Long projectId,Integer state,String monthStr);
    /***
     * @Description //TODO 查询单据数据是否被月度成本分析归集
     *
     * @param projectId 项目id
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean queryIsSettlement(Long projectId,String monthStr);
    /***
     * @Description //TODO
     * 查询涉及类过程结算单的子表往期数据
     * @param contract  合同id
     * @param monthStr  报量日期  日期格式化为 yyyy-MM
     * @param projectName 项目名称 子表项目名称非主表的项目名称
     * @param exTaxUnitThisDeclare   除税单价
     * @param inTaxUnitThisDeclare   含税单价
     * @return java.util.List<com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO>
     * @createDate 2023/2/3
     * @author yupengjie
     **/
    List<DesignsubcontractnodedetailVO> queryDesignsubcontractnodedetail(String contract,String monthStr,String projectName);

    //查询往期数据
    DesignsubcontractnodedetailVO queryDetailHistory(Long contract, String projectName, BigDecimal exTaxUnitLastAudit,BigDecimal inTaxUnitLastAudit);

}
