package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetailEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleaseVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.PurchasesettlementMapper;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 月度物资采购结算单
 * 
 * @author generator
 * 
 */
@Service("purchasesettlementService")
public class PurchasesettlementServiceImpl extends BaseServiceImpl<PurchasesettlementMapper, PurchasesettlementEntity> implements IPurchasesettlementService{
    @Autowired
    private IPurchasesettlementService purchasesettlementService;
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;
    @Override
    public PurchasesettlementVO getSumByContractId(Long contractId) {
        PurchasesettlementVO purchasesettlementVO = new PurchasesettlementVO();
        LambdaQueryWrapper<PurchasesettlementEntity> listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(PurchasesettlementEntity::getContractId, contractId);
        listWrapper.in(PurchasesettlementEntity::getBillState, "1,3");
        List<PurchasesettlementEntity> purchasesettlementEntities = super.list(listWrapper);
        if (CollectionUtils.isNotEmpty(purchasesettlementEntities)){
            BigDecimal sumMny = purchasesettlementEntities.stream().map(PurchasesettlementEntity::getMonthlyTotal)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumMnyTax = purchasesettlementEntities.stream().map(PurchasesettlementEntity::getTaxMonthlyTotal)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
            purchasesettlementVO.setSumMny(sumMny);
            purchasesettlementVO.setSumMnyTax(sumMnyTax);
        }
        return purchasesettlementVO;
    }

    @Override
    public PurchasesettlementVO getPurchaseDataById(PurchasesettlementVO purchasesettlementVO) {
        LambdaQueryWrapper<PurchasesettlementEntity> listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(PurchasesettlementEntity::getContractId, purchasesettlementVO.getContractId());
        listWrapper.in(PurchasesettlementEntity::getBillState, "1,3");
        List<PurchasesettlementEntity> purchasesettlementEntityList = super.list(listWrapper);
        Map<String, List<PurchasesettlementdetailEntity>> groupMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(purchasesettlementEntityList)){
            //主表id
            List<Long> ids = purchasesettlementEntityList.stream().map(PurchasesettlementEntity::getId).collect(Collectors.toList());

            LambdaQueryWrapper<PurchasesettlementdetailEntity> detailWrapper = Wrappers.lambdaQuery();
            detailWrapper.in(PurchasesettlementdetailEntity::getMid, ids);
            List<PurchasesettlementdetailEntity> mechanicalleasedetailEntityList = purchasesettlementdetailService.list(detailWrapper);
            if (CollectionUtils.isNotEmpty(mechanicalleasedetailEntityList)){
                //获取累计值
                groupMap = mechanicalleasedetailEntityList.stream().collect(
                        Collectors.groupingBy(s -> s.getBillCode()));
            }

        }
        List<PurchasesettlementdetailVO> purchasesettlementdetailEntities = purchasesettlementVO.getPurchasesettlementdetailEntities();
        if (CollectionUtils.isNotEmpty(purchasesettlementdetailEntities)){
            for (PurchasesettlementdetailVO purchasesettlementdetailVO : purchasesettlementdetailEntities){
                String key = purchasesettlementdetailVO.getBillCode();
                BigDecimal settlementPrice = purchasesettlementdetailVO.getSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSettlementPrice();
                BigDecimal taxSettlementPrice = purchasesettlementdetailVO.getTaxSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getTaxSettlementPrice();
                BigDecimal supplyQuantity = purchasesettlementdetailVO.getSupplyQuantity() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSupplyQuantity();
                //本期值
                BigDecimal settlementAmount = settlementPrice.multiply(supplyQuantity);
                BigDecimal taxSettlementAmount = taxSettlementPrice.multiply(supplyQuantity);
                purchasesettlementdetailVO.setSettlementAmount(settlementAmount);
                purchasesettlementdetailVO.setTaxSettlementAmount(taxSettlementAmount);
                //累计值
                purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity);
                purchasesettlementdetailVO.setSettlementTotal(settlementAmount);
                purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount);

                if (groupMap.containsKey(key)) {
                    List<PurchasesettlementdetailEntity> groupList = groupMap.get(key);
                    BigDecimal taxSettlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getTaxSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal settlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal supplyQuantitySum = groupList.stream().map(PurchasesettlementdetailEntity::getSupplyQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    purchasesettlementdetailVO.setSettlementTotal(settlementAmount.add(settlementAmountSum));
                    purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount.add(taxSettlementAmountSum));
                    purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity.add(supplyQuantitySum));

                    purchasesettlementdetailVO.setSettleNum(supplyQuantity.add(supplyQuantitySum));
                    purchasesettlementdetailVO.setSettleMny(settlementAmount.add(settlementAmountSum));
                    purchasesettlementdetailVO.setSettleMnyTax(taxSettlementAmount.add(taxSettlementAmountSum));
                }

            }

        }
        return purchasesettlementVO;
    }

}
