package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.ConsultotherEntity;
import com.ejianc.business.middlemeasurement.bean.ConsultotherdetailEntity;
import com.ejianc.business.middlemeasurement.service.IConsultotherService;
import com.ejianc.business.middlemeasurement.service.IConsultotherdetailService;
import com.ejianc.business.middlemeasurement.service.IConsultotherodetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 咨询及其他类合同过程结算单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("consultother")
public class ConsultotherController implements Serializable {
	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;

	@Autowired
	private IOutcontractApi outcontractApi;

	@Autowired
	private SessionManager sessionManager;

	private static final String BILL_CODE = "Subcontractingvolume_Open_Apply_Code";// 此处需要根据实际修改

	@Autowired
	private IConsultotherService service;
	@Autowired
	private IConsultotherdetailService consultotherdetailService;
	@Autowired
	private IConsultotherodetailService consultotherodetailService;

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<ConsultotherVO> saveOrUpdate(@RequestBody ConsultotherVO saveorUpdateVO) {
		ConsultotherEntity entity = BeanMapper.map(saveorUpdateVO, ConsultotherEntity.class);

		//校验：同一合同，只能存在一份自由态或审批中的单据
		checkBillStateUniq(entity.getId(), entity.getContractId(), true);

		//校验：单据编号唯一性
		entity = checkBillCodeUniq(entity);

		service.saveOrUpdate(entity, false);
		ConsultotherVO vo = BeanMapper.map(entity, ConsultotherVO.class);

		return CommonResponse.success("保存或修改单据成功！", vo);
	}

	/**
	 * 同一合同，只能存在一份自由态或审批中的单据
	 * @param id
	 * @param contractId
	 * @param isShowError 是否需要校验（初始化数据不需要，切换合同或保存需要）
	 */
	private void checkBillStateUniq(Long id, Long contractId, boolean isShowError) {
		//创建条件构造器
		QueryWrapper<ConsultotherEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", contractId);
		queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
		queryWrapper.eq("dr", "0");
		if(id != null){
			queryWrapper.ne("id", id);
		}
		List<ConsultotherEntity> pro = service.list(queryWrapper);
		if(pro != null && pro.size() > 0){
			throw new BusinessException("同一合同只能存在一份自由态或审批中的\"咨询及其他类合同过程结算单\"!");
		}
	}

	/**
	 * 单据编码唯一性校验
	 * @param entity
	 */
	private ConsultotherEntity checkBillCodeUniq(ConsultotherEntity entity) {
		if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
			if(billCode.isSuccess()) {
				entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}else {
			//单据编码唯一性
			QueryWrapper<ConsultotherEntity> queryWrapperBillCode = new QueryWrapper<>();
			queryWrapperBillCode.eq("bill_code", entity.getBillCode());
			queryWrapperBillCode.eq("dr", "0");
			Long id = entity.getId();
			if(id != null){
				queryWrapperBillCode.ne("id", id);
			}
			List<ConsultotherEntity> proBillCode = service.list(queryWrapperBillCode);
			if(proBillCode != null && proBillCode.size() > 0){
				throw new BusinessException("单据编码已存在，请重新录入!");
			}
		}

		return entity;
	}

	/**
	 * 页面子表新增参照合同价后
	 * 查询累计
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/refreshDetailData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> refreshDetailData(@RequestBody List<ConsultotherdetailVO> list, HttpServletResponse response) {
		JSONObject json = new JSONObject();
		for (int i = 0; i < list.size(); i++) {
			ConsultotherdetailVO consultotherdetailVO = list.get(i);
			String rowState = consultotherdetailVO.getRowState();
			if("add".equals(rowState)){
				//查询该清单编码往期累计
				//创建条件构造器
				QueryWrapper<ConsultotherdetailEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("contract_id", consultotherdetailVO.getContractId());
				queryWrapper.eq("subitem_name", consultotherdetailVO.getSubitemName());
				queryWrapper.eq("spec", consultotherdetailVO.getSpec());
				queryWrapper.eq("unit", consultotherdetailVO.getUnit());
				queryWrapper.eq("unitprice", consultotherdetailVO.getUnitprice());
				queryWrapper.eq("tax_unitprice", consultotherdetailVO.getTaxUnitprice());
				queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
				queryWrapper.orderByDesc("create_time");//最新往期
				queryWrapper.last("limit 1");
				List<ConsultotherdetailEntity> pastDetails = consultotherdetailService.list(queryWrapper);
				if(pastDetails != null && pastDetails.size() > 0) {
					ConsultotherdetailEntity pastSubcontractingvolumedetail = pastDetails.get(0);
					if (pastSubcontractingvolumedetail.getDr() == 0) {
						//数量（分包商上报累计）
						consultotherdetailVO.setCumulativeQuantity(pastSubcontractingvolumedetail.getCumulativeQuantity());
						//除税金额（分包商上报累计）
						consultotherdetailVO.setCumulativeAmounts(pastSubcontractingvolumedetail.getCumulativeAmounts());
						//含税金额（分包商上报累计）
						consultotherdetailVO.setCumulativeTaxAmounts(pastSubcontractingvolumedetail.getCumulativeTaxAmounts());
						//数量（项目部审核累计）
						consultotherdetailVO.setExamineCumulativeQuantity(pastSubcontractingvolumedetail.getExamineCumulativeQuantity());
						//除税金额（项目部审核累计）
						consultotherdetailVO.setExamineCumulativeAmounts(pastSubcontractingvolumedetail.getExamineCumulativeAmounts());
						//含税金额（项目部审核累计）
						consultotherdetailVO.setExamineCumulativeTaxAmounts(pastSubcontractingvolumedetail.getExamineCumulativeTaxAmounts());
					}
				}
				consultotherdetailVO.setRowState("edit");
				consultotherdetailVO.setId(IdWorker.getId());
			}
		}
		json.put("dataSource", list);

		return CommonResponse.success(json);
	}

	/**
	 * @Description  查询往期
	 * @param contractId
	 */
	@RequestMapping(value = "/pastData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ConsultotherVO> pastData(Long id, Long contractId, boolean isShowError) {
		if(isShowError){
			//校验：同一合同，只能存在一份自由态或审批中的单据
			checkBillStateUniq(id, contractId, isShowError);
		}

		//本期日期
		Date currentDate = new Date(System.currentTimeMillis());
		if(id != null && "".equals(id)){//更新
			ConsultotherEntity entity = service.selectById(id);
			currentDate = entity.getCreateTime();
		}

		return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
	}

	/**
	 * 获取往期审批通过的合计数据
	 *
	 * @param contractId 合同id
	 * @param currentDate 本期日期
	 */
	private ConsultotherVO getPastTotalData(Long contractId, Date currentDate) {
		//创建条件构造器
		QueryWrapper<ConsultotherEntity> queryWrapperTotal = new QueryWrapper<>();
		queryWrapperTotal.eq("contract_id", contractId);
		queryWrapperTotal.eq("dr", 0);
		queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
		queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
		queryWrapperTotal.orderByDesc("create_time");
		queryWrapperTotal.last("limit 1");

		List<ConsultotherEntity> proTotal = service.list(queryWrapperTotal);

		ConsultotherVO vo = new ConsultotherVO();
		if(proTotal != null && proTotal.size() > 0){
			ConsultotherEntity pastEntity = proTotal.get(0);
			vo = BeanMapper.map(pastEntity, ConsultotherVO.class);
		}

		vo.setContractId(contractId);
		return vo;
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ConsultotherVO> queryDetail(Long id) {
		ConsultotherEntity entity = service.selectById(id);
		ConsultotherVO vo = BeanMapper.map(entity, ConsultotherVO.class);
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<ConsultotherVO> vos) {
		service.removeByIds(vos.stream().map(ConsultotherVO::getId).collect(Collectors.toList()), true);
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @Description queryList 查询列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<ConsultotherVO>> queryList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		UserContext userContextCache =sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		}else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if(5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if(CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if(CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		IPage<ConsultotherEntity> page = service.queryPage(param, false);
		IPage<ConsultotherVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConsultotherVO.class));

		return CommonResponse.success("查询列表数据成功！", pageData);
	}

	/**
	 * @Description 导出
	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");
		param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.setPageIndex(1);
		param.setPageSize(-1);
		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		UserContext userContextCache =sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		}else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if(5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if(CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if(CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
		List<ConsultotherEntity> list = service.queryList(param);
		//时间转换
		List<ConsultotherVO> consultotherVOList = BeanMapper.mapList(list, ConsultotherVO.class);
		for (int i = 0; i < consultotherVOList.size(); i++) {
			ConsultotherVO consultotherVO = consultotherVOList.get(i);
			consultotherVO.setSort(String.valueOf(i+1));
			if (consultotherVO.getReportingTime()!=null){
				consultotherVO.setReportingTimeShow(DateUtils.dateSimple2(consultotherVO.getReportingTime()));
			}

			String billStateStr = consultotherVO.getBillState().toString();
			if (billStateStr != null){
				if("0".equals(billStateStr)){//自由态
					billStateStr = "自由态";
				}else if("1".equals(billStateStr)){//已提交
					billStateStr = "已提交";
				}else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
					billStateStr = "审批中";
				}else if("3".equals(billStateStr)){//审批通过
					billStateStr = "审批通过";
				}else if("4".equals(billStateStr)){//驳回
					billStateStr = "驳回";
				}

				consultotherVO.setBillStateStr(billStateStr);
			}
		}
		// todo:字段翻译等等
		Map<String, Object> beans = new HashMap<>();
		beans.put("records", consultotherVOList);
		ExcelExport.getInstance().export("consultother-export.xlsx", beans, response);
	}

	/**
	 * 获取RPC数据
	 * resp 返回值
	 * isMustSuc 是否必须成功
	 * errMsg 失败提示
	 */
	private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
		if(isMustSuc && !resp.isSuccess()) {
			throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
		}
		return resp.getData();
	}


	/**
	 * @Description 参照
	 * @param
	 * @Return void
	 */
	@RequestMapping(value = "/refSubcontractingvolumeData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<ConsultotherVO>> refSubcontractingvolumeData(@RequestParam Integer pageNumber,
			@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
		QueryParam param = new QueryParam();
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");

		param.setPageSize(pageSize);
		param.setPageIndex(pageNumber);
		param.setSearchText(searchText);
		param.setSearchObject(searchObject);
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if (StringUtils.isNotEmpty(condition)) {
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
			if(_con.get("projectId")!=null){
				param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
			}
		}

		//未被引用
		param.getParams().put("isReference", new Parameter(QueryParam.EQ, 0));

		//审批通过
		param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
		param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));

		IPage<ConsultotherEntity> page = service.queryPage(param, false);
		IPage<ConsultotherVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<ConsultotherVO> consultotherVOList = BeanMapper.mapList(page.getRecords(), ConsultotherVO.class);

		pageData.setRecords(consultotherVOList);

		return CommonResponse.success("查询参照数据成功！", pageData);
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode, Map<String, ConsultotherdetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找
			if (pcode.length() == 2) {
				//最上级
				return null;
			} else if (pcode.length() == 4) {
				String ppcode = pcode.substring(0, 2);
				return this.setPid(ppcode, map);
			} else if (pcode.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode, map);
			} else if (pcode.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode, map);
			} else {
				return null;
			}
		}
	}
}
