package com.ejianc.business.middlemeasurement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.middlemeasurement.bean.ConsultotherEntity;
import com.ejianc.business.middlemeasurement.service.IConsultotherService;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/consultother")
public class ConsultotherApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IConsultotherService service;

    /**
     * @Return void
     */
    @RequestMapping(value = "/queryListByCont", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ConsultotherVO>> queryListByCont(@RequestParam(value = "contractId") Long contractId) {
        LambdaQueryWrapper<ConsultotherEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ConsultotherEntity::getContractId, contractId);
        List<ConsultotherEntity> list = service.list(queryWrapper);
        List<ConsultotherVO> resp = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ConsultotherEntity entity : list) {
                resp.add(BeanMapper.map(service.selectById(entity.getId()), ConsultotherVO.class));
            }
        }
        return CommonResponse.success("查询数据成功！", resp);
    }
}
