package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.ConsultotherodetailEntity;
import com.ejianc.business.middlemeasurement.bean.ConsultotherdetailEntity;
import com.ejianc.business.middlemeasurement.service.IConsultotherService;
import com.ejianc.business.middlemeasurement.service.IConsultotherodetailService;
import com.ejianc.business.middlemeasurement.service.IConsultotherdetailService;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherodetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 咨询及其他类合同过程结算单导入导出
 */
@Controller
@RequestMapping("consultotherExport")
public class ExcelConsultotherController {

	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IConsultotherdetailService consultotherdetailService;
	@Autowired
	private IConsultotherodetailService consultotherodetailService;
	@Autowired
	private IConsultotherService service;
	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download", method = RequestMethod.POST)
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "consultotherdetail-import.xlsx", "咨询及其他类合同过程结算单-最终结算计价明表");
	}

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download3", method = RequestMethod.POST)
	@ResponseBody
	public void download3(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "consultotherodetail-import.xlsx", "其它扣款清单");
	}

	/**
	 * excel导入
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData(HttpServletRequest request, HttpServletResponse response, String contractId,String monthStr)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ConsultotherdetailVO> successList = new ArrayList<>();
		List<ConsultotherdetailVO> errorList = new ArrayList<>();
		Map<String, ConsultotherdetailVO> map = new HashMap<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 3; i < result.size(); i++) {
					List<String> datas = result.get(i);
					StringBuilder errorsMsgBuilder = new StringBuilder();
					String subitemName = datas.get(0);//名称
					String spec = datas.get(1);//规格
					String unit = datas.get(2);//单位
					String unitprice = datas.get(3);//除税单价（分包商上报：本期）
					String taxUnitprice = datas.get(4);//含税单价（分包商上报：本期）
					String examineQuantity = datas.get(5);//数量（项目部审批：本期）
					String memo = datas.get(6);//备注
					ConsultotherdetailVO detailVO = new ConsultotherdetailVO();
					detailVO.setId(IdWorker.getId());//id
					detailVO.setTid(String.valueOf(IdWorker.getId()));//tid
					detailVO.setContractId(Long.parseLong(contractId));//合同id
					detailVO.setSubitemName(subitemName); // 名称
					detailVO.setSpec(spec); // 规格
					detailVO.setUnit(unit); //单位
					/*if("合同内".equals(source)){
						detailVO.setSource("1"); //来源
					}else if("合同外".equals(source)){
						detailVO.setSource("2"); //来源
					}*/
					detailVO.setMemo(memo); //备注
					//必填项校验
					if (subitemName == null || TextUtils.isEmpty(subitemName)) {
						detailVO.setErrorMsg("名称不能为空！");
						errorsMsgBuilder.append("名称不能为空！");
					}
					if (spec == null || TextUtils.isEmpty(spec)) {
						detailVO.setErrorMsg("规格及特征不能为空！");
						errorsMsgBuilder.append("规格及特征不能为空！");
					}
					if (unit == null || TextUtils.isEmpty(unit)) {
						detailVO.setErrorMsg("单位不能为空！");
						errorsMsgBuilder.append("单位不能为空！");
					}

					if (unitprice == null || TextUtils.isEmpty(unitprice)) {
						detailVO.setErrorMsg("除税单价不能为空！");
						errorsMsgBuilder.append("除税单价不能为空！");
					}
					if (taxUnitprice == null || TextUtils.isEmpty(taxUnitprice)) {
						detailVO.setErrorMsg("含税单价不能为空！");
						errorsMsgBuilder.append("含税单价不能为空！");
					}
					if (examineQuantity == null || TextUtils.isEmpty(examineQuantity)) {
						detailVO.setErrorMsg("数量（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("数量（项目部审批：本期）不能为空！");
					}

					if (StringUtils.isNotBlank(unitprice)) {
						if(!NumberUtil.isNumber(unitprice)){
							detailVO.setErrorMsg("除税单价格式不正确！");
							errorsMsgBuilder.append("除税单价格式不正确！");
						}else {
							detailVO.setUnitprice(new BigDecimal(unitprice));
						}
					}

					if (StringUtils.isNotBlank(taxUnitprice)) {
						if(!NumberUtil.isNumber(taxUnitprice)){
							detailVO.setErrorMsg("含税单价格式不正确！");
							errorsMsgBuilder.append("含税单价格式不正确！");
						}else {
							detailVO.setTaxUnitprice(new BigDecimal(taxUnitprice));
						}
					}

					if (StringUtils.isNotBlank(examineQuantity)) {
						if(!NumberUtil.isNumber(examineQuantity)){
							detailVO.setErrorMsg("数量（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("数量（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineQuantity(new BigDecimal(examineQuantity));
						}
					}
					//除税单价 unitprice  含税单价 taxUnitprice
					//本期   除税金额 	examineAmounts    含税金额 examineTaxAmounts   数量  examineQuantity
					//累计 数量 examineCumulativeQuantity  除税金额 examineCumulativeAmounts  含税金额 examineCumulativeTaxAmounts
					detailVO.setExamineAmounts(ComputeUtil.safeMultiply(detailVO.getExamineQuantity(),detailVO.getUnitprice()));
					detailVO.setExamineTaxAmounts(ComputeUtil.safeMultiply(detailVO.getExamineQuantity(),detailVO.getTaxUnitprice()));
					//抓取子表累计值
					if(StringUtils.isNotBlank(subitemName)){
						//导入的本期
						BigDecimal examineQuantityB = detailVO.getExamineQuantity();
						BigDecimal examineAmountsB = detailVO.getExamineAmounts();
						BigDecimal examineTaxAmountsB = detailVO.getExamineTaxAmounts();
						//查询该清单编码往期累计
						List<ConsultotherdetailVO> pastDetails = service.queryConsultotherdetail(contractId,monthStr,subitemName,spec,unit,unitprice,taxUnitprice);
						if(pastDetails != null && pastDetails.size() > 0){
							ConsultotherdetailVO pastConsultotherdetail = pastDetails.get(0);

							BigDecimal pastExamineQuantityB = pastConsultotherdetail.getExamineCumulativeQuantity();//累计 数量
							BigDecimal pastExamineAmountsB = pastConsultotherdetail.getExamineCumulativeAmounts();//除税金额
							BigDecimal pastExamineTaxAmountsB = pastConsultotherdetail.getExamineCumulativeTaxAmounts();//examineCumulativeTaxAmounts

							if(examineQuantityB != null){
								pastExamineQuantityB = pastExamineQuantityB.add(examineQuantityB);
							}
							if(examineAmountsB != null){
								pastExamineAmountsB = pastExamineAmountsB.add(examineAmountsB);
							}
							if(examineTaxAmountsB != null){
								pastExamineTaxAmountsB = pastExamineTaxAmountsB.add(examineTaxAmountsB);
							}
							//数量（项目部审核累计）
							detailVO.setExamineCumulativeQuantity(pastExamineQuantityB);
							//除税金额（项目部审核累计）
							detailVO.setExamineCumulativeAmounts(pastExamineAmountsB);
							//含税金额（项目部审核累计）
							detailVO.setExamineCumulativeTaxAmounts(pastExamineTaxAmountsB);
						}else {
							if(examineQuantityB != null){
								detailVO.setExamineCumulativeQuantity(examineQuantityB);
							}
							if(examineAmountsB != null){
								detailVO.setExamineCumulativeAmounts(examineAmountsB);
							}
							if(examineTaxAmountsB != null){
								detailVO.setExamineCumulativeTaxAmounts(examineTaxAmountsB);
							}
						}

					}

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(detailVO);
					} else {
						successList.add(detailVO);
					}
				}
			}
		}
		//设置tid和tpid
		List<ConsultotherdetailVO> resList = setTidAndTpid(successList, map);
		//构建树
		resList = createTreeData(resList);

		//统计父级的合计数值
//		getChildrenUnitTotalAmount(resList);

		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", resList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导入其它扣款清单
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import3", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData3(HttpServletRequest request, HttpServletResponse response)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ConsultotherodetailVO> successList = new ArrayList<>();
		List<ConsultotherodetailVO> errorList = new ArrayList<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 1; i < result.size(); i++) {
					StringBuilder errorsMsgBuilder = new StringBuilder();
					ConsultotherodetailVO vo = new ConsultotherodetailVO();

					List<String> datas = result.get(i);
					String expenseName = datas.get(0);//费用名称
					String unit = datas.get(1);//单位
					String quantity = datas.get(2);//数量
					String unitPrice = datas.get(3);//(除税)单价
					String unitTaxPrice = datas.get(4);//(含税)单价
					String remarks = datas.get(5);//备注
					vo.setId(IdWorker.getId());
					vo.setExpenseName(expenseName);
					vo.setUnit(unit);
					vo.setRemarks(remarks);
					//格式校验
					if(StringUtils.isNotBlank(quantity)){
						if(NumberUtil.isNumber(quantity)){
							vo.setoQuantity(new BigDecimal(quantity));
						}else {
							vo.setErrorMsg("数量格式不正确！");
							errorsMsgBuilder.append("数量格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(unitPrice)){
						if(NumberUtil.isNumber(unitPrice)){
							vo.setoUnitPrice(new BigDecimal(unitPrice));
						}else {
							vo.setErrorMsg("(除税)单价格式不正确！");
							errorsMsgBuilder.append("(除税)单价格式不正确！");
						}
					}
					if(StringUtils.isNotBlank(unitTaxPrice)){
						if(NumberUtil.isNumber(unitTaxPrice)){
							vo.setoTaxUnitPrice(new BigDecimal(unitTaxPrice));
						}else {
							vo.setErrorMsg("(含税)单价格式不正确！");
							errorsMsgBuilder.append("(含税)单价格式不正确！");
						}
					}

					vo.setAmounts(ComputeUtil.safeMultiply(vo.getoQuantity(),vo.getoUnitPrice()));
					vo.setTaxAmounts(ComputeUtil.safeMultiply(vo.getoQuantity(),vo.getoTaxUnitPrice()));

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(vo);
					} else {
						successList.add(vo);
					}
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export", method = RequestMethod.POST)
	@ResponseBody
	public void export(@RequestBody ConsultotherVO consultotherVO, HttpServletResponse response) {
		QueryWrapper<ConsultotherdetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", consultotherVO.getId());
		queryWrapper.eq("dr", 0);
		List<ConsultotherdetailEntity> list = consultotherdetailService.list(queryWrapper);
		List<ConsultotherdetailVO> voList = BeanMapper.mapList(list, ConsultotherdetailVO.class);
		List<ConsultotherdetailVO> records = new ArrayList<>();

		//构建树
		voList = createTreeData(voList);

		for(ConsultotherdetailVO vo : voList){
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("consultotherdetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage(@RequestBody List<ConsultotherdetailVO> list, HttpServletResponse response) {
		List<ConsultotherdetailVO> records = new ArrayList<>();
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				ConsultotherdetailVO vo = list.get(i);
				String source = vo.getSource();
				if("1".equals(source)){//来源：1合同内 2合同外
					source = "合同内";
				}else if("2".equals(source)){
					source = "合同外";
				}
				vo.setSource(source);
				records.add(vo);
				if(vo.getChildren()!=null&&vo.getChildren().size()>0){
					this.splitList(vo.getChildren(),records);
				}
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("consultotherdetail-export.xlsx", beans, response);
	}

	/**
	 * 导出遍历加上所有子表
	 * @param list
	 * @param records
	 */
	private void splitList(List<ConsultotherdetailVO> list,List<ConsultotherdetailVO> records) {
		for(ConsultotherdetailVO vo : list){
			String source = vo.getSource();
			if("1".equals(source)){//来源：1合同内 2合同外
				source = "合同内";
			}else if("2".equals(source)){
				source = "合同外";
			}
			vo.setSource(source);
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export3", method = RequestMethod.POST)
	@ResponseBody
	public void export3(@RequestBody ConsultotherVO vo, HttpServletResponse response) {
		QueryWrapper<ConsultotherodetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", vo.getId());
		queryWrapper.eq("dr", 0);
		List<ConsultotherodetailEntity> list = consultotherodetailService.list(queryWrapper);
		List<ConsultotherodetailVO> vOList = BeanMapper.mapList(list, ConsultotherodetailVO.class);
		if (!CollectionUtil.isEmpty(vOList)) {
			for (int i = 0; i < vOList.size(); i++) {
				ConsultotherodetailVO linevo = vOList.get(i);
				linevo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", vOList);
		ExcelExport.getInstance().export("consultotherodetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage3", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage3(@RequestBody List<ConsultotherodetailVO> list, HttpServletResponse response) {
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				ConsultotherodetailVO vo = list.get(i);
				vo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("consultotherodetail-export.xlsx", beans, response);
	}

	/**
	 * 设置tid和tpid
	 *
	 * @param vos
	 * @param map
	 * @return
	 */
	private List<ConsultotherdetailVO> setTidAndTpid(List<ConsultotherdetailVO> vos, Map<String, ConsultotherdetailVO> map) {
		if(vos == null){
			return null;
		}

		for (int i = 0; i < vos.size(); i++) {
			ConsultotherdetailVO consultotherdetailVO = vos.get(i);
			//设置父级id
			String innercode = consultotherdetailVO.getInnercode();
			if(innercode == null){
				continue;
			}
			Long pid = null;
			if (innercode.length() == 2) {
				//最上级
			} else if (innercode.length() == 4) {
				String pcode = innercode.substring(0, 2);
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercode.length() == 6) {
				String pcode = innercode.substring(0, 4);
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercode.length() > 6) {
				String pcode = innercode.substring(0, 6);
				//有父节点
				pid = this.setPid(pcode, map);
			}

			if (pid != null) {
				consultotherdetailVO.setTpid(pid.toString());
			} else {
				consultotherdetailVO.setTpid("");
			}
		}

		return vos;
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode, Map<String, ConsultotherdetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找

			if (pcode.length() == 2) {
				//最上级
				return null;
			} else if (pcode.length() == 4) {
				String ppcode = pcode.substring(0, 2);
				return this.setPid(ppcode, map);
			} else if (pcode.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode, map);
			} else if (pcode.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode, map);
			} else {
				return null;
			}
		}
	}

	/**
	 * 构建树
	 *
	 * @param list
	 * @return
	 */
	public static List<ConsultotherdetailVO> createTreeData(List<ConsultotherdetailVO> list) {
		List<ConsultotherdetailVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, ConsultotherdetailVO> listMap = new HashMap<>();
		for (ConsultotherdetailVO item : list) {
			listMap.put(item.getTid().toString(), item);
		}

		for (int i = 0; i < list.size(); i++) {
			ConsultotherdetailVO item = list.get(i);
			String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
			ConsultotherdetailVO parent = listMap.get(parentId);
			if (parent != null) {
				List<ConsultotherdetailVO> child = (List<ConsultotherdetailVO>) parent.getChildren();
				if (child != null) {
					child.add(item);
				} else {
					List<ConsultotherdetailVO> children = new ArrayList<ConsultotherdetailVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getTid());
			}
		}

		for (String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}
}
