package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumemdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeodetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumemdetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeodetailService;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumemdetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeodetailVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包月度报量及申请报告导入导出
 */
@Controller
@RequestMapping("subcontractingvolumeExport")
public class ExcelSubcontractingvolumeController {

	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private ISubcontractingvolumeService service;
	@Autowired
	private ISubcontractingvolumedetailService subcontractingvolumedetailService;
	@Autowired
	private ISubcontractingvolumemdetailService subcontractingvolumemdetailService;
	@Autowired
	private ISubcontractingvolumeodetailService subcontractingvolumeodetailService;
	@Autowired
	private IOutcontractApi outcontractApi;

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download", method = RequestMethod.POST)
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "subcontractingvolumedetail-import.xlsx", "分包月度报量及申请报告");
	}
	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download2", method = RequestMethod.POST)
	@ResponseBody
	public void download2(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "subcontractingvolumemdetail-import.xlsx", "物资代扣及超用扣款清单");
	}
	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download3", method = RequestMethod.POST)
	@ResponseBody
	public void download3(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "subcontractingvolumeodetail-import.xlsx", "其它扣款清单");
	}

	/**
	 * excel导入
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData(HttpServletRequest request, HttpServletResponse response,Long selectContractId,String monthStr)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<SubcontractingvolumedetailVO> successList = new ArrayList<>();
		List<SubcontractingvolumedetailVO> errorList = new ArrayList<>();
		Map<String, SubcontractingvolumedetailVO> map = new HashMap<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
		/*	//获取往期累计数据
			QueryWrapper<SubcontractingvolumedetailEntity> queryWrapperNum = new QueryWrapper<>();
			queryWrapperNum.eq("contract_id", selectContractId);
			queryWrapperNum.in("bill_state", 1, 3);//1直审 3审批通过
			queryWrapperNum.eq("dr", "0");
			List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntityList = subcontractingvolumedetailService.list(queryWrapperNum);
			Map<String, List<SubcontractingvolumedetailEntity>> groupMap = new HashMap<>();
//			Map<String, List<SubcontractingvolumedetailEntity>> numMap = new HashMap<>();
			if(CollectionUtils.isNotEmpty(subcontractingvolumedetailEntityList)){
				groupMap = subcontractingvolumedetailEntityList.stream().collect(
						Collectors.groupingBy(
								s -> s.getSubitemCode() +'-' + s.getSection() +'-' + s.getExamineUnitprice() +'-' + s.getExamineTaxUnitprice()
						));

			}*/

			CommonResponse<OutcontractVO> outcontractVOCommonResponse = outcontractApi.queryDetail(selectContractId);
			if(!outcontractVOCommonResponse.isSuccess()) {
				throw new BusinessException("获取合同信息失败" + outcontractVOCommonResponse.getMsg());
			}
			OutcontractVO outcontractVO = outcontractVOCommonResponse.getData();
			List<OutcontractSubcontractUnitPriceVO> outcontractSubcontractUnitPriceList = outcontractVO.getOutcontractSubcontractUnitPriceList();
			Map<String, List<OutcontractSubcontractUnitPriceVO>> contractListCodeMap = outcontractSubcontractUnitPriceList.stream().collect(
					Collectors.groupingBy(
							s -> s.getListCode()
					));
//			Map<String, OutcontractSubcontractUnitPriceVO> contractListCodeMap = outcontractSubcontractUnitPriceList.stream().collect(Collectors.toMap(OutcontractSubcontractUnitPriceVO::getListCode,Function.identity()));

			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 3; i < result.size(); i++) {
					List<String> datas = result.get(i);
					StringBuilder errorsMsgBuilder = new StringBuilder();

					String subitemCode = datas.get(0);//清单编号
					String section = datas.get(1);//区段
					String subitemName = datas.get(2);//清单项目名称
					String subitemDesc = datas.get(3);//子目特征描述
					String unit = datas.get(4);//单位
					String examineQuantity = datas.get(5);//数量（分包商上报：本期）
					String examineUnitprice = datas.get(6);//除税单价（分包商上报：本期）
					String examineTaxUnitprice = datas.get(7);//含税单价（分包商上报：本期）
					BigDecimal examineQuantityNum = BigDecimal.ZERO;
					if (StringUtils.isNotEmpty(examineQuantity)) {
						examineQuantityNum = new BigDecimal(examineQuantity);
					}
					BigDecimal examineUnitpriceNum = BigDecimal.ZERO;
					if (StringUtils.isNotEmpty(examineUnitprice)) {
						examineUnitpriceNum = new BigDecimal(examineUnitprice);
					}
					BigDecimal examineTaxUnitpriceNum = BigDecimal.ZERO;
					if (StringUtils.isNotEmpty(examineTaxUnitprice)) {
						examineTaxUnitpriceNum = new BigDecimal(examineTaxUnitprice);
					}
					BigDecimal examineAmounts = examineQuantityNum.multiply(examineUnitpriceNum);
					BigDecimal examineTaxAmounts = examineQuantityNum.multiply(examineTaxUnitpriceNum);
					String memo = datas.get(8);//备注

					SubcontractingvolumedetailVO detailVO = new SubcontractingvolumedetailVO();
					detailVO.setId(IdWorker.getId());//id
					detailVO.setTid(String.valueOf(IdWorker.getId()));//tid
					detailVO.setContractId(selectContractId);//合同id

					detailVO.setSubitemCode(subitemCode); // 清单编号\
					detailVO.setSection(section);
					detailVO.setSubitemName(subitemName); // 清单项目名称
					detailVO.setSubitemDesc(subitemDesc);//子目特征描述
					detailVO.setUnit(unit); //单位

					CommonResponse<List<OutcontractSubcontractUnitPriceVO>> outcontractResp = outcontractApi.queryListBycontractIdAndCode(detailVO.getContractId(),detailVO.getSubitemCode());
					List<OutcontractSubcontractUnitPriceVO> voList = outcontractResp.getData();
					if(voList != null && voList.size() > 0){
						detailVO.setSource("1");//合同内
					}else{
						detailVO.setSource("2");//合同外
					};
					detailVO.setMemo(memo); //备注

					//必填项校验
					if (subitemCode == null || TextUtils.isEmpty(subitemCode)) {
						detailVO.setErrorMsg("清单编号不能为空！");
						errorsMsgBuilder.append("清单编号不能为空！");
					}
					if (section == null || TextUtils.isEmpty(section)) {
						detailVO.setErrorMsg("区段不能为空！");
						errorsMsgBuilder.append("区段不能为空！");
					}
					if (subitemName == null || TextUtils.isEmpty(subitemName)) {
						detailVO.setErrorMsg("清单项目名称不能为空！");
						errorsMsgBuilder.append("清单项目名称不能为空！");
					}
					if (unit == null || TextUtils.isEmpty(unit)) {
						detailVO.setErrorMsg("单位不能为空！");
						errorsMsgBuilder.append("单位不能为空！");
					}
					if (examineQuantity == null || TextUtils.isEmpty(examineQuantity)) {
						detailVO.setErrorMsg("数量（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("数量（项目部审批：本期）不能为空！");
					}
					if (examineUnitprice == null || TextUtils.isEmpty(examineUnitprice)) {
						detailVO.setErrorMsg("除税单价（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("除税单价（项目部审批：本期）不能为空！");
					}
					if (examineTaxUnitprice == null || TextUtils.isEmpty(examineTaxUnitprice)) {
						detailVO.setErrorMsg("含税单价（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("含税单价（项目部审批：本期）不能为空！");
					}

					if (StringUtils.isNotBlank(subitemCode)) {
						detailVO.setInnercode(subitemCode+ "_" + section);//清单编号确定唯一性
//						if ("01".equals(subitemCode) && subitemName != null && subitemName.contains("装饰")) {
//							detailVO.setInnercode("a1"+ "_" + detailVO.getSection());
//						}
						//判断是否是装饰工程的子节点编码
//						if (subitemCode.length() >= 4) {
//							//0111、0112、0113、0114、0115这五个节点都是装饰工程下的
//							String code = subitemCode.substring(0, 4);
//							if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
//								//若是的话，将内码改为a1xx
//								detailVO.setInnercode("a1" + subitemCode.substring(2, subitemCode.length()) + "_" + section);
//							}
//						}
						//1、校验编码是否符合规则--2、4、6、9、9以上
						if (subitemCode == null || !(subitemCode.length() == 2 || subitemCode.length() == 4 || subitemCode.length() == 6 || subitemCode.length() >= 9)) {
							detailVO.setErrorMsg("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则");
							errorsMsgBuilder.append("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则！");
						}
						detailVO.setSubitemCode(subitemCode);

						//重复性校验
						SubcontractingvolumedetailVO mapVO = map.get(detailVO.getInnercode());
						if (mapVO == null) {
							map.put(detailVO.getInnercode(), detailVO);
						} else {
							detailVO.setErrorMsg("清单编号已存在！");
							errorsMsgBuilder.append("清单编号已存在！");
						}
						detailVO.setSubitemCode(subitemCode);
					}

					if (StringUtils.isNotBlank(examineQuantity)) {
						if(!NumberUtil.isNumber(examineQuantity)){
							detailVO.setErrorMsg("数量（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("数量（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineQuantity(new BigDecimal(examineQuantity));
						}
					}

					if (StringUtils.isNotBlank(examineUnitprice)) {
						if(!NumberUtil.isNumber(examineUnitprice)){
							detailVO.setErrorMsg("除税单价（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("除税单价（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineUnitprice(new BigDecimal(examineUnitprice));
						}
					}

					if (StringUtils.isNotBlank(examineTaxUnitprice)) {
						if(!NumberUtil.isNumber(examineTaxUnitprice)){
							detailVO.setErrorMsg("含税单价（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("含税单价（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineTaxUnitprice(new BigDecimal(examineTaxUnitprice));
						}
					}
					detailVO.setExamineAmounts(examineAmounts);
					detailVO.setExamineTaxAmounts(examineTaxAmounts);



					//查询往期累计
					QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("contract_id", detailVO.getContractId());
					queryWrapper.eq("subitem_code", detailVO.getSubitemCode());
					queryWrapper.eq("section", detailVO.getSection());
					queryWrapper.eq("examine_unitprice", detailVO.getExamineUnitprice());
					queryWrapper.eq("examine_tax_unitprice", detailVO.getExamineTaxUnitprice());
					queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
					queryWrapper.eq("dr", "0");
					List<SubcontractingvolumedetailEntity> pastDetails = subcontractingvolumedetailService.list(queryWrapper);
					if(CollectionUtils.isNotEmpty(pastDetails)){
						BigDecimal examineQuantity1 = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
						BigDecimal examineAmounts1= pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
						BigDecimal examineTaxAmounts1 = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineTaxAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
						//导入之后如果查到往期累计，直接计算本期加累计
						detailVO.setExamineCumulativeQuantity(ComputeUtil.safeAdd(examineQuantity1,detailVO.getExamineQuantity()));// examineCumulativeQuantity 累计数量
						detailVO.setExamineCumulativeAmounts(ComputeUtil.safeAdd(examineAmounts1,detailVO.getExamineAmounts()));  //examineCumulativeAmounts 累计除税金额
						detailVO.setExamineCumulativeTaxAmounts(ComputeUtil.safeAdd(examineTaxAmounts1,detailVO.getExamineTaxAmounts())); // examineCumulativeTaxAmounts  累计含税金额
					}else{
						//如果没查到往期，累计等于导入的本期
						detailVO.setExamineCumulativeQuantity(detailVO.getExamineQuantity());
						detailVO.setExamineCumulativeAmounts(detailVO.getExamineAmounts());
						detailVO.setExamineCumulativeTaxAmounts(detailVO.getExamineTaxAmounts());
					}

					//抓取子表累计值
					if(StringUtils.isNotBlank(subitemCode)){
					/*	//导入的本期
						detailVO.setExamineCumulativeTaxAmounts(detailVO.getExamineTaxAmounts());
						detailVO.setExamineCumulativeTaxAmounts(detailVO.getExamineTaxAmounts());
						detailVO.setExamineCumulativeAmounts(detailVO.getExamineAmounts());
						String key = detailVO.getSubitemCode() +'-' + detailVO.getSection() +'-' + detailVO.getExamineUnitprice() +'-' + detailVO.getExamineTaxUnitprice();
						if (groupMap.containsKey(key)) {
							List<SubcontractingvolumedetailEntity> subcontractingvolumeDetailList = groupMap.get(key);
							BigDecimal examineAmountSum = subcontractingvolumeDetailList.stream().map(SubcontractingvolumedetailEntity::getExamineAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
							BigDecimal examineTaxAmountSum = subcontractingvolumeDetailList.stream().map(SubcontractingvolumedetailEntity::getExamineTaxAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
							detailVO.setExamineCumulativeTaxAmounts(examineTaxAmountSum);
							detailVO.setExamineCumulativeAmounts(examineAmountSum);
						}*/
						if (contractListCodeMap.containsKey(detailVO.getSubitemCode())) {
							OutcontractSubcontractUnitPriceVO outcontractSubcontractUnitPriceVO = contractListCodeMap.get(detailVO.getSubitemCode()).stream().findFirst().get();
							detailVO.setContractNumber(outcontractSubcontractUnitPriceVO.getEngineeringQuantity());
							detailVO.setSource("1");//合同内
						}else {
							detailVO.setSource("2");//合同外
						}

					}

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(detailVO);
					} else {
						successList.add(detailVO);
					}
				}
			}
		}

		//按子目编码排序
		Collections.sort(successList, new Comparator<SubcontractingvolumedetailVO>() {
			@Override
			public int compare(SubcontractingvolumedetailVO o1, SubcontractingvolumedetailVO o2) {
				return (o1.getSubitemCode()+ o1.getSection()).compareTo(o2.getSubitemCode()+ o1.getSection());
			}
		});

		//设置tid和tpid
		List<SubcontractingvolumedetailVO> resList = setTidAndTpid(successList, map);
		//获取子集,汇总数据
		List<String> tpidList = resList.stream().map(SubcontractingvolumedetailVO::getTpid).collect(Collectors.toList());
		for(SubcontractingvolumedetailVO subcontractingvolumedetailVO : resList){
			List<SubcontractingvolumedetailVO> detailByPid = getDetailByPid(subcontractingvolumedetailVO.getTid(), resList);
			if (CollectionUtils.isNotEmpty(detailByPid)){
				subcontractingvolumedetailVO.setExamineQuantity(null);
				subcontractingvolumedetailVO.setExamineUnitprice(null);
				subcontractingvolumedetailVO.setExamineTaxUnitprice(null);
				subcontractingvolumedetailVO.setExamineAmounts(null);
				subcontractingvolumedetailVO.setExamineTaxAmounts(null);
				subcontractingvolumedetailVO.setExamineCumulativeTaxAmounts(null);
				subcontractingvolumedetailVO.setExamineCumulativeAmounts(null);
				subcontractingvolumedetailVO.setExamineCumulativeQuantity(null);
				BigDecimal examineAmounts = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineAmounts() != null).map(SubcontractingvolumedetailVO::getExamineAmounts)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				BigDecimal examineTaxAmounts = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineTaxAmounts() != null).map(SubcontractingvolumedetailVO::getExamineTaxAmounts)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				BigDecimal examineCumulativeAmounts = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineCumulativeAmounts() != null).map(SubcontractingvolumedetailVO::getExamineCumulativeAmounts)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				BigDecimal examineCumulativeTaxAmounts = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineCumulativeTaxAmounts() != null).map(SubcontractingvolumedetailVO::getExamineCumulativeTaxAmounts)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				BigDecimal examineCumulativeQuantity = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineCumulativeTaxAmounts() != null).map(SubcontractingvolumedetailVO::getExamineCumulativeQuantity)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				subcontractingvolumedetailVO.setExamineAmounts(examineAmounts);
				subcontractingvolumedetailVO.setExamineTaxAmounts(examineTaxAmounts);
				subcontractingvolumedetailVO.setExamineCumulativeTaxAmounts(examineCumulativeTaxAmounts);
				subcontractingvolumedetailVO.setExamineCumulativeAmounts(examineCumulativeAmounts);
				subcontractingvolumedetailVO.setExamineCumulativeQuantity(examineCumulativeQuantity);

				subList.clear();
			}
		}
		//构建树
		resList = createTreeData(resList);

		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", resList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	List<SubcontractingvolumedetailVO> subList = new ArrayList<>();
	private List<SubcontractingvolumedetailVO> getDetailByPid(String tid, List<SubcontractingvolumedetailVO> list) {

		for (SubcontractingvolumedetailVO subcontractingvolumedetailVO : list) {
			if (tid != null && tid.equals(subcontractingvolumedetailVO.getTpid())) {
				getDetailByPid(subcontractingvolumedetailVO.getTid(), list);
				subList.add(subcontractingvolumedetailVO);
			}
		}
		return subList;
	}

	/**
	 * excel导入 物资代扣及超用扣款清单
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import2", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData2(HttpServletRequest request, HttpServletResponse response)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<SubcontractingvolumemdetailVO> successList = new ArrayList<>();
		List<SubcontractingvolumemdetailVO> errorList = new ArrayList<>();
		Map<String, SubcontractingvolumemdetailVO> map = new HashMap<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 1; i < result.size(); i++) {
					StringBuilder errorsMsgBuilder = new StringBuilder();

					SubcontractingvolumemdetailVO vo = new SubcontractingvolumemdetailVO();
					List<String> datas = result.get(i);
					String billCode = datas.get(0);//编码
					String section = datas.get(1);//区段
					String billName = datas.get(2);//物资名称
					String subitemDesc = datas.get(3);//子目特征描述
					String unit = datas.get(4);//单位
					String unitprice = datas.get(5);//除税单价(元)
					String unitTaxprice = datas.get(6);//含税单价(元)
					String budgetquantity = datas.get(7);//预算数量
					String actualConsumption = datas.get(8);//实际消耗数量
					String excessdosage = datas.get(9);//超用量
					String overdraftDeduction = datas.get(10);//除税超用扣款（元）
					String overdraftTaxDeduction = datas.get(11);//含税超用扣款（元）
					String remark = datas.get(12);//13
					vo.setId(IdWorker.getId());//id
					vo.setTid(String.valueOf(IdWorker.getId()));//tid
					vo.setBillCode(billCode);
					vo.setSectionCost(section);
					vo.setBillName(billName);
					vo.setSubitemDesc(subitemDesc);
					vo.setUnit(unit);
					vo.setRemark(remark);

					//校验必填不能为空
					if (StringUtils.isBlank(billCode)){
						vo.setErrorMsg("编码不能为空");
						errorList.add(vo);
						continue;
					}
					if (StringUtils.isBlank(section)){
						vo.setErrorMsg("区段不能为空");
						errorList.add(vo);
						continue;
					}
					if (StringUtils.isNotBlank(billCode)) {
						vo.setInnercode(billCode+ "_" + section);//清单编号确定唯一性
//						if ("01".equals(billCode) && billCode != null && billCode.contains("装饰")) {
//							vo.setInnercode("a1"+ "_" + vo.getSectionCost());
//						}
						//判断是否是装饰工程的子节点编码
//						if (billCode.length() >= 4) {
//							//0111、0112、0113、0114、0115这五个节点都是装饰工程下的
//							String code = billCode.substring(0, 4);
//							if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
//								//若是的话，将内码改为a1xx
//								vo.setInnercode("a1" + billCode.substring(2, billCode.length()) + "_" + section);
//							}
//						}
						//1、校验编码是否符合规则--2、4、6、9、9以上
						if (billCode == null || !(billCode.length() == 2 || billCode.length() == 4 || billCode.length() == 6 || billCode.length() >= 9)) {
							vo.setErrorMsg("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则");
							errorsMsgBuilder.append("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则！");
						}
						vo.setBillCode(billCode);
						//重复性校验
						SubcontractingvolumemdetailVO mapVO = map.get(vo.getInnercode());
						if (mapVO == null) {
							map.put(vo.getInnercode(), vo);
						} else {
							vo.setErrorMsg("清单编号已存在！");
							errorsMsgBuilder.append("清单编号已存在！");
						}
						vo.setBillCode(billCode);
					}

					//格式校验
					if(StringUtils.isNotBlank(unitprice)){
						if(NumberUtil.isNumber(unitprice)){
							vo.setmUnitprice(new BigDecimal(unitprice));
						}else {
							vo.setErrorMsg("除税单价(元)格式不正确！");
							errorsMsgBuilder.append("除税单价(元)格式不正确！");
						}
					}
					//格式校验
					if(StringUtils.isNotBlank(unitTaxprice)){
						if(NumberUtil.isNumber(unitTaxprice)){
							vo.setmTaxUnitprice(new BigDecimal(unitTaxprice));
						}else {
							vo.setErrorMsg("含税单价(元)格式不正确！");
							errorsMsgBuilder.append("含税单价(元)格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(budgetquantity)){
						if(NumberUtil.isNumber(budgetquantity)){
							vo.setBudgetquantity(new BigDecimal(budgetquantity));
						}else {
							vo.setErrorMsg("预算数量格式不正确！");
							errorsMsgBuilder.append("预算数量格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(actualConsumption)){
						if(NumberUtil.isNumber(actualConsumption)){
							vo.setActualConsumption(new BigDecimal(actualConsumption));
						}else {
							vo.setErrorMsg("实际消耗数量格式不正确！");
							errorsMsgBuilder.append("实际消耗数量格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(excessdosage)){
						if(NumberUtil.isNumber(excessdosage)){
							vo.setExcessdosage(new BigDecimal(excessdosage));
						}else {
							vo.setErrorMsg("超用量格式不正确！");
							errorsMsgBuilder.append("超用量格式不正确！");
						}
					}else {//超用量 = 实际消耗数量-预算数量
						BigDecimal actualConsumptionB = vo.getActualConsumption();
						BigDecimal budgetquantityB = vo.getBudgetquantity();
						if(budgetquantityB != null && actualConsumptionB != null){
							BigDecimal excessdosageB = actualConsumptionB.subtract(budgetquantityB);
							vo.setExcessdosage(excessdosageB);
						}
					}
					//如果实际用量和预算数量不为空 则计算超用量
					if(StringUtils.isNotBlank(budgetquantity) && StringUtils.isNotBlank(actualConsumption)){
						BigDecimal actualConsumptionB = vo.getActualConsumption();
						BigDecimal budgetquantityB = vo.getBudgetquantity();
						if(budgetquantityB != null && actualConsumptionB != null){
							BigDecimal excessdosageB = actualConsumptionB.subtract(budgetquantityB);
							vo.setExcessdosage(excessdosageB);
						}
					}

					if(StringUtils.isNotBlank(overdraftDeduction)){
						if(NumberUtil.isNumber(overdraftDeduction)){
							vo.setOverdraftDeduction(new BigDecimal(overdraftDeduction));
						}else {
							vo.setErrorMsg("除税超用扣款（元）格式不正确！");
							errorsMsgBuilder.append("除税超用扣款（元）格式不正确！");
						}
					}else {//未填写，自动计算
						BigDecimal excessdosageB = vo.getExcessdosage();
						BigDecimal unitpriceB = vo.getmUnitprice();
						if(excessdosageB != null && unitpriceB != null){
							BigDecimal overdraftDeductionB = excessdosageB.multiply(unitpriceB);
							vo.setOverdraftDeduction(overdraftDeductionB);
						}
					}
					//如果超用量和单价不为空 则计算金额
					if(vo.getmUnitprice() != null && vo.getExcessdosage() != null){
						vo.setOverdraftDeduction(ComputeUtil.safeMultiply(vo.getmUnitprice(),vo.getExcessdosage()));
					}

					if(StringUtils.isNotBlank(overdraftTaxDeduction)){
						if(NumberUtil.isNumber(overdraftTaxDeduction)){
							vo.setOverdraftTaxDeduction(new BigDecimal(overdraftTaxDeduction));
						}else {
							vo.setErrorMsg("含税超用扣款（元）格式不正确！");
							errorsMsgBuilder.append("含税超用扣款（元）格式不正确！");
						}
					}else {//未填写，自动计算
						BigDecimal excessdosageB = vo.getExcessdosage();
						BigDecimal unitTaxpriceB = vo.getmTaxUnitprice();
						if(excessdosageB != null && unitTaxpriceB != null){
							BigDecimal overdraftTaxDeductionB = excessdosageB.multiply(unitTaxpriceB);
							vo.setOverdraftTaxDeduction(overdraftTaxDeductionB);
						}
					}

					if(vo.getmTaxUnitprice() != null && vo.getExcessdosage() != null){
						vo.setOverdraftTaxDeduction(ComputeUtil.safeMultiply(vo.getmTaxUnitprice(),vo.getExcessdosage()));
					}

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(vo);
					} else {
						successList.add(vo);
					}
				}

			}
		}

		//按子目编码排序
		Collections.sort(successList, new Comparator<SubcontractingvolumemdetailVO>() {
			@Override
			public int compare(SubcontractingvolumemdetailVO o1, SubcontractingvolumemdetailVO o2) {
				return (o1.getBillCode() + o1.getSectionCost()).compareTo(o2.getBillCode() + o2.getSectionCost());
			}
		});

		//设置tid和tpid
		//List<SubcontractingvolumemdetailVO> resList = setTidAndTpid1(successList, map);
		//构建树
		//resList = createTreeData1(resList);
		//统计父级的合计数值
		//getChildrenUnitTotalAmount(resList);
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}


	/**
	 * 设置tid和tpid
	 *
	 * @param vos
	 * @param map
	 * @return
	 */
	private List<SubcontractingvolumemdetailVO> setTidAndTpid1(List<SubcontractingvolumemdetailVO> vos, Map<String, SubcontractingvolumemdetailVO> map) {
		if(vos == null){
			return null;
		}

		for (int i = 0; i < vos.size(); i++) {
			SubcontractingvolumemdetailVO SubcontractingvolumemdetailVO = vos.get(i);
			//设置父级id
			String innercode = SubcontractingvolumemdetailVO.getInnercode();
			String[] innercodeSubArr = innercode.split("_");
			String innercodeSub = "";
			String sectionSuf = "";
			if (innercodeSubArr.length > 1) {
				innercodeSub = innercodeSubArr[0];
				sectionSuf = "_" + innercodeSubArr[1];
			}

			Long pid = null;
			if (innercodeSub.length() == 2) {
				//最上级
			} else if (innercodeSub.length() == 4) {
				String pcode = innercodeSub.substring(0, 2) + sectionSuf;
				//有父节点
				pid = this.setPid1(pcode, map);
			} else if (innercodeSub.length() == 6) {
				String pcode = innercodeSub.substring(0, 4) + sectionSuf;
				//有父节点
				pid = this.setPid1(pcode, map);
			} else if (innercodeSub.length() > 6) {
				String pcode = innercodeSub.substring(0, 6) + sectionSuf;
				//有父节点
				pid = this.setPid1(pcode, map);
			}

			if (pid != null) {
				SubcontractingvolumemdetailVO.setTpid(pid.toString());
			} else {
				SubcontractingvolumemdetailVO.setTpid("");
			}
		}

		return vos;
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid1(String pcode, Map<String, SubcontractingvolumemdetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找
			String[] pcodeSubArr = pcode.split("_");
			String pcodeSub = "";
			String sectionSuf = "";//"_" + 区段
			if (pcodeSubArr.length > 1) {
				pcodeSub = pcodeSubArr[0];
				sectionSuf = "_" + pcodeSubArr[1];
			}
			if (pcodeSub.length() == 2) {
				//最上级
				return null;
			} else if (pcodeSub.length() == 4) {
				String ppcode = pcodeSub.substring(0, 2);
				return this.setPid1(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid1(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid1(ppcode + sectionSuf, map);
			} else {
				return null;
			}
		}
	}


	/**
	 * 构建树
	 *
	 * @param list
	 * @return
	 */
	public static List<SubcontractingvolumemdetailVO> createTreeData1(List<SubcontractingvolumemdetailVO> list) {
		List<SubcontractingvolumemdetailVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, SubcontractingvolumemdetailVO> listMap = new HashMap<>();
		for (SubcontractingvolumemdetailVO item : list) {
			listMap.put(item.getTid().toString(), item);
		}

		for (int i = 0; i < list.size(); i++) {
			SubcontractingvolumemdetailVO item = list.get(i);
			String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
			SubcontractingvolumemdetailVO parent = listMap.get(parentId);
			if (parent != null) {
				List<SubcontractingvolumemdetailVO> child = (List<SubcontractingvolumemdetailVO>) parent.getChildren();
				if (child != null) {
					child.add(item);
				} else {
					List<SubcontractingvolumemdetailVO> children = new ArrayList<SubcontractingvolumemdetailVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getTid());
			}
		}

		for (String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}
	/**
	 * excel导入其它扣款清单
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import3", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData3(HttpServletRequest request, HttpServletResponse response)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<SubcontractingvolumeodetailVO> successList = new ArrayList<>();
		List<SubcontractingvolumeodetailVO> errorList = new ArrayList<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 1; i < result.size(); i++) {
					StringBuilder errorsMsgBuilder = new StringBuilder();
					SubcontractingvolumeodetailVO vo = new SubcontractingvolumeodetailVO();

					List<String> datas = result.get(i);
					String withholdingOther = datas.get(0);//其他扣款/代扣款
					String expenseName = datas.get(1);//费用名称
					String unit = datas.get(2);//单位
					String quantity = datas.get(3);//数量
					String unitPrice = datas.get(4);//除税单价
					String unitTaxPrice = datas.get(5);//含税单价
					String remarks = datas.get(6);//备注
					vo.setWithholdingOther(withholdingOther);
					vo.setId(IdWorker.getId());
					vo.setExpenseName(expenseName);
					vo.setUnit(unit);
					vo.setRemarks(remarks);



					//格式校验
					if(StringUtils.isNotBlank(quantity)){
						if(NumberUtil.isNumber(quantity)){
							vo.setoQuantity(new BigDecimal(quantity));
						}else {
							vo.setErrorMsg("数量格式不正确！");
							errorsMsgBuilder.append("数量格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(unitPrice)){
						if(NumberUtil.isNumber(unitPrice)){
							vo.setoUnitPrice(new BigDecimal(unitPrice));
						}else {
							vo.setErrorMsg("除税单价格式不正确！");
							errorsMsgBuilder.append("除税单价格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(unitTaxPrice)){
						if(NumberUtil.isNumber(unitTaxPrice)){
							vo.setoUnitTaxPrice(new BigDecimal(unitTaxPrice));
						}else {
							vo.setErrorMsg("含税单价格式不正确！");
							errorsMsgBuilder.append("含税单价格式不正确！");
						}
					}
					vo.setAmounts(ComputeUtil.safeMultiply(vo.getoQuantity() == null ? new BigDecimal("0"):vo.getoQuantity(),vo.getoUnitPrice() == null ? new BigDecimal("0"):vo.getoUnitPrice()));
					vo.setTaxAmounts(ComputeUtil.safeMultiply(vo.getoQuantity() == null ? new BigDecimal("0"):vo.getoQuantity() ,vo.getoUnitTaxPrice() == null ? new BigDecimal("0"):vo.getoUnitTaxPrice()));

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(vo);
					} else {
						successList.add(vo);
					}
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export", method = RequestMethod.POST)
	@ResponseBody
	public void export(@RequestBody SubcontractingvolumeVO subcontractingvolumeVO, HttpServletResponse response) {
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", subcontractingvolumeVO.getId());
		queryWrapper.eq("dr", 0);
		List<SubcontractingvolumedetailEntity> list = this.subcontractingvolumedetailService.list(queryWrapper);
		List<SubcontractingvolumedetailVO> voList = BeanMapper.mapList(list, SubcontractingvolumedetailVO.class);
		List<SubcontractingvolumedetailVO> records = new ArrayList<>();

		//构建树
		voList = createTreeData(voList);

		for(SubcontractingvolumedetailVO vo : voList){
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("subcontractingvolumedetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
		List<SubcontractingvolumedetailVO> records = new ArrayList<>();
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				SubcontractingvolumedetailVO vo = list.get(i);
				String source = vo.getSource();
				if("1".equals(source)){//来源：1合同内 2合同外
					source = "合同内";
				}else if("2".equals(source)){
					source = "合同外";
				}
				vo.setSource(source);
				records.add(vo);
				if(vo.getChildren()!=null&&vo.getChildren().size()>0){
					this.splitList(vo.getChildren(),records);
				}
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("subcontractingvolumedetail-export.xlsx", beans, response);
	}

	/**
	 * 导出遍历加上所有子表
	 * @param list
	 * @param records
	 */
	private void splitList(List<SubcontractingvolumedetailVO> list,List<SubcontractingvolumedetailVO> records) {
		for(SubcontractingvolumedetailVO vo : list){
			String source = vo.getSource();
			if("1".equals(source)){//来源：1合同内 2合同外
				source = "合同内";
			}else if("2".equals(source)){
				source = "合同外";
			}
			vo.setSource(source);
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export2", method = RequestMethod.POST)
	@ResponseBody
	public void export2(@RequestBody SubcontractingvolumeVO vo, HttpServletResponse response) {
		QueryWrapper<SubcontractingvolumemdetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", vo.getId());
		queryWrapper.eq("dr", 0);
		List<SubcontractingvolumemdetailEntity> list = subcontractingvolumemdetailService.list(queryWrapper);
		List<SubcontractingvolumemdetailVO> vOList = BeanMapper.mapList(list, SubcontractingvolumemdetailVO.class);
		if (!CollectionUtil.isEmpty(vOList)) {
			for (int i = 0; i < vOList.size(); i++) {
				SubcontractingvolumemdetailVO linevo = vOList.get(i);
				linevo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", vOList);
		ExcelExport.getInstance().export("subcontractingvolumemdetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage2", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage2(@RequestBody List<SubcontractingvolumemdetailVO> list, HttpServletResponse response) {
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				SubcontractingvolumemdetailVO vo = list.get(i);
				vo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("subcontractingvolumemdetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export3", method = RequestMethod.POST)
	@ResponseBody
	public void export3(@RequestBody SubcontractingvolumeVO vo, HttpServletResponse response) {
		QueryWrapper<SubcontractingvolumeodetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", vo.getId());
		queryWrapper.eq("dr", 0);
		List<SubcontractingvolumeodetailEntity> list = this.subcontractingvolumeodetailService.list(queryWrapper);
		List<SubcontractingvolumeodetailVO> vOList = BeanMapper.mapList(list, SubcontractingvolumeodetailVO.class);
		if (!CollectionUtil.isEmpty(vOList)) {
			for (int i = 0; i < vOList.size(); i++) {
				SubcontractingvolumeodetailVO linevo = vOList.get(i);
				linevo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", vOList);
		ExcelExport.getInstance().export("subcontractingvolumeodetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage3", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage3(@RequestBody List<SubcontractingvolumeodetailVO> list, HttpServletResponse response) {
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				SubcontractingvolumeodetailVO vo = list.get(i);
				vo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("subcontractingvolumeodetail-export.xlsx", beans, response);
	}

	/**
	 * 设置tid和tpid
	 *
	 * @param vos
	 * @param map
	 * @return
	 */
	private List<SubcontractingvolumedetailVO> setTidAndTpid(List<SubcontractingvolumedetailVO> vos, Map<String, SubcontractingvolumedetailVO> map) {
		if(vos == null){
			return null;
		}

		for (int i = 0; i < vos.size(); i++) {
			SubcontractingvolumedetailVO consdrawbudgetdetailVO = vos.get(i);
			//设置父级id
			String innercode = consdrawbudgetdetailVO.getInnercode();
			String[] innercodeSubArr = innercode.split("_");
			String innercodeSub = "";
			String sectionSuf = "";
			if (innercodeSubArr.length > 1) {
				innercodeSub = innercodeSubArr[0];
				sectionSuf = "_" + innercodeSubArr[1];
			}

			Long pid = null;
			if (innercodeSub.length() == 2) {
				//最上级
			} else if (innercodeSub.length() == 4) {
				String pcode = innercodeSub.substring(0, 2) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercodeSub.length() == 6) {
				String pcode = innercodeSub.substring(0, 4) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercodeSub.length() > 6) {
				String pcode = innercodeSub.substring(0, 6) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			}


			if (pid != null) {
				consdrawbudgetdetailVO.setTpid(pid.toString());
			} else {
				consdrawbudgetdetailVO.setTpid("");
			}
		}

		return vos;
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode, Map<String, SubcontractingvolumedetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找
			String[] pcodeSubArr = pcode.split("_");
			String pcodeSub = "";
			String sectionSuf = "";//"_" + 区段
			if (pcodeSubArr.length > 1) {
				pcodeSub = pcodeSubArr[0];
				sectionSuf = "_" + pcodeSubArr[1];
			}
			if (pcodeSub.length() == 2) {
				//最上级
				return null;
			} else if (pcodeSub.length() == 4) {
				String ppcode = pcodeSub.substring(0, 2);
				return this.setPid(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode + sectionSuf, map);
			} else {
				return null;
			}
		}
	}

	/**
	 * 构建树
	 *
	 * @param list
	 * @return
	 */
	public static List<SubcontractingvolumedetailVO> createTreeData(List<SubcontractingvolumedetailVO> list) {
		List<SubcontractingvolumedetailVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, SubcontractingvolumedetailVO> listMap = new HashMap<>();
		for (SubcontractingvolumedetailVO item : list) {
			listMap.put(item.getTid().toString(), item);
		}

		for (int i = 0; i < list.size(); i++) {
			SubcontractingvolumedetailVO item = list.get(i);
			String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
			SubcontractingvolumedetailVO parent = listMap.get(parentId);
			if (parent != null) {
				List<SubcontractingvolumedetailVO> child = (List<SubcontractingvolumedetailVO>) parent.getChildren();
				if (child != null) {
					child.add(item);
				} else {
					List<SubcontractingvolumedetailVO> children = new ArrayList<SubcontractingvolumedetailVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getTid());
			}
		}

		for (String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}
}
