package com.ejianc.business.middlemeasurement.service;

import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.RevolvingleasedetaildataVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;

import java.math.BigDecimal;
import java.util.List;

/**
 * 月度周转工具租赁费结算单
 *
 * @author generator
 *
 */
public interface IRevolvingleaseService extends IBaseService<RevolvingleaseEntity> {
    /**
     * 更新单据数据的归集状态
     * @param projectId  项目id
     * @param state     状态
     * @return
     */
    boolean updateSettlementState(Long projectId,Integer state,String monthStr);
    /***
     * @Description //TODO 查询单据数据是否被月度成本分析归集
     *
     * @param projectId 项目id
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean queryIsSettlement(Long projectId,String monthStr);

    List<RevolvingleasedetailVO> querySumById(List<RevolvingleasedetailVO> vos);

    RevolvingleasedetailVO queryCumulative(Long projectId, Long contractId, String materialCode, String encode, String section,
                                           BigDecimal lesseeUnitprice, BigDecimal taxLesseeUnitprice);

    RevolvingleasedetailVO queryDetailList(Long contractId, String encode, String materialCode);
}
