package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.ConsultotherEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import com.ejianc.foundation.middlemeasurement.vo.DesignSettlementDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.DesignsubcontractnodeMapper;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodeEntity;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodeService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设计分包节点报量申请
 *
 * @author generator
 *
 */
@Service("designsubcontractnodeService")
public class DesignsubcontractnodeServiceImpl extends BaseServiceImpl<DesignsubcontractnodeMapper, DesignsubcontractnodeEntity> implements IDesignsubcontractnodeService{
    @Autowired
    private DesignsubcontractnodeMapper mapper;
    @Autowired
    private IDesignsubcontractnodeService service;

    @Override
    public List<CostManageVO> queryDesign(Long projectId,String monthStr) {
        return mapper.queryDesign(projectId,monthStr);
    }

    @Override
    public List<CostManageVO> queryDesignMonth(Long projectId, String monthStr) {
        return mapper.queryDesignMonth(projectId,monthStr);
    }

    @Override
    public List<DesignSettlementDetailVO> queryDesignDetailCumPast(Long contractId, String date) {
        return mapper.queryDesignDetailCumPast(contractId,date);
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<DesignsubcontractnodeEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( settlement_date, '%Y-%m' )",monthStr);
        List<DesignsubcontractnodeEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (DesignsubcontractnodeEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<DesignsubcontractnodeEntity> query = new LambdaQueryWrapper<DesignsubcontractnodeEntity>()
                .eq(DesignsubcontractnodeEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(settlement_date, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(DesignsubcontractnodeEntity::getIsSettlement)
                        .or().eq(DesignsubcontractnodeEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("设计分包中间计量有未归集的数据");
        LambdaQueryWrapper<DesignsubcontractnodeEntity> query1 = new LambdaQueryWrapper<DesignsubcontractnodeEntity>()
                .eq(DesignsubcontractnodeEntity::getProjectId, projectId)
                .ne(DesignsubcontractnodeEntity::getBillState, 3)
                .ne(DesignsubcontractnodeEntity::getBillState, 1)
                .apply("DATE_FORMAT(settlement_date, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("设计分包中间计量有本期审批未通过的数据");
        return true;
    }

    @Override
    public List<DesignsubcontractnodedetailVO> queryDesignsubcontractnodedetail(String contract, String monthStr, String projectName) {
        Map<String,String> map = new HashMap<>();
        map.put("contractId",contract);
        map.put("settlementDate",monthStr);
        map.put("projectName",projectName);
//        map.put("exTaxUnitThisDeclare",exTaxUnitThisDeclare);
//        map.put("inTaxUnitThisDeclare",inTaxUnitThisDeclare);
        return mapper.queryDesignsubcontractnodedetail(map);
    }

    @Override
    public DesignsubcontractnodedetailVO queryDetailHistory(Long contract, String projectName, BigDecimal exTaxUnitLastAudit, BigDecimal inTaxUnitLastAudit) {
        return mapper.queryDetailHistory(contract,projectName,exTaxUnitLastAudit,inTaxUnitLastAudit);
    }


}
