package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleaseVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.MechanicalleaseMapper;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 月度机械设备租赁单
 *
 * @author generator
 *
 */
@Service("mechanicalleaseService")
public class MechanicalleaseServiceImpl extends BaseServiceImpl<MechanicalleaseMapper, MechanicalleaseEntity> implements IMechanicalleaseService{
    @Autowired
    private IMechanicalleaseService service;
    @Autowired
    private IMechanicalleasedetailService mechanicalleasedetailService;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<MechanicalleaseEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( settlement_time, '%Y-%m' )",monthStr);
        List<MechanicalleaseEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (MechanicalleaseEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<MechanicalleaseEntity> query = new LambdaQueryWrapper<MechanicalleaseEntity>()
                .eq(MechanicalleaseEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(settlement_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(MechanicalleaseEntity::getIsSettlement)
                        .or().eq(MechanicalleaseEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("机械设备租赁中间计量有往期未归集的数据");
        LambdaQueryWrapper<MechanicalleaseEntity> query1 = new LambdaQueryWrapper<MechanicalleaseEntity>()
                .eq(MechanicalleaseEntity::getProjectId, projectId)
                .ne(MechanicalleaseEntity::getBillState, 3)
                .ne(MechanicalleaseEntity::getBillState, 1)
                .apply("DATE_FORMAT(settlement_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("机械设备租赁中间计量有本期审批未通过的数据");
        return true;
    }


    @Override
    public MechanicalleaseVO getDataById(MechanicalleaseVO mechanicalleaseVO) {
        LambdaQueryWrapper<MechanicalleaseEntity> listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(MechanicalleaseEntity::getContractId, mechanicalleaseVO.getContractId());
        listWrapper.in(MechanicalleaseEntity::getBillState, "1,3");
        List<MechanicalleaseEntity> mechanicalleaseEntityList = super.list(listWrapper);
        Map<String, List<MechanicalleasedetailEntity>> groupMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(mechanicalleaseEntityList)){
            //主表id
            List<Long> ids = mechanicalleaseEntityList.stream().map(MechanicalleaseEntity::getId).collect(Collectors.toList());

            LambdaQueryWrapper<MechanicalleasedetailEntity> detailWrapper = Wrappers.lambdaQuery();
            detailWrapper.in(MechanicalleasedetailEntity::getMid, ids);
            List<MechanicalleasedetailEntity> mechanicalleasedetailEntityList = mechanicalleasedetailService.list(detailWrapper);
            if (CollectionUtils.isNotEmpty(mechanicalleasedetailEntityList)){
                //获取累计值
                groupMap = mechanicalleasedetailEntityList.stream().collect(
                        Collectors.groupingBy(
                                s -> s.getEquipmentCode() +'-' + s.getExTaxLeaseUnit() +'-' + s.getInTaxLeaseUnit()
                        ));
            }

        }
        DecimalFormat decimalFormat  = new DecimalFormat("0.00000000");
        List<MechanicalleasedetailVO> mechanicalleasedetailEntities = mechanicalleaseVO.getMechanicalleasedetailEntities();
        if (CollectionUtils.isNotEmpty(mechanicalleasedetailEntities)){
            for (MechanicalleasedetailVO mechanicalleasedetailVO : mechanicalleasedetailEntities){
                String key = mechanicalleasedetailVO.getEquipmentCode() +'-' +
                        decimalFormat.format(mechanicalleasedetailVO.getExTaxLeaseUnit()) +'-' + decimalFormat.format(mechanicalleasedetailVO.getInTaxLeaseUnit());

                BigDecimal exTaxLeaseUnit = mechanicalleasedetailVO.getExTaxLeaseUnit() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getExTaxLeaseUnit();
                BigDecimal inTaxLeaseUnit = mechanicalleasedetailVO.getInTaxLeaseUnit() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getInTaxLeaseUnit();
                BigDecimal leaseDaysThisTime = mechanicalleasedetailVO.getLeaseDaysThisTime() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getLeaseDaysThisTime();
                BigDecimal leaseNum = mechanicalleasedetailVO.getLeaseNum() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getLeaseNum();

                BigDecimal exTaxRentSettleAmount = exTaxLeaseUnit.multiply(leaseDaysThisTime).multiply(leaseNum);
                BigDecimal inTaxRentSettleAmount = inTaxLeaseUnit.multiply(leaseDaysThisTime).multiply(leaseNum);
                BigDecimal exTaxEntranceExitFee = mechanicalleasedetailVO.getExTaxEntranceExitFee() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getExTaxEntranceExitFee();;
                BigDecimal inTaxEntranceExitFee = mechanicalleasedetailVO.getInTaxEntranceExitFee() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getInTaxEntranceExitFee();;
                BigDecimal exTaxEefCurrentSettleAmount = exTaxRentSettleAmount.add(exTaxEntranceExitFee);
                BigDecimal inTaxEefCurrentSettleAmount = inTaxRentSettleAmount.add(inTaxEntranceExitFee);

                mechanicalleasedetailVO.setExTaxRentCumulative(exTaxRentSettleAmount);
                mechanicalleasedetailVO.setInTaxRentCumulative(inTaxRentSettleAmount);
                mechanicalleasedetailVO.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFee);
                mechanicalleasedetailVO.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFee);
                mechanicalleasedetailVO.setExTaxEefCumulative(exTaxEefCurrentSettleAmount);
                mechanicalleasedetailVO.setInTaxEefCumulative(inTaxEefCurrentSettleAmount);
        if (groupMap.containsKey(key)) {
            List<MechanicalleasedetailEntity> groupList = groupMap.get(key);
            BigDecimal exTaxRentSettleAmountSum = groupList.stream().filter(item -> item.getExTaxRentSettleAmount() != null).map(MechanicalleasedetailEntity::getExTaxRentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal inTaxRentSettleAmountSum = groupList.stream().filter(item -> item.getInTaxRentSettleAmount() != null).map(MechanicalleasedetailEntity::getInTaxRentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exTaxEntranceExitFeeSum = groupList.stream().filter(item -> item.getExTaxEntranceExitFee() != null).map(MechanicalleasedetailEntity::getExTaxEntranceExitFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal inTaxEntranceExitFeeSum = groupList.stream().filter(item -> item.getInTaxEntranceExitFee() != null).map(MechanicalleasedetailEntity::getInTaxEntranceExitFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exTaxEefCurrentSettleAmountSum = groupList.stream().filter(item -> item.getExTaxEefCurrentSettleAmount() != null).map(MechanicalleasedetailEntity::getExTaxEefCurrentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal inTaxEefCurrentSettleAmountSum = groupList.stream().filter(item -> item.getInTaxEefCurrentSettleAmount() != null).map(MechanicalleasedetailEntity::getInTaxEefCurrentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            mechanicalleasedetailVO.setExTaxRentCumulative(exTaxRentSettleAmount.add(exTaxRentSettleAmountSum));
            mechanicalleasedetailVO.setInTaxRentCumulative(inTaxRentSettleAmount.add(inTaxRentSettleAmountSum));
            mechanicalleasedetailVO.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFee.add(exTaxEntranceExitFeeSum));
            mechanicalleasedetailVO.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFee.add(inTaxEntranceExitFeeSum));
            mechanicalleasedetailVO.setExTaxEefCumulative(exTaxEefCurrentSettleAmount.add(exTaxEefCurrentSettleAmountSum));
            mechanicalleasedetailVO.setInTaxEefCumulative(inTaxEefCurrentSettleAmount.add(inTaxEefCurrentSettleAmountSum));

            mechanicalleasedetailVO.setMathExTaxRentCumulative(exTaxRentSettleAmountSum);
            mechanicalleasedetailVO.setMathInTaxRentCumulative(inTaxRentSettleAmountSum);
            mechanicalleasedetailVO.setMathExTaxEntranceExitFeeCumulative(exTaxEntranceExitFeeSum);
            mechanicalleasedetailVO.setMathInTaxEntranceExitFeeCumulative(inTaxEntranceExitFeeSum);
        }

            }

        }

        return mechanicalleaseVO;
    }


    @Override
    public MechanicalleasedetailVO queryCumulative(Long projectId, Long contractId, String equipmentCode) {
        MechanicalleasedetailVO vo = baseMapper.queryCumulative(projectId, contractId, equipmentCode);
        return vo;
    }
}
