package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetotalEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesummaryEntity;
import com.ejianc.business.middlemeasurement.mapper.RevolvingleasedetailMapper;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.RevolvingleasedetaildataVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.RevolvingleaseMapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 月度周转工具租赁费结算单
 *
 * @author generator
 *
 */
@Service("revolvingleaseService")
public class RevolvingleaseServiceImpl extends BaseServiceImpl<RevolvingleaseMapper, RevolvingleaseEntity> implements IRevolvingleaseService{

    @Autowired
    private IRevolvingleaseService service;

    @Autowired
    private RevolvingleasedetailMapper revolvingleasedetailMapper;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<RevolvingleaseEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( settle_time, '%Y-%m' )",monthStr);
        List<RevolvingleaseEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (RevolvingleaseEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<RevolvingleaseEntity> query = new LambdaQueryWrapper<RevolvingleaseEntity>()
                .eq(RevolvingleaseEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(settle_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(RevolvingleaseEntity::getIsSettlement)
                        .or().eq(RevolvingleaseEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("周转租赁中间计量有往期未归集的数据");
        LambdaQueryWrapper<RevolvingleaseEntity> query1 = new LambdaQueryWrapper<RevolvingleaseEntity>()
                .eq(RevolvingleaseEntity::getProjectId, projectId)
                .ne(RevolvingleaseEntity::getBillState, 3)
                .ne(RevolvingleaseEntity::getBillState, 1)
                .apply("DATE_FORMAT(settle_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("周转租赁中间计量有本期审批未通过的数据");
        return true;
    }

    @Override
    public List<RevolvingleasedetailVO> querySumById(List<RevolvingleasedetailVO> list) {
        if (CollectionUtils.isNotEmpty(list)){
            for (RevolvingleasedetailVO revolvingleasedetailVO : list){


            }

        }
        return null;
    }

    @Override
    public RevolvingleasedetailVO queryCumulative(Long projectId, Long contractId, String materialCode, String encode, String section, BigDecimal lesseeUnitprice, BigDecimal taxLesseeUnitprice) {
        RevolvingleasedetailVO vo = baseMapper.queryCumulative(projectId,contractId,materialCode,encode,section,lesseeUnitprice,taxLesseeUnitprice);
        return vo;
    }

    @Override
    public RevolvingleasedetailVO queryDetailList(Long contractId, String encode, String materialCode) {
        return revolvingleasedetailMapper.queryDetailList(contractId,encode,materialCode);
    }
}
