/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IConsultotherService;
import com.ejianc.business.middlemeasurement.service.IConsultotherdetailService;
import com.ejianc.business.middlemeasurement.service.IConsultotherodetailService;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherodetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"consultotherExport"})
public class ExcelConsultotherController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IConsultotherdetailService consultotherdetailService;
    @Autowired
    private IConsultotherodetailService consultotherodetailService;
    @Autowired
    private IConsultotherService service;

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"consultotherdetail-import.xlsx", (String)"\u54a8\u8be2\u53ca\u5176\u4ed6\u7c7b\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97\u5355-\u6700\u7ec8\u7ed3\u7b97\u8ba1\u4ef7\u660e\u8868");
    }

    @RequestMapping(value={"/download3"}, method={RequestMethod.POST})
    @ResponseBody
    public void download3(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"consultotherodetail-import.xlsx", (String)"\u5176\u5b83\u6263\u6b3e\u6e05\u5355");
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData(HttpServletRequest request, HttpServletResponse response, String contractId, String monthStr) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ConsultotherdetailVO> successList = new ArrayList<ConsultotherdetailVO>();
        ArrayList<ConsultotherdetailVO> errorList = new ArrayList<ConsultotherdetailVO>();
        HashMap<String, ConsultotherdetailVO> map = new HashMap<String, ConsultotherdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 3; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String subitemName = (String)datas.get(0);
                String spec = (String)datas.get(1);
                String unit = (String)datas.get(2);
                String unitprice = (String)datas.get(3);
                String taxUnitprice = (String)datas.get(4);
                String examineQuantity = (String)datas.get(5);
                String memo = (String)datas.get(6);
                ConsultotherdetailVO detailVO = new ConsultotherdetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                detailVO.setTid(String.valueOf(IdWorker.getId()));
                detailVO.setContractId(Long.valueOf(Long.parseLong(contractId)));
                detailVO.setSubitemName(subitemName);
                detailVO.setSpec(spec);
                detailVO.setUnit(unit);
                detailVO.setMemo(memo);
                if (subitemName == null || TextUtils.isEmpty((CharSequence)subitemName)) {
                    detailVO.setErrorMsg("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (spec == null || TextUtils.isEmpty((CharSequence)spec)) {
                    detailVO.setErrorMsg("\u89c4\u683c\u53ca\u7279\u5f81\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u89c4\u683c\u53ca\u7279\u5f81\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (unit == null || TextUtils.isEmpty((CharSequence)unit)) {
                    detailVO.setErrorMsg("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (unitprice == null || TextUtils.isEmpty((CharSequence)unitprice)) {
                    detailVO.setErrorMsg("\u9664\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u9664\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (taxUnitprice == null || TextUtils.isEmpty((CharSequence)taxUnitprice)) {
                    detailVO.setErrorMsg("\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (examineQuantity == null || TextUtils.isEmpty((CharSequence)examineQuantity)) {
                    detailVO.setErrorMsg("\u6570\u91cf\uff08\u9879\u76ee\u90e8\u5ba1\u6279\uff1a\u672c\u671f\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u6570\u91cf\uff08\u9879\u76ee\u90e8\u5ba1\u6279\uff1a\u672c\u671f\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isNotBlank((CharSequence)unitprice)) {
                    if (!NumberUtil.isNumber((String)unitprice)) {
                        detailVO.setErrorMsg("\u9664\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u9664\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    } else {
                        detailVO.setUnitprice(new BigDecimal(unitprice));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)taxUnitprice)) {
                    if (!NumberUtil.isNumber((String)taxUnitprice)) {
                        detailVO.setErrorMsg("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    } else {
                        detailVO.setTaxUnitprice(new BigDecimal(taxUnitprice));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)examineQuantity)) {
                    if (!NumberUtil.isNumber((String)examineQuantity)) {
                        detailVO.setErrorMsg("\u6570\u91cf\uff08\u9879\u76ee\u90e8\u5ba1\u6279\uff1a\u672c\u671f\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u6570\u91cf\uff08\u9879\u76ee\u90e8\u5ba1\u6279\uff1a\u672c\u671f\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    } else {
                        detailVO.setExamineQuantity(new BigDecimal(examineQuantity));
                    }
                }
                detailVO.setExamineAmounts(ComputeUtil.safeMultiply((BigDecimal)detailVO.getExamineQuantity(), (BigDecimal)detailVO.getUnitprice()));
                detailVO.setExamineTaxAmounts(ComputeUtil.safeMultiply((BigDecimal)detailVO.getExamineQuantity(), (BigDecimal)detailVO.getTaxUnitprice()));
                if (StringUtils.isNotBlank((CharSequence)subitemName)) {
                    BigDecimal examineQuantityB = detailVO.getExamineQuantity();
                    BigDecimal examineAmountsB = detailVO.getExamineAmounts();
                    BigDecimal examineTaxAmountsB = detailVO.getExamineTaxAmounts();
                    List<ConsultotherdetailVO> pastDetails = this.service.queryConsultotherdetail(contractId, monthStr, subitemName, spec, unit, unitprice, taxUnitprice);
                    if (pastDetails != null && pastDetails.size() > 0) {
                        ConsultotherdetailVO pastConsultotherdetail = pastDetails.get(0);
                        BigDecimal pastExamineQuantityB = pastConsultotherdetail.getExamineCumulativeQuantity();
                        BigDecimal pastExamineAmountsB = pastConsultotherdetail.getExamineCumulativeAmounts();
                        BigDecimal pastExamineTaxAmountsB = pastConsultotherdetail.getExamineCumulativeTaxAmounts();
                        if (examineQuantityB != null) {
                            pastExamineQuantityB = pastExamineQuantityB.add(examineQuantityB);
                        }
                        if (examineAmountsB != null) {
                            pastExamineAmountsB = pastExamineAmountsB.add(examineAmountsB);
                        }
                        if (examineTaxAmountsB != null) {
                            pastExamineTaxAmountsB = pastExamineTaxAmountsB.add(examineTaxAmountsB);
                        }
                        detailVO.setExamineCumulativeQuantity(pastExamineQuantityB);
                        detailVO.setExamineCumulativeAmounts(pastExamineAmountsB);
                        detailVO.setExamineCumulativeTaxAmounts(pastExamineTaxAmountsB);
                    } else {
                        if (examineQuantityB != null) {
                            detailVO.setExamineCumulativeQuantity(examineQuantityB);
                        }
                        if (examineAmountsB != null) {
                            detailVO.setExamineCumulativeAmounts(examineAmountsB);
                        }
                        if (examineTaxAmountsB != null) {
                            detailVO.setExamineCumulativeTaxAmounts(examineTaxAmountsB);
                        }
                    }
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        List<ConsultotherdetailVO> resList = this.setTidAndTpid(successList, map);
        resList = ExcelConsultotherController.createTreeData(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/import3"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData3(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ConsultotherodetailVO> successList = new ArrayList<ConsultotherodetailVO>();
        ArrayList<ConsultotherodetailVO> errorList = new ArrayList<ConsultotherodetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorsMsgBuilder = new StringBuilder();
                ConsultotherodetailVO vo = new ConsultotherodetailVO();
                List datas = (List)result.get(i);
                String expenseName = (String)datas.get(0);
                String unit = (String)datas.get(1);
                String quantity = (String)datas.get(2);
                String unitPrice = (String)datas.get(3);
                String unitTaxPrice = (String)datas.get(4);
                String remarks = (String)datas.get(5);
                vo.setId(Long.valueOf(IdWorker.getId()));
                vo.setExpenseName(expenseName);
                vo.setUnit(unit);
                vo.setRemarks(remarks);
                if (StringUtils.isNotBlank((CharSequence)quantity)) {
                    if (NumberUtil.isNumber((String)quantity)) {
                        vo.setoQuantity(new BigDecimal(quantity));
                    } else {
                        vo.setErrorMsg("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)unitPrice)) {
                    if (NumberUtil.isNumber((String)unitPrice)) {
                        vo.setoUnitPrice(new BigDecimal(unitPrice));
                    } else {
                        vo.setErrorMsg("(\u9664\u7a0e)\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("(\u9664\u7a0e)\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)unitTaxPrice)) {
                    if (NumberUtil.isNumber((String)unitTaxPrice)) {
                        vo.setoTaxUnitPrice(new BigDecimal(unitTaxPrice));
                    } else {
                        vo.setErrorMsg("(\u542b\u7a0e)\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("(\u542b\u7a0e)\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                vo.setAmounts(ComputeUtil.safeMultiply((BigDecimal)vo.getoQuantity(), (BigDecimal)vo.getoUnitPrice()));
                vo.setTaxAmounts(ComputeUtil.safeMultiply((BigDecimal)vo.getoQuantity(), (BigDecimal)vo.getoTaxUnitPrice()));
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(vo);
                    continue;
                }
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    @ResponseBody
    public void export(@RequestBody ConsultotherVO consultotherVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)consultotherVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.consultotherdetailService.list((Wrapper)queryWrapper);
        List<ConsultotherdetailVO> voList = BeanMapper.mapList((Iterable)list, ConsultotherdetailVO.class);
        ArrayList<ConsultotherdetailVO> records = new ArrayList<ConsultotherdetailVO>();
        voList = ExcelConsultotherController.createTreeData(voList);
        for (ConsultotherdetailVO vo : voList) {
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
        HashMap<String, ArrayList<ConsultotherdetailVO>> beans = new HashMap<String, ArrayList<ConsultotherdetailVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("consultotherdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/exportFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportFromPage(@RequestBody List<ConsultotherdetailVO> list, HttpServletResponse response) {
        ArrayList<ConsultotherdetailVO> records = new ArrayList<ConsultotherdetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ConsultotherdetailVO vo = list.get(i);
                String source = vo.getSource();
                if ("1".equals(source)) {
                    source = "\u5408\u540c\u5185";
                } else if ("2".equals(source)) {
                    source = "\u5408\u540c\u5916";
                }
                vo.setSource(source);
                records.add(vo);
                if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
                this.splitList(vo.getChildren(), records);
            }
        }
        HashMap<String, ArrayList<ConsultotherdetailVO>> beans = new HashMap<String, ArrayList<ConsultotherdetailVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("consultotherdetail-export.xlsx", beans, response);
    }

    private void splitList(List<ConsultotherdetailVO> list, List<ConsultotherdetailVO> records) {
        for (ConsultotherdetailVO vo : list) {
            String source = vo.getSource();
            if ("1".equals(source)) {
                source = "\u5408\u540c\u5185";
            } else if ("2".equals(source)) {
                source = "\u5408\u540c\u5916";
            }
            vo.setSource(source);
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
    }

    @RequestMapping(value={"/export3"}, method={RequestMethod.POST})
    @ResponseBody
    public void export3(@RequestBody ConsultotherVO vo, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)vo.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.consultotherodetailService.list((Wrapper)queryWrapper);
        List vOList = BeanMapper.mapList((Iterable)list, ConsultotherodetailVO.class);
        if (!CollectionUtil.isEmpty((Collection)vOList)) {
            for (int i = 0; i < vOList.size(); ++i) {
                ConsultotherodetailVO linevo = (ConsultotherodetailVO)vOList.get(i);
                linevo.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vOList);
        ExcelExport.getInstance().export("consultotherodetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/exportFromPage3"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportFromPage3(@RequestBody List<ConsultotherodetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ConsultotherodetailVO vo = list.get(i);
                vo.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<ConsultotherodetailVO>> beans = new HashMap<String, List<ConsultotherodetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consultotherodetail-export.xlsx", beans, response);
    }

    private List<ConsultotherdetailVO> setTidAndTpid(List<ConsultotherdetailVO> vos, Map<String, ConsultotherdetailVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            ConsultotherdetailVO consultotherdetailVO = vos.get(i);
            String innercode = consultotherdetailVO.getInnercode();
            if (innercode == null) continue;
            Long pid = null;
            if (innercode.length() != 2) {
                String pcode;
                if (innercode.length() == 4) {
                    pcode = innercode.substring(0, 2);
                    pid = this.setPid(pcode, map);
                } else if (innercode.length() == 6) {
                    pcode = innercode.substring(0, 4);
                    pid = this.setPid(pcode, map);
                } else if (innercode.length() > 6) {
                    pcode = innercode.substring(0, 6);
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                consultotherdetailVO.setTpid(pid.toString());
                continue;
            }
            consultotherdetailVO.setTpid("");
        }
        return vos;
    }

    private Long setPid(String pcode, Map<String, ConsultotherdetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        if (pcode.length() == 2) {
            return null;
        }
        if (pcode.length() == 4) {
            String ppcode = pcode.substring(0, 2);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode, map);
        }
        return null;
    }

    public static List<ConsultotherdetailVO> createTreeData(List<ConsultotherdetailVO> list) {
        ArrayList<ConsultotherdetailVO> resp = new ArrayList<ConsultotherdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ConsultotherdetailVO> listMap = new HashMap<String, ConsultotherdetailVO>();
        for (ConsultotherdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ConsultotherdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            ConsultotherdetailVO parent = (ConsultotherdetailVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ConsultotherdetailVO> children = new ArrayList<ConsultotherdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((ConsultotherdetailVO)listMap.get(rootId));
        }
        return resp;
    }
}

