/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.BigDecimalUtils;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"revolvingleaseExport"})
public class ExcelRevolvingleaseController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IRevolvingleaseService revolvingleaseService;
    List<RevolvingleasedetailVO> subList = new ArrayList<RevolvingleasedetailVO>();

    @RequestMapping(value={"/downloadRevolvinglease"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadRevolvinglease(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"revolvingleasedetail-import.xlsx", (String)"\u6708\u5ea6\u5468\u8f6c\u79df\u8d41\u5355\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportRevolvinglease"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportRevolvinglease(HttpServletRequest request, HttpServletResponse response, Long contractId, Long projectId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        HashMap<String, RevolvingleasedetailVO> mapVO = new HashMap<String, RevolvingleasedetailVO>();
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<RevolvingleasedetailVO> successList = new ArrayList<RevolvingleasedetailVO>();
        ArrayList<RevolvingleasedetailVO> errorList = new ArrayList<RevolvingleasedetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        HashMap map = new HashMap();
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                String errorMessage;
                String errorMessage2;
                String errorMessage3;
                String errorMessage4;
                String errorMessage5;
                String errorMessage6;
                int num1 = 0;
                RevolvingleasedetailVO revolvingleasedetailVO = new RevolvingleasedetailVO();
                Object back = null;
                List datas = (List)result.get(i);
                revolvingleasedetailVO.setId(IdWorker.getId());
                revolvingleasedetailVO.setTid(String.valueOf(IdWorker.getId()));
                String encode = (String)datas.get(0);
                String section = (String)datas.get(1);
                String branch = (String)datas.get(2);
                String subitemDesc = (String)datas.get(3);
                if (StringUtils.isBlank((CharSequence)encode)) {
                    errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage6 == null) {
                        errorMessage6 = "";
                    }
                    errorMessage6 = errorMessage6 + "'\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage6);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setEncode(StringUtils.isNotBlank((CharSequence)encode) ? encode : null);
                }
                if (StringUtils.isNotBlank((CharSequence)encode)) {
                    revolvingleasedetailVO.setInnercode(encode + "_" + section);
                    if (encode == null || encode.length() != 2 && encode.length() != 4 && encode.length() != 6 && encode.length() < 9) {
                        revolvingleasedetailVO.setErrorMsg("\u6e05\u5355\u7f16\u53f7\u5fc5\u987b\u7b26\u5408\uff1a2\u4f4d\u30014\u4f4d\u30016\u4f4d\u30019\u4f4d\u62169\u4f4d\u4ee5\u4e0a\u4e2d\u4efb\u610f\u4e00\u89c4\u5219");
                        ++num1;
                    }
                    revolvingleasedetailVO.setEncode(encode);
                    RevolvingleasedetailVO reVo = (RevolvingleasedetailVO)((Object)mapVO.get(revolvingleasedetailVO.getInnercode()));
                    if (reVo == null) {
                        mapVO.put(revolvingleasedetailVO.getInnercode(), revolvingleasedetailVO);
                    } else {
                        revolvingleasedetailVO.setErrorMsg("\u6e05\u5355\u7f16\u53f7\u5df2\u5b58\u5728\uff01");
                        ++num1;
                    }
                    revolvingleasedetailVO.setEncode(encode);
                }
                if (StringUtils.isBlank((CharSequence)section)) {
                    errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage6 == null) {
                        errorMessage6 = "";
                    }
                    errorMessage6 = errorMessage6 + "'\u533a\u6bb5'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage6);
                    ++num1;
                }
                revolvingleasedetailVO.setSection(StringUtils.isNotBlank((CharSequence)section) ? section : null);
                if (StringUtils.isBlank((CharSequence)branch)) {
                    errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage6 == null) {
                        errorMessage6 = "";
                    }
                    errorMessage6 = errorMessage6 + "'\u5b50\u76ee\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage6);
                    ++num1;
                }
                revolvingleasedetailVO.setBranch(StringUtils.isNotBlank((CharSequence)branch) ? branch : null);
                if (StringUtils.isBlank((CharSequence)subitemDesc)) {
                    errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage6 == null) {
                        errorMessage6 = "";
                    }
                    errorMessage6 = errorMessage6 + "'\u5b50\u76ee\u7279\u5f81\u63cf\u8ff0'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage6);
                    ++num1;
                }
                revolvingleasedetailVO.setSubitemDesc(StringUtils.isNotBlank((CharSequence)subitemDesc) ? subitemDesc : null);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage6 == null) {
                        errorMessage6 = "";
                    }
                    errorMessage6 = errorMessage6 + "'\u7269\u8d44\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage6);
                    ++num1;
                }
                CommonResponse back0 = this.shareMaterialApi.queryMaterialByCode((String)datas.get(4));
                MaterialVO back0Data = (MaterialVO)back0.getData();
                if (back0.getCode() == 1 || back0Data == null) {
                    String errorMessage7 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage7 == null) {
                        errorMessage7 = "";
                    }
                    errorMessage7 = errorMessage7 + "\u672a\u67e5\u8be2\u5230\u8be5\u7269\u8d44\u7f16\u7801\u4e0b\u7684\u7269\u8d44\u8be6\u60c5";
                    revolvingleasedetailVO.setErrorMsg(errorMessage7);
                    ++num1;
                    errorList.add(revolvingleasedetailVO);
                    continue;
                }
                revolvingleasedetailVO.setMaterialCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                revolvingleasedetailVO.setLesseeMaterialsName(((MaterialVO)back0.getData()).getName());
                revolvingleasedetailVO.setSpecifications(((MaterialVO)back0.getData()).getSpec());
                revolvingleasedetailVO.setMeasurementUnit(((MaterialVO)back0.getData()).getUnitName());
                revolvingleasedetailVO.setMaterialCategoryId(((MaterialVO)back0.getData()).getCategoryId());
                revolvingleasedetailVO.setMaterialCategoryCode(((MaterialVO)back0.getData()).getCode());
                revolvingleasedetailVO.setMaterialCategoryName(((MaterialVO)back0.getData()).getCategoryName());
                BigDecimal num = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(12))) || datas.get(12) == null) {
                    errorMessage5 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage5 == null) {
                        errorMessage5 = "";
                    }
                    errorMessage5 = errorMessage5 + "'\u79df\u8d41\u6570\u91cf'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage5);
                    if (!NumberUtil.isNumber((String)((String)datas.get(12)))) {
                        if (errorMessage5 == null) {
                            errorMessage5 = "";
                        }
                        errorMessage5 = errorMessage5 + "'\u79df\u8d41\u6570\u91cf'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage5);
                    }
                    ++num1;
                } else {
                    num = num.add(new BigDecimal((int)Float.parseFloat((String)datas.get(12))));
                    revolvingleasedetailVO.setLesseeQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? Integer.valueOf((int)Float.parseFloat((String)datas.get(12))) : null);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) && datas.get(8) != null) {
                    if (!DateUtils.grepDate((String)datas.get(8))) {
                        errorMessage5 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage5 == null) {
                            errorMessage5 = "";
                        }
                        errorMessage5 = errorMessage5 + "'\u672c\u671f\u8ba1\u7b97\u8d77\u59cb\u65f6\u95f4'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage5);
                        ++num1;
                    } else {
                        revolvingleasedetailVO.setSettleTime(DateUtils.Date((String)datas.get(8)));
                    }
                } else {
                    errorMessage5 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage5 == null) {
                        errorMessage5 = "";
                    }
                    errorMessage5 = errorMessage5 + "'\u672c\u671f\u8ba1\u7b97\u8d77\u59cb\u65f6\u95f4'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage5);
                    ++num1;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) && datas.get(9) != null) {
                    revolvingleasedetailVO.setEndTime(DateUtils.Date((String)datas.get(9)));
                    if (!DateUtils.grepDate((String)datas.get(9))) {
                        errorMessage5 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage5 == null) {
                            errorMessage5 = "";
                        }
                        errorMessage5 = errorMessage5 + "'\u672c\u671f\u8ba1\u7b97\u7ec8\u6b62\u65f6\u95f4'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage5);
                        ++num1;
                    }
                } else {
                    errorMessage5 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage5 == null) {
                        errorMessage5 = "";
                    }
                    errorMessage5 = errorMessage5 + "'\u672c\u671f\u8ba1\u7b97\u7ec8\u6b62\u65f6\u95f4'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage5);
                    ++num1;
                }
                BigDecimal dayValue = new BigDecimal(0);
                SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date star = dft.parse(DateUtils.ExcelDoubleToDate((String)datas.get(8)));
                    Date endDay = dft.parse(DateUtils.ExcelDoubleToDate((String)datas.get(9)));
                    Long starTime = star.getTime();
                    Long endTime = endDay.getTime();
                    Long nums = endTime - starTime;
                    Long day = nums / 24L / 60L / 60L / 1000L + 1L;
                    revolvingleasedetailVO.setLesseeTerm(Integer.parseInt(day.toString()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                BigDecimal exUnitPrice = new BigDecimal(0);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) && datas.get(13) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(13)))) {
                        String errorMessage8 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage8 == null) {
                            errorMessage8 = "";
                        }
                        errorMessage8 = errorMessage8 + "'\u79df\u8d41\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage8);
                        ++num1;
                    } else {
                        exUnitPrice = exUnitPrice.add(new BigDecimal((String)datas.get(13)));
                        revolvingleasedetailVO.setLesseeUnitprice(exUnitPrice);
                    }
                } else {
                    revolvingleasedetailVO.setLesseeUnitprice(null);
                }
                BigDecimal inUnitPrice = new BigDecimal(0);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) && datas.get(14) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(14)))) {
                        String errorMessage9 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage9 == null) {
                            errorMessage9 = "";
                        }
                        errorMessage9 = errorMessage9 + "'\u79df\u8d41\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage9);
                        ++num1;
                    } else {
                        inUnitPrice = inUnitPrice.add(new BigDecimal((String)datas.get(14)));
                        revolvingleasedetailVO.setTaxLesseeUnitprice(inUnitPrice);
                    }
                } else {
                    revolvingleasedetailVO.setTaxLesseeUnitprice(null);
                }
                BigDecimal lesseeTotalprice = new BigDecimal(revolvingleasedetailVO.getLesseeQuantity() == null ? 0 : revolvingleasedetailVO.getLesseeQuantity()).multiply(new BigDecimal(revolvingleasedetailVO.getLesseeTerm() == null ? 0 : revolvingleasedetailVO.getLesseeTerm())).multiply(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getLesseeUnitprice()));
                revolvingleasedetailVO.setLesseeTotalprice(lesseeTotalprice);
                BigDecimal taxLesseeTotalprice = new BigDecimal(revolvingleasedetailVO.getLesseeQuantity() == null ? 0 : revolvingleasedetailVO.getLesseeQuantity()).multiply(new BigDecimal(revolvingleasedetailVO.getLesseeTerm() == null ? 0 : revolvingleasedetailVO.getLesseeTerm())).multiply(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getTaxLesseeUnitprice()));
                revolvingleasedetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);
                BigDecimal findNum = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(17))) || datas.get(17) == null) {
                    errorMessage4 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage4 == null) {
                        errorMessage4 = "";
                    }
                    errorMessage4 = errorMessage4 + "'\u4e22\u5931\u635f\u574f\u91cf'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage4);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(17)))) {
                    errorMessage4 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage4 == null) {
                        errorMessage4 = "";
                    }
                    errorMessage4 = errorMessage4 + "'\u4e22\u5931\u635f\u574f\u91cf'\u8f93\u5165\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage4);
                    ++num1;
                } else {
                    findNum = findNum.add(new BigDecimal((String)datas.get(17)));
                    revolvingleasedetailVO.setLossDamage(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(17))) ? new BigDecimal((String)datas.get(17)) : null);
                }
                BigDecimal pexUnitPrice = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(18))) || datas.get(18) == null) {
                    errorMessage3 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage3 == null) {
                        errorMessage3 = "";
                    }
                    errorMessage3 = errorMessage3 + "'\u8d54\u507f\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage3);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(18)))) {
                    errorMessage3 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage3 == null) {
                        errorMessage3 = "";
                    }
                    errorMessage3 = errorMessage3 + "'\u8d54\u507f\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage3);
                    ++num1;
                } else {
                    pexUnitPrice = pexUnitPrice.add(new BigDecimal((String)datas.get(18)));
                    revolvingleasedetailVO.setCompensateUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(18))) ? new BigDecimal((String)datas.get(18)) : null);
                }
                BigDecimal pinUnitPrice = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(19))) || datas.get(19) == null) {
                    errorMessage2 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage2 == null) {
                        errorMessage2 = "";
                    }
                    errorMessage2 = errorMessage2 + "'\u8d54\u507f\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage2);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(19)))) {
                    errorMessage2 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage2 == null) {
                        errorMessage2 = "";
                    }
                    errorMessage2 = errorMessage2 + "'\u8d54\u507f\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage2);
                    ++num1;
                } else {
                    pinUnitPrice = pinUnitPrice.add(new BigDecimal((String)datas.get(19)));
                    revolvingleasedetailVO.setTaxCompensateUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(19))) ? new BigDecimal((String)datas.get(19)) : null);
                }
                revolvingleasedetailVO.setCompensateAccount(ComputeUtil.safeMultiply((BigDecimal)(revolvingleasedetailVO.getLossDamage() == null ? BigDecimal.ZERO : revolvingleasedetailVO.getLossDamage()), (BigDecimal)(revolvingleasedetailVO.getCompensateUnitprice() == null ? BigDecimal.ZERO : revolvingleasedetailVO.getCompensateUnitprice())));
                revolvingleasedetailVO.setTaxCompensateAccount(ComputeUtil.safeMultiply((BigDecimal)(revolvingleasedetailVO.getLossDamage() == null ? BigDecimal.ZERO : revolvingleasedetailVO.getLossDamage()), (BigDecimal)(revolvingleasedetailVO.getTaxCompensateUnitprice() == null ? BigDecimal.ZERO : revolvingleasedetailVO.getTaxCompensateUnitprice())));
                BigDecimal cleanEx = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(22))) || datas.get(22) == null) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6e05\u7406\u7ef4\u4fee\u8d39\u975e\u7b49\u5176\u4ed6\u8d39\u7528(\u9664\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(22)))) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6e05\u7406\u7ef4\u4fee\u8d39\u975e\u7b49\u5176\u4ed6\u8d39\u7528(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setOtherExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(22))) ? new BigDecimal((String)datas.get(22)) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(23))) || datas.get(23) == null) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6e05\u7406\u7ef4\u4fee\u8d39\u975e\u7b49\u5176\u4ed6\u8d39\u7528(\u542b\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(23)))) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6e05\u7406\u7ef4\u4fee\u8d39\u975e\u7b49\u5176\u4ed6\u8d39\u7528(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setTaxOtherExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(23))) ? new BigDecimal((String)datas.get(23)) : null);
                }
                revolvingleasedetailVO.setMonthlyExpenses(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO.getLesseeTotalprice(), (BigDecimal[])new BigDecimal[]{revolvingleasedetailVO.getCompensateAccount(), revolvingleasedetailVO.getOtherExpenses()}));
                revolvingleasedetailVO.setTaxMonthlyExpenses(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO.getTaxLesseeTotalprice(), (BigDecimal[])new BigDecimal[]{revolvingleasedetailVO.getTaxCompensateAccount(), revolvingleasedetailVO.getTaxOtherExpenses()}));
                revolvingleasedetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(34))) ? String.valueOf(datas.get(34)) : null);
                RevolvingleasedetailVO revolvingleasedetailVO1 = this.revolvingleaseService.queryDetailList(contractId, revolvingleasedetailVO.getEncode(), revolvingleasedetailVO.getMaterialCode());
                if (revolvingleasedetailVO1 != null) {
                    revolvingleasedetailVO.setSumRentMoney(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO1.getSumRentMoney(), (BigDecimal)revolvingleasedetailVO.getLesseeTotalprice()));
                    revolvingleasedetailVO.setSumRentMoneyTax(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO1.getSumRentMoneyTax(), (BigDecimal)revolvingleasedetailVO.getTaxLesseeTotalprice()));
                    revolvingleasedetailVO.setSumCompensationMoney(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO1.getSumCompensationMoney(), (BigDecimal)revolvingleasedetailVO.getCompensateAccount()));
                    revolvingleasedetailVO.setSumCompensationMoneyTax(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO1.getSumCompensationMoneyTax(), (BigDecimal)revolvingleasedetailVO.getTaxCompensateAccount()));
                    revolvingleasedetailVO.setSumFeeMoney(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO1.getSumFeeMoney(), (BigDecimal)revolvingleasedetailVO.getOtherExpenses()));
                    revolvingleasedetailVO.setSumFeeMoneyTax(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO1.getSumFeeMoneyTax(), (BigDecimal)revolvingleasedetailVO.getTaxOtherExpenses()));
                    revolvingleasedetailVO.setCumulativeAmount(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO1.getCumulativeAmount(), (BigDecimal)revolvingleasedetailVO.getMonthlyExpenses()));
                    revolvingleasedetailVO.setTaxCumulativeAmount(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO1.getTaxCumulativeAmount(), (BigDecimal)revolvingleasedetailVO.getTaxMonthlyExpenses()));
                    revolvingleasedetailVO.setLeaseDaysSumTime(ComputeUtil.safeAdd((BigDecimal)revolvingleasedetailVO1.getLeaseDaysSumTime(), (BigDecimal)new BigDecimal(revolvingleasedetailVO.getLesseeTerm())));
                } else {
                    revolvingleasedetailVO.setSumRentMoney(revolvingleasedetailVO.getLesseeTotalprice());
                    revolvingleasedetailVO.setSumRentMoneyTax(revolvingleasedetailVO.getTaxLesseeTotalprice());
                    revolvingleasedetailVO.setSumCompensationMoney(revolvingleasedetailVO.getCompensateAccount());
                    revolvingleasedetailVO.setSumCompensationMoneyTax(revolvingleasedetailVO.getTaxCompensateAccount());
                    revolvingleasedetailVO.setSumFeeMoney(revolvingleasedetailVO.getOtherExpenses());
                    revolvingleasedetailVO.setSumFeeMoneyTax(revolvingleasedetailVO.getTaxOtherExpenses());
                    revolvingleasedetailVO.setCumulativeAmount(revolvingleasedetailVO.getMonthlyExpenses());
                    revolvingleasedetailVO.setTaxCumulativeAmount(revolvingleasedetailVO.getTaxMonthlyExpenses());
                    revolvingleasedetailVO.setLeaseDaysSumTime(new BigDecimal(revolvingleasedetailVO.getLesseeTerm()));
                }
                revolvingleasedetailVO.setSumRentMoneyPast(revolvingleasedetailVO.getSumRentMoney());
                revolvingleasedetailVO.setSumRentMoneyTaxPast(revolvingleasedetailVO.getSumRentMoneyTax());
                revolvingleasedetailVO.setSumCompensationMoneyPast(revolvingleasedetailVO.getSumCompensationMoney());
                revolvingleasedetailVO.setSumCompensationMoneyTaxPast(revolvingleasedetailVO.getSumCompensationMoneyTax());
                revolvingleasedetailVO.setSumFeeMoneyPast(revolvingleasedetailVO.getSumFeeMoney());
                revolvingleasedetailVO.setSumFeeMoneyTaxPast(revolvingleasedetailVO.getSumFeeMoneyTax());
                revolvingleasedetailVO.setCumulativeAmountPast(revolvingleasedetailVO.getCumulativeAmount());
                revolvingleasedetailVO.setTaxCumulativeAmountPast(revolvingleasedetailVO.getTaxCumulativeAmount());
                if (num1 > 0) {
                    errorList.add(revolvingleasedetailVO);
                    continue;
                }
                successList.add(revolvingleasedetailVO);
            }
        }
        Collections.sort(successList, new Comparator<RevolvingleasedetailVO>(){

            @Override
            public int compare(RevolvingleasedetailVO o1, RevolvingleasedetailVO o2) {
                return (o1.getEncode() + o1.getSection()).compareTo(o2.getEncode() + o2.getSection());
            }
        });
        List<RevolvingleasedetailVO> resList = this.setTidAndTpid(successList, mapVO);
        List tpidList = resList.stream().map(RevolvingleasedetailVO::getTpid).collect(Collectors.toList());
        for (RevolvingleasedetailVO revolvingleasedetailVO : resList) {
            List<RevolvingleasedetailVO> detailByPid = this.getDetailByPid(revolvingleasedetailVO.getTid(), resList);
            if (!CollectionUtils.isNotEmpty(detailByPid)) continue;
            revolvingleasedetailVO.setSettleTime(null);
            revolvingleasedetailVO.setSettleTimeShow(null);
            revolvingleasedetailVO.setLesseeTerm(null);
            revolvingleasedetailVO.setLesseeQuantity(null);
            revolvingleasedetailVO.setLesseeUnitprice(null);
            revolvingleasedetailVO.setTaxLesseeUnitprice(null);
            revolvingleasedetailVO.setLossDamage(null);
            revolvingleasedetailVO.setCompensateUnitprice(null);
            revolvingleasedetailVO.setTaxCompensateUnitprice(null);
            revolvingleasedetailVO.setOtherExpenses(null);
            revolvingleasedetailVO.setTaxOtherExpenses(null);
            revolvingleasedetailVO.setEndTimeShow(null);
            BigDecimal lesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeTotalprice() != null).map(RevolvingleasedetailVO::getLesseeTotalprice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxLesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxLesseeTotalprice() != null).map(RevolvingleasedetailVO::getTaxLesseeTotalprice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal compensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCompensateAccount() != null).map(RevolvingleasedetailVO::getCompensateAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCompensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCompensateAccount() != null).map(RevolvingleasedetailVO::getTaxCompensateAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal monthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getMonthlyExpenses() != null).map(RevolvingleasedetailVO::getMonthlyExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxMonthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxMonthlyExpenses() != null).map(RevolvingleasedetailVO::getTaxMonthlyExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumRentMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoney() != null).map(RevolvingleasedetailVO::getSumRentMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumRentMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoneyTax() != null).map(RevolvingleasedetailVO::getSumRentMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumCompensationMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoney() != null).map(RevolvingleasedetailVO::getSumCompensationMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumCompensationMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoneyTax() != null).map(RevolvingleasedetailVO::getSumCompensationMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumFeeMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoney() != null).map(RevolvingleasedetailVO::getSumFeeMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumFeeMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoneyTax() != null).map(RevolvingleasedetailVO::getSumFeeMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal cumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCumulativeAmount() != null).map(RevolvingleasedetailVO::getCumulativeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCumulativeAmount() != null).map(RevolvingleasedetailVO::getTaxCumulativeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal otherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getOtherExpenses() != null).map(RevolvingleasedetailVO::getOtherExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxOtherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxOtherExpenses() != null).map(RevolvingleasedetailVO::getTaxOtherExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            revolvingleasedetailVO.setOtherExpenses(otherExpenses);
            revolvingleasedetailVO.setTaxOtherExpenses(taxOtherExpenses);
            revolvingleasedetailVO.setLesseeTotalprice(lesseeTotalprice);
            revolvingleasedetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);
            revolvingleasedetailVO.setCompensateAccount(compensateAccount);
            revolvingleasedetailVO.setTaxCompensateAccount(taxCompensateAccount);
            revolvingleasedetailVO.setMonthlyExpenses(monthlyExpenses);
            revolvingleasedetailVO.setTaxMonthlyExpenses(taxMonthlyExpenses);
            revolvingleasedetailVO.setSumRentMoney(sumRentMoney);
            revolvingleasedetailVO.setSumRentMoneyTax(sumRentMoneyTax);
            revolvingleasedetailVO.setSumCompensationMoney(sumCompensationMoney);
            revolvingleasedetailVO.setSumCompensationMoneyTax(sumCompensationMoneyTax);
            revolvingleasedetailVO.setSumFeeMoney(sumFeeMoney);
            revolvingleasedetailVO.setSumFeeMoneyTax(sumFeeMoneyTax);
            revolvingleasedetailVO.setCumulativeAmount(cumulativeAmount);
            revolvingleasedetailVO.setTaxCumulativeAmount(taxCumulativeAmount);
            this.subList.clear();
        }
        resList = ExcelRevolvingleaseController.createTreeData(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)resList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<RevolvingleasedetailVO> getDetailByPid(String tid, List<RevolvingleasedetailVO> list) {
        for (RevolvingleasedetailVO revolvingleasedetailVO : list) {
            if (tid == null || !tid.equals(revolvingleasedetailVO.getTpid())) continue;
            this.getDetailByPid(revolvingleasedetailVO.getTid(), list);
            this.subList.add(revolvingleasedetailVO);
        }
        return this.subList;
    }

    public static List<RevolvingleasedetailVO> createTreeData(List<RevolvingleasedetailVO> list) {
        ArrayList<RevolvingleasedetailVO> resp = new ArrayList<RevolvingleasedetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, RevolvingleasedetailVO> listMap = new HashMap<String, RevolvingleasedetailVO>();
        for (RevolvingleasedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            RevolvingleasedetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            RevolvingleasedetailVO parent = (RevolvingleasedetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<RevolvingleasedetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<RevolvingleasedetailVO> children = new ArrayList<RevolvingleasedetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((RevolvingleasedetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private List<RevolvingleasedetailVO> setTidAndTpid(List<RevolvingleasedetailVO> vos, Map<String, RevolvingleasedetailVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            RevolvingleasedetailVO consdrawbudgetdetailVO = vos.get(i);
            String innercode = consdrawbudgetdetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                consdrawbudgetdetailVO.setTpid(pid.toString());
                continue;
            }
            consdrawbudgetdetailVO.setTpid("");
        }
        return vos;
    }

    private Long setPid(String pcode, Map<String, RevolvingleasedetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }

    @RequestMapping(value={"/excelExportRevolvingleaseFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportRevolvingleaseFromDatabase(@RequestBody RevolvingleaseVO revolvingleaseVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)revolvingleaseVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.revolvingleasedetailService.list((Wrapper)queryWrapper);
        List revolvingleasedetailVOList = BeanMapper.mapList((Iterable)list, RevolvingleasedetailVO.class);
        if (revolvingleasedetailVOList != null && revolvingleasedetailVOList.size() > 0) {
            for (int i = 0; i < revolvingleasedetailVOList.size(); ++i) {
                RevolvingleasedetailVO revolvingleasedetailVO = (RevolvingleasedetailVO)((Object)revolvingleasedetailVOList.get(i));
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() == null) continue;
                revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", revolvingleasedetailVOList);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportRevolvingleaseFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportRevolvingleaseFromPage(@RequestBody List<RevolvingleasedetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                RevolvingleasedetailVO revolvingleasedetailVO = list.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() == null) continue;
                revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
            }
        }
        HashMap<String, List<RevolvingleasedetailVO>> beans = new HashMap<String, List<RevolvingleasedetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

    private RevolvingleaseVO getPastTotalData(Long contractId, Date currentDate, boolean isSave) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List proTotal = this.revolvingleaseService.list((Wrapper)queryWrapperTotal);
        ArrayList revolvingleasedetailEntityList = new ArrayList();
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            RevolvingleaseEntity revolvingleaseEntity = (RevolvingleaseEntity)((Object)proTotal.get(0));
            BigDecimal Total = revolvingleaseEntity.getTotal();
            BigDecimal TaxTotal = revolvingleaseEntity.getTaxTotal();
            if (occurrenceTotal != null && Total != null) {
                occurrenceTotal = occurrenceTotal.add(revolvingleaseEntity.getTotal());
            }
            if (taxOccurrenceTotal != null && TaxTotal != null) {
                taxOccurrenceTotal = taxOccurrenceTotal.add(revolvingleaseEntity.getTaxTotal());
            }
            if (isSave) {
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.eq((Object)"mid", (Object)revolvingleaseEntity.getId());
                List detailList = this.revolvingleasedetailService.list((Wrapper)detailWrapper);
                revolvingleasedetailEntityList.addAll(detailList);
            }
        }
        RevolvingleaseVO vo = new RevolvingleaseVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);
        vo.setContractId(contractId);
        vo.setRevolvingleasedetailEntities(BeanMapper.mapList(revolvingleasedetailEntityList, RevolvingleasedetailVO.class));
        return vo;
    }
}

