/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetailEntity;
import com.ejianc.business.middlemeasurement.mapper.MechanicalleaseMapper;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleaseVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mechanicalleaseService")
public class MechanicalleaseServiceImpl
extends BaseServiceImpl<MechanicalleaseMapper, MechanicalleaseEntity>
implements IMechanicalleaseService {
    @Autowired
    private IMechanicalleaseService service;
    @Autowired
    private IMechanicalleasedetailService mechanicalleasedetailService;

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"DATE_FORMAT( settlement_time, '%Y-%m' )", (Object)monthStr);
        List list = this.service.list((Wrapper)query);
        if (!list.isEmpty()) {
            for (MechanicalleaseEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = this.service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MechanicalleaseEntity::getProjectId, (Object)projectId)).apply("DATE_FORMAT(settlement_time, '%Y-%m') < '" + monthStr + "'", new Object[0])).and(qw -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(MechanicalleaseEntity::getIsSettlement)).or()).eq(MechanicalleaseEntity::getIsSettlement, (Object)0));
        int count = this.service.count((Wrapper)query);
        if (count > 0) {
            throw new BusinessException("\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u4e2d\u95f4\u8ba1\u91cf\u6709\u5f80\u671f\u672a\u5f52\u96c6\u7684\u6570\u636e");
        }
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MechanicalleaseEntity::getProjectId, (Object)projectId)).ne(MechanicalleaseEntity::getBillState, (Object)3)).ne(MechanicalleaseEntity::getBillState, (Object)1)).apply("DATE_FORMAT(settlement_time, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count1 = this.service.count((Wrapper)query1);
        if (count1 > 0) {
            throw new BusinessException("\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u4e2d\u95f4\u8ba1\u91cf\u6709\u672c\u671f\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e");
        }
        return true;
    }

    @Override
    public MechanicalleaseVO getDataById(MechanicalleaseVO mechanicalleaseVO) {
        LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(MechanicalleaseEntity::getContractId, (Object)mechanicalleaseVO.getContractId());
        listWrapper.in(MechanicalleaseEntity::getBillState, new Object[]{"1,3"});
        List mechanicalleaseEntityList = super.list((Wrapper)listWrapper);
        Map<Object, Object> groupMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)mechanicalleaseEntityList)) {
            List ids = mechanicalleaseEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper detailWrapper = Wrappers.lambdaQuery();
            detailWrapper.in(MechanicalleasedetailEntity::getMid, ids);
            List mechanicalleasedetailEntityList = this.mechanicalleasedetailService.list((Wrapper)detailWrapper);
            if (CollectionUtils.isNotEmpty((Collection)mechanicalleasedetailEntityList)) {
                groupMap = mechanicalleasedetailEntityList.stream().collect(Collectors.groupingBy(s -> s.getEquipmentCode() + '-' + s.getExTaxLeaseUnit() + '-' + s.getInTaxLeaseUnit()));
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        List<MechanicalleasedetailVO> mechanicalleasedetailEntities = mechanicalleaseVO.getMechanicalleasedetailEntities();
        if (CollectionUtils.isNotEmpty(mechanicalleasedetailEntities)) {
            for (MechanicalleasedetailVO mechanicalleasedetailVO : mechanicalleasedetailEntities) {
                String key = mechanicalleasedetailVO.getEquipmentCode() + '-' + decimalFormat.format(mechanicalleasedetailVO.getExTaxLeaseUnit()) + '-' + decimalFormat.format(mechanicalleasedetailVO.getInTaxLeaseUnit());
                BigDecimal exTaxLeaseUnit = mechanicalleasedetailVO.getExTaxLeaseUnit() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getExTaxLeaseUnit();
                BigDecimal inTaxLeaseUnit = mechanicalleasedetailVO.getInTaxLeaseUnit() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getInTaxLeaseUnit();
                BigDecimal leaseDaysThisTime = mechanicalleasedetailVO.getLeaseDaysThisTime() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getLeaseDaysThisTime();
                BigDecimal leaseNum = mechanicalleasedetailVO.getLeaseNum() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getLeaseNum();
                BigDecimal exTaxRentSettleAmount = exTaxLeaseUnit.multiply(leaseDaysThisTime).multiply(leaseNum);
                BigDecimal inTaxRentSettleAmount = inTaxLeaseUnit.multiply(leaseDaysThisTime).multiply(leaseNum);
                BigDecimal exTaxEntranceExitFee = mechanicalleasedetailVO.getExTaxEntranceExitFee() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getExTaxEntranceExitFee();
                BigDecimal inTaxEntranceExitFee = mechanicalleasedetailVO.getInTaxEntranceExitFee() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getInTaxEntranceExitFee();
                BigDecimal exTaxEefCurrentSettleAmount = exTaxRentSettleAmount.add(exTaxEntranceExitFee);
                BigDecimal inTaxEefCurrentSettleAmount = inTaxRentSettleAmount.add(inTaxEntranceExitFee);
                mechanicalleasedetailVO.setExTaxRentCumulative(exTaxRentSettleAmount);
                mechanicalleasedetailVO.setInTaxRentCumulative(inTaxRentSettleAmount);
                mechanicalleasedetailVO.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFee);
                mechanicalleasedetailVO.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFee);
                mechanicalleasedetailVO.setExTaxEefCumulative(exTaxEefCurrentSettleAmount);
                mechanicalleasedetailVO.setInTaxEefCumulative(inTaxEefCurrentSettleAmount);
                if (!groupMap.containsKey(key)) continue;
                List groupList = (List)groupMap.get(key);
                BigDecimal exTaxRentSettleAmountSum = groupList.stream().filter(item -> item.getExTaxRentSettleAmount() != null).map(MechanicalleasedetailEntity::getExTaxRentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal inTaxRentSettleAmountSum = groupList.stream().filter(item -> item.getInTaxRentSettleAmount() != null).map(MechanicalleasedetailEntity::getInTaxRentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal exTaxEntranceExitFeeSum = groupList.stream().filter(item -> item.getExTaxEntranceExitFee() != null).map(MechanicalleasedetailEntity::getExTaxEntranceExitFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal inTaxEntranceExitFeeSum = groupList.stream().filter(item -> item.getInTaxEntranceExitFee() != null).map(MechanicalleasedetailEntity::getInTaxEntranceExitFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal exTaxEefCurrentSettleAmountSum = groupList.stream().filter(item -> item.getExTaxEefCurrentSettleAmount() != null).map(MechanicalleasedetailEntity::getExTaxEefCurrentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal inTaxEefCurrentSettleAmountSum = groupList.stream().filter(item -> item.getInTaxEefCurrentSettleAmount() != null).map(MechanicalleasedetailEntity::getInTaxEefCurrentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                mechanicalleasedetailVO.setExTaxRentCumulative(exTaxRentSettleAmount.add(exTaxRentSettleAmountSum));
                mechanicalleasedetailVO.setInTaxRentCumulative(inTaxRentSettleAmount.add(inTaxRentSettleAmountSum));
                mechanicalleasedetailVO.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFee.add(exTaxEntranceExitFeeSum));
                mechanicalleasedetailVO.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFee.add(inTaxEntranceExitFeeSum));
                mechanicalleasedetailVO.setExTaxEefCumulative(exTaxEefCurrentSettleAmount.add(exTaxEefCurrentSettleAmountSum));
                mechanicalleasedetailVO.setInTaxEefCumulative(inTaxEefCurrentSettleAmount.add(inTaxEefCurrentSettleAmountSum));
                mechanicalleasedetailVO.setMathExTaxRentCumulative(exTaxRentSettleAmountSum);
                mechanicalleasedetailVO.setMathInTaxRentCumulative(inTaxRentSettleAmountSum);
                mechanicalleasedetailVO.setMathExTaxEntranceExitFeeCumulative(exTaxEntranceExitFeeSum);
                mechanicalleasedetailVO.setMathInTaxEntranceExitFeeCumulative(inTaxEntranceExitFeeSum);
            }
        }
        return mechanicalleaseVO;
    }

    @Override
    public MechanicalleasedetailVO queryCumulative(Long projectId, Long contractId, String equipmentCode) {
        MechanicalleasedetailVO vo = ((MechanicalleaseMapper)this.baseMapper).queryCumulative(projectId, contractId, equipmentCode);
        return vo;
    }
}

