/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.mapper.PurchasesettlementMapper;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchasesettlementService")
public class PurchasesettlementServiceImpl
extends BaseServiceImpl<PurchasesettlementMapper, PurchasesettlementEntity>
implements IPurchasesettlementService {
    @Autowired
    private IPurchasesettlementService purchasesettlementService;
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;

    @Override
    public PurchasesettlementVO getSumByContractId(Long contractId) {
        PurchasesettlementVO purchasesettlementVO = new PurchasesettlementVO();
        LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(PurchasesettlementEntity::getContractId, (Object)contractId);
        listWrapper.in(PurchasesettlementEntity::getBillState, new Object[]{"1,3"});
        List purchasesettlementEntities = super.list((Wrapper)listWrapper);
        if (CollectionUtils.isNotEmpty((Collection)purchasesettlementEntities)) {
            BigDecimal sumMny = purchasesettlementEntities.stream().map(PurchasesettlementEntity::getMonthlyTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumMnyTax = purchasesettlementEntities.stream().map(PurchasesettlementEntity::getTaxMonthlyTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchasesettlementVO.setSumMny(sumMny);
            purchasesettlementVO.setSumMnyTax(sumMnyTax);
        }
        return purchasesettlementVO;
    }

    @Override
    public PurchasesettlementVO getPurchaseDataById(PurchasesettlementVO purchasesettlementVO) {
        List purchasesettlementdetailEntities;
        LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(PurchasesettlementEntity::getContractId, (Object)purchasesettlementVO.getContractId());
        listWrapper.in(PurchasesettlementEntity::getBillState, new Object[]{"1,3"});
        List purchasesettlementEntityList = super.list((Wrapper)listWrapper);
        Map<Object, Object> groupMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)purchasesettlementEntityList)) {
            List ids = purchasesettlementEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper detailWrapper = Wrappers.lambdaQuery();
            detailWrapper.in(PurchasesettlementdetailEntity::getMid, ids);
            List mechanicalleasedetailEntityList = this.purchasesettlementdetailService.list((Wrapper)detailWrapper);
            if (CollectionUtils.isNotEmpty((Collection)mechanicalleasedetailEntityList)) {
                groupMap = mechanicalleasedetailEntityList.stream().collect(Collectors.groupingBy(s -> s.getBillCode()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(purchasesettlementdetailEntities = purchasesettlementVO.getPurchasesettlementdetailEntities()))) {
            for (PurchasesettlementdetailVO purchasesettlementdetailVO : purchasesettlementdetailEntities) {
                String key = purchasesettlementdetailVO.getBillCode();
                BigDecimal settlementPrice = purchasesettlementdetailVO.getSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSettlementPrice();
                BigDecimal taxSettlementPrice = purchasesettlementdetailVO.getTaxSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getTaxSettlementPrice();
                BigDecimal supplyQuantity = purchasesettlementdetailVO.getSupplyQuantity() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSupplyQuantity();
                BigDecimal settlementAmount = settlementPrice.multiply(supplyQuantity);
                BigDecimal taxSettlementAmount = taxSettlementPrice.multiply(supplyQuantity);
                purchasesettlementdetailVO.setSettlementAmount(settlementAmount);
                purchasesettlementdetailVO.setTaxSettlementAmount(taxSettlementAmount);
                purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity);
                purchasesettlementdetailVO.setSettlementTotal(settlementAmount);
                purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount);
                if (!groupMap.containsKey(key)) continue;
                List groupList = (List)groupMap.get(key);
                BigDecimal taxSettlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getTaxSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal settlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal supplyQuantitySum = groupList.stream().map(PurchasesettlementdetailEntity::getSupplyQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                purchasesettlementdetailVO.setSettlementTotal(settlementAmount.add(settlementAmountSum));
                purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount.add(taxSettlementAmountSum));
                purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity.add(supplyQuantitySum));
                purchasesettlementdetailVO.setSettleNum(supplyQuantity.add(supplyQuantitySum));
                purchasesettlementdetailVO.setSettleMny(settlementAmount.add(settlementAmountSum));
                purchasesettlementdetailVO.setSettleMnyTax(taxSettlementAmount.add(taxSettlementAmountSum));
            }
        }
        return purchasesettlementVO;
    }
}

