package com.ejianc.business.middlemeasurement.controller.api;

import com.ejianc.business.middlemeasurement.service.IConsultotherService;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodeService;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinalOtherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinaldetailVO;
import com.ejianc.foundation.middlemeasurement.vo.DesignSettlementDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/12/24
 * @description:查询设计和咨询过程单得子表得往期累计数据
 */
@RestController
@RequestMapping("/api/designAndConsultApi")
public class DesignAndConsultApiController {
    @Autowired
    private IConsultotherService consultotherService;
    @Autowired
    private IDesignsubcontractnodeService designsubcontractnodeService;

    /**
     * 根据合同id和报量时间查询其他扣款往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    @GetMapping(value = "/queryConsultOtherDetailCumPast")
    public CommonResponse<List<ConsultfinalOtherdetailVO>> queryConsultOtherDetailCumPast(Long contractId,String date){
        List<ConsultfinalOtherdetailVO> consultfinalOtherdetailVOS =
                consultotherService.queryConsultOtherDetailCumPast(contractId, date);
        for (ConsultfinalOtherdetailVO vo : consultfinalOtherdetailVOS) {
            vo.setId(IdWorker.getId());
        }
        return CommonResponse.success("查询咨询其他扣款的往期累计数据成功",consultfinalOtherdetailVOS);
    }

    /**
     * 根据合同id和报量时间查询子表往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    @GetMapping(value = "/queryConsultDetailCumPast")
    public CommonResponse<List<ConsultfinaldetailVO>> queryConsultDetailCumPast(Long contractId, String date){
        List<ConsultfinaldetailVO> consultfinalOtherdetailVOS =
                consultotherService.queryConsultDetailCumPast(contractId, date);
        for (ConsultfinaldetailVO vo : consultfinalOtherdetailVOS) {
            vo.setId(IdWorker.getId());
        }
        return CommonResponse.success("查询咨询子表的往期累计数据成功",consultfinalOtherdetailVOS);
    }
    /**
     * 根据合同id和报量时间查询子表往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    @GetMapping(value = "/queryDesignDetailCumPast")
    public CommonResponse<List<DesignSettlementDetailVO>> queryDesignDetailCumPast(Long contractId, String date){
        List<DesignSettlementDetailVO> consultfinalOtherdetailVOS =
                designsubcontractnodeService.queryDesignDetailCumPast(contractId, date);
        for (DesignSettlementDetailVO vo : consultfinalOtherdetailVOS) {
            vo.setId(IdWorker.getId());
        }
        return CommonResponse.success("查询设计分包子表的往期累计数据成功",consultfinalOtherdetailVOS);
    }


}
