package com.ejianc.business.middlemeasurement.excel;


import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 月度物资采购结算导入导出
 */
@Controller
@RequestMapping("purchasesettlementExport")
public class ExcelPurchasesettlementController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;

    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IPurchasesettlementService purchasesettlementService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadPurchasesettlement")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "purchasesettlementdetail-import.xlsx", "月度物资采购结算模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportPurchasesettlement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, Long contractId,HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PurchasesettlementdetailVO> successList = new ArrayList<>();
        List<PurchasesettlementdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            LambdaQueryWrapper<PurchasesettlementEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(PurchasesettlementEntity::getContractId, contractId);
            listWrapper.in(PurchasesettlementEntity::getBillState, "1,3");
            List<PurchasesettlementEntity> purchasesettlementEntityList = purchasesettlementService.list(listWrapper);
            Map<String, List<PurchasesettlementdetailEntity>> groupMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(purchasesettlementEntityList)){
                //主表id
                List<Long> ids = purchasesettlementEntityList.stream().map(PurchasesettlementEntity::getId).collect(Collectors.toList());

                LambdaQueryWrapper<PurchasesettlementdetailEntity> detailWrapper = Wrappers.lambdaQuery();
                detailWrapper.in(PurchasesettlementdetailEntity::getMid, ids);
                List<PurchasesettlementdetailEntity> mechanicalleasedetailEntityList = purchasesettlementdetailService.list(detailWrapper);
                if (CollectionUtils.isNotEmpty(mechanicalleasedetailEntityList)){
                    //获取累计值
                    groupMap = mechanicalleasedetailEntityList.stream().collect(
                            Collectors.groupingBy(s -> s.getBillCode()));
                }

            }

            List<List<String>> result = ExcelReader.readExcel(mf);
            Map<String, String> map = new HashMap<>();
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                     int errorCount =0;
                    List<String> datas = result.get(i);
                    PurchasesettlementdetailVO purchasesettlementdetailVO = new PurchasesettlementdetailVO();
                    purchasesettlementdetailVO.setId(IdWorker.getId());//id
                    purchasesettlementdetailVO.setSource("导入"); // 来源
                    if (datas.get(0) == null && StringUtils.isBlank(datas.get(0))) {
                        purchasesettlementdetailVO.setErrorMsg("'材料编码'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                        continue;
                    }else{
                        purchasesettlementdetailVO.setBillCode(StringUtils.isNotBlank(datas.get(0)) ? datas.get(0) : null); // 材料编码
                    }

                    if (StringUtils.isBlank(datas.get(1)) && datas.get(1) == null) {
                        purchasesettlementdetailVO.setErrorMsg("'材料名称'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                        continue;
                    }else{
                        purchasesettlementdetailVO.setBillName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 材料名称
                    }

                    if (StringUtils.isBlank(datas.get(2)) && datas.get(2) == null) {
                        purchasesettlementdetailVO.setErrorMsg("'品牌/规格型号'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                        continue;
                    }else{
                        purchasesettlementdetailVO.setBrandModel(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 品牌/规格型号
                    }

                    //校验库中物资
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(0));
                    if (back0.getCode() == 1 || back0.getData() == null) {
                        purchasesettlementdetailVO.setErrorMsg("未查询到该材料编码下的物资详情");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                        continue;
                    }

                    if (StringUtils.isNotBlank(back0.getData().getName())) {
                        if (!back0.getData().getName().equals(datas.get(1))) {
                            purchasesettlementdetailVO.setErrorMsg("'材料名称'错误,请检查！");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getSpec())) {
                        if (!back0.getData().getSpec().equals(datas.get(2))) {
                            purchasesettlementdetailVO.setErrorMsg("'品牌/规格型号'错误,请检查！");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getUnitName())) {
                        if (!back0.getData().getUnitName().equals(datas.get(3))) {
                            purchasesettlementdetailVO.setErrorMsg("'单位'错误,请检查！");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                            continue;
                        }
                    }else{
                        purchasesettlementdetailVO.setUnit(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 单位
                    }


                    //物资名称三项是否重复
                    StringBuffer materConcat = new StringBuffer();
                    if (datas.get(2) != null && StringUtils.isNotBlank(datas.get(2))) {
                        materConcat.append(back0.getData().getCode()).append(back0.getData().getName()).append(back0.getData().getSpec());
                    }
                    if (datas.get(3) != null && StringUtils.isNotBlank(datas.get(3))) {
                        materConcat.append(back0.getData().getUnitName());
                    }
                    map.put(materConcat.toString(), materConcat.toString());

                    purchasesettlementdetailVO.setBillCode(back0.getData().getCode());
                    purchasesettlementdetailVO.setBillName(back0.getData().getName());
                    purchasesettlementdetailVO.setBrandModel(back0.getData().getSpec());
                    purchasesettlementdetailVO.setUnit(back0.getData().getUnitName());

                    purchasesettlementdetailVO.setMaterialCategoryId(back0.getData().getCategoryId());
                    purchasesettlementdetailVO.setMaterialCategoryCode(back0.getData().getCode());
                    purchasesettlementdetailVO.setMaterialCategory(back0.getData().getCategoryName());



                    if(StringUtils.isBlank(datas.get(4)) || datas.get(4) == null){
                        purchasesettlementdetailVO.setErrorMsg("'供货时间'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                    }else{
                        if (DateUtils.grepDate(datas.get(4))) {
                            purchasesettlementdetailVO.setErrorMsg("'供货时间'格式到月份");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setSupplyTime(StringUtils.isNotBlank(datas.get(4)) ?  DateUtils.Dates(datas.get(4)) : null); //供货时间
                        }
                    }
                    if(StringUtils.isBlank(datas.get(5)) || datas.get(5) == null){
                       /* purchasesettlementdetailVO.setErrorMsg("'合同单价除税(元)'不能为空");
                        errorBuffer.append("'合同单价除税(元)'不能为空");*/
                    }else{
                        if (!NumberUtil.isNumber(datas.get(5))) {
                            purchasesettlementdetailVO.setErrorMsg("'网价'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setNetPrice(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 网价(元)
                        }
                    }
                    if(StringUtils.isBlank(datas.get(6)) || datas.get(6) == null){
                       /* purchasesettlementdetailVO.setErrorMsg("'合同单价除税(元)'不能为空");
                        errorBuffer.append("'合同单价除税(元)'不能为空");*/
                    }else{
                        if (!NumberUtil.isNumber(datas.get(6))) {
                            purchasesettlementdetailVO.setErrorMsg("'浮动价'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setFloatPrice(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 浮动价(元)
                        }
                    }

                    if(StringUtils.isBlank(datas.get(7)) || datas.get(7) == null){
                       /* purchasesettlementdetailVO.setErrorMsg("'合同单价除税(元)'不能为空");
                        errorBuffer.append("'合同单价除税(元)'不能为空");*/
                    }else{
                        if (!NumberUtil.isNumber(datas.get(7))) {
                            purchasesettlementdetailVO.setErrorMsg("'合同单价除税(元)'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setUnitPrice(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 合同单价除税(元)
                        }
                    }


                    if(StringUtils.isBlank(datas.get(8)) || datas.get(8) == null){
                       /* purchasesettlementdetailVO.setErrorMsg("'合同单价含税(元)'不能为空");
                        errorBuffer.append("'合同单价含税(元)'不能为空");*/
                    }else{
                        if (!NumberUtil.isNumber(datas.get(8))) {
                            purchasesettlementdetailVO.setErrorMsg("'合同单价含税(元)'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setTaxUnitPrice(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 合同单价含税(元)
                        }
                    }

                    BigDecimal supplyNumber = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(9)) || datas.get(9) == null){
                        purchasesettlementdetailVO.setErrorMsg("'结算量'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(9))){
                            purchasesettlementdetailVO.setErrorMsg("'结算量'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            supplyNumber = supplyNumber.add(new BigDecimal(datas.get(9)));
                            purchasesettlementdetailVO.setSupplyQuantity(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 供货数量
                        }
                    }


                    BigDecimal exPrice = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(10)) || datas.get(10) == null){
                        purchasesettlementdetailVO.setErrorMsg("'结算单价(除税)(元)'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                    }else{
                        if (!NumberUtil.isNumber(datas.get(10))) {
                            purchasesettlementdetailVO.setErrorMsg("'结算单价(除税)(元)'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            exPrice = exPrice.add(new BigDecimal(datas.get(10)));
                            purchasesettlementdetailVO.setSettlementPrice(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 结算单价(除税)(元)
                        }
                    }

                    BigDecimal inPrice = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(11)) || datas.get(11) == null){
                        purchasesettlementdetailVO.setErrorMsg("'结算单价(含税)(元)'不能为空");
                        errorList.add(purchasesettlementdetailVO);
                    }else{
                        if (!NumberUtil.isNumber(datas.get(11))) {
                            purchasesettlementdetailVO.setErrorMsg("'结算单价(含税)(元)'格式错误");
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            inPrice = inPrice.add(new BigDecimal(datas.get(11)));
                            purchasesettlementdetailVO.setTaxSettlementPrice(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 结算单价(含税)(元)
                        }
                    }

                    purchasesettlementdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(14)) ?datas.get(14) : null); // 备注

                    String key = purchasesettlementdetailVO.getBillCode();
                    BigDecimal settlementPrice = purchasesettlementdetailVO.getSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSettlementPrice();
                    BigDecimal taxSettlementPrice = purchasesettlementdetailVO.getTaxSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getTaxSettlementPrice();
                    BigDecimal supplyQuantity = purchasesettlementdetailVO.getSupplyQuantity() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSupplyQuantity();
                    //本期值
                    BigDecimal settlementAmount = settlementPrice.multiply(supplyQuantity);
                    BigDecimal taxSettlementAmount = taxSettlementPrice.multiply(supplyQuantity);
                    purchasesettlementdetailVO.setSettlementAmount(settlementAmount);
                    purchasesettlementdetailVO.setTaxSettlementAmount(taxSettlementAmount);
                    //累计值
                    purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity);
                    purchasesettlementdetailVO.setSettlementTotal(settlementAmount);
                    purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount);

                    if (groupMap.containsKey(key)) {
                        List<PurchasesettlementdetailEntity> groupList = groupMap.get(key);
                        BigDecimal taxSettlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getTaxSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal settlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal supplyQuantitySum = groupList.stream().map(PurchasesettlementdetailEntity::getSupplyQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                        purchasesettlementdetailVO.setSettlementTotal(settlementAmount.add(settlementAmountSum));
                        purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount.add(taxSettlementAmountSum));
                        purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity.add(supplyQuantitySum));

                        purchasesettlementdetailVO.setSettleNum(supplyQuantity.add(supplyQuantitySum));
                        purchasesettlementdetailVO.setSettleMny(settlementAmount.add(settlementAmountSum));
                        purchasesettlementdetailVO.setSettleMnyTax(taxSettlementAmount.add(taxSettlementAmountSum));
                    }

                    if(errorCount==0){
                        successList.add(purchasesettlementdetailVO);
                    }
                }
            }
        }

        //填充往期数据
        getLastDetail(contractId,successList);


        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
    //填充往期数据
    private void getLastDetail(Long contractId, List<PurchasesettlementdetailVO> successList) {
        LambdaQueryWrapper<PurchasesettlementEntity> lambdaLast = Wrappers.<PurchasesettlementEntity>lambdaQuery();
        lambdaLast.eq(PurchasesettlementEntity::getContractId, contractId);
        lambdaLast.in(PurchasesettlementEntity::getBillState, 1,3);
        lambdaLast.orderByDesc(PurchasesettlementEntity::getCreateTime);
        List<PurchasesettlementEntity> costanalysisEntityList = purchasesettlementService.list(lambdaLast);
        List<PurchasesettlementdetailEntity> subcontractingvolumedetailEntityList = new ArrayList<>();
        Map<String, List<PurchasesettlementdetailVO>> groupMap = new HashMap<>();
        Map<String, List<PurchasesettlementdetailVO>> groupLastMap = new HashMap<>();

        if(CollectionUtils.isNotEmpty(costanalysisEntityList)){
            PurchasesettlementEntity subcontractingvolumeEntityLast = costanalysisEntityList.stream().findFirst().get();
            LambdaQueryWrapper<PurchasesettlementdetailEntity> lambdaCostPeople = Wrappers.<PurchasesettlementdetailEntity>lambdaQuery();
            lambdaCostPeople.eq(PurchasesettlementdetailEntity::getMid, subcontractingvolumeEntityLast.getId());
            subcontractingvolumedetailEntityList = purchasesettlementdetailService.list(lambdaCostPeople);
        }

        groupMap = successList.stream().filter(s-> !(s.getRowState() != null && s.getRowState().equals("del"))).collect(
                Collectors.groupingBy(
                        s -> s.getBillCode()
                ));
        List<PurchasesettlementdetailVO> subcontractingvolumedetailVOS = BeanMapper.mapList(subcontractingvolumedetailEntityList, PurchasesettlementdetailVO.class);
        for (PurchasesettlementdetailVO subcontractingvolumedetailEntity : subcontractingvolumedetailVOS){
            String key = subcontractingvolumedetailEntity.getBillCode();
            if (!groupMap.containsKey(key)) {
                subcontractingvolumedetailEntity.setSupplyQuantity(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setSettlementAmount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxSettlementAmount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setId(IdWorker.getId());
                subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.上期数据.getCode());
                subcontractingvolumedetailEntity.setMid(null);

                successList.add(subcontractingvolumedetailEntity);
            }
        }

        groupLastMap = subcontractingvolumedetailVOS.stream().filter(s-> !(s.getRowState() != null && s.getRowState().equals("del"))).collect(
                Collectors.groupingBy(
                        s -> s.getBillCode()
                ));
        for (PurchasesettlementdetailVO subcontractingvolumedetailEntity : successList){
            String key = subcontractingvolumedetailEntity.getBillCode();
            if (groupLastMap.containsKey(key)) {
                subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.上期数据.getCode());
            }
        }

    }
    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPurchasesettlementFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody PurchasesettlementVO purchasesettlementVO, HttpServletResponse response) {
        QueryWrapper<PurchasesettlementdetailEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("mid", purchasesettlementVO.getId());
        queryWrapper.eq("dr", 0);
        List<PurchasesettlementdetailEntity> list = purchasesettlementdetailService.list(queryWrapper);
        List<PurchasesettlementdetailVO> purchasesettlementdetailVOList = BeanMapper.mapList(list, PurchasesettlementdetailVO.class);
        if (purchasesettlementdetailVOList != null && purchasesettlementdetailVOList.size() > 0) {
            for (int i = 0; i < purchasesettlementdetailVOList.size(); i++) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = purchasesettlementdetailVOList.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if(purchasesettlementdetailVO.getSupplyTime()!=null){
                    String sdates = DateUtils.dateSimple3(purchasesettlementdetailVO.getSupplyTime());
                    purchasesettlementdetailVO.setSupplyTimeShow(sdates);

                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", purchasesettlementdetailVOList);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPurchasesettlementFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<PurchasesettlementdetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = list.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if(purchasesettlementdetailVO.getSupplyTime()!=null){
                    String sdate = DateUtils.dateSimple3(purchasesettlementdetailVO.getSupplyTime());
                    purchasesettlementdetailVO.setSupplyTimeShow(sdate);
                }

            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }

}
