package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("mechanicalleaseExport")
public class ExcelmechanicalleaseController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMechanicalleaseService service;

    @Autowired
    private IMechanicalleasedetailService detailService;

    @Autowired
    private IShareEquipmentApi shareEquipmentApi;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMechanicalleasedetail",method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "mechanicalleasedetail-imports.xlsx", "月度机械设备租赁单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelMechanicallease", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMechanicallease(HttpServletRequest request,Long selectContractId, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MechanicalleasedetailVO> successList = new ArrayList<>();
        List<MechanicalleasedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                LambdaQueryWrapper<MechanicalleaseEntity> listWrapper = Wrappers.lambdaQuery();
                listWrapper.eq(MechanicalleaseEntity::getContractId, selectContractId);
                listWrapper.in(MechanicalleaseEntity::getBillState, "1,3");
                List<MechanicalleaseEntity> mechanicalleaseEntityList = service.list(listWrapper);
                Map<String, List<MechanicalleasedetailEntity>> groupMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(mechanicalleaseEntityList)){
                    //主表id
                    List<Long> ids = mechanicalleaseEntityList.stream().map(MechanicalleaseEntity::getId).collect(Collectors.toList());

                    LambdaQueryWrapper<MechanicalleasedetailEntity> detailWrapper = Wrappers.lambdaQuery();
                    detailWrapper.in(MechanicalleasedetailEntity::getMid, ids);
                    List<MechanicalleasedetailEntity> mechanicalleasedetailEntityList = detailService.list(detailWrapper);
                    if (CollectionUtils.isNotEmpty(mechanicalleasedetailEntityList)){
                        //获取累计值
                        groupMap = mechanicalleasedetailEntityList.stream().collect(
                                Collectors.groupingBy(
                                        s -> s.getEquipmentCode() +'-' + s.getExTaxLeaseUnit() +'-' + s.getInTaxLeaseUnit()
                                ));
                    }

                }
                HashMap<String, String> map = new HashMap<>();
                DecimalFormat decimalFormat  = new DecimalFormat("0.00000000");
                for (int i = 1; i < result.size(); i++) {
                    MechanicalleasedetailVO mechanicalleasedetailVO = new MechanicalleasedetailVO();
                    List<String> datas = result.get(i);
                    mechanicalleasedetailVO.setId(IdWorker.getId());//id
                    mechanicalleasedetailVO.setSort(StringUtils.isNotEmpty(datas.get(0)) ? datas.get(0) : null);// 序号
                    mechanicalleasedetailVO.setEquipmentCode(StringUtils.isNotEmpty(datas.get(1)) ? datas.get(1) : null);// 单据编号
                    mechanicalleasedetailVO.setName(StringUtils.isNotEmpty(datas.get(2)) ? datas.get(2) : null);// 租赁物资名称
                    mechanicalleasedetailVO.setSpec(StringUtils.isNotEmpty(datas.get(3)) ? datas.get(3) : null); // 规格型号
                    mechanicalleasedetailVO.setMeasuringUnit(StringUtils.isNotEmpty(datas.get(4)) ? datas.get(4) : null);// 计量单位
                    String equipmentCode = datas.get(0);
                    if (equipmentCode == null ||equipmentCode == "") {
                        mechanicalleasedetailVO.setErrorMsg("设备编码不能为空");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }
                    //校验库中物资
                    CommonResponse<EquipmentVO> back0 = shareEquipmentApi.queryEquipmentByCode(datas.get(1));
                    if (back0.getCode() == 1 || back0.getData() == null) {
                        mechanicalleasedetailVO.setErrorMsg("未查询到该物资编码下的物资详情");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }
                    if (StringUtils.isNotBlank(back0.getData().getName())) {
                        if (!back0.getData().getName().equals(datas.get(2))) {
                            mechanicalleasedetailVO.setErrorMsg("'租赁物资名称'未在库中,请检查！");
                            errorList.add(mechanicalleasedetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getSpec())) {
                        if (!back0.getData().getSpec().equals(datas.get(3))) {
                            mechanicalleasedetailVO.setErrorMsg("'规格型号'未在库中,请检查！");
                            errorList.add(mechanicalleasedetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getUnitName())) {
                        if (!back0.getData().getUnitName().equals(datas.get(4))) {
                            mechanicalleasedetailVO.setErrorMsg("'计量单位'未在库中,请检查！");
                            errorList.add(mechanicalleasedetailVO);
                            continue;
                        }
                    }else{
                        mechanicalleasedetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(4))?datas.get(4):null);
                    }

                    //物资名称三项是否重复
                    StringBuffer materConcat = new StringBuffer();
                    if (datas.get(3) != null && StringUtils.isNotBlank(datas.get(3))) {
                        materConcat.append(back0.getData().getCode()).append(back0.getData().getName()).append(back0.getData().getSpec());
                    }
                    if (datas.get(4) != null && StringUtils.isNotBlank(datas.get(4))) {
                        materConcat.append(back0.getData().getUnitName());
                    }
                    if (map.containsKey(materConcat.toString())) {
                        mechanicalleasedetailVO.setErrorMsg("'编码','物资名称','物资规格','计量单位不能重复'");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    } else {
                        map.put(materConcat.toString(), materConcat.toString());
                    }

                    mechanicalleasedetailVO.setCategoryId(back0.getData().getCategoryId());//物资分类id
                    mechanicalleasedetailVO.setCategoryCode(back0.getData().getCode());// 物资分类编码
                    mechanicalleasedetailVO.setCategoryName(back0.getData().getCategoryName());//物资分类id


                    if(!NumberUtil.isNumber(datas.get(8))){
                        mechanicalleasedetailVO.setErrorMsg("'租赁数量'格式错误");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }else{
                        mechanicalleasedetailVO.setLeaseNum(StringUtils.isNotEmpty(datas.get(8)) ? new BigDecimal(datas.get(8)) : null);// 租赁数量
                    }
                    if(StringUtils.isBlank(datas.get(5)) || datas.get(5) == null){
                        mechanicalleasedetailVO.setErrorMsg("'本期计算起始日期'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }else{
                        if(!DateUtils.grepDate(datas.get(5))){
                            mechanicalleasedetailVO.setErrorMsg("'本期计算起始日期'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                            continue;
                        }else{
                            mechanicalleasedetailVO.setBillingStartTimes(StringUtils.isNotEmpty(datas.get(5)) ? DateUtils.Date(datas.get(5)) : null);// 本期计算起始日期
                        }
                     }

                    if(StringUtils.isBlank(datas.get(6)) || datas.get(6) == null){
                        mechanicalleasedetailVO.setErrorMsg("'本期计算终止日期'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }else {
                        if(!DateUtils.grepDate(datas.get(6))){
                            mechanicalleasedetailVO.setErrorMsg("'本期计算终止日期'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                            continue;
                        }else{
                            mechanicalleasedetailVO.setBillingEndTimes(StringUtils.isNotEmpty(datas.get(6)) ? DateUtils.Date(datas.get(6)) : null);// 本期计算终止日期
                        }
                    }

                    Date billingStartTime =  mechanicalleasedetailVO.getBillingStartTimes();// 本期计算起始日期
                    Date billingEndTime =  mechanicalleasedetailVO.getBillingEndTimes();// 本期计算终止日期

                    if(billingStartTime!=null && billingEndTime != null){
                        BigDecimal day = getDays2(billingStartTime,billingEndTime);
                        BigDecimal leaseDaysThisTime = day.add(new BigDecimal(1)).divide(new BigDecimal(30),8,BigDecimal.ROUND_HALF_UP);
                        mechanicalleasedetailVO.setLeaseDaysThisTime(leaseDaysThisTime);//  本期租赁期长(天/月/台)
                    }
                    if(!NumberUtil.isNumber(datas.get(9))){
                        mechanicalleasedetailVO.setErrorMsg("'租赁单价（除税）（元）'格式错误");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }else{
                        mechanicalleasedetailVO.setExTaxLeaseUnit(StringUtils.isNotEmpty(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 租赁单价（除税）（元）
                    }
                    if(!NumberUtil.isNumber(datas.get(10))){
                        mechanicalleasedetailVO.setErrorMsg("'租赁单价（含税）（元）'格式错误");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }else{
                        mechanicalleasedetailVO.setInTaxLeaseUnit(StringUtils.isNotEmpty(datas.get(10)) ? new BigDecimal(datas.get(10)) : null);// 租赁单价（含税）（元）
                    }

                    if(!NumberUtil.isNumber(datas.get(13))){
                        mechanicalleasedetailVO.setErrorMsg("'进出场费（除税）'格式错误");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }else {
                        mechanicalleasedetailVO.setExTaxEntranceExitFee(new BigDecimal(datas.get(13)));
                    }

                    if(!NumberUtil.isNumber(datas.get(14))){
                        mechanicalleasedetailVO.setErrorMsg("'进出场费（含税）'格式错误");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }else {
                        mechanicalleasedetailVO.setInTaxEntranceExitFee(new BigDecimal(datas.get(14)));
                    }

                    mechanicalleasedetailVO.setRemarks(StringUtils.isNotEmpty(datas.get(15)) ? datas.get(15) : null);// 备注
                    //计算累计值
                    String key = mechanicalleasedetailVO.getEquipmentCode() +'-' +
                            decimalFormat.format(mechanicalleasedetailVO.getExTaxLeaseUnit()) +'-' + decimalFormat.format(mechanicalleasedetailVO.getInTaxLeaseUnit());

                    BigDecimal exTaxLeaseUnit = mechanicalleasedetailVO.getExTaxLeaseUnit() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getExTaxLeaseUnit();
                    BigDecimal inTaxLeaseUnit = mechanicalleasedetailVO.getInTaxLeaseUnit() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getInTaxLeaseUnit();
                    BigDecimal leaseDaysThisTime = mechanicalleasedetailVO.getLeaseDaysThisTime() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getLeaseDaysThisTime();
                    BigDecimal leaseNum = mechanicalleasedetailVO.getLeaseNum() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getLeaseNum();

                    BigDecimal exTaxRentSettleAmount = exTaxLeaseUnit.multiply(leaseDaysThisTime).multiply(leaseNum);
                    BigDecimal inTaxRentSettleAmount = inTaxLeaseUnit.multiply(leaseDaysThisTime).multiply(leaseNum);
                    BigDecimal exTaxEntranceExitFee = mechanicalleasedetailVO.getExTaxEntranceExitFee() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getExTaxEntranceExitFee();;
                    BigDecimal inTaxEntranceExitFee = mechanicalleasedetailVO.getInTaxEntranceExitFee() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getInTaxEntranceExitFee();;
                    BigDecimal exTaxEefCurrentSettleAmount = exTaxRentSettleAmount.add(exTaxEntranceExitFee);
                    BigDecimal inTaxEefCurrentSettleAmount = inTaxRentSettleAmount.add(inTaxEntranceExitFee);

                    mechanicalleasedetailVO.setExTaxRentSettleAmount(exTaxRentSettleAmount);
                    mechanicalleasedetailVO.setInTaxRentSettleAmount(inTaxRentSettleAmount);
                    mechanicalleasedetailVO.setExTaxEefCurrentSettleAmount(exTaxEefCurrentSettleAmount);
                    mechanicalleasedetailVO.setInTaxEefCurrentSettleAmount(inTaxEefCurrentSettleAmount);
                    mechanicalleasedetailVO.setExTaxRentCumulative(exTaxRentSettleAmount);
                    mechanicalleasedetailVO.setInTaxRentCumulative(inTaxRentSettleAmount);
                    mechanicalleasedetailVO.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFee);
                    mechanicalleasedetailVO.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFee);
                    mechanicalleasedetailVO.setExTaxEefCumulative(exTaxEefCurrentSettleAmount);
                    mechanicalleasedetailVO.setInTaxEefCumulative(inTaxEefCurrentSettleAmount);
                    if (groupMap.containsKey(key)) {
                        List<MechanicalleasedetailEntity> groupList = groupMap.get(key);
                        BigDecimal exTaxRentSettleAmountSum = groupList.stream().filter(s -> s.getExTaxRentSettleAmount() != null).map(MechanicalleasedetailEntity::getExTaxRentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal inTaxRentSettleAmountSum = groupList.stream().filter(s -> s.getInTaxRentSettleAmount() != null).map(MechanicalleasedetailEntity::getInTaxRentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal exTaxEntranceExitFeeSum = groupList.stream().filter(s -> s.getExTaxEntranceExitFee() != null).map(MechanicalleasedetailEntity::getExTaxEntranceExitFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal inTaxEntranceExitFeeSum = groupList.stream().filter(s -> s.getInTaxEntranceExitFee() != null).map(MechanicalleasedetailEntity::getInTaxEntranceExitFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal exTaxEefCurrentSettleAmountSum = groupList.stream().filter(s -> s.getExTaxEefCurrentSettleAmount() != null).map(MechanicalleasedetailEntity::getExTaxEefCurrentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal inTaxEefCurrentSettleAmountSum = groupList.stream().filter(s -> s.getInTaxEefCurrentSettleAmount() != null).map(MechanicalleasedetailEntity::getInTaxEefCurrentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        mechanicalleasedetailVO.setExTaxRentCumulative(exTaxRentSettleAmount.add(exTaxRentSettleAmountSum));
                        mechanicalleasedetailVO.setInTaxRentCumulative(inTaxRentSettleAmount.add(inTaxRentSettleAmountSum));
                        mechanicalleasedetailVO.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFee.add(exTaxEntranceExitFeeSum));
                        mechanicalleasedetailVO.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFee.add(inTaxEntranceExitFeeSum));
                        mechanicalleasedetailVO.setExTaxEefCumulative(exTaxEefCurrentSettleAmount.add(exTaxEefCurrentSettleAmountSum));
                        mechanicalleasedetailVO.setInTaxEefCumulative(inTaxEefCurrentSettleAmount.add(inTaxEefCurrentSettleAmountSum));
                    }

                    successList.add(mechanicalleasedetailVO);
                }
            }
        }
        //填充往期数据
        getLastDetail(selectContractId,successList);
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
    private void getLastDetail(Long contractId, List<MechanicalleasedetailVO> successList) {
        LambdaQueryWrapper<MechanicalleaseEntity> lambdaLast = Wrappers.<MechanicalleaseEntity>lambdaQuery();
        lambdaLast.eq(MechanicalleaseEntity::getContractId, contractId);
        lambdaLast.in(MechanicalleaseEntity::getBillState, 1,3);
        lambdaLast.orderByDesc(MechanicalleaseEntity::getCreateTime);
        List<MechanicalleaseEntity> costanalysisEntityList = service.list(lambdaLast);
        List<MechanicalleasedetailEntity> subcontractingvolumedetailEntityList = new ArrayList<>();
        Map<String, List<MechanicalleasedetailVO>> groupMap = new HashMap<>();
        Map<String, List<MechanicalleasedetailVO>> groupLastMap = new HashMap<>();
        DecimalFormat decimalFormat  = new DecimalFormat("0.00000000");
        if(CollectionUtils.isNotEmpty(costanalysisEntityList)){
            MechanicalleaseEntity subcontractingvolumeEntityLast = costanalysisEntityList.stream().findFirst().get();
            LambdaQueryWrapper<MechanicalleasedetailEntity> lambdaCostPeople = Wrappers.<MechanicalleasedetailEntity>lambdaQuery();
            lambdaCostPeople.eq(MechanicalleasedetailEntity::getMid, subcontractingvolumeEntityLast.getId());
            subcontractingvolumedetailEntityList = detailService.list(lambdaCostPeople);
        }

        groupMap = successList.stream().filter(s-> !(s.getRowState() != null && s.getRowState().equals("del"))).collect(
                Collectors.groupingBy(
                        s -> s.getEquipmentCode() +'-' + s.getExTaxLeaseUnit() +'-' + s.getInTaxLeaseUnit()
                ));
        List<MechanicalleasedetailVO> subcontractingvolumedetailVOS = BeanMapper.mapList(subcontractingvolumedetailEntityList, MechanicalleasedetailVO.class);
        List<MechanicalleasedetailVO> collect = subcontractingvolumedetailVOS.stream().filter(s -> s.getLeaseNum () != null).collect(Collectors.toList());
        for (MechanicalleasedetailVO subcontractingvolumedetailEntity : collect){
            String key = subcontractingvolumedetailEntity.getBillCode();
            if (!groupMap.containsKey(key)) {
                subcontractingvolumedetailEntity.setLeaseNum(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setExTaxRentSettleAmount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setInTaxRentSettleAmount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setExTaxEntranceExitFee(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setInTaxEntranceExitFee(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setExTaxEefCurrentSettleAmount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setInTaxEefCurrentSettleAmount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setId(IdWorker.getId());
                subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.上期数据.getCode());
                subcontractingvolumedetailEntity.setMid(null);

                successList.add(subcontractingvolumedetailEntity);
            }
        }

        groupLastMap = collect.stream().filter(s-> !(s.getRowState() != null && s.getRowState().equals("del"))).collect(
                Collectors.groupingBy(
                        s -> s.getEquipmentCode() +'-' + s.getExTaxLeaseUnit() +'-' + s.getInTaxLeaseUnit()
                ));
        for (MechanicalleasedetailVO subcontractingvolumedetailEntity : successList){
            String key = subcontractingvolumedetailEntity.getBillCode();
            if (groupLastMap.containsKey(key)) {
                subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.上期数据.getCode());
            }
        }

    }
    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMechanicalleaseFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMechanicalleaseFromDatabase(@RequestBody MechanicalleasedetailVO detailVo, HttpServletResponse response) {
        QueryWrapper<MechanicalleasedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<MechanicalleasedetailEntity> list = detailService.list(queryWrapper);
        List<MechanicalleasedetailVO> mechanicalleasedetailVOList = BeanMapper.mapList(list, MechanicalleasedetailVO.class);
        if (mechanicalleasedetailVOList != null && mechanicalleasedetailVOList.size() > 0) {
            for (int i = 0; i < mechanicalleasedetailVOList.size(); i++) {
                MechanicalleasedetailVO mechanicalleasedetailVO = mechanicalleasedetailVOList.get(i);
                mechanicalleasedetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetailVO.getBillingStartTimes()!= null) {
                    mechanicalleasedetailVO.setBillingStartTimes(mechanicalleasedetailVO.getBillingStartTimes());
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>(16);
        beans.put("records", mechanicalleasedetailVOList);
        ExcelExport.getInstance().export("mechanicalleasedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMechanicalleasedetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMechanicalleasedetailFromPage(@RequestBody List<MechanicalleasedetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                MechanicalleasedetailVO mechanicalleasedetailVO = list.get(i);
                mechanicalleasedetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetailVO.getBillingEndTimes() != null) {
                    mechanicalleasedetailVO.setBillingEndTimeShow(DateUtils.dateSimple(mechanicalleasedetailVO.getBillingEndTimes()));
                }
                if(mechanicalleasedetailVO.getBillingStartTimes()!=null){
                    mechanicalleasedetailVO.setBillingStartTimeShow(DateUtils.dateSimple(mechanicalleasedetailVO.getBillingStartTimes()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>(16);
        beans.put("records", list);
        ExcelExport.getInstance().export("mechanicalleasedetail-export.xlsx", beans, response);
    }

    /**
     * 计算两天相差天数
     * @param start
     * @param end
     * @return
     */
    public BigDecimal getDays2(Date start,Date end){
        BigDecimal day = new BigDecimal(0);
        Long startTime = start.getTime();
        Long endTime = end.getTime();
        BigDecimal day1 = new BigDecimal(endTime - startTime);
        BigDecimal day2 = new BigDecimal(1000 * 60 * 60 * 24);
        day  = day1.divide(day2,8,BigDecimal.ROUND_HALF_UP);
        return day;
    }
}
