package com.ejianc.business.middlemeasurement.mapper;

import com.ejianc.foundation.middlemeasurement.vo.ConsultotherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinalOtherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinaldetailVO;
import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.middlemeasurement.bean.ConsultotherEntity;

import java.util.List;
import java.util.Map;

/**
 * 咨询及其他类合同过程结算单
 *
 * @author generator
 *
 */
@Mapper
public interface ConsultotherMapper extends BaseCrudMapper<ConsultotherEntity> {
    /**
     * 根据合同id查询咨询类合价和金额
     * @param projectId
     * @return
     */
    List<CostManageVO> queryConsultother(Long projectId,String monthStr);
    /**
     * 根据合同id和月份查询咨询类合价和金额
     * @param projectId
     * @param monthStr
     * @return
     */

    List<CostManageVO> queryConsultotherMonth(Long projectId,String monthStr);

    /**
     * 根据合同id和月份查询咨询类合价和金额
     * @param projectId
     * @param monthStr
     * @return
     */

    List<CostManageVO> queryConsultotherOtherdetailMonth(Long projectId,String monthStr);

    /**
     * 根据合同id和报量时间查询其他扣款往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    List<ConsultfinalOtherdetailVO> queryConsultOtherDetailCumPast(Long contractId, String date);

    /**
     * 根据合同id和报量时间查询子表往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    List<ConsultfinaldetailVO> queryConsultDetailCumPast(Long contractId, String date);
    /***
     * @Description //TODO
     * 查询咨询类过程结算单的计价明细的往期数据
     * @param map
     * @return java.util.List<com.ejianc.business.middlemeasurement.vo.ConsultotherdetailVO>
     * @createDate 2023/2/3
     * @author yupengjie
     **/
    List<ConsultotherdetailVO> queryConsultotherdetail(Map<String ,String> map);
}
