package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleaseVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.PurchasesettlementMapper;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 月度物资采购结算单
 * 
 * @author generator
 * 
 */
@Service("purchasesettlementService")
public class PurchasesettlementServiceImpl extends BaseServiceImpl<PurchasesettlementMapper, PurchasesettlementEntity> implements IPurchasesettlementService{
    @Autowired
    private IPurchasesettlementService purchasesettlementService;
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;
    @Override
    public PurchasesettlementVO getSumByContractId(Long contractId) {
        PurchasesettlementVO purchasesettlementVO = new PurchasesettlementVO();
        LambdaQueryWrapper<PurchasesettlementEntity> listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(PurchasesettlementEntity::getContractId, contractId);
        listWrapper.in(PurchasesettlementEntity::getBillState, "1,3");
        List<PurchasesettlementEntity> purchasesettlementEntities = super.list(listWrapper);
        if (CollectionUtils.isNotEmpty(purchasesettlementEntities)){
            BigDecimal sumMny = purchasesettlementEntities.stream().map(PurchasesettlementEntity::getMonthlyTotal)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumMnyTax = purchasesettlementEntities.stream().map(PurchasesettlementEntity::getTaxMonthlyTotal)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
            purchasesettlementVO.setSumMny(sumMny);
            purchasesettlementVO.setSumMnyTax(sumMnyTax);
        }
        return purchasesettlementVO;
    }
    /**
     * 获取上期数据明细
     *
     * @param contractId 合同id
     */
    @Override
    public List<PurchasesettlementdetailVO> getPastDetailData(Long contractId) {
        //创建条件构造器
        QueryWrapper<PurchasesettlementEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("dr", 0);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.orderByDesc("create_time");
        queryWrapperTotal.last("limit 1");

        List<PurchasesettlementEntity> proTotal = purchasesettlementService.list(queryWrapperTotal);
        List<PurchasesettlementdetailVO> subcontractingvolumedetailVOS = new ArrayList<>();
        PurchasesettlementVO vo = new PurchasesettlementVO();
        if(proTotal != null && proTotal.size() > 0){
            PurchasesettlementEntity pastEntity = proTotal.get(0);
            vo = BeanMapper.map(pastEntity, PurchasesettlementVO.class);
            //查询子表-月度（中间）计量计价明细表数据
            LambdaQueryWrapper<PurchasesettlementdetailEntity> lambdaCostPeople = Wrappers.<PurchasesettlementdetailEntity>lambdaQuery();
            lambdaCostPeople.eq(PurchasesettlementdetailEntity::getMid, pastEntity.getId());
            List<PurchasesettlementdetailEntity> subcontractingvolumedetailEntities = purchasesettlementdetailService.list(lambdaCostPeople);
            subcontractingvolumedetailVOS = BeanMapper.mapList(subcontractingvolumedetailEntities, PurchasesettlementdetailVO.class);

            for(PurchasesettlementdetailVO subcontractingvolumedetailVO : subcontractingvolumedetailVOS){
                subcontractingvolumedetailVO.setSupplyQuantity(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setSettlementAmount(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setTaxSettlementAmount(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setId(IdWorker.getId());
                subcontractingvolumedetailVO.setOldFlag(OldFlagEnum.上期数据.getCode());
                subcontractingvolumedetailVO.setMid(null);
                subcontractingvolumedetailVO.setSettleNum(subcontractingvolumedetailVO.getSupplyQuantityTotal());
                subcontractingvolumedetailVO.setSettleMny(subcontractingvolumedetailVO.getSettlementTotal());
                subcontractingvolumedetailVO.setSettleMnyTax(subcontractingvolumedetailVO.getTaxSettlementTotal());
            }
        }

        return subcontractingvolumedetailVOS;
    }

    @Override
    public PurchasesettlementVO getPurchaseDataById(PurchasesettlementVO purchasesettlementVO) {
        LambdaQueryWrapper<PurchasesettlementEntity> listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(PurchasesettlementEntity::getContractId, purchasesettlementVO.getContractId());
        listWrapper.in(PurchasesettlementEntity::getBillState, "1,3");
        List<PurchasesettlementEntity> purchasesettlementEntityList = super.list(listWrapper);
        Map<String, List<PurchasesettlementdetailEntity>> groupMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(purchasesettlementEntityList)){
            //主表id
            List<Long> ids = purchasesettlementEntityList.stream().map(PurchasesettlementEntity::getId).collect(Collectors.toList());

            LambdaQueryWrapper<PurchasesettlementdetailEntity> detailWrapper = Wrappers.lambdaQuery();
            detailWrapper.in(PurchasesettlementdetailEntity::getMid, ids);
            List<PurchasesettlementdetailEntity> mechanicalleasedetailEntityList = purchasesettlementdetailService.list(detailWrapper);
            if (CollectionUtils.isNotEmpty(mechanicalleasedetailEntityList)){
                //获取累计值
                groupMap = mechanicalleasedetailEntityList.stream().collect(
                        Collectors.groupingBy(s -> s.getBillCode()));
            }

        }
        List<PurchasesettlementdetailVO> purchasesettlementdetailEntities = purchasesettlementVO.getPurchasesettlementdetailEntities();
        if (CollectionUtils.isNotEmpty(purchasesettlementdetailEntities)){
            for (PurchasesettlementdetailVO purchasesettlementdetailVO : purchasesettlementdetailEntities){
                String key = purchasesettlementdetailVO.getBillCode();
                BigDecimal settlementPrice = purchasesettlementdetailVO.getSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSettlementPrice();
                BigDecimal taxSettlementPrice = purchasesettlementdetailVO.getTaxSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getTaxSettlementPrice();
                BigDecimal supplyQuantity = purchasesettlementdetailVO.getSupplyQuantity() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSupplyQuantity();
                //本期值
                BigDecimal settlementAmount = settlementPrice.multiply(supplyQuantity);
                BigDecimal taxSettlementAmount = taxSettlementPrice.multiply(supplyQuantity);
                purchasesettlementdetailVO.setSettlementAmount(settlementAmount);
                purchasesettlementdetailVO.setTaxSettlementAmount(taxSettlementAmount);
                //累计值
                purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity);
                purchasesettlementdetailVO.setSettlementTotal(settlementAmount);
                purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount);

                if (groupMap.containsKey(key)) {
                    List<PurchasesettlementdetailEntity> groupList = groupMap.get(key);
                    BigDecimal taxSettlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getTaxSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal settlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal supplyQuantitySum = groupList.stream().map(PurchasesettlementdetailEntity::getSupplyQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    purchasesettlementdetailVO.setSettlementTotal(settlementAmount.add(settlementAmountSum));
                    purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount.add(taxSettlementAmountSum));
                    purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity.add(supplyQuantitySum));

                    purchasesettlementdetailVO.setSettleNum(supplyQuantity.add(supplyQuantitySum));
                    purchasesettlementdetailVO.setSettleMny(settlementAmount.add(settlementAmountSum));
                    purchasesettlementdetailVO.setSettleMnyTax(taxSettlementAmount.add(taxSettlementAmountSum));
                }

            }

        }
        return purchasesettlementVO;
    }

}
