package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetotalEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractaccountEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractaccountService;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.PurchasesummaryMapper;
import com.ejianc.business.middlemeasurement.bean.PurchasesummaryEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesummaryService;

import java.util.List;

/**
 * 月度物资采购结算汇总
 * 
 * @author generator
 * 
 */
@Service("purchasesummaryService")
public class PurchasesummaryServiceImpl extends BaseServiceImpl<PurchasesummaryMapper, PurchasesummaryEntity> implements IPurchasesummaryService{
    @Autowired
    private IPurchasesummaryService service;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<PurchasesummaryEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( statistical_time, '%Y-%m' )",monthStr);
        List<PurchasesummaryEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (PurchasesummaryEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<PurchasesummaryEntity> query = new LambdaQueryWrapper<PurchasesummaryEntity>()
                .eq(PurchasesummaryEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(statistical_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(PurchasesummaryEntity::getIsSettlement)
                        .or().eq(PurchasesummaryEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("月度物资采购结算汇总有往期未归集的数据");
        LambdaQueryWrapper<PurchasesummaryEntity> query1 = new LambdaQueryWrapper<PurchasesummaryEntity>()
                .eq(PurchasesummaryEntity::getProjectId, projectId)
                .ne(PurchasesummaryEntity::getBillState, 3)
                .ne(PurchasesummaryEntity::getBillState, 1)
                .apply("DATE_FORMAT(statistical_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("月度物资采购结算汇总有本期审批未通过的数据");
        return true;
    }
}
