/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasedetailEntity;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.mapper.RevolvingleaseMapper;
import com.ejianc.business.middlemeasurement.mapper.RevolvingleasedetailMapper;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="revolvingleaseService")
public class RevolvingleaseServiceImpl
extends BaseServiceImpl<RevolvingleaseMapper, RevolvingleaseEntity>
implements IRevolvingleaseService {
    @Autowired
    private IRevolvingleaseService service;
    @Autowired
    private RevolvingleasedetailMapper revolvingleasedetailMapper;
    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"DATE_FORMAT( settle_time, '%Y-%m' )", (Object)monthStr);
        List list = this.service.list((Wrapper)query);
        if (!list.isEmpty()) {
            for (RevolvingleaseEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = this.service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RevolvingleaseEntity::getProjectId, (Object)projectId)).apply("DATE_FORMAT(settle_time, '%Y-%m') < '" + monthStr + "'", new Object[0])).and(qw -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(RevolvingleaseEntity::getIsSettlement)).or()).eq(RevolvingleaseEntity::getIsSettlement, (Object)0));
        int count = this.service.count((Wrapper)query);
        if (count > 0) {
            throw new BusinessException("\u5468\u8f6c\u79df\u8d41\u4e2d\u95f4\u8ba1\u91cf\u6709\u5f80\u671f\u672a\u5f52\u96c6\u7684\u6570\u636e");
        }
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RevolvingleaseEntity::getProjectId, (Object)projectId)).ne(RevolvingleaseEntity::getBillState, (Object)3)).ne(RevolvingleaseEntity::getBillState, (Object)1)).apply("DATE_FORMAT(settle_time, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count1 = this.service.count((Wrapper)query1);
        if (count1 > 0) {
            throw new BusinessException("\u5468\u8f6c\u79df\u8d41\u4e2d\u95f4\u8ba1\u91cf\u6709\u672c\u671f\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e");
        }
        return true;
    }

    @Override
    public List<RevolvingleasedetailVO> querySumById(List<RevolvingleasedetailVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (RevolvingleasedetailVO revolvingleasedetailVO : list) {
            }
        }
        return null;
    }

    @Override
    public RevolvingleasedetailVO queryCumulative(Long projectId, Long contractId, String materialCode, String encode, String section, BigDecimal lesseeUnitprice, BigDecimal taxLesseeUnitprice) {
        RevolvingleasedetailVO vo = ((RevolvingleaseMapper)this.baseMapper).queryCumulative(projectId, contractId, materialCode, encode, section, lesseeUnitprice, taxLesseeUnitprice);
        return vo;
    }

    @Override
    public RevolvingleasedetailVO queryDetailList(Long contractId, String encode, String materialCode) {
        return this.revolvingleasedetailMapper.queryDetailList(contractId, encode, materialCode);
    }

    @Override
    public List<RevolvingleasedetailVO> getPastDetailData(Long contractId) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.eq((Object)"dr", (Object)0);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.orderByDesc((Object)"create_time");
        queryWrapperTotal.last("limit 1");
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        List<RevolvingleasedetailVO> subcontractingvolumedetailVOS = new ArrayList<RevolvingleasedetailVO>();
        RevolvingleaseVO vo = new RevolvingleaseVO();
        if (proTotal != null && proTotal.size() > 0) {
            RevolvingleaseEntity pastEntity = (RevolvingleaseEntity)((Object)proTotal.get(0));
            vo = (RevolvingleaseVO)((Object)BeanMapper.map((Object)((Object)pastEntity), RevolvingleaseVO.class));
            LambdaQueryWrapper lambdaCostPeople = Wrappers.lambdaQuery();
            lambdaCostPeople.eq(RevolvingleasedetailEntity::getMid, (Object)pastEntity.getId());
            List subcontractingvolumedetailEntities = this.revolvingleasedetailService.list((Wrapper)lambdaCostPeople);
            subcontractingvolumedetailVOS = BeanMapper.mapList((Iterable)subcontractingvolumedetailEntities, RevolvingleasedetailVO.class);
            List collect = subcontractingvolumedetailVOS.stream().filter(s -> s.getLesseeQuantity() != null).collect(Collectors.toList());
            for (RevolvingleasedetailVO subcontractingvolumedetailEntity : collect) {
                subcontractingvolumedetailEntity.setLesseeQuantity(0);
                subcontractingvolumedetailEntity.setLesseeTotalprice(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxLesseeTotalprice(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setLossDamage(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setCompensateAccount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxCompensateAccount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setOtherExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxOtherExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setMonthlyExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxMonthlyExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setId(IdWorker.getId());
                subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.\u4e0a\u671f\u6570\u636e.getCode());
                subcontractingvolumedetailEntity.setMid(null);
            }
        }
        return subcontractingvolumedetailVOS;
    }
}

