package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周转租赁中间计量
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("revolvinglease")
public class RevolvingleaseController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "middlemeasurement-revolvinglease";//此处需要根据实际修改

    @Autowired
    private IRevolvingleaseService service;

    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> saveOrUpdate(@RequestBody RevolvingleaseVO saveorUpdateVO) {
    	RevolvingleaseEntity entity = BeanMapper.map(saveorUpdateVO, RevolvingleaseEntity.class);
        entity.setSaveTime(new Date());

        //1.校验
        QueryWrapper<RevolvingleaseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", entity.getContractId());
        if (entity.getId() != null) {
            queryWrapper.ne("id", entity.getId());
        }
        List<RevolvingleaseEntity> pro = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(pro)) {
            for (RevolvingleaseEntity revolvingleaseEntity : pro) {
                int numDate = entity.getSettleTime().compareTo(revolvingleaseEntity.getSettleTime());
                if (revolvingleaseEntity.getBillState() != 1 && revolvingleaseEntity.getBillState() != 3) {
                    throw new BusinessException("同一合同只能存在一份自由态或审批中的\"月度周转结算单\"!");
                } else if (numDate<=0) {
                    throw new BusinessException("同一合同下的结算单结算时间必须大于等于最后一期的\"月度周转结算单\"!");
                }
            }
        }


    /*    //3.累计（包含本期）
        Date currentDate = new Date(System.currentTimeMillis());
        if(saveorUpdateVO.getCreateTime() != null){
            currentDate = saveorUpdateVO.getCreateTime();
        }
        //获取往期
     //   RevolvingleaseVO pastVo = getPastTotalData(saveorUpdateVO.getContractId(), currentDate, true);
        //本期 + 往期（主表）
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if(saveorUpdateVO.getTotal()!=null){
            occurrenceTotal  = saveorUpdateVO.getTotal().add(pastVo.getOccurrenceTotal());
        }
        if(saveorUpdateVO.getTaxTotal()!=null){
            taxOccurrenceTotal   = saveorUpdateVO.getTaxTotal().add(pastVo.getTaxOccurrenceTotal());
        }

        entity.setOccurrenceTotal(occurrenceTotal);
        entity.setTaxOccurrenceTotal(taxOccurrenceTotal);

        //本期 + 往期（子表）
        List<RevolvingleasedetailVO> saveRevolvingleasedetailEntities = saveorUpdateVO.getRevolvingleasedetailEntities();
        List<RevolvingleasedetailVO> revolvingleasedetailVOList =  pastVo.getRevolvingleasedetailEntities();
        if(saveRevolvingleasedetailEntities != null && revolvingleasedetailVOList != null){
            //本期
            for (int i = 0; i < saveRevolvingleasedetailEntities.size(); i++) {
                RevolvingleasedetailVO saveRevolvingleasedetailVO = saveRevolvingleasedetailEntities.get(i);
                //物料编码
                String saveMaterialCode = saveRevolvingleasedetailVO.getMaterialCode();
                //月度结算费用((除税)(元)
                BigDecimal saveMonthlyExpenses = saveRevolvingleasedetailVO.getMonthlyExpenses();
                //月度结算费用（含税）（元）
                BigDecimal saveTaxMonthlyExpenses = saveRevolvingleasedetailVO.getTaxMonthlyExpenses() == null ? BigDecimal.ZERO : saveRevolvingleasedetailVO.getTaxMonthlyExpenses();

                //往期
                for (int j = 0; j < revolvingleasedetailVOList.size(); j++) {
                    RevolvingleasedetailVO revolvingleasedetailVO = revolvingleasedetailVOList.get(j);
                    String materialCode = revolvingleasedetailVO.getMaterialCode();
                    if(materialCode.equals(saveMaterialCode)){
                        //月度结算费用((除税)(元)
                        BigDecimal monthlyExpenses = revolvingleasedetailVO.getMonthlyExpenses();
                            if (saveMonthlyExpenses != null) {
                                saveMonthlyExpenses = saveMonthlyExpenses.add(monthlyExpenses == null ? new BigDecimal(0) : monthlyExpenses);
                            }
                        //月度结算费用(含税)(元)
                        BigDecimal taxMonthlyExpenses = revolvingleasedetailVO.getTaxMonthlyExpenses() == null ? BigDecimal.ZERO : revolvingleasedetailVO.getTaxMonthlyExpenses();
                        saveTaxMonthlyExpenses = saveTaxMonthlyExpenses.add(taxMonthlyExpenses == null ? new BigDecimal(0) : taxMonthlyExpenses);
                    }
                }

                saveRevolvingleasedetailVO.setCumulativeAmount(saveMonthlyExpenses);
                saveRevolvingleasedetailVO.setTaxCumulativeAmount(saveTaxMonthlyExpenses);
            }
            // 子表累计值计算
            for (RevolvingleasedetailVO vo : saveRevolvingleasedetailEntities) {
                RevolvingleasedetailVO revolvingleasedetailVO = service.queryCumulative(entity.getProjectId(), entity.getContractId(),
                        vo.getMaterialCode(), vo.getEncode(), vo.getSection(), vo.getLesseeUnitprice(), vo.getTaxLesseeUnitprice());
                if (revolvingleasedetailVO != null) {
                    vo.setSumRentMoney(ComputeUtil.safeAdd(vo.getLesseeTotalprice(), revolvingleasedetailVO.getSumRentMoney()));
                    vo.setSumRentMoneyTax(ComputeUtil.safeAdd(vo.getTaxLesseeTotalprice(), revolvingleasedetailVO.getSumRentMoneyTax()));
                    vo.setSumCompensationMoney(ComputeUtil.safeAdd(vo.getCompensateAccount(), revolvingleasedetailVO.getSumCompensationMoney()));
                    vo.setSumCompensationMoneyTax(ComputeUtil.safeAdd(vo.getTaxCompensateAccount(), revolvingleasedetailVO.getSumCompensationMoneyTax()));
                    vo.setSumFeeMoney(ComputeUtil.safeAdd(vo.getOtherExpenses(), revolvingleasedetailVO.getSumFeeMoney()));
                    vo.setSumFeeMoneyTax(ComputeUtil.safeAdd(vo.getTaxOtherExpenses(), revolvingleasedetailVO.getSumFeeMoneyTax()));
                    vo.setLeaseDaysSumTime(ComputeUtil.safeAdd(new BigDecimal(vo.getLesseeTerm()), revolvingleasedetailVO.getLeaseDaysSumTime()));
                } else {
                    vo.setSumRentMoney(vo.getLesseeTotalprice());
                    vo.setSumRentMoneyTax(vo.getTaxLesseeTotalprice());
                    vo.setSumCompensationMoney(vo.getCompensateAccount());
                    vo.setSumCompensationMoneyTax(vo.getTaxCompensateAccount());
                    vo.setSumFeeMoney(vo.getOtherExpenses());
                    vo.setSumFeeMoneyTax(vo.getTaxOtherExpenses());
                    vo.setLeaseDaysSumTime(new BigDecimal(vo.getLesseeTerm() == null ? 0:vo.getLesseeTerm()));
                }
                entity.setCurrentCompensationMny(ComputeUtil.safeAdd(entity.getCurrentCompensationMny(), vo.getCompensateAccount()));
                entity.setCurrentCompensationMnyTax(ComputeUtil.safeAdd(entity.getCurrentCompensationMnyTax(), vo.getTaxCompensateAccount()));
                entity.setCurrentFeeMny(ComputeUtil.safeAdd(entity.getCurrentFeeMny(), vo.getOtherExpenses()));
                entity.setCurrentFeeMnyTax(ComputeUtil.safeAdd(entity.getCurrentFeeMnyTax(), vo.getTaxOtherExpenses()));

                entity.setSumCompensationMny(ComputeUtil.safeAdd(entity.getSumCompensationMny(), vo.getSumCompensationMoney()));
                entity.setSumCompensationMnyTax(ComputeUtil.safeAdd(entity.getSumCompensationMnyTax(), vo.getSumCompensationMoneyTax()));
                entity.setSumFeeMny(ComputeUtil.safeAdd(entity.getSumFeeMny(), vo.getSumFeeMoney()));
                entity.setSumFeeMnyTax(ComputeUtil.safeAdd(entity.getSumFeeMnyTax(),vo.getSumFeeMoneyTax()));
            }
            entity.setRevolvingleasedetailEntities(BeanMapper.mapList(saveRevolvingleasedetailEntities, RevolvingleasedetailEntity.class));
        }*/

        entity = checkBillCodeUniq(entity);
        entity.setIsFlag(0);
    	service.saveOrUpdate(entity, false);
    	RevolvingleaseVO vo = BeanMapper.map(entity, RevolvingleaseVO.class);
        //构建树形结构
        vo.setRevolvingleasedetailEntities(handleChildren(vo.getRevolvingleasedetailEntities()));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }



    /**
     * @Description  累计值是按照物资编码+编码+区段一致的作为相同项目进行累计值合计
     */
    @RequestMapping(value = "/querySumById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RevolvingleasedetailVO>> querySumById(@RequestBody List<RevolvingleasedetailVO> vos) {
        List<RevolvingleasedetailVO> list = service.querySumById(vos);
        return CommonResponse.success("查询详情数据成功！", list);
    }

    /**
     * @param id
     * @Description 获取上期数据明细
     */
    @RequestMapping(value = "/getPastDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RevolvingleasedetailVO>> getPastDetailData(Long contractId) {
        List<RevolvingleasedetailVO> list = service.getPastDetailData(contractId);
        return CommonResponse.success("查询详情数据成功！", list);
    }


    /**
     * 单据编码唯一性校验
     *
     * @param entity
     */
    private RevolvingleaseEntity checkBillCodeUniq(RevolvingleaseEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //单据编码唯一性
            QueryWrapper<RevolvingleaseEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne("id", id);
            }
            List<RevolvingleaseEntity> proBillCode = service.list(queryWrapperBillCode);
            if (proBillCode != null && proBillCode.size() > 0) {
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }

        return entity;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> queryDetail(Long id) {
    	RevolvingleaseEntity entity = service.selectById(id);
    	RevolvingleaseVO vo = BeanMapper.map(entity, RevolvingleaseVO.class);
        //构建树形结构
        vo.setRevolvingleasedetailEntities(handleChildren(vo.getRevolvingleasedetailEntities()));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RevolvingleaseVO> vos) {
        service.removeByIds(vos.stream().map(RevolvingleaseVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RevolvingleaseVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<RevolvingleaseEntity> page = service.queryPage(param,false);
        IPage<RevolvingleaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RevolvingleaseVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<RevolvingleaseEntity> list = service.queryList(param);
        //时间转换
        List<RevolvingleaseVO> revolvingleaseVOList = BeanMapper.mapList(list, RevolvingleaseVO.class);
        for (int i = 0; i < revolvingleaseVOList.size(); i++) {
            RevolvingleaseVO revolvingleaseVO = revolvingleaseVOList.get(i);
            revolvingleaseVO.setSort(String.valueOf(i+1));
            if (revolvingleaseVO.getSettleTime()!=null){
                revolvingleaseVO.setSettleTimeShow(DateUtils.dateSimple2(revolvingleaseVO.getSettleTime()));
            }
            if (revolvingleaseVO.getStartTime()!=null){
                revolvingleaseVO.setStartTimeShow(DateUtils.dateSimple2(revolvingleaseVO.getStartTime()));
            }
            if (revolvingleaseVO.getDeadline()!=null){
                revolvingleaseVO.setDeadlineShow(DateUtils.dateSimple2(revolvingleaseVO.getDeadline()));
            }

            String billStateStr = revolvingleaseVO.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                revolvingleaseVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", revolvingleaseVOList);
        ExcelExport.getInstance().export("RevolvingleaseMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refRevolvingleaseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RevolvingleaseVO>> refRevolvingleaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("lessee_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }

        //未被引用
        param.getParams().put("isReference", new Parameter(QueryParam.EQ, 0));

        //审批通过
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        IPage<RevolvingleaseEntity> page = service.queryPage(param,false);
        IPage<RevolvingleaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<RevolvingleaseVO> revolvingleaseVOList = BeanMapper.mapList(page.getRecords(), RevolvingleaseVO.class);
        for (int i = 0; i < revolvingleaseVOList.size(); i++) {
            RevolvingleaseVO revolvingleaseVO = revolvingleaseVOList.get(i);
            revolvingleaseVO.setSort(String.valueOf(i + 1));

            QueryWrapper<RevolvingleasedetailEntity> detailWrapper = new QueryWrapper<>();
            detailWrapper.eq("mid", revolvingleaseVO.getId());
            List<RevolvingleasedetailEntity> entityList = revolvingleasedetailService.list(detailWrapper);
            if (entityList != null && entityList.size() > 0) {

                List<RevolvingleasedetailVO> detailList = BeanMapper.mapList(entityList, RevolvingleasedetailVO.class);
                revolvingleaseVO.setRevolvingleasedetailEntities(detailList);
            }
        }
        pageData.setRecords(revolvingleaseVOList);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description  查询往期
     * @param contractId
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> pastData(Long id, Long contractId) {
        //判断该合同是否存在单据
        QueryWrapper<RevolvingleaseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("contract_id",contractId);
        queryWrapper.notIn("bill_state",1,3);
        if(id != null && id != 0){
            queryWrapper.ne("id", id);
        }
        List<RevolvingleaseEntity> entityList = service.list(queryWrapper);

        if(entityList != null && entityList.size() > 0){
            throw new BusinessException("同一合同只能存在一份自由态或审批中的月度周转结算单");
        }

        Date currentDate = new Date(System.currentTimeMillis());
        if(id != null && "".equals(id)){//更新
            RevolvingleaseEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate, false));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId 合同id
     * @param currentDate 本期日期
     * @param isSave true保存 false查询
     * @return
     */
    private RevolvingleaseVO getPastTotalData(Long contractId, Date currentDate, boolean isSave) {
        //创建条件构造器
        QueryWrapper<RevolvingleaseEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<RevolvingleaseEntity> proTotal = service.list(queryWrapperTotal);
        List<RevolvingleasedetailEntity> revolvingleasedetailEntityList = new ArrayList<>();

        //累计发生(除税)
        BigDecimal occurrenceTotal = new BigDecimal(0);
        //累计发生(含税)
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);

        if(proTotal != null && proTotal.size() > 0){
            for (int i = 0; i < proTotal.size(); i++) {
                RevolvingleaseEntity revolvingleaseEntity = proTotal.get(i);
                BigDecimal Total = revolvingleaseEntity.getTotal();
                BigDecimal TaxTotal= revolvingleaseEntity.getTaxTotal();


                    if(occurrenceTotal != null && Total != null )
                    { occurrenceTotal = occurrenceTotal.add(revolvingleaseEntity.getTotal());}
                if(taxOccurrenceTotal != null && TaxTotal != null )
                    taxOccurrenceTotal = taxOccurrenceTotal.add(revolvingleaseEntity.getTaxTotal());

                    if (isSave) {
                        QueryWrapper<RevolvingleasedetailEntity> detailWrapper = new QueryWrapper<>();
                        detailWrapper.eq("mid", revolvingleaseEntity.getId());
                        List<RevolvingleasedetailEntity> detailList = revolvingleasedetailService.list(detailWrapper);
                        revolvingleasedetailEntityList.addAll(detailList);
                    }

            }
        }

        RevolvingleaseVO vo = new RevolvingleaseVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);

        vo.setContractId(contractId);
        //往期所有子表 entity和vo转换
        vo.setRevolvingleasedetailEntities(BeanMapper.mapList(revolvingleasedetailEntityList, RevolvingleasedetailVO.class));

        return vo;
    }


    /**
     * @param contractId
     * @Description 查询详情
     */
    @RequestMapping(value = "/queryAmount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> queryAmount( Long contractId , Long projectId) {
        BigDecimal exTaxSettlementMonth = new BigDecimal(0);
        BigDecimal inTaxSettlementMonth = new BigDecimal(0);
        BigDecimal exTaxCumulative = new BigDecimal(0);
        BigDecimal inTaxCumulative = new BigDecimal(0);
        //主表查询
        QueryWrapper<RevolvingleaseEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id",projectId);
        wrapper.eq("contract_id",contractId);
        wrapper.eq("dr",0);
        wrapper.in("bill_state",1,3);
        List<RevolvingleaseEntity> entityList = service.list(wrapper);
        for (RevolvingleaseEntity revolvinglease : entityList) {

            if(revolvinglease.getOccurrenceTotal()!=null){
                exTaxCumulative = exTaxCumulative.add(revolvinglease.getOccurrenceTotal());
            }
            if(revolvinglease.getTaxOccurrenceTotal()!=null){
                inTaxCumulative = inTaxCumulative.add(revolvinglease.getTaxOccurrenceTotal());
            }

            //子表属性合计
            QueryWrapper<RevolvingleasedetailEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("mid",revolvinglease.getId());
            queryWrapper.eq("dr",0);
            List<RevolvingleasedetailEntity> revolvingleasedetailEntities = revolvingleasedetailService.list(queryWrapper);
            for (RevolvingleasedetailEntity revolvingleasedetail : revolvingleasedetailEntities) {
                if(revolvingleasedetail.getMonthlyExpenses()!=null){
                    exTaxSettlementMonth = exTaxSettlementMonth.add(revolvingleasedetail.getMonthlyExpenses());
                }
                if(revolvingleasedetail.getTaxMonthlyExpenses()!=null){
                    inTaxSettlementMonth = inTaxSettlementMonth.add(revolvingleasedetail.getTaxMonthlyExpenses());
                }
            }
        }
        RevolvingleaseVO vo = new RevolvingleaseVO();
        vo.setTotal(exTaxSettlementMonth);
        vo.setTaxTotal(inTaxSettlementMonth);
        vo.setOccurrenceTotal(exTaxCumulative);
        vo.setTaxOccurrenceTotal(inTaxCumulative);
        return CommonResponse.success("查询往期审批通过的累计数据成功！",vo);
    }

    /**
     * 对子表做排序、构建树等处理
     *
     * @param voList
     */
    private List<RevolvingleasedetailVO> handleChildren(List<RevolvingleasedetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<RevolvingleasedetailVO>() {
            @Override
            public int compare(RevolvingleasedetailVO o1, RevolvingleasedetailVO o2) {
                return (o1.getEncode() + o1.getSection()).compareTo(o2.getEncode() + o2.getSection());
            }
        });

        //获取子集,汇总数据
        List<String> tpidList = voList.stream().map(RevolvingleasedetailVO::getTpid).collect(Collectors.toList());
        for(RevolvingleasedetailVO revolvingleasedetailVO : voList){
            List<RevolvingleasedetailVO> detailByPid = getDetailByPid(revolvingleasedetailVO.getTid(), voList);
            if (CollectionUtils.isNotEmpty(detailByPid)){
                revolvingleasedetailVO.setSettleTime(null);
                revolvingleasedetailVO.setSettleTimeShow(null);
                revolvingleasedetailVO.setLesseeTerm(null);
                revolvingleasedetailVO.setLesseeQuantity(null);
                revolvingleasedetailVO.setLesseeUnitprice(null);
                revolvingleasedetailVO.setTaxLesseeUnitprice(null);
                revolvingleasedetailVO.setLossDamage(null);
                revolvingleasedetailVO.setCompensateUnitprice(null);
                revolvingleasedetailVO.setTaxCompensateUnitprice(null);
                revolvingleasedetailVO.setOtherExpenses(null);
                revolvingleasedetailVO.setTaxOtherExpenses(null);
                revolvingleasedetailVO.setEndTimeShow(null);

                BigDecimal lesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeTotalprice() != null).map(RevolvingleasedetailVO::getLesseeTotalprice)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxLesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxLesseeTotalprice() != null).map(RevolvingleasedetailVO::getTaxLesseeTotalprice)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal compensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCompensateAccount() != null).map(RevolvingleasedetailVO::getCompensateAccount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxCompensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCompensateAccount() != null).map(RevolvingleasedetailVO::getTaxCompensateAccount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal monthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getMonthlyExpenses() != null).map(RevolvingleasedetailVO::getMonthlyExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxMonthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxMonthlyExpenses() != null).map(RevolvingleasedetailVO::getTaxMonthlyExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumRentMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoney() != null).map(RevolvingleasedetailVO::getSumRentMoney)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumRentMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoneyTax() != null).map(RevolvingleasedetailVO::getSumRentMoneyTax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumCompensationMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoney() != null).map(RevolvingleasedetailVO::getSumCompensationMoney)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumCompensationMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoneyTax() != null).map(RevolvingleasedetailVO::getSumCompensationMoneyTax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumFeeMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoney() != null).map(RevolvingleasedetailVO::getSumFeeMoney)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumFeeMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoneyTax() != null).map(RevolvingleasedetailVO::getSumFeeMoneyTax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal cumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCumulativeAmount() != null).map(RevolvingleasedetailVO::getCumulativeAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxCumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCumulativeAmount() != null).map(RevolvingleasedetailVO::getTaxCumulativeAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);

                revolvingleasedetailVO.setLesseeTotalprice(lesseeTotalprice);
                revolvingleasedetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);
                revolvingleasedetailVO.setCompensateAccount(compensateAccount);
                revolvingleasedetailVO.setTaxCompensateAccount(taxCompensateAccount);
                revolvingleasedetailVO.setMonthlyExpenses(monthlyExpenses);
                revolvingleasedetailVO.setTaxMonthlyExpenses(taxMonthlyExpenses);
                revolvingleasedetailVO.setSumRentMoney(sumRentMoney);
                revolvingleasedetailVO.setSumRentMoneyTax(sumRentMoneyTax);
                revolvingleasedetailVO.setSumCompensationMoney(sumCompensationMoney);
                revolvingleasedetailVO.setSumCompensationMoneyTax(sumCompensationMoneyTax);
                revolvingleasedetailVO.setSumFeeMoney(sumFeeMoney);
                revolvingleasedetailVO.setSumFeeMoneyTax(sumFeeMoneyTax);
                revolvingleasedetailVO.setCumulativeAmount(cumulativeAmount);
                revolvingleasedetailVO.setTaxCumulativeAmount(taxCumulativeAmount);
                subList.clear();
            }
        }
        //构建树
        voList = createTreeData(voList);


        return voList;
    }


    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<RevolvingleasedetailVO> createTreeData(List<RevolvingleasedetailVO> list) {
        List<RevolvingleasedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, RevolvingleasedetailVO> listMap = new HashMap<>();
        for (RevolvingleasedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            RevolvingleasedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            RevolvingleasedetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<RevolvingleasedetailVO> child = (List<RevolvingleasedetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<RevolvingleasedetailVO> children = new ArrayList<RevolvingleasedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }



    List<RevolvingleasedetailVO> subList = new ArrayList<>();
    private List<RevolvingleasedetailVO> getDetailByPid(String tid, List<RevolvingleasedetailVO> list) {

        for (RevolvingleasedetailVO revolvingleasedetailVO : list) {
            if (tid != null && tid.equals(revolvingleasedetailVO.getTpid())) {
                getDetailByPid(revolvingleasedetailVO.getTid(), list);
                subList.add(revolvingleasedetailVO);
            }
        }
        return subList;
    }
}
