package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.ISubcontractaccountdetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.vo.SubcontractaccountdetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.service.ISubcontractaccountService;
import com.ejianc.business.middlemeasurement.vo.SubcontractaccountVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

/**
 * 分包月度报量台账
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("subcontractaccount")
public class SubcontractaccountController implements Serializable {
	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;

	private static final String BILL_CODE = "subcontractaccount_Open_Apply_Code";// 此处需要根据实际修改

	@Autowired
	private ISubcontractaccountService service;

	@Autowired
	private ISubcontractaccountdetailService detailService;

	@Autowired
	private ISubcontractingvolumeService subcontractingvolumeService;

	@Autowired
	private SessionManager sessionManager;

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<SubcontractaccountVO> saveOrUpdate(@RequestBody SubcontractaccountVO saveorUpdateVO) {
		SubcontractaccountEntity entity = BeanMapper.map(saveorUpdateVO, SubcontractaccountEntity.class);

		//校验：同一项目，只能存在一份自由态或审批中的单据
		checkBillStateUniq(entity);

		//校验：单据编号唯一性
		entity = checkBillCodeUniq(entity);

		//重新计算累计
		entity = reCumulative(entity);

		service.saveOrUpdate(entity, false);

		//更新引用单据的被引用状态
		updateIsRef(saveorUpdateVO, entity);

		SubcontractaccountVO vo = BeanMapper.map(entity, SubcontractaccountVO.class);
		return CommonResponse.success("保存或修改单据成功！", vo);
	}

	/**
	 * 重新计算累计
	 * @param entity
	 * @return
	 */
	private SubcontractaccountEntity reCumulative(SubcontractaccountEntity entity) {
		List<SubcontractaccountdetailEntity> detailEntityList = entity.getSubcontractaccountdetailEntities();
		if(detailEntityList != null && detailEntityList.size() > 0){
			for (int i = 0; i < detailEntityList.size(); i++) {
				SubcontractaccountdetailEntity subcontractaccountdetail = detailEntityList.get(i);
				BigDecimal actualPayment = subcontractaccountdetail.getActualPayment();

				//查询该合同报量申请单往期累计
				//创建条件构造器
				QueryWrapper<SubcontractaccountdetailEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("contract_id", subcontractaccountdetail.getContractId());
				queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
				queryWrapper.eq("dr", "0");
				queryWrapper.orderByDesc("create_time");//最新往期
				queryWrapper.last("limit 1");
				List<SubcontractaccountdetailEntity> pastDetails = detailService.list(queryWrapper);
				if(pastDetails != null && pastDetails.size() > 0){
					SubcontractaccountdetailEntity pastSubcontractaccountdetail = pastDetails.get(0);
					//至本月累计付款金额
					BigDecimal pastCumulativePayment = pastSubcontractaccountdetail.getCumulativePayment();

					if(pastCumulativePayment != null && actualPayment != null){
						BigDecimal cumulativePayment = actualPayment.add(pastCumulativePayment);
						subcontractaccountdetail.setCumulativePayment(cumulativePayment);
					}
				}
			}

			entity.setSubcontractaccountdetailEntities(detailEntityList);
		}
		return entity;
	}

	/**
	 *更新引用单据的被引用状态
	 * @param entity
	 */
	private void updateIsRef(SubcontractaccountVO saveorUpdateVO, SubcontractaccountEntity entity) {
		if(saveorUpdateVO.getId() != null){
			//1.更新后，先把老数据的被引用状态改为0
			//创建条件构造器
			QueryWrapper<SubcontractingvolumeEntity> queryWrapperOld = new QueryWrapper<>();
			queryWrapperOld.in("reference_code", entity.getBillCode());
			queryWrapperOld.eq("dr",0);
			List<SubcontractingvolumeEntity> oldList = subcontractingvolumeService.list(queryWrapperOld);
			if(oldList != null && oldList.size() > 0){
				for (SubcontractingvolumeEntity item : oldList) {
					item.setIsReference(0);
					item.setReferenceCode(null);
				}
				subcontractingvolumeService.saveOrUpdateBatch(oldList);
			}
		}

		//2.更新被引用单据的引用状态
		List<String> referenceIdList = saveorUpdateVO.getReferenceIdList();
		if(referenceIdList != null && referenceIdList.size() > 0){
			//创建条件构造器
			QueryWrapper<SubcontractingvolumeEntity> queryWrapperByIdsNew = new QueryWrapper<>();
			queryWrapperByIdsNew.in("id", referenceIdList);
			queryWrapperByIdsNew.eq("dr",0);
			List<SubcontractingvolumeEntity> newList = subcontractingvolumeService.list(queryWrapperByIdsNew);
			if(newList != null && newList.size() > 0){
				for (SubcontractingvolumeEntity item : newList) {
					item.setIsReference(1);
					item.setReferenceCode(entity.getBillCode());
				}
				subcontractingvolumeService.saveOrUpdateBatch(newList);
			}
		}
	}

	/**
	 * 1.同一项目，只能存在一份自由态或审批中的单据
	 * 2.校验统计月份是否已统计过
	 *
	 * @param entity
	 */
	private void checkBillStateUniq(SubcontractaccountEntity entity) {
		Long id = entity.getId();
		Long projectId = entity.getProjectId();
		Date statisticalMonth = entity.getStatisticalMonth();
		//创建条件构造器
		QueryWrapper<SubcontractaccountEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
		queryWrapper.eq("dr", "0");
		if (id != null) {
			queryWrapper.ne("id", id);
		}
		List<SubcontractaccountEntity> pro = service.list(queryWrapper);
		if (pro != null && pro.size() > 0) {
			throw new BusinessException("同一合同只能存在一份自由态或审批中的\"分包月度报量台账\"!");
		}

		QueryWrapper<SubcontractaccountEntity> queryWrapperMonth = new QueryWrapper<>();
		queryWrapperMonth.eq("project_id", projectId);
		queryWrapperMonth.in("bill_state", 1, 3);//1直审 3审批通过
		queryWrapperMonth.eq("dr", "0");
		queryWrapperMonth.eq("statistical_month", statisticalMonth);//统计月份
		if (id != null) {
			queryWrapper.ne("id", id);
		}
		List<SubcontractaccountEntity> proMonth = service.list(queryWrapperMonth);
		if (proMonth != null && proMonth.size() > 0) {
			throw new BusinessException("本次统计月份已存在\"分包月度报量台账\"!");
		}
	}

	/**
	 * 单据编码唯一性校验
	 *
	 * @param entity
	 */
	private SubcontractaccountEntity checkBillCodeUniq(SubcontractaccountEntity entity) {
		if (entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())) {
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
			if (billCode.isSuccess()) {
				entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			} else {
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		} else {
			//单据编码唯一性
			QueryWrapper<SubcontractaccountEntity> queryWrapperBillCode = new QueryWrapper<>();
			queryWrapperBillCode.eq("bill_code", entity.getBillCode());
			queryWrapperBillCode.eq("dr", "0");
			Long id = entity.getId();
			if (id != null) {
				queryWrapperBillCode.ne("id", id);
			}
			List<SubcontractaccountEntity> proBillCode = service.list(queryWrapperBillCode);
			if (proBillCode != null && proBillCode.size() > 0) {
				throw new BusinessException("单据编码已存在，请重新录入!");
			}
		}

		return entity;
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubcontractaccountVO> queryDetail(Long id) {
		SubcontractaccountEntity entity = service.selectById(id);
		SubcontractaccountVO vo = BeanMapper.map(entity, SubcontractaccountVO.class);
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<SubcontractaccountVO> vos) {
		List<Long> idList = vos.stream().map(SubcontractaccountVO::getId).collect(Collectors.toList());
		QueryWrapper<SubcontractaccountEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr",0);
		queryWrapper.in("id",idList);
		List<SubcontractaccountEntity> subcontractaccountEntityList = service.list(queryWrapper);

		List<String> codeList = new ArrayList<>();
		for (SubcontractaccountEntity entity : subcontractaccountEntityList) {
			codeList.add(entity.getBillCode());
		}

		QueryWrapper<SubcontractingvolumeEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("dr",0);
		wrapper.in("reference_code", codeList);
		List<SubcontractingvolumeEntity> list = subcontractingvolumeService.list(wrapper);

		if(list != null && list.size() > 0){
			//删除时，去掉引用的分包月度报量及申请报告的引用状态
			for (SubcontractingvolumeEntity entity : list) {
				entity.setIsReference(0);
				entity.setReferenceCode(null);
			}
			//保存分包月度报量及申请报告
			subcontractingvolumeService.saveOrUpdateBatch(list);
		}

		service.removeByIds(idList, true);
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @Description queryList 查询列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<SubcontractaccountVO>> queryList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("projectName");
		fuzzyFields.add("name");
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//		param.getParams().put("orgId",
//				new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()
//						.stream().map(OrgVO::getId).collect(Collectors.toList())));

		UserContext userContextCache = sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		}else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if(5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if(CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if(CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		IPage<SubcontractaccountEntity> page = service.queryPage(param, false);
		IPage<SubcontractaccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractaccountVO.class));

		return CommonResponse.success("查询列表数据成功！", pageData);
	}

	/**
	 * 获取RPC数据
	 * resp 返回值
	 * isMustSuc 是否必须成功
	 * errMsg 失败提示
	 */
	private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
		if(isMustSuc && !resp.isSuccess()) {
			throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
		}
		return resp.getData();
	}

	/**
	 * @Description 导出
	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.setPageIndex(1);
		param.setPageSize(-1);
		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//		param.getParams().put("orgId",
//				new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()
//						.stream().map(OrgVO::getId).collect(Collectors.toList())));
		UserContext userContextCache = sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		} else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if (5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if (CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if (CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
		List<SubcontractaccountEntity> list = service.queryList(param);
		// todo:字段翻译等等
		List<SubcontractaccountVO> subcontractaccountVOList = BeanMapper.mapList(list, SubcontractaccountVO.class);
		for (int i = 0; i < subcontractaccountVOList.size(); i++) {
			SubcontractaccountVO subcontractaccountVO = subcontractaccountVOList.get(i);

			String billStateStr = subcontractaccountVO.getBillState().toString();
			if (billStateStr != null){
				if("0".equals(billStateStr)){//自由态
					billStateStr = "自由态";
				}else if("1".equals(billStateStr)){//已提交
					billStateStr = "已提交";
				}else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
					billStateStr = "审批中";
				}else if("3".equals(billStateStr)){//审批通过
					billStateStr = "审批通过";
				}else if("4".equals(billStateStr)){//驳回
					billStateStr = "驳回";
				}

				subcontractaccountVO.setBillStateStr(billStateStr);
			}
		}
		Map<String, Object> beans = new HashMap<>();
		beans.put("records", subcontractaccountVOList);
		ExcelExport.getInstance().export("subcontractaccount-export.xlsx", beans, response);
	}

	/**
	 * @Description 参照
	 * @param
	 * @Return void
	 */
	@RequestMapping(value = "/refSubcontractaccountData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<SubcontractaccountVO>> refSubcontractaccountData(@RequestParam Integer pageNumber,
			@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
		QueryParam param = new QueryParam();
		param.setPageSize(pageSize);
		param.setPageIndex(pageNumber);
		param.setSearchText(searchText);
		param.setSearchObject(searchObject);
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if (StringUtils.isNotEmpty(condition)) {
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
		}

		IPage<SubcontractaccountEntity> page = service.queryPage(param, false);
		IPage<SubcontractaccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractaccountVO.class));

		return CommonResponse.success("查询参照数据成功！", pageData);
	}

	/**
	 * 页面子表新增参照月度报量申请后：
	 * 查询累计
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/refreshDetailData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> refreshDetailData(@RequestBody List<SubcontractaccountdetailVO> list, HttpServletResponse response) {
		JSONObject json = new JSONObject();

		for (SubcontractaccountdetailVO subcontractaccountdetailVO : list) {
			String rowState = subcontractaccountdetailVO.getRowState();
			if ("add".equals(rowState)) {
				//查询该报量申请单编号往期累计
				//创建条件构造器
				QueryWrapper<SubcontractaccountdetailEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("contract_id", subcontractaccountdetailVO.getContractId());
				queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
				queryWrapper.orderByDesc("create_time");//最新往期
				queryWrapper.last("limit 1");
				List<SubcontractaccountdetailEntity> pastDetails = detailService.list(queryWrapper);
				if (pastDetails != null && pastDetails.size() > 0) {
					SubcontractaccountdetailEntity pastSubcontractaccountdetail = pastDetails.get(0);
					//至本月累计付款金额
					subcontractaccountdetailVO.setCumulativePayment(pastSubcontractaccountdetail.getCumulativePayment());
				}

				subcontractaccountdetailVO.setRowState("edit");
			}
			subcontractaccountdetailVO.setId(IdWorker.getId());
		}

		json.put("dataSource", list);

		return CommonResponse.success(json);
	}

	/**
	 * 查询被引用的结算单
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/getSelectId", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<Long>> getSelectId(Long id) {
		SubcontractaccountEntity subcontractaccountEntity = service.selectById(id);
		String billCode = subcontractaccountEntity.getBillCode();
		QueryWrapper<SubcontractingvolumeEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("dr",0);
		wrapper.eq("reference_code",billCode);
		List<SubcontractingvolumeEntity> list = subcontractingvolumeService.list(wrapper);
		List<Long> idList = new ArrayList<>();
		for (SubcontractingvolumeEntity entity : list) {
			idList.add(entity.getId());
		}

		return CommonResponse.success("查询成功！", idList);
	}
}
