package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumemdetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeodetailService;
import com.ejianc.business.middlemeasurement.utils.BigDecimalUtils;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.business.settlementmanage.api.ISettlementBookApi;
import com.ejianc.foundation.budgetmanage.api.IConsdrawbudgetApi;
import com.ejianc.foundation.budgetmanage.api.ISubpackageApi;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetVO;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetdetailVO;
import com.ejianc.foundation.budgetmanage.vo.SubpackageVO;
import com.ejianc.foundation.budgetmanage.vo.SubpackagedetailVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包月度报量及申请报告
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractingvolume")
public class SubcontractingvolumeController implements Serializable {
	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;

	@Autowired
	private IOutcontractApi outcontractApi;

	@Autowired
	private IConsdrawbudgetApi consdrawbudgetApi;

	@Autowired
	private ISubpackageApi subpackageApi;

	@Autowired
	private ISettlementBookApi settlementBookApi;

	@Autowired
	private SessionManager sessionManager;

	private static final String BILL_CODE = "Subcontractingvolume_Open_Apply_Code";// 此处需要根据实际修改

	@Autowired
	private ISubcontractingvolumeService service;
	@Autowired
	private ISubcontractingvolumedetailService subcontractingvolumedetailService;
	@Autowired
	private ISubcontractingvolumemdetailService subcontractingvolumemdetailService;
	@Autowired
	private ISubcontractingvolumeodetailService subcontractingvolumeodetailService;

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<SubcontractingvolumeVO> saveOrUpdate(@RequestBody SubcontractingvolumeVO saveorUpdateVO) {
        SubcontractingvolumeEntity entity = BeanMapper.map(saveorUpdateVO, SubcontractingvolumeEntity.class);
		//填充明细数据 带入最近一期审批通过的数据,填充本期未录入但是上期存在的数据
//        getLastDetail(saveorUpdateVO, entity);

		//校验：同一合同，只能存在一份自由态或审批中的单据
		checkBillStateUniq(entity.getId(), entity.getContractId(), true);

		//校验：单据编号唯一性
		entity = checkBillCodeUniq(entity);

		//检验：不允许超过分包施工图预算工程量
		checkSubpackageQuantity(entity);

		//校验：工程分包结算书生成之后，不允许再做分包月度报量
		checkSubcontract(entity.getContractId());

		//检验：不允许超过施工图预算工程量
		checkQuantity(entity);

		entity.setIsReference(0);
		entity.setIsSettlement(0);
		//校验唯一性, 根据清单编号,区段,单价
		List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntities = entity.getSubcontractingvolumedetailEntities();
		if (CollectionUtils.isNotEmpty(subcontractingvolumedetailEntities)){
			Map<String, Long> numMap = subcontractingvolumedetailEntities.stream().filter(s->s.getRowState() != null && !s.getRowState().equals("del")).collect(Collectors.groupingBy((s -> s.getSubitemCode() +'-' + s.getSection() +'-' + s.getExamineUnitprice() +'-' + s.getExamineTaxUnitprice()),
					Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().collect(Collectors.counting()))));

			numMap.forEach((key,value) ->{
				if (value > 1){
					throw new BusinessException("数据有重复,请修改");
				}
			});
		}

		//构建树形结构
		List<SubcontractingvolumedetailEntity> consdrawbudgetdetailVOList = entity.getSubcontractingvolumedetailEntities();
		//末级数据需要判断之前的中间计量上级和下级是否有末级数据
		checkInfo(saveorUpdateVO.getContractId(), consdrawbudgetdetailVOList);
		entity.setIsSettlementBook(0);
		service.saveOrUpdate(entity, false);
		SubcontractingvolumeVO vo = BeanMapper.map(entity, SubcontractingvolumeVO.class);
		vo.setSubcontractingvolumedetailEntities(handleChildren(vo.getSubcontractingvolumedetailEntities()));
		return CommonResponse.success("保存或修改单据成功！", vo);
	}

    private void getLastDetail(SubcontractingvolumeVO saveorUpdateVO, SubcontractingvolumeEntity entity) {
        LambdaQueryWrapper<SubcontractingvolumeEntity> lambdaLast = Wrappers.<SubcontractingvolumeEntity>lambdaQuery();
        lambdaLast.eq(SubcontractingvolumeEntity::getContractId, saveorUpdateVO.getContractId());
        lambdaLast.in(SubcontractingvolumeEntity::getBillState, 1,3);
        lambdaLast.orderByDesc(SubcontractingvolumeEntity::getReportingTime);
        List<SubcontractingvolumeEntity> costanalysisEntityList = service.list(lambdaLast);
        List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntityList = new ArrayList<>();
        Map<String, List<SubcontractingvolumedetailEntity>> groupMap = new HashMap<>();
        DecimalFormat decimalFormat  = new DecimalFormat("0.00000000");
        if(CollectionUtils.isNotEmpty(costanalysisEntityList)){
            SubcontractingvolumeEntity subcontractingvolumeEntityLast = costanalysisEntityList.stream().findFirst().get();
            LambdaQueryWrapper<SubcontractingvolumedetailEntity> lambdaCostPeople = Wrappers.<SubcontractingvolumedetailEntity>lambdaQuery();
            lambdaCostPeople.eq(SubcontractingvolumedetailEntity::getMid, subcontractingvolumeEntityLast.getId());
            subcontractingvolumedetailEntityList = subcontractingvolumedetailService.list(lambdaCostPeople);
        }

        List<SubcontractingvolumedetailEntity> detailList = entity.getSubcontractingvolumedetailEntities();
        groupMap = detailList.stream().filter(s-> !(s.getRowState() != null && s.getRowState().equals("del"))).collect(
                Collectors.groupingBy(
                        s -> s.getSubitemCode() +'-' + s.getSection() +'-' + decimalFormat.format(s.getExamineUnitprice()) +'-' + decimalFormat.format(s.getExamineTaxUnitprice())
                ));

        for (SubcontractingvolumedetailEntity subcontractingvolumedetailEntity : subcontractingvolumedetailEntityList){
            String key = subcontractingvolumedetailEntity.getSubitemCode() +'-' + subcontractingvolumedetailEntity.getSection() +'-' + decimalFormat.format(subcontractingvolumedetailEntity.getExamineUnitprice()) +'-' + decimalFormat.format(subcontractingvolumedetailEntity.getExamineTaxUnitprice());
                if (!groupMap.containsKey(key)) {
                    subcontractingvolumedetailEntity.setExamineQuantity(BigDecimal.ZERO);
                    subcontractingvolumedetailEntity.setExamineAmounts(BigDecimal.ZERO);
                    subcontractingvolumedetailEntity.setExamineTaxAmounts(BigDecimal.ZERO);
                    subcontractingvolumedetailEntity.setId(IdWorker.getId());
                    subcontractingvolumedetailEntity.setMid(null);
                    detailList.add(subcontractingvolumedetailEntity);
                }
		}
    }

    private void checkInfo(Long contractId, List<SubcontractingvolumedetailEntity> consdrawbudgetdetailVOList) {
		//获取子集,汇总数据
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapperNum = new QueryWrapper<>();
		queryWrapperNum.eq("contract_id", contractId);
		queryWrapperNum.in("bill_state", 1, 3);//1直审 3审批通过
		queryWrapperNum.eq("dr", "0");
		List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntityList = subcontractingvolumedetailService.list(queryWrapperNum);
		for(SubcontractingvolumedetailEntity subcontractingvolumedetailVO : consdrawbudgetdetailVOList){
			if (subcontractingvolumedetailVO.getRowState() != null && subcontractingvolumedetailVO.getRowState().equals("del")){
				continue;
			}

			if (subcontractingvolumedetailVO.getExamineQuantity() != null){
				//末级数据需要判断之前的中间计量上级和下级是否有末级数据
				if(CollectionUtils.isNotEmpty(subcontractingvolumedetailEntityList)){
					String subitemCode = subcontractingvolumedetailVO.getSubitemCode();
					String section = subcontractingvolumedetailVO.getSection();
					String innercode = subcontractingvolumedetailVO.getInnercode();

					if (subitemCode.length() == 2){
						getChild(subcontractingvolumedetailEntityList, subitemCode, section, innercode);
					}
					if (subitemCode.length() == 4){
						//判断下级
						getChild(subcontractingvolumedetailEntityList, subitemCode, section, innercode);
						//判断上级
						List<String> innerCodeList = new ArrayList<>();
						String innercodeParent = subitemCode.substring(0, 2) + "_" + section;
						innerCodeList.add(innercodeParent);
						getParentNum(subcontractingvolumedetailEntityList, innercode, innerCodeList);

					}
					if (subitemCode.length() == 6){
						//判断下级
						getChild(subcontractingvolumedetailEntityList, subitemCode, section, innercode);
						//判断上级
						List<String> innerCodeList = new ArrayList<>();
						String innercodeParent = subitemCode.substring(0, 2) + "_" + section;
						String innercodeParentB = subitemCode.substring(0, 4) + "_" + section;
						innerCodeList.add(innercodeParent);
						innerCodeList.add(innercodeParentB);
						getParentNum(subcontractingvolumedetailEntityList, innercode, innerCodeList);

					}
					if (subitemCode.length() > 6){
						//判断上级
						List<String> innerCodeList = new ArrayList<>();
						String innercodeParent = subitemCode.substring(0, 2) + "_" + section;
						String innercodeParentB = subitemCode.substring(0, 4) + "_" + section;
						String innercodeParentC = subitemCode.substring(0, 6) + "_" + section;
						innerCodeList.add(innercodeParent);
						innerCodeList.add(innercodeParentB);
						innerCodeList.add(innercodeParentC);
						getParentNum(subcontractingvolumedetailEntityList, innercode, innerCodeList);
					}
				}

			}
		}
	}
	//判断新增节点的数据是否有上级或下级发生的数据
    private void checkHappenCost(Long contractId, SubcontractingvolumedetailVO subcontractingvolumedetailVO) {
		//获取子集,汇总数据
        //创建条件构造器
        QueryWrapper<SubcontractingvolumeEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("dr", 0);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        List<SubcontractingvolumeEntity> proTotal = service.list(queryWrapperTotal);
        SubcontractingvolumeVO vo = new SubcontractingvolumeVO();
        List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntityList = new ArrayList<>();
        if(proTotal != null && proTotal.size() > 0){
            List<Long> ids = proTotal.stream().map(SubcontractingvolumeEntity::getId).collect(Collectors.toList());
            //查询子表-月度（中间）计量计价明细表数据
            LambdaQueryWrapper<SubcontractingvolumedetailEntity> lambdaCostPeople = Wrappers.<SubcontractingvolumedetailEntity>lambdaQuery();
            lambdaCostPeople.in(SubcontractingvolumedetailEntity::getMid, ids);
            subcontractingvolumedetailEntityList = subcontractingvolumedetailService.list(lambdaCostPeople);
        }
        //末级数据需要判断之前的中间计量上级和下级是否有末级数据
        if(CollectionUtils.isNotEmpty(subcontractingvolumedetailEntityList)){
            String subitemCode = subcontractingvolumedetailVO.getSubitemCode();
            String section = subcontractingvolumedetailVO.getSection();
            String innercode = subcontractingvolumedetailVO.getInnercode();

            if (subitemCode.length() == 2){
                getChild(subcontractingvolumedetailEntityList, subitemCode, section, innercode);
            }
            if (subitemCode.length() == 4){
                //判断下级
                getChild(subcontractingvolumedetailEntityList, subitemCode, section, innercode);
                //判断上级
                List<String> innerCodeList = new ArrayList<>();
                String innercodeParent = subitemCode.substring(0, 2) + "_" + section;
                innerCodeList.add(innercodeParent);
                getParentNum(subcontractingvolumedetailEntityList, innercode, innerCodeList);

            }
            if (subitemCode.length() == 6){
                //判断下级
                getChild(subcontractingvolumedetailEntityList, subitemCode, section, innercode);
                //判断上级
                List<String> innerCodeList = new ArrayList<>();
                String innercodeParent = subitemCode.substring(0, 2) + "_" + section;
                String innercodeParentB = subitemCode.substring(0, 4) + "_" + section;
                innerCodeList.add(innercodeParent);
                innerCodeList.add(innercodeParentB);
                getParentNum(subcontractingvolumedetailEntityList, innercode, innerCodeList);

            }
            if (subitemCode.length() > 6){
                //判断上级
                List<String> innerCodeList = new ArrayList<>();
                String innercodeParent = subitemCode.substring(0, 2) + "_" + section;
                String innercodeParentB = subitemCode.substring(0, 4) + "_" + section;
                String innercodeParentC = subitemCode.substring(0, 6) + "_" + section;
                innerCodeList.add(innercodeParent);
                innerCodeList.add(innercodeParentB);
                innerCodeList.add(innercodeParentC);
                getParentNum(subcontractingvolumedetailEntityList, innercode, innerCodeList);
            }
        }

	}

	private void getChild(List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntityList, String subitemCode, String section, String innercode) {
		for (SubcontractingvolumedetailEntity subcontractingvolumedetailEntity : subcontractingvolumedetailEntityList){
			if (!subcontractingvolumedetailEntity.getSubitemCode().equals(subitemCode) && subcontractingvolumedetailEntity.getSubitemCode().startsWith("subitemCode")
					&& subcontractingvolumedetailEntity.getSection().equals(section) && subcontractingvolumedetailEntity.getExamineQuantity() != null){
				throw new BusinessException("清单编码和区段"+innercode+"下有往期末级中间计量数据,无法新增!");
			}
		}
	}

	private void getParentNum(List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntityList, String innercode, List<String> innerCodeList) {
		for (SubcontractingvolumedetailEntity subcontractingvolumedetailEntity : subcontractingvolumedetailEntityList){
			if (innerCodeList.contains(subcontractingvolumedetailEntity.getInnercode()) && subcontractingvolumedetailEntity.getExamineQuantity() != null){
				throw new BusinessException("清单编码和区段"+innercode+"有往期上级中间计量数据,无法新增!");
			}
		}
	}

	/**
	 * 间计量——分包月度报量及申请报告——工程分包结算书生成之后，不允许再做分包月度报量
	 * @param
	 * @param contractId
	 */
	private void checkSubcontract(Long contractId) {
		CommonResponse<Integer> subcontracts = settlementBookApi.queryContractIds(contractId);
		if (subcontracts.getCode() == 0){
			if (subcontracts.getData() == 0){
				return;
			}else{
				throw new BusinessException("已有工程分包结算书，不能新增分包月度报量及申请报告");
			}
		}
	}



	/**
	 * 不允许超过分包施工图预算工程量
	 * @param entity
	 */
	private void checkSubpackageQuantity(SubcontractingvolumeEntity entity) {
		Long contractId = entity.getContractId();
		CommonResponse<SubpackageVO> subpackageResponse = subpackageApi.queryByContractId(contractId);
		if(subpackageResponse.getCode() != 0){
			return;
		}

		//本单据子表
		List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntities = entity.getSubcontractingvolumedetailEntities();
		if(subcontractingvolumedetailEntities == null && subcontractingvolumedetailEntities.size() == 0){
			return;
		}

		//分包施工图预算
		SubpackageVO subpackageVO = subpackageResponse.getData();

		//如果subpackageVO 为null，该项目没做分包施工图预算，则认为不开启控制
		if(subpackageVO != null){
			//分包施工图预算子表
			List<SubpackagedetailVO> subpackagedetailVOS = subpackageVO.getSubpackagedetailEntities();
			Long isEnable = subpackageVO.getIsEnable();
			if (isEnable != null && isEnable == 1){//是否开启控制:0 否，1:是
				for (int i = 0; i < subcontractingvolumedetailEntities.size(); i++) {
					boolean isHave = false;//本单据子表的清单编号是否在施工图预算中存在
					SubcontractingvolumedetailEntity subcontractingvolumedetail = subcontractingvolumedetailEntities.get(i);
					//数量（项目部审核：本期）
					BigDecimal examineQuantity = subcontractingvolumedetail.getExamineQuantity();
					//数量（项目部审核：累计）
					BigDecimal examineCumulativeQuantity = subcontractingvolumedetail.getExamineCumulativeQuantity();
					//清单编号
					String subitemCode = subcontractingvolumedetail.getSubitemCode();
					//1合同内 2合同外
					String source = subcontractingvolumedetail.getSource();
					if(!"1".equals(source) || "del".equals(subcontractingvolumedetail.getRowState())){
						continue;
					}
					for (int j = 0; j < subpackagedetailVOS.size(); j++) {
						SubpackagedetailVO subpackagedetailVO = subpackagedetailVOS.get(j);
						//分包施工图预算【工程量】
						BigDecimal subpackagEengineeQuatity = subpackagedetailVO.getSubpackageQuantities();
						String subpackagSubtitleCode = subpackagedetailVO.getSubtitleCode();
						if(subitemCode.equals(subpackagSubtitleCode)){
							isHave = true;
							if(examineQuantity != null && (subpackagEengineeQuatity == null || examineQuantity.compareTo(subpackagEengineeQuatity) > 0)){
								throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核本期【数量】超过分包施工图预算工程量！");
							}

							if(examineCumulativeQuantity != null && (subpackagEengineeQuatity == null || examineCumulativeQuantity.compareTo(subpackagEengineeQuatity) > 0)){
								throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核累计【数量】超过分包施工图预算工程量！");
							}

							break;
						}
					}

					//清单编号不在施工图预算中，以工程量为0做控制
					if(!isHave && examineQuantity != null && examineQuantity.compareTo(BigDecimal.ZERO) > 0){
						throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核本期【数量】超过分包施工图预算工程量！");
					}

					if(!isHave && examineCumulativeQuantity != null && examineCumulativeQuantity.compareTo(BigDecimal.ZERO) > 0){
						throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核累计【数量】超过分包施工图预算工程量！");
					}
				}
			}
		}
	}

	/**
	 * 检验：不允许超过施工图预算工程量
	 * @param entity
	 */
	private void checkQuantity(SubcontractingvolumeEntity entity) {
		Long projectId = entity.getProjectId();
		CommonResponse<ConsdrawbudgetVO> consdrawbudgetResponse = consdrawbudgetApi.queryByProjectId(projectId);
		if(consdrawbudgetResponse.getCode() != 0){
			return;
		}

		//本单据子表
		List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntities = entity.getSubcontractingvolumedetailEntities();
		if(subcontractingvolumedetailEntities == null && subcontractingvolumedetailEntities.size() == 0){
			return;
		}

		//施工图预算
		ConsdrawbudgetVO consdrawbudgetVO = consdrawbudgetResponse.getData();

		//如果consdrawbudgetVO 为null，该项目没做施工图预算，则认为不开启控制
		if(consdrawbudgetVO != null){
			//施工图预算子表
			List<ConsdrawbudgetdetailVO> consdrawbudgetdetailVOS = consdrawbudgetVO.getConsdrawbudgetdetailEntities();
			Integer isOpenControl = consdrawbudgetVO.getIsOpenControl();
			if (isOpenControl != null && isOpenControl == 1){//是否开启控制:0 否，1:是
				for (int i = 0; i < subcontractingvolumedetailEntities.size(); i++) {
					boolean isHave = false;//本单据子表的清单编号是否在施工图预算中存在
					SubcontractingvolumedetailEntity subcontractingvolumedetail = subcontractingvolumedetailEntities.get(i);
					//数量（项目部审核：本期）
					BigDecimal examineQuantity = subcontractingvolumedetail.getExamineQuantity();
					//数量（项目部审核：累计）
					BigDecimal examineCumulativeQuantity = subcontractingvolumedetail.getExamineCumulativeQuantity();
					//清单编号
					String subitemCode = subcontractingvolumedetail.getSubitemCode();
					//1合同内 2合同外
					String source = subcontractingvolumedetail.getSource();
					if(!"1".equals(source) || "del".equals(subcontractingvolumedetail.getRowState())){
						continue;
					}
					for (int j = 0; j < consdrawbudgetdetailVOS.size(); j++) {
						ConsdrawbudgetdetailVO consdrawbudgetdetailVO = consdrawbudgetdetailVOS.get(j);
						//施工图预算【工程量】
						BigDecimal engineeQuatity = consdrawbudgetdetailVO.getEngineeQuatity();
						String consdrawbudgetSubitemCode = consdrawbudgetdetailVO.getSubitemCode();
						if(subitemCode.equals(consdrawbudgetSubitemCode)){
							isHave = true;
							if(examineQuantity != null && (engineeQuatity == null || examineQuantity.compareTo(engineeQuatity) > 0)){
								throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核本期【数量】超过施工图预算工程量！");
							}

							if(examineCumulativeQuantity != null && (engineeQuatity == null || examineCumulativeQuantity.compareTo(engineeQuatity) > 0)){
								throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核累计【数量】超过施工图预算工程量！");
							}

							break;
						}
					}

					//清单编号不在施工图预算中，以工程量为0做控制
					if(!isHave && examineQuantity != null && examineQuantity.compareTo(BigDecimal.ZERO) > 0){
						throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核本期【数量】超过施工图预算工程量！");
					}

					if(!isHave && examineCumulativeQuantity != null && examineCumulativeQuantity.compareTo(BigDecimal.ZERO) > 0){
						throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核累计【数量】超过施工图预算工程量！");
					}
				}
			}
		}
	}

	/**
	 * 同一合同，只能存在一份自由态或审批中的单据
	 * @param id
	 * @param contractId
	 * @param isShowError 是否需要校验（初始化数据不需要，切换合同或保存需要）
	 */
	private void checkBillStateUniq(Long id, Long contractId, boolean isShowError) {
		//创建条件构造器
		QueryWrapper<SubcontractingvolumeEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", contractId);
		queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
		queryWrapper.eq("dr", "0");
		if(id != null){
			queryWrapper.ne("id", id);
		}
		List<SubcontractingvolumeEntity> pro = service.list(queryWrapper);
		if(pro != null && pro.size() > 0){
			throw new BusinessException("同一合同只能存在一份自由态或审批中的\"分包月度报量及申请报告\"!");
		}
	}

	/**
	 * 单据编码唯一性校验
	 * @param entity
	 */
	private SubcontractingvolumeEntity checkBillCodeUniq(SubcontractingvolumeEntity entity) {
		if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
			if(billCode.isSuccess()) {
				entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}else {
			//单据编码唯一性
			QueryWrapper<SubcontractingvolumeEntity> queryWrapperBillCode = new QueryWrapper<>();
			queryWrapperBillCode.eq("bill_code", entity.getBillCode());
			queryWrapperBillCode.eq("dr", "0");
			Long id = entity.getId();
			if(id != null){
				queryWrapperBillCode.ne("id", id);
			}
			List<SubcontractingvolumeEntity> proBillCode = service.list(queryWrapperBillCode);
			if(proBillCode != null && proBillCode.size() > 0){
				throw new BusinessException("单据编码已存在，请重新录入!");
			}
		}

		return entity;
	}

	/**
	 * 页面新增清单编号后重新构建树
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/refreshData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> refreshData(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
		JSONObject json = new JSONObject();
		Map<String, SubcontractingvolumedetailVO> map = new HashMap<>();
		SubcontractingvolumedetailVO add = list.get(list.size() - 1);
		for (SubcontractingvolumedetailVO VO : list) {
			if (VO.getId() == null){
				VO.setId(IdWorker.getId());
			}
		}
		add.setTid(String.valueOf(IdWorker.getId()));
		add.setRowState("edit");
		add.setInnercode(add.getSubitemCode() + "_" + add.getSection());//清单编码确定唯一性
		//查询该清单编码往期累计
		//创建条件构造器
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", add.getContractId());
		queryWrapper.eq("subitem_code", add.getSubitemCode());
		queryWrapper.eq("section", add.getSection());
		queryWrapper.eq("examine_unitprice", add.getExamineUnitprice());
		queryWrapper.eq("examine_tax_unitprice", add.getExamineTaxUnitprice());
		queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
		queryWrapper.eq("dr", "0");
		List<SubcontractingvolumedetailEntity> pastDetails = subcontractingvolumedetailService.list(queryWrapper);
		if(pastDetails != null && pastDetails.size() > 0){
			BigDecimal examineQuantity = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
			BigDecimal examineAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
			BigDecimal examineTaxAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineTaxAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
			add.setExamineCumulativeQuantity(examineQuantity);
			add.setExamineCumulativeAmounts(examineAmounts);
			add.setExamineCumulativeTaxAmounts(examineTaxAmounts);
		}
//		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapperNum = new QueryWrapper<>();
//		queryWrapperNum.eq("contract_id", add.getContractId());
//		queryWrapperNum.eq("subitem_code", add.getSubitemCode());
//		queryWrapperNum.eq("section", add.getSection());
//		queryWrapperNum.in("bill_state", 1, 3);//1直审 3审批通过
//		queryWrapperNum.eq("dr", "0");
//		List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntityList = subcontractingvolumedetailService.list(queryWrapperNum);
//		if(CollectionUtils.isNotEmpty(subcontractingvolumedetailEntityList)){
//			BigDecimal examineQuantity = subcontractingvolumedetailEntityList.stream().map(SubcontractingvolumedetailEntity::getExamineQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
//			add.setSumNum(examineQuantity);
//		}

		//判断新增行是合同内还是合同外
		CommonResponse<List<OutcontractSubcontractUnitPriceVO>> outcontractResp = outcontractApi.queryListBycontractIdAndCode(add.getContractId(), add.getSubitemCode());
		int responseCode = outcontractResp.getCode();
		if(responseCode == 0){
			List<OutcontractSubcontractUnitPriceVO> voList = outcontractResp.getData();
			if(voList != null && voList.size() > 0){
				OutcontractSubcontractUnitPriceVO priceVO = voList.get(0);
				BigDecimal comprehensiveUnitPrice = priceVO.getComprehensiveUnitPrice();//综合单价
				add.setSource("1");//合同内
				add.setUnit(priceVO.getUnit());//单位
				add.setTaxUnitprice(comprehensiveUnitPrice);//含税单价
				add.setContractNumber(priceVO.getEngineeringQuantity());//
				BigDecimal tax = priceVO.getTax();//税金
				BigDecimal engineeringQuantity = priceVO.getEngineeringQuantity();//工程量
				if(tax != null && engineeringQuantity != null && engineeringQuantity.compareTo(BigDecimal.ZERO) != 0){
					//除税单价 = 综合单价 - 税金/工程量
					BigDecimal temp = tax.divide(engineeringQuantity, 8, BigDecimal.ROUND_HALF_UP);
					add.setUnitprice(comprehensiveUnitPrice.subtract(temp));//除税单价
				}else {
					add.setUnitprice(comprehensiveUnitPrice);
				}
			}else {
				add.setSource("2");//合同外
			}
		}else {
			add.setSource("2");//合同外
		}

		for (SubcontractingvolumedetailVO vo : list) {
			map.put(vo.getInnercode(), vo);
			if (!add.getId().equals(vo.getId()) && add.getInnercode().equals(vo.getInnercode()) && add.getExamineUnitprice().equals(vo.getExamineUnitprice()) && add.getExamineTaxUnitprice().equals(vo.getExamineTaxUnitprice())) {
				throw new BusinessException("数据已存在，请重新填写");
			}
		}
		//判断新增数据的上级清单编码和区段是否有重复值,有的话不能新增
		String subitemCode = add.getSubitemCode();
		String section = add.getSection();
		String innercodeDouble = null;
		Map<String, List<SubcontractingvolumedetailVO>> mapDouble = list.stream().collect(
				Collectors.groupingBy(
						s -> s.getSubitemCode()+'_'+s.getSection()
				));
		if (subitemCode.length() == 4){
			innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
			checkDouble(innercodeDouble, mapDouble);
		}
		if (subitemCode.length() == 6){
			innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
			checkDouble(innercodeDouble, mapDouble);
			innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
			checkDouble(innercodeDouble, mapDouble);
		}
		if (subitemCode.length() > 6){
			innercodeDouble = subitemCode.substring(0, 6) + "_" + section;
			checkDouble(innercodeDouble, mapDouble);
			innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
			checkDouble(innercodeDouble, mapDouble);
			innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
			checkDouble(innercodeDouble, mapDouble);
		}
		//判断新增节点的数据是否有上级或下级发生的数据
        checkHappenCost(add.getContractId(), add);




        //设置父级id
		for (SubcontractingvolumedetailVO vo : list) {
			String innercode = vo.getInnercode();
			String[] innercodeSubArr = innercode.split("_");
			String innercodeSub = "";
			String sectionSuf = "";
			if (innercodeSubArr.length > 1) {
				innercodeSub = innercodeSubArr[0];
				sectionSuf = "_" + innercodeSubArr[1];
			}

			Long pid = null;
			if (innercodeSub.length() == 2) {
				//最上级
			} else if (innercodeSub.length() == 4) {
				String pcode = innercodeSub.substring(0, 2) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);

			} else if (innercodeSub.length() == 6) {
				String pcode = innercodeSub.substring(0, 4) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercodeSub.length() > 6) {
				String pcode = innercodeSub.substring(0, 6) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			}

			if (pid != null) {
				vo.setTpid(pid.toString());
			} else {
				vo.setTpid("");
			}
		}

		list = handleChildren(list);

		//统计父级的合计数值
//		getChildrenUnitTotalAmount(list);
		json.put("dataSource", list);

		return CommonResponse.success(json);
	}
	/**
	 * 页面新增清单编号后重新构建树
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/getInfoById", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubcontractingvolumedetailVO> getInfoById(SubcontractingvolumedetailVO subcontractingvolumedetailVO) {
		//根据区段,清单编码,单价合同主键获取累计值
		//查询该清单编码往期累计
		//创建条件构造器
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", subcontractingvolumedetailVO.getContractId());
		queryWrapper.eq("subitem_code", subcontractingvolumedetailVO.getSubitemCode());
		queryWrapper.eq("section", subcontractingvolumedetailVO.getSection());
		queryWrapper.eq("examine_unitprice", subcontractingvolumedetailVO.getExamineUnitprice());
		queryWrapper.eq("examine_tax_unitprice", subcontractingvolumedetailVO.getExamineTaxUnitprice());
		queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
		queryWrapper.eq("dr", "0");
		queryWrapper.notIn(subcontractingvolumedetailVO.getIds()!=null,"id", subcontractingvolumedetailVO.getIds());
		List<SubcontractingvolumedetailEntity> pastDetails = subcontractingvolumedetailService.list(queryWrapper);
		//计算含税无税金额
		BigDecimal examineQuantity =subcontractingvolumedetailVO.getExamineQuantity() == null ? BigDecimal.ZERO : subcontractingvolumedetailVO.getExamineQuantity();
		BigDecimal examineUnitprice =subcontractingvolumedetailVO.getExamineUnitprice() == null ? BigDecimal.ZERO : subcontractingvolumedetailVO.getExamineUnitprice();
		BigDecimal examineTaxUnitprice =subcontractingvolumedetailVO.getExamineTaxUnitprice() == null ? BigDecimal.ZERO : subcontractingvolumedetailVO.getExamineTaxUnitprice();
		BigDecimal money = examineQuantity.multiply(examineUnitprice);
		BigDecimal moneyTax = examineQuantity.multiply(examineTaxUnitprice);
		subcontractingvolumedetailVO.setExamineCumulativeAmounts(money);
		subcontractingvolumedetailVO.setExamineCumulativeTaxAmounts(moneyTax);
		if(pastDetails != null && pastDetails.size() > 0){

			BigDecimal examineQuantitySum = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
			logger.info("examineQuantitySum" +examineQuantitySum);
			BigDecimal examineAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
			BigDecimal examineTaxAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineTaxAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
			logger.info("examineQuantity" +examineQuantity);
			subcontractingvolumedetailVO.setExamineCumulativeQuantity(examineQuantitySum);
			subcontractingvolumedetailVO.setExamineCumulativeAmounts(examineAmounts.add(money));
			subcontractingvolumedetailVO.setExamineCumulativeTaxAmounts(examineTaxAmounts.add(moneyTax));
		}

		return CommonResponse.success("查询往期审批通过的累计数据成功！", subcontractingvolumedetailVO);
	}
	/**
	 * updateDataTest
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/updateDataTest", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubcontractingvolumedetailVO> updateDataTest(Long contractId) {
		//根据区段,清单编码,单价合同主键获取累计值
		//查询该清单编码往期累计
		//创建条件构造器
//		sql
//		SELECT mid,examine_quantity,examine_unitprice,examine_tax_unitprice ,
//		examine_amounts,examine_tax_amounts,examine_cumulative_quantity,examine_cumulative_amounts,examine_cumulative_tax_amounts FROM `ejc_middlemeasurement_subcontractingvolumedetail` WHERE contract_id = '720664447998795808' and dr = 0 and subitem_code = 'GG02'
//		order by mid asc
//		650257261653930078	上海医都医院项目主体劳务分包合同	4   ((错误-数据错乱-不能处理))
//		650278878304022607	上海医都医院项目主体劳务分包合同	3     (错误-数据错乱-不能处理)
//		650291292344954902	上海医都医院项目防水分包工程合同	3   (正确-数据不用处理)
//		650343192213860441	上海医都医院项目脚手架工程分包合同	4  (错误-数据错乱-不能处理)
//		650353394979975196	上海医都医院项目模板工程分包合同	4  (错误-数据错乱-不能处理)
//		650356042865061941	上海医都医院项目模板工程分包合同	3  (错误-数据错乱-不能处理)
//		650730389681221643	上海医都医院项目垃圾外运专业分包合同	3(错误-数据错乱-不能处理)
//		650737947666034770	上海医都医院项目临建劳务分包合同	2(错误-数据错乱-不能处理)
//		650746995174027359	上海医都医院项目材料检测分包合同	3(错误-数据错乱-不能处理)
//		680699045411856479	新城建示范及智能建筑产业园（一期）工程勘察设计施工总承包项目二标段钢结构工程专业分包合同	2  (正确-数据不用处理)
//		681096096058482696	新城建示范及智能建筑产业园（一期）工程勘察设计施工总承包项目钢结构工程专业分包合同	2 (正确-数据不用处理)
//		699213114431279157	新城建示范及智能建筑产业园(一期)工程勘察设计施工总承包钢结构防火涂料专业分包工程 	2  (正确-数据不用处理)
//		713406738454847559	新城建示范及智能建筑产业园（一期）工程勘察设计施工总承包工程电梯采购/安装工程	2  (正确-数据不用处理)
//		715572008950730782	美锦氢能总部基地项目一期基坑支护工程	2 (正确-数据不用处理)
//		715682216507121697	美锦氢能总部基地项目一期土建劳务分包工程	5 (正确-数据不用处理)
//		718044440043229278	新城建示范及智能建筑产业园 (一期)工程勘察设计施工总承包 ALC墙板劳务分包工程合同	2  (正确-数据不用处理)
//		720664447998795808	美锦氢能总部基地项目一期钢结构工程专业分包合同	6    (不正确-数据可以处理)
//		720945764997046321	美锦氢能总部基地一期项目机电安装工程分包合同	4 (正确-数据不用处理)
//		722491230515662855	美锦氢能总部基地一期项目土方工程	3 (正确-数据不用处理)
//		727791311913521153	1#、4#、5#、6#、7#标准厂房模板脚手架专业分包合同	2 (正确-数据不用处理)
//		728650072827928635	美锦氢能总部基地一期项目防水专业分包合同	3 (不正确-数据可以处理)
//		730328564103680045	上海医都医院项目总承包工程二结构及粗装修分包合同	2 (错误-数据错乱-不能处理)
//		730690205395755061	上海医都医院项目总承包工程二结构及粗装修分包合同	2 (错误-数据错乱-不能处理)
//		754749501590745111	美锦氢能总部基地一期项目土方回填工程	3 (正确-数据不用处理)
//		768771415636189279	坪山生物医药产业加速器园区项目（一标段）工程总承包（EPC）项目1A栋公区精装合同	2 (正确-数据不用处理)
//		771427045819822138	土方工程分包合同	2  (错误-数据错乱-不能处理)
//		779848062477017106	美锦氢能总部基地一期项目幕墙专业分包合同	2 (正确-数据不用处理)
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", contractId);
//		queryWrapper.eq("subitem_code", subcontractingvolumedetailVO.getSubitemCode());
//		queryWrapper.eq("section", subcontractingvolumedetailVO.getSection());
//		queryWrapper.eq("examine_unitprice", subcontractingvolumedetailVO.getExamineUnitprice());
//		queryWrapper.eq("examine_tax_unitprice", subcontractingvolumedetailVO.getExamineTaxUnitprice());
//		queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
		queryWrapper.eq("dr", "0");
		queryWrapper.isNotNull("section");
		queryWrapper.isNotNull("examine_unitprice");
		queryWrapper.isNotNull("examine_tax_unitprice");
		queryWrapper.isNotNull("subitem_code");
//		queryWrapper.notIn(subcontractingvolumedetailVO.getIds()!=null,"id", subcontractingvolumedetailVO.getIds());
		List<SubcontractingvolumedetailEntity> detailList = subcontractingvolumedetailService.list(queryWrapper);
		logger.info("数量-{}",detailList.size());

		QueryWrapper<SubcontractingvolumeEntity> qrapper = new QueryWrapper<>();
		qrapper.eq("contract_id", contractId);
		qrapper.eq("dr", "0");
//		queryWrapper.notIn(subcontractingvolumedetailVO.getIds()!=null,"id", subcontractingvolumedetailVO.getIds());
		List<SubcontractingvolumeEntity> list = service.list(qrapper);
		Map<Long, SubcontractingvolumeEntity> attacMap = list.stream().collect(Collectors.toMap(SubcontractingvolumeEntity::getId, Function.identity()));

//		detailVO.setExamineTaxUnitprice(new BigDecimal(examineTaxUnitprice).setScale(8,RoundingMode.HALF_UP));
		for (SubcontractingvolumedetailEntity detailEntity : detailList){
			SubcontractingvolumeEntity subcontractingvolumeEntity = attacMap.get(detailEntity.getMid());
			Date reportingTime = subcontractingvolumeEntity.getReportingTime();

			//更新累计值
//			BigDecimal examineAmounts = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineAmounts() != null).map(SubcontractingvolumedetailVO::getExamineAmounts)
////					.reduce(BigDecimal.ZERO, BigDecimal::add);
			List<SubcontractingvolumedetailEntity> collect = detailList.stream().filter(s -> attacMap.get(s.getMid()).getReportingTime().before(reportingTime)).collect(Collectors.toList());

			BigDecimal examineAmounts  = collect.stream().filter(s->s.getContractId().equals(detailEntity.getContractId()) && s.getSubitemCode().equals(detailEntity.getSubitemCode())
			&& s.getSection().equals(detailEntity.getSection()) && s.getExamineUnitprice().setScale(8,RoundingMode.HALF_UP).compareTo(detailEntity.getExamineUnitprice().setScale(8,RoundingMode.HALF_UP)) == 0
					&& s.getExamineTaxUnitprice().setScale(8,RoundingMode.HALF_UP).compareTo(detailEntity.getExamineTaxUnitprice().setScale(8,RoundingMode.HALF_UP)) == 0
					&& (s.getBillState().equals(1) ||  s.getBillState().equals(3))).map(SubcontractingvolumedetailEntity::getExamineAmounts)
					.reduce(BigDecimal.ZERO, BigDecimal::add);
			BigDecimal examineTaxAmounts  = collect.stream().filter(s->s.getContractId().equals(detailEntity.getContractId()) && s.getSubitemCode().equals(detailEntity.getSubitemCode())
			&& s.getSection().equals(detailEntity.getSection()) && s.getExamineUnitprice().setScale(8,RoundingMode.HALF_UP).compareTo(detailEntity.getExamineUnitprice().setScale(8,RoundingMode.HALF_UP)) == 0
					&& s.getExamineTaxUnitprice().setScale(8,RoundingMode.HALF_UP).compareTo(detailEntity.getExamineTaxUnitprice().setScale(8,RoundingMode.HALF_UP)) == 0
					&& (s.getBillState().equals(1) ||  s.getBillState().equals(3))).map(SubcontractingvolumedetailEntity::getExamineTaxAmounts)
					.reduce(BigDecimal.ZERO, BigDecimal::add);
			BigDecimal examineQuantity  = collect.stream().filter(s->s.getContractId().equals(detailEntity.getContractId()) && s.getSubitemCode().equals(detailEntity.getSubitemCode())
			&& s.getSection().equals(detailEntity.getSection()) && s.getExamineUnitprice().setScale(8,RoundingMode.HALF_UP).compareTo(detailEntity.getExamineUnitprice().setScale(8,RoundingMode.HALF_UP)) == 0
					&& s.getExamineTaxUnitprice().setScale(8,RoundingMode.HALF_UP).compareTo(detailEntity.getExamineTaxUnitprice().setScale(8,RoundingMode.HALF_UP)) == 0
					&& (s.getBillState().equals(1) ||  s.getBillState().equals(3))).map(SubcontractingvolumedetailEntity::getExamineQuantity)
					.reduce(BigDecimal.ZERO, BigDecimal::add);

			detailEntity.setExamineCumulativeAmounts(examineAmounts.add(BigDecimalUtils.ofNullable(detailEntity.getExamineAmounts())));
			detailEntity.setExamineCumulativeTaxAmounts(examineTaxAmounts.add(BigDecimalUtils.ofNullable(detailEntity.getExamineTaxAmounts())));
			detailEntity.setExamineCumulativeQuantity(examineQuantity.add(BigDecimalUtils.ofNullable(detailEntity.getExamineQuantity())));
		}
		subcontractingvolumedetailService.updateBatchById(detailList);


		return CommonResponse.success("查询往期审批通过的累计数据成功！", null);
	}

	List<SubcontractingvolumedetailVO> subcontractingvolumedetailVOList = new ArrayList<SubcontractingvolumedetailVO>();
	BigDecimal num = null;

	private void checkDouble(String innercode, Map<String, List<SubcontractingvolumedetailVO>> mapDouble) {
		if (mapDouble.containsKey(innercode)){
			List<SubcontractingvolumedetailVO> subcontractingvolumedetailVOS = mapDouble.get(innercode);
			if (subcontractingvolumedetailVOS.size() > 1){
				throw new BusinessException("父级编码重复,无法新增!");
			}
		}
	}

	/**
	 * 页面子表新增参照合同价后
	 * 1.查询累计
	 * 2.重新构建树
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/refreshDetailData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> refreshDetailData(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
		JSONObject json = new JSONObject();

		for (int i = 0; i < list.size(); i++) {
			SubcontractingvolumedetailVO subcontractingvolumedetailVO = list.get(i);
			String rowState = subcontractingvolumedetailVO.getRowState();
			if("add".equals(rowState)){
				//查询该清单编码往期累计
				//创建条件构造器
				subcontractingvolumedetailVO.setRowState("edit");
			}
		}

		//排序、构建树
		list = handleChildren(list);

		//统计父级的合计数值
//		getChildrenUnitTotalAmount(list);

		json.put("dataSource", list);
		//筛选出根节点


		return CommonResponse.success(json);
	}






	/**
	 * @Description  查询往期
	 * @param contractId
	 */
	@RequestMapping(value = "/pastData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubcontractingvolumeVO> pastData(Long id, Long contractId, boolean isShowError) {
		if(isShowError){
			//校验：同一合同，只能存在一份自由态或审批中的单据
			checkBillStateUniq(id, contractId, isShowError);
		}

		//本期日期
		Date currentDate = new Date(System.currentTimeMillis());
		if(id != null){//更新
			SubcontractingvolumeEntity entity = service.selectById(id);
			currentDate = entity.getCreateTime();
		}

		return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
	}

	/**
	 * 获取往期审批通过的合计数据
	 *
	 * @param contractId 合同id
	 * @param currentDate 本期日期
	 */
	private SubcontractingvolumeVO getPastTotalData(Long contractId, Date currentDate) {
		//创建条件构造器
		QueryWrapper<SubcontractingvolumeEntity> queryWrapperTotal = new QueryWrapper<>();
		queryWrapperTotal.eq("contract_id", contractId);
		queryWrapperTotal.eq("dr", 0);
		queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
//		queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
		queryWrapperTotal.orderByDesc("create_time");
		queryWrapperTotal.last("limit 1");

		List<SubcontractingvolumeEntity> proTotal = service.list(queryWrapperTotal);

		SubcontractingvolumeVO vo = new SubcontractingvolumeVO();
		if(proTotal != null && proTotal.size() > 0){
			SubcontractingvolumeEntity pastEntity = proTotal.get(0);
			vo = BeanMapper.map(pastEntity, SubcontractingvolumeVO.class);
			//查询子表-月度（中间）计量计价明细表数据
            LambdaQueryWrapper<SubcontractingvolumedetailEntity> lambdaCostPeople = Wrappers.<SubcontractingvolumedetailEntity>lambdaQuery();
            lambdaCostPeople.eq(SubcontractingvolumedetailEntity::getMid, pastEntity.getId());
            List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntities = subcontractingvolumedetailService.list(lambdaCostPeople);
            List<SubcontractingvolumedetailVO> subcontractingvolumedetailVOS = BeanMapper.mapList(subcontractingvolumedetailEntities, SubcontractingvolumedetailVO.class);
            List<SubcontractingvolumedetailVO> collect = subcontractingvolumedetailVOS.stream().filter(s -> s.getExamineQuantity() != null).collect(Collectors.toList());

            for(SubcontractingvolumedetailVO subcontractingvolumedetailVO : collect){
                subcontractingvolumedetailVO.setExamineQuantity(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setExamineAmounts(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setExamineTaxAmounts(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setId(IdWorker.getId());
                subcontractingvolumedetailVO.setBillState(0);
                subcontractingvolumedetailVO.setOldFlag(OldFlagEnum.上期数据.getCode());
                subcontractingvolumedetailVO.setMid(null);
            }
            vo.setSubcontractingvolumedetailEntities(subcontractingvolumedetailVOS);
        }

		vo.setContractId(contractId);
		return vo;
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubcontractingvolumeVO> queryDetail(Long id) {
		SubcontractingvolumeEntity entity = service.selectById(id);
		SubcontractingvolumeVO vo = BeanMapper.map(entity, SubcontractingvolumeVO.class);

		//构建树形结构
		List<SubcontractingvolumedetailVO> consdrawbudgetdetailVOList = vo.getSubcontractingvolumedetailEntities();
		vo.setSubcontractingvolumedetailEntities(handleDetailChildren(consdrawbudgetdetailVOList));
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<SubcontractingvolumeVO> vos) {
		service.removeByIds(vos.stream().map(SubcontractingvolumeVO::getId).collect(Collectors.toList()), true);
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @Description queryList 查询列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<SubcontractingvolumeVO>> queryList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		UserContext userContextCache =sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		}else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if(5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if(CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if(CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		IPage<SubcontractingvolumeEntity> page = service.queryPage(param, false);
		IPage<SubcontractingvolumeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractingvolumeVO.class));

		return CommonResponse.success("查询列表数据成功！", pageData);
	}

	/**
	 * @Description 导出
	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");
		param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.setPageIndex(1);
		param.setPageSize(-1);
		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		UserContext userContextCache =sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		}else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if(5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if(CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if(CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
		List<SubcontractingvolumeEntity> list = service.queryList(param);
		//时间转换
		List<SubcontractingvolumeVO> subcontractingvolumeVOList = BeanMapper.mapList(list, SubcontractingvolumeVO.class);
		for (int i = 0; i < subcontractingvolumeVOList.size(); i++) {
			SubcontractingvolumeVO subcontractingvolumeVO = subcontractingvolumeVOList.get(i);
			subcontractingvolumeVO.setSort(String.valueOf(i+1));
			if (subcontractingvolumeVO.getReportingTime()!=null){
				subcontractingvolumeVO.setReportingTimeShow(DateUtils.dateSimple2(subcontractingvolumeVO.getReportingTime()));
			}

			String billStateStr = subcontractingvolumeVO.getBillState().toString();
			if (billStateStr != null){
				if("0".equals(billStateStr)){//自由态
					billStateStr = "自由态";
				}else if("1".equals(billStateStr)){//已提交
					billStateStr = "已提交";
				}else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
					billStateStr = "审批中";
				}else if("3".equals(billStateStr)){//审批通过
					billStateStr = "审批通过";
				}else if("4".equals(billStateStr)){//驳回
					billStateStr = "驳回";
				}

				subcontractingvolumeVO.setBillStateStr(billStateStr);
			}
		}
		// todo:字段翻译等等
		Map<String, Object> beans = new HashMap<>();
		beans.put("records", subcontractingvolumeVOList);
		ExcelExport.getInstance().export("subcontractingvolume-export.xlsx", beans, response);
	}

	/**
	 * 获取RPC数据
	 * resp 返回值
	 * isMustSuc 是否必须成功
	 * errMsg 失败提示
	 */
	private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
		if(isMustSuc && !resp.isSuccess()) {
			throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
		}
		return resp.getData();
	}


	/**
	 * @Description 参照
	 * @param
	 * @Return void
	 */
	@RequestMapping(value = "/refSubcontractingvolumeData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<SubcontractingvolumeVO>> refSubcontractingvolumeData(@RequestParam Integer pageNumber,
			@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
		QueryParam param = new QueryParam();
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");

		param.setPageSize(pageSize);
		param.setPageIndex(pageNumber);
		param.setSearchText(searchText);
		param.setSearchObject(searchObject);
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if (StringUtils.isNotEmpty(condition)) {
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
			if(_con.get("projectId")!=null){
				param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
			}
		}

		//未被引用
		param.getParams().put("isReference", new Parameter(QueryParam.EQ, 0));

		//审批通过
		param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
		param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));

		IPage<SubcontractingvolumeEntity> page = service.queryPage(param, false);
		IPage<SubcontractingvolumeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<SubcontractingvolumeVO> subcontractingvolumeVOList = BeanMapper.mapList(page.getRecords(), SubcontractingvolumeVO.class);

		pageData.setRecords(subcontractingvolumeVOList);

		return CommonResponse.success("查询参照数据成功！", pageData);
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode, Map<String, SubcontractingvolumedetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找
			String[] pcodeSubArr = pcode.split("_");
			String pcodeSub = "";
			String sectionSuf = "";//"_" + 区段
			if (pcodeSubArr.length > 1) {
				pcodeSub = pcodeSubArr[0];
				sectionSuf = "_" + pcodeSubArr[1];
			}
			if (pcodeSub.length() == 2) {
				//最上级
				return null;
			} else if (pcodeSub.length() == 4) {
				String ppcode = pcodeSub.substring(0, 2);
				return this.setPid(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode + sectionSuf, map);
			} else {
				return null;
			}
		}
	}







	/**
	 * 对子表做排序、构建树等处理
	 *
	 * @param voList
	 */
	private List<SubcontractingvolumedetailVO> handleChildren(List<SubcontractingvolumedetailVO> voList) {
		//按子目编码排序
		Collections.sort(voList, new Comparator<SubcontractingvolumedetailVO>() {
			@Override
			public int compare(SubcontractingvolumedetailVO o1, SubcontractingvolumedetailVO o2) {
				return (o1.getSubitemCode() + o1.getSection()).compareTo(o2.getSubitemCode() + o2.getSection());
			}
		});

		//获取子集,汇总数据
		List<String> tpidList = voList.stream().map(SubcontractingvolumedetailVO::getTpid).collect(Collectors.toList());
		for(SubcontractingvolumedetailVO subcontractingvolumedetailVO : voList){
			List<SubcontractingvolumedetailVO> detailByPid = getDetailByPid(subcontractingvolumedetailVO.getTid(), voList);

			if (CollectionUtils.isNotEmpty(detailByPid)){
				subcontractingvolumedetailVO.setExamineQuantity(null);
				subcontractingvolumedetailVO.setExamineUnitprice(null);
				subcontractingvolumedetailVO.setExamineTaxUnitprice(null);
				subcontractingvolumedetailVO.setExamineAmounts(null);
				subcontractingvolumedetailVO.setExamineTaxAmounts(null);
				subcontractingvolumedetailVO.setExamineCumulativeTaxAmounts(null);
				subcontractingvolumedetailVO.setExamineCumulativeAmounts(null);
				subcontractingvolumedetailVO.setExamineCumulativeQuantity(null);
				BigDecimal examineAmounts = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineAmounts() != null).map(SubcontractingvolumedetailVO::getExamineAmounts)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				BigDecimal examineTaxAmounts = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineTaxAmounts() != null).map(SubcontractingvolumedetailVO::getExamineTaxAmounts)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				BigDecimal examineCumulativeAmounts = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineCumulativeAmounts() != null).map(SubcontractingvolumedetailVO::getExamineCumulativeAmounts)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				BigDecimal examineCumulativeTaxAmounts = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineCumulativeTaxAmounts() != null).map(SubcontractingvolumedetailVO::getExamineCumulativeTaxAmounts)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				BigDecimal examineCumulativeQuantity = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getExamineCumulativeQuantity() != null).map(SubcontractingvolumedetailVO::getExamineCumulativeQuantity)
						.reduce(BigDecimal.ZERO, BigDecimal::add);
				subcontractingvolumedetailVO.setExamineAmounts(examineAmounts);
				subcontractingvolumedetailVO.setExamineTaxAmounts(examineTaxAmounts);
				subcontractingvolumedetailVO.setExamineCumulativeTaxAmounts(examineCumulativeTaxAmounts);
				subcontractingvolumedetailVO.setExamineCumulativeAmounts(examineCumulativeAmounts);
				subcontractingvolumedetailVO.setExamineCumulativeQuantity(examineCumulativeQuantity);
				subList.clear();
			}
		}
		//构建树
		voList = createTreeData(voList);


		return voList;
	}
	/**
	 * 对子表做排序、构建树等处理
	 *
	 * @param voList
	 */
	private List<SubcontractingvolumedetailVO> handleDetailChildren(List<SubcontractingvolumedetailVO> voList) {
		//按子目编码排序
		Collections.sort(voList, new Comparator<SubcontractingvolumedetailVO>() {
			@Override
			public int compare(SubcontractingvolumedetailVO o1, SubcontractingvolumedetailVO o2) {
				return (o1.getSubitemCode() + o1.getSection()).compareTo(o2.getSubitemCode() + o2.getSection());
			}
		});
		//构建树
		voList = createTreeData(voList);


		return voList;
	}
	List<SubcontractingvolumedetailVO> subList = new ArrayList<>();
	private List<SubcontractingvolumedetailVO> getDetailByPid(String tid, List<SubcontractingvolumedetailVO> list) {

		for (SubcontractingvolumedetailVO subcontractingvolumedetailVO : list) {
			if (tid != null && tid.equals(subcontractingvolumedetailVO.getTpid())) {
				getDetailByPid(subcontractingvolumedetailVO.getTid(), list);
				subList.add(subcontractingvolumedetailVO);
			}
		}
		return subList;
	}
	public static List<SubcontractingvolumedetailVO> createTreeData(List<SubcontractingvolumedetailVO> list) {
		List<SubcontractingvolumedetailVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, SubcontractingvolumedetailVO> listMap = new HashMap<>();
		for (SubcontractingvolumedetailVO item : list) {
			listMap.put(item.getTid().toString(), item);
		}

		for (int i = 0; i < list.size(); i++) {
			SubcontractingvolumedetailVO item = list.get(i);
			String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
			SubcontractingvolumedetailVO parent = listMap.get(parentId);
			if (parent != null) {
				List<SubcontractingvolumedetailVO> child = (List<SubcontractingvolumedetailVO>) parent.getChildren();
				if (child != null) {
					child.add(item);
				} else {
					List<SubcontractingvolumedetailVO> children = new ArrayList<SubcontractingvolumedetailVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getTid());
			}
		}

		for (String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}
}
