package com.ejianc.business.middlemeasurement.controller.api;

import com.ejianc.business.middlemeasurement.service.IConsultotherService;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodeService;
import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/12/3
 * @description:查询成本管理所需要的设计和咨询类的本期累计和本月累计数据
 */
@RestController
@RequestMapping("/api/costManageApi/")
public class CostManageApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private IDesignsubcontractnodeService service;
    @Autowired
    private IConsultotherService consultotherService;
    /**
     * 根据合同id查询设计分包节点申请报量合价和金额
     * @param contractId
     * @return
     */
    @GetMapping("queryDesign")
    public CommonResponse<Map<String,CostManageVO>> queryDesign(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "monthStr")String monthStr){
        Map<String,CostManageVO> map = new HashMap<>();
        List<CostManageVO> costManageVOS = service.queryDesign(projectId,monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            map.put(costManageVO.getContractId(),costManageVO);
        }
        return CommonResponse.success("设计分包节点申请报量合价和金额成功",map);
    }
    /**
     * 根据合同id和月份查询计分包节点申请报量合价和金额
     * @param contractId
     * @param monthStr
     * @return
     */
    @GetMapping("queryDesignMonth")
    public CommonResponse<Map<String,CostManageVO>> queryDesignMonth(@RequestParam(value = "projectId")Long projectId,@RequestParam(value = "monthStr")String monthStr){
        Map<String,CostManageVO> map = new HashMap<>();
        List<CostManageVO> costManageVOS = service.queryDesignMonth(projectId,monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            map.put(costManageVO.getContractId(),costManageVO);
        }
        return CommonResponse.success("设计分包节点申请报量合价和金额成功",map);
    }
    /**
     * 根据合同id查询咨询类合价和金额
     * @param contractId
     * @return
     */
    @GetMapping("queryConsultother")
    public CommonResponse<Map<String,CostManageVO>> queryConsultother(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "monthStr")String monthStr){
        Map<String,CostManageVO> map = new HashMap<>();
        List<CostManageVO> costManageVOS = consultotherService.queryConsultother(projectId,monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            map.put(costManageVO.getContractId(),costManageVO);
        }
        return CommonResponse.success("咨询类合价和金额成功",map);
    }
    /**
     * 根据合同id和月份查询咨询类合价和金额
     * @param contractId
     * @param monthStr
     * @return
     */
    @GetMapping("queryConsultotherMonth")
    public CommonResponse<Map<String,CostManageVO>> queryConsultotherMonth(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "monthStr") String monthStr){
        Map<String,CostManageVO> map = new HashMap<>();
        List<CostManageVO> costManageVOS = consultotherService.queryConsultotherMonth(projectId,monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            map.put("1",costManageVO);
        }
        return CommonResponse.success("咨询类合价和金额成功",map);
    }


}
