package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodedetailService;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import com.ejianc.foundation.middlemeasurement.vo.DesignSettlementDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.DesignsubcontractnodeMapper;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodeService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设计分包节点报量申请
 *
 * @author generator
 *
 */
@Service("designsubcontractnodeService")
public class DesignsubcontractnodeServiceImpl extends BaseServiceImpl<DesignsubcontractnodeMapper, DesignsubcontractnodeEntity> implements IDesignsubcontractnodeService{
    @Autowired
    private DesignsubcontractnodeMapper mapper;
    @Autowired
    private IDesignsubcontractnodeService service;
    @Autowired
    private IDesignsubcontractnodedetailService designsubcontractnodedetailService;

    @Override
    public List<CostManageVO> queryDesign(Long projectId,String monthStr) {
        return mapper.queryDesign(projectId,monthStr);
    }

    @Override
    public List<CostManageVO> queryDesignMonth(Long projectId, String monthStr) {
        return mapper.queryDesignMonth(projectId,monthStr);
    }

    @Override
    public List<DesignSettlementDetailVO> queryDesignDetailCumPast(Long contractId, String date) {
        return mapper.queryDesignDetailCumPast(contractId,date);
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<DesignsubcontractnodeEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( settlement_date, '%Y-%m' )",monthStr);
        List<DesignsubcontractnodeEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (DesignsubcontractnodeEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<DesignsubcontractnodeEntity> query = new LambdaQueryWrapper<DesignsubcontractnodeEntity>()
                .eq(DesignsubcontractnodeEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(settlement_date, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(DesignsubcontractnodeEntity::getIsSettlement)
                        .or().eq(DesignsubcontractnodeEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("设计分包中间计量有未归集的数据");
        LambdaQueryWrapper<DesignsubcontractnodeEntity> query1 = new LambdaQueryWrapper<DesignsubcontractnodeEntity>()
                .eq(DesignsubcontractnodeEntity::getProjectId, projectId)
                .ne(DesignsubcontractnodeEntity::getBillState, 3)
                .ne(DesignsubcontractnodeEntity::getBillState, 1)
                .apply("DATE_FORMAT(settlement_date, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("设计分包中间计量有本期审批未通过的数据");
        return true;
    }

    @Override
    public List<DesignsubcontractnodedetailVO> queryDesignsubcontractnodedetail(String contract, String monthStr, String projectName) {
        Map<String,String> map = new HashMap<>();
        map.put("contractId",contract);
        map.put("settlementDate",monthStr);
        map.put("projectName",projectName);
//        map.put("exTaxUnitThisDeclare",exTaxUnitThisDeclare);
//        map.put("inTaxUnitThisDeclare",inTaxUnitThisDeclare);
        return mapper.queryDesignsubcontractnodedetail(map);
    }

    @Override
    public DesignsubcontractnodedetailVO queryDetailHistory(Long contract, String projectName, BigDecimal exTaxUnitLastAudit, BigDecimal inTaxUnitLastAudit) {
        return mapper.queryDetailHistory(contract,projectName,exTaxUnitLastAudit,inTaxUnitLastAudit);
    }

    @Override
    public List<DesignsubcontractnodedetailVO> getPastDetailData(Long contractId) {
        //创建条件构造器
        QueryWrapper<DesignsubcontractnodeEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract", contractId);
        queryWrapperTotal.eq("dr", 0);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.orderByDesc("create_time");
        queryWrapperTotal.last("limit 1");

        List<DesignsubcontractnodeEntity> proTotal = service.list(queryWrapperTotal);
        List<DesignsubcontractnodedetailVO> subcontractingvolumedetailVOS = new ArrayList<>();
        PurchasesettlementVO vo = new PurchasesettlementVO();
        if(proTotal != null && proTotal.size() > 0){
            DesignsubcontractnodeEntity pastEntity = proTotal.get(0);
            vo = BeanMapper.map(pastEntity, PurchasesettlementVO.class);
            //查询子表-月度（中间）计量计价明细表数据
            LambdaQueryWrapper<DesignsubcontractnodedetailEntity> lambdaCostPeople = Wrappers.<DesignsubcontractnodedetailEntity>lambdaQuery();
            lambdaCostPeople.eq(DesignsubcontractnodedetailEntity::getMid, pastEntity.getId());
            List<DesignsubcontractnodedetailEntity> subcontractingvolumedetailEntities = designsubcontractnodedetailService.list(lambdaCostPeople);
            subcontractingvolumedetailVOS = BeanMapper.mapList(subcontractingvolumedetailEntities, DesignsubcontractnodedetailVO.class);

            for(DesignsubcontractnodedetailVO subcontractingvolumedetailVO : subcontractingvolumedetailVOS){
                subcontractingvolumedetailVO.setCompleteThisAudit(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setExTaxTotalThisAudit(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setInTaxTotalThisAudit(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setCompleteLastAudit(subcontractingvolumedetailVO.getCompleteCumulativeAudit());
                subcontractingvolumedetailVO.setExTaxTotalLastAudit(subcontractingvolumedetailVO.getExTaxTotalCumulativeAudit());
                subcontractingvolumedetailVO.setInTaxTotalLastAudit(subcontractingvolumedetailVO.getInTaxTotalCumulativeAudit());
//                subcontractingvolumedetailVO.setCompleteCumulativeAudit(BigDecimal.ZERO);
//                subcontractingvolumedetailVO.setExTaxTotalCumulativeAudit(BigDecimal.ZERO);
//                subcontractingvolumedetailVO.setInTaxTotalCumulativeAudit(BigDecimal.ZERO);
                subcontractingvolumedetailVO.setId(IdWorker.getId());
                subcontractingvolumedetailVO.setOldFlag(OldFlagEnum.上期数据.getCode());
                subcontractingvolumedetailVO.setMid(null);
            }
        }

        return subcontractingvolumedetailVOS;
    }


}
