package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.mapper.RevolvingleasedetailMapper;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.RevolvingleasedetaildataVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.RevolvingleaseMapper;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 月度周转工具租赁费结算单
 *
 * @author generator
 *
 */
@Service("revolvingleaseService")
public class RevolvingleaseServiceImpl extends BaseServiceImpl<RevolvingleaseMapper, RevolvingleaseEntity> implements IRevolvingleaseService{

    @Autowired
    private IRevolvingleaseService service;

    @Autowired
    private RevolvingleasedetailMapper revolvingleasedetailMapper;
    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<RevolvingleaseEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( settle_time, '%Y-%m' )",monthStr);
        List<RevolvingleaseEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (RevolvingleaseEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<RevolvingleaseEntity> query = new LambdaQueryWrapper<RevolvingleaseEntity>()
                .eq(RevolvingleaseEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(settle_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(RevolvingleaseEntity::getIsSettlement)
                        .or().eq(RevolvingleaseEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("周转租赁中间计量有往期未归集的数据");
        LambdaQueryWrapper<RevolvingleaseEntity> query1 = new LambdaQueryWrapper<RevolvingleaseEntity>()
                .eq(RevolvingleaseEntity::getProjectId, projectId)
                .ne(RevolvingleaseEntity::getBillState, 3)
                .ne(RevolvingleaseEntity::getBillState, 1)
                .apply("DATE_FORMAT(settle_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("周转租赁中间计量有本期审批未通过的数据");
        return true;
    }

    @Override
    public List<RevolvingleasedetailVO> querySumById(List<RevolvingleasedetailVO> list) {
        if (CollectionUtils.isNotEmpty(list)){
            for (RevolvingleasedetailVO revolvingleasedetailVO : list){


            }

        }
        return null;
    }

    @Override
    public RevolvingleasedetailVO queryCumulative(Long projectId, Long contractId, String materialCode, String encode, String section, BigDecimal lesseeUnitprice, BigDecimal taxLesseeUnitprice) {
        RevolvingleasedetailVO vo = baseMapper.queryCumulative(projectId,contractId,materialCode,encode,section,lesseeUnitprice,taxLesseeUnitprice);
        return vo;
    }

    @Override
    public RevolvingleasedetailVO queryDetailList(Long contractId, String encode, String materialCode) {
        return revolvingleasedetailMapper.queryDetailList(contractId,encode,materialCode);
    }

    @Override
    public List<RevolvingleasedetailVO> getPastDetailData(Long contractId) {

        //创建条件构造器
        QueryWrapper<RevolvingleaseEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("dr", 0);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.orderByDesc("create_time");
        queryWrapperTotal.last("limit 1");

        List<RevolvingleaseEntity> proTotal = service.list(queryWrapperTotal);
        List<RevolvingleasedetailVO> subcontractingvolumedetailVOS = new ArrayList<>();
        RevolvingleaseVO vo = new RevolvingleaseVO();
        if(proTotal != null && proTotal.size() > 0){
            RevolvingleaseEntity pastEntity = proTotal.get(0);
            vo = BeanMapper.map(pastEntity, RevolvingleaseVO.class);
            //查询子表-月度（中间）计量计价明细表数据
            LambdaQueryWrapper<RevolvingleasedetailEntity> lambdaCostPeople = Wrappers.<RevolvingleasedetailEntity>lambdaQuery();
            lambdaCostPeople.eq(RevolvingleasedetailEntity::getMid, pastEntity.getId());
            List<RevolvingleasedetailEntity> subcontractingvolumedetailEntities = revolvingleasedetailService.list(lambdaCostPeople);
            subcontractingvolumedetailVOS = BeanMapper.mapList(subcontractingvolumedetailEntities, RevolvingleasedetailVO.class);
            List<RevolvingleasedetailVO> collect = subcontractingvolumedetailVOS.stream().filter(s -> s.getLesseeQuantity () != null).collect(Collectors.toList());

            for(RevolvingleasedetailVO subcontractingvolumedetailEntity : collect){
                subcontractingvolumedetailEntity.setLesseeQuantity(0);
                subcontractingvolumedetailEntity.setLesseeTotalprice(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxLesseeTotalprice(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setLossDamage(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setCompensateAccount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxCompensateAccount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setOtherExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxOtherExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setMonthlyExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxMonthlyExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setId(IdWorker.getId());
                subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.上期数据.getCode());
                subcontractingvolumedetailEntity.setMid(null);
            }
        }

        return subcontractingvolumedetailVOS;
    }
}
