package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 月度物资采购结算单
 *
 * @author generator
 */
@Controller
@RequestMapping("purchasesettlement")
public class PurchasesettlementController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    private static final String BILL_CODE = "middlemeasurement-purchasesettlement";//此处需要根据实际修改

    @Autowired
    private IPurchasesettlementService service;
    @Autowired
    private IPurchasesettlementdetailService detailService;
    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> saveOrUpdate(@RequestBody PurchasesettlementVO saveorUpdateVO) {
        //补全二级组织信息
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(saveorUpdateVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
        if (orgVo.isSuccess() && null != orgVo.getData()) {
            String innerCode = orgVo.getData().getInnerCode();
            String[] strs = innerCode.split("\\|");
            CommonResponse<OrgVO> orgVos = iOrgApi.detailById(Long.parseLong(strs[1]));
            if (orgVos.isSuccess() && null != orgVos.getData()) {
                //二级组织信息
                saveorUpdateVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
            }
        }

//获取项目创建时间
        CommonResponse<ProjectVO> projectVOCommonResponse = zjkjProjectApi.queryDetailById(saveorUpdateVO.getProjectId());
        if(!projectVOCommonResponse.isSuccess()){
            throw new BusinessException("获取项目信息失败");
        }
        ProjectVO projectVO = projectVOCommonResponse.getData();
        saveorUpdateVO.setProjectCreateTime(projectVO.getCreateTime());

        PurchasesettlementEntity entity = BeanMapper.map(saveorUpdateVO, PurchasesettlementEntity.class);
        entity.setSaveTime(new Date());
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            //创建条件构造器
            QueryWrapper<PurchasesettlementEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id", entity.getContractId());
            queryWrapper.in("bill_state", 0, 2, 4, 5);//
            List<PurchasesettlementEntity> pro = service.list(queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("同一合同只能存在一份自由态、审批中、审批驳回的\"月度物资采购结算单\"!");
            }
            //创建条件构造器(校验同一份合同的发生日期)
            QueryWrapper<PurchasesettlementEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper.eq("contract_id", entity.getContractId());
            queryWrapper.eq("occurrence_time", entity.getOccurrenceTime());//发生日期
            List<PurchasesettlementEntity> list = service.list(queryWrapper);
            if (pro != null && list.size() > 0) {
                throw new BusinessException("相同合同的发生日期不允许重复!");
            }
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }


        //3.累计（包含本期）
        Date currentDate = new Date(System.currentTimeMillis());
        if(saveorUpdateVO.getCreateTime() != null){
            currentDate = saveorUpdateVO.getCreateTime();
        }
        //获取往期
//        PurchasesettlementVO pastVo = getPastTotal(saveorUpdateVO.getContractId(), currentDate, true);
//        //本期 + 往期（主表）
//        BigDecimal occurrenceTotal = new BigDecimal(0);
//        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
//        if(saveorUpdateVO.getMonthlyTotal()!=null){
//            occurrenceTotal  = saveorUpdateVO.getMonthlyTotal().add(pastVo.getOccurrenceTotal());
//            entity.setOccurrenceTotal(occurrenceTotal);
//        }
//        if(saveorUpdateVO.getTaxMonthlyTotal()!=null){
//            taxOccurrenceTotal   = saveorUpdateVO.getTaxMonthlyTotal().add(pastVo.getTaxOccurrenceTotal());
//            entity.setTaxOccurrenceTotal(taxOccurrenceTotal);
//        }


        //本期 + 往期（子表）
//        List<PurchasesettlementdetailVO> purchasesettlementdetailEntities = saveorUpdateVO.getPurchasesettlementdetailEntities();
//        List<PurchasesettlementdetailVO> purchasesettlementdetailVOS =  pastVo.getPurchasesettlementdetailEntities();
//        if(purchasesettlementdetailEntities != null && purchasesettlementdetailVOS != null){
//            //本期
//            for (int i = 0; i < purchasesettlementdetailEntities.size(); i++) {
//                PurchasesettlementdetailVO purchasesettlementdetailVO = purchasesettlementdetailEntities.get(i);
//                //物料编码
//                String saveMaterialCode = purchasesettlementdetailVO.getBillCode();
//                //月度结算费用((除税)(元)
//                BigDecimal saveMonthlyExpenses = purchasesettlementdetailVO.getSettlementAmount();
//                //月度结算费用（含税）（元）
//                BigDecimal saveTaxMonthlyExpenses = purchasesettlementdetailVO.getTaxSettlementAmount();
//                //月度结算量 本期
//                BigDecimal supplyQuantitySum = purchasesettlementdetailVO.getSupplyQuantity();
//
//                //往期
//                for (int j = 0; j < purchasesettlementdetailVOS.size(); j++) {
//                    PurchasesettlementdetailVO purchasesettlementdetailVO1 = purchasesettlementdetailVOS.get(j);
//                    String materialCode = purchasesettlementdetailVO1.getBillCode();
//                    if(materialCode.equals(saveMaterialCode)){
//                        //月度结算费用((除税)(元)
//                        BigDecimal monthlyExpenses = purchasesettlementdetailVO1.getSettlementAmount();
//                        saveMonthlyExpenses = saveMonthlyExpenses.add(monthlyExpenses);
//
//                        //月度结算费用(含税)(元)
//                        BigDecimal taxMonthlyExpenses = purchasesettlementdetailVO1.getTaxSettlementAmount();
//                        saveTaxMonthlyExpenses = saveTaxMonthlyExpenses.add(taxMonthlyExpenses);
//
//                        //月度结算费用(含税)(元)
//                        BigDecimal supplyQuantityTotal = purchasesettlementdetailVO1.getSupplyQuantity();
//                        supplyQuantitySum = supplyQuantitySum.add(supplyQuantityTotal);
//                    }
//                }
//
//                purchasesettlementdetailVO.setSettlementTotal(saveMonthlyExpenses);
//                purchasesettlementdetailVO.setTaxSettlementTotal(saveTaxMonthlyExpenses);
//                purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantitySum);
//            }
//
//            entity.setPurchasesettlementdetailEntities(BeanMapper.mapList(purchasesettlementdetailEntities, PurchasesettlementdetailEntity.class));
//        }
        entity.setSaveTime(currentDate);
        entity.setIsReference(0);
        service.saveOrUpdate(entity, false);
        PurchasesettlementVO vo = BeanMapper.map(entity, PurchasesettlementVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> queryDetail(Long id) {
        PurchasesettlementEntity entity = service.selectById(id);
        PurchasesettlementVO vo = BeanMapper.map(entity, PurchasesettlementVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }
    /**
     * @param id
     * @Description queryDetail 根据合同id查询累计值
     */
    @RequestMapping(value = "/getSumByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> getSumByContractId(Long contractId) {
        PurchasesettlementVO vo = service.getSumByContractId(contractId);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 页面新增清单编号后重新构建树
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/getInfoById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasesettlementdetailVO> getInfoById(PurchasesettlementdetailVO subcontractingvolumedetailVO) {
        //根据区段,清单编码,单价合同主键获取累计值
        //查询该清单编码往期累计
        //创建条件构造器
        QueryWrapper<PurchasesettlementdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", subcontractingvolumedetailVO.getContractId());
        queryWrapper.eq("bill_code", subcontractingvolumedetailVO.getBillCode());
        queryWrapper.eq("settlement_price", subcontractingvolumedetailVO.getSettlementPrice());
        queryWrapper.eq("tax_settlement_price", subcontractingvolumedetailVO.getTaxSettlementPrice());
        queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapper.eq("dr", "0");
//        queryWrapper.notIn(subcontractingvolumedetailVO.getIds()!=null,"id", subcontractingvolumedetailVO.getIds());
        List<PurchasesettlementdetailEntity> pastDetails = detailService.list(queryWrapper);
        //计算含税无税金额
        BigDecimal examineQuantity =subcontractingvolumedetailVO.getSupplyQuantity() == null ? BigDecimal.ZERO : subcontractingvolumedetailVO.getSupplyQuantity();
        BigDecimal examineUnitprice =subcontractingvolumedetailVO.getSettlementPrice() == null ? BigDecimal.ZERO : subcontractingvolumedetailVO.getSettlementPrice();
        BigDecimal examineTaxUnitprice =subcontractingvolumedetailVO.getTaxSettlementPrice() == null ? BigDecimal.ZERO : subcontractingvolumedetailVO.getTaxSettlementPrice();
        BigDecimal money = examineQuantity.multiply(examineUnitprice);
        BigDecimal moneyTax = examineQuantity.multiply(examineTaxUnitprice);
        subcontractingvolumedetailVO.setSettlementAmount(money);
        subcontractingvolumedetailVO.setTaxSettlementAmount(moneyTax);
        if(pastDetails != null && pastDetails.size() > 0){
            BigDecimal examineQuantitySum = pastDetails.stream().map(PurchasesettlementdetailEntity::getSupplyQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineAmounts = pastDetails.stream().map(PurchasesettlementdetailEntity::getSettlementPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineTaxAmounts = pastDetails.stream().map(PurchasesettlementdetailEntity::getTaxSettlementPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            subcontractingvolumedetailVO.setSupplyQuantityTotal(examineQuantitySum);
            subcontractingvolumedetailVO.setSettlementTotal(examineAmounts.add(money));
            subcontractingvolumedetailVO.setTaxSettlementTotal(examineTaxAmounts.add(moneyTax));
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", subcontractingvolumedetailVO);
    }
    /**
     * @param id
     * @Description 获取上期数据明细
     */
    @RequestMapping(value = "/getPastDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PurchasesettlementdetailVO>> getPastDetailData(Long contractId) {
        List<PurchasesettlementdetailVO> list = service.getPastDetailData(contractId);
        return CommonResponse.success("查询详情数据成功！", list);
    }
    /**
     * @Description 查询明细的累计值返回
     */
    @RequestMapping(value = "/getPurchaseDataById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> getPurchaseDataById(@RequestBody PurchasesettlementVO purchasesettlementVO) {
        PurchasesettlementVO purchaseDataById = service.getPurchaseDataById(purchasesettlementVO);
        return CommonResponse.success("查询往期审批通过的累计数据成功！", purchaseDataById);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasesettlementVO> vos) {
        service.removeByIds(vos.stream().map(PurchasesettlementVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("settlementType");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
         UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            // 要求主表有orgId字段，保存单据所属组织
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            // 要求主表有projectDepartmentId字段，保存单据所属项目部
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getOrderMap().put("org_status_order", QueryParam.ASC);
        param.getOrderMap().put("project_create_time", QueryParam.ASC);
        IPage<PurchasesettlementEntity> page = service.queryPage(param, false);
        IPage<PurchasesettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasesettlementVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("settlementType");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getOrderMap().put("org_status_order", QueryParam.ASC);
        param.getOrderMap().put("project_create_time", QueryParam.ASC);
        List<PurchasesettlementEntity> list = service.queryList(param);
        int  count = 1;
        for (PurchasesettlementEntity entity : list) {
            entity.setSort(String.valueOf(count));
            if (entity.getAgentTime()!=null){
                entity.setAgentTimeShow(DateUtils.dateSimple2(entity.getAgentTime()));
            }
            if (entity.getSettlementStartTime()!=null){
                entity.setSettlementStartTimeShow(DateUtils.dateSimple2(entity.getSettlementStartTime()));
            }
            if (entity.getSettlementDeadline()!=null){
                entity.setSettlementDeadlineShow(DateUtils.dateSimple2(entity.getSettlementDeadline()));
            }
            if (entity.getDepartmentAgentDate()!=null){
                entity.setDepartmentAgentDateShow(DateUtils.dateSimple2(entity.getDepartmentAgentDate()));
            }

            String billStateStr = entity.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                entity.setBillStateStr(billStateStr);
                count++;
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Purchasesettlement-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchasesettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> refPurchasesettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        fuzzyFields.add("department_agent_name");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }

        //未被引用
        param.getParams().put("isReference", new Parameter(QueryParam.EQ, 0));

        //审批通过
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        IPage<PurchasesettlementEntity> page = service.queryPage(param,false);
        IPage<PurchasesettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<PurchasesettlementVO> purchasesettlementVOList = BeanMapper.mapList(page.getRecords(), PurchasesettlementVO.class);
        for (int i = 0; i < purchasesettlementVOList.size(); i++) {
            PurchasesettlementVO purchasesettlementVO = purchasesettlementVOList.get(i);
            purchasesettlementVO.setSort(String.valueOf(i + 1));

            QueryWrapper<PurchasesettlementdetailEntity> detailWrapper = new QueryWrapper<>();
            detailWrapper.eq("mid", purchasesettlementVO.getId());
            List<PurchasesettlementdetailEntity> entityList = detailService.list(detailWrapper);
            if (entityList != null && entityList.size() > 0) {

                List<PurchasesettlementdetailVO> detailList = BeanMapper.mapList(entityList, PurchasesettlementdetailVO.class);
                purchasesettlementVO.setPurchasesettlementdetailEntities(detailList);
            }
        }
        pageData.setRecords(purchasesettlementVOList);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param contractId
     * @Description 查询往期
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            PurchasesettlementEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId  合同id
     * @param currentDate 本期日期
     */
    private PurchasesettlementVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器
        QueryWrapper<PurchasesettlementEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.in("bill_state", 1,3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        queryWrapperTotal.eq("dr",0);
        List<PurchasesettlementEntity> proTotal = service.list(queryWrapperTotal);

        BigDecimal occurrenceTotal = new BigDecimal(0); //累计发生除税
        BigDecimal taxOccurrenceTotal = new BigDecimal(0); //累计发生含税
/*
        BigDecimal settlementTotal = new BigDecimal(0); //累计结算金额含税
        BigDecimal taxSettlementTotal = new BigDecimal(0); //累计结算金额含税*/
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); i++) {
                PurchasesettlementEntity purchasesettlementEntity = proTotal.get(i);
                occurrenceTotal = occurrenceTotal.add(purchasesettlementEntity.getMonthlyTotal());
                taxOccurrenceTotal = taxOccurrenceTotal.add(purchasesettlementEntity.getTaxMonthlyTotal());

            }
        }
     /*   List<PurchasesettlementdetailEntity> list = detailService.list(detailQueryWrapper);
        if (list != null&&list.size()>0) {
            for (int i = 0; i < list.size(); i++) {
                PurchasesettlementdetailEntity entity = list.get(i);
                settlementTotal=settlementTotal.add(entity.getSettlementAmount());
                taxSettlementTotal= taxSettlementTotal.add(entity.getTaxSettlementAmount());
            }
        }*/
        PurchasesettlementVO vo = new PurchasesettlementVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);
    /*    vo.setSettlementTotal(settlementTotal);
        vo.setTaxSettlementTotal(taxSettlementTotal);*/
        vo.setContractId(contractId);


        return vo;
    }

    /**
     * @param contractId
     * @Description 查询详情
     */
    @RequestMapping(value = "/queryAmount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> queryAmount(Long contractId , Long projectId) {
        BigDecimal exTaxSettlementMonth = new BigDecimal(0);
        BigDecimal inTaxSettlementMonth = new BigDecimal(0);
        BigDecimal exTaxCumulative = new BigDecimal(0);
        BigDecimal inTaxCumulative = new BigDecimal(0);
        //主表查询
        QueryWrapper<PurchasesettlementEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id",projectId);
        wrapper.eq("contract_id",contractId);
        wrapper.eq("dr",0);
        wrapper.in("bill_state",1,3);
        List<PurchasesettlementEntity> entityList = service.list(wrapper);
        for (PurchasesettlementEntity purchasesettlementEntity : entityList) {

            if(purchasesettlementEntity.getOccurrenceTotal()!=null){
                exTaxCumulative = exTaxCumulative.add(purchasesettlementEntity.getMonthlyTotal());
            }
            if(purchasesettlementEntity.getTaxOccurrenceTotal()!=null){
                inTaxCumulative = inTaxCumulative.add(purchasesettlementEntity.getTaxMonthlyTotal());
            }

            //子表属性合计
            QueryWrapper<PurchasesettlementdetailEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("mid",purchasesettlementEntity.getId());
            queryWrapper.eq("dr",0);
            List<PurchasesettlementdetailEntity> purchasesettlementdetailEntities = detailService.list(queryWrapper);
            for (PurchasesettlementdetailEntity purchasesettlementdetailEntity : purchasesettlementdetailEntities) {
                if(purchasesettlementdetailEntity.getSettlementAmount()!=null){
                    exTaxSettlementMonth = exTaxSettlementMonth.add(purchasesettlementdetailEntity.getSettlementAmount());
                }
                if(purchasesettlementdetailEntity.getTaxSettlementAmount()!=null){
                    inTaxSettlementMonth = inTaxSettlementMonth.add(purchasesettlementdetailEntity.getTaxSettlementAmount());
                }
            }
        }
        PurchasesettlementVO vo = new PurchasesettlementVO();
        vo.setMonthlyTotal(exTaxSettlementMonth);
        vo.setTaxMonthlyTotal(inTaxSettlementMonth);
        vo.setOccurrenceTotal(exTaxCumulative);
        vo.setTaxOccurrenceTotal(inTaxCumulative);
        return CommonResponse.success("查询往期审批通过的累计数据成功！",vo);
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId 合同id
     * @param currentDate 本期日期
     * @param isSave true保存 false查询
     * @return
     */
    private PurchasesettlementVO getPastTotal(Long contractId, Date currentDate, boolean isSave) {
        //创建条件构造器
        QueryWrapper<PurchasesettlementEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<PurchasesettlementEntity> proTotal = service.list(queryWrapperTotal);
        List<PurchasesettlementdetailEntity> purchasesettlementdetailEntities = new ArrayList<>();

        //累计发生(除税)
        BigDecimal occurrenceTotal = new BigDecimal(0);
        //累计发生(含税)
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);

        if(proTotal != null && proTotal.size() > 0){
            for (int i = 0; i < proTotal.size(); i++) {
                PurchasesettlementEntity purchasesettlementEntity = proTotal.get(i);
                occurrenceTotal = occurrenceTotal.add(purchasesettlementEntity.getMonthlyTotal());
                taxOccurrenceTotal = taxOccurrenceTotal.add(purchasesettlementEntity.getTaxMonthlyTotal());

                if(isSave){
                    QueryWrapper<PurchasesettlementdetailEntity> detailWrapper = new QueryWrapper<>();
                    detailWrapper.eq("mid", purchasesettlementEntity.getId());
                    List<PurchasesettlementdetailEntity> detailList = detailService.list(detailWrapper);
                    purchasesettlementdetailEntities.addAll(detailList);
                }
            }
        }

        PurchasesettlementVO vo = new PurchasesettlementVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);

        vo.setContractId(contractId);
        //往期所有子表 entity和vo转换
        vo.setPurchasesettlementdetailEntities(BeanMapper.mapList(purchasesettlementdetailEntities, PurchasesettlementdetailVO.class));

        return vo;
    }

}
