package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.*;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.service.IPurchasesummaryService;

/**
 * 月度物资采购结算汇总
 *
 * @author generator
 */
@Controller
@RequestMapping("purchasesummary")
public class PurchasesummaryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "middlemeasurement-purchasesummary";//此处需要根据实际修改

    @Autowired
    private IPurchasesummaryService service;

    @Autowired
    private IPurchasesettlementService purchasesettlementService;
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasesummaryVO> saveOrUpdate(@RequestBody PurchasesummaryVO saveorUpdateVO) {
        PurchasesummaryEntity entity = BeanMapper.map(saveorUpdateVO, PurchasesummaryEntity.class);

        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //1.校验（同一项目，如有未审批通过的单据，不允许新增）
        QueryWrapper<PurchasesummaryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.in("bill_state", 0, 2, 4, 5);
        if(entity.getId() != null && entity.getId() != 0){
            queryWrapper.ne("id", entity.getId());
        }
        List<PurchasesummaryEntity> pro = service.list(queryWrapper);
        if (pro != null && pro.size() > 0) {
            throw new BusinessException("同一项目只能存在一份自由态、审批中、审批驳回的\"月度采购结算汇总单\"!");
        }

        //2.校验统计时间，同一项目的统计时间不能存在
        Date statisticalTime = entity.getStatisticalTime();//统计时间
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String statisticalTimeStr = format.format(statisticalTime);
        QueryWrapper<PurchasesummaryEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("project_id", entity.getProjectId());
        queryWrapper1.eq("dr",0);
        queryWrapper1.eq("date_format(statistical_time,'%Y-%m')", statisticalTimeStr);
        if(entity.getId() != null && entity.getId() != 0){
            queryWrapper1.ne("id", entity.getId());
        }
        List<PurchasesummaryEntity> proDate = service.list(queryWrapper1);
        if (proDate != null && proDate.size() > 0) {
            throw new BusinessException(entity.getProjectName() + "项目该月份单据已存在，不能重复创建!");
        }

        //更新被引用的采购结算单状态
        if (entity.getId() != null) {
            List<String> referenceIdList = saveorUpdateVO.getReferenceIdList();
            if (referenceIdList != null && referenceIdList.size() > 0) {
                for (int i = 0; i < referenceIdList.size(); i++) {
                    QueryWrapper<PurchasesettlementEntity> referenceWrapper = new QueryWrapper<>();
                    PurchasesettlementEntity referenceEntities = purchasesettlementService.selectById(referenceIdList.get(i));
                    if (referenceEntities != null) {
                        referenceEntities.setIsReference(1);
                        purchasesettlementService.saveOrUpdate(referenceEntities);
                    }
                }
            }

        }

        //2.2更新被引用单据的引用状态
        List<String> referenceIdList = saveorUpdateVO.getReferenceIdList();
        if(referenceIdList != null && referenceIdList.size() > 0){
            //创建条件构造器
            QueryWrapper<PurchasesettlementEntity> queryWrapperByIdsNew = new QueryWrapper<>();
            queryWrapperByIdsNew.in("id", referenceIdList);
            queryWrapperByIdsNew.eq("dr",0);
            List<PurchasesettlementEntity> newList = purchasesettlementService.list(queryWrapperByIdsNew);
            if(newList != null && newList.size() > 0){
                for (PurchasesettlementEntity item : newList) {
                    item.setIsReference(1);
                    item.setReferenceCode(entity.getCode());
                }
                purchasesettlementService.saveOrUpdateBatch(newList);
            }
        }

        BigDecimal count = new BigDecimal(0);
        String type = "月度物资采购结算单";
        for (PurchasesummarydetatilEntity purchasesummarydetatil : entity.getPurchasesummarydetatilEntities()) {
            if(purchasesummarydetatil.getPaymentProportion()!=null){
                count = count.add(purchasesummarydetatil.getPaymentProportion());
            }
        }
        entity.setPaymentProportionCount(count);
        entity.setSettlementType(type);
        service.saveOrUpdate(entity, false);
        PurchasesummaryVO vo = BeanMapper.map(entity, PurchasesummaryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasesummaryVO> queryDetail(Long id) {
        PurchasesummaryEntity entity = service.selectById(id);
        PurchasesummaryVO vo = BeanMapper.map(entity, PurchasesummaryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasesummaryVO> vos) {
        List<Long> idList = vos.stream().map(PurchasesummaryVO::getId).collect(Collectors.toList());

        QueryWrapper<PurchasesummaryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr",0);
        queryWrapper.in("id",idList);
        List<PurchasesummaryEntity> purchasesummaryEntities = service.list(queryWrapper);

        List<String> codeList = new ArrayList<>();
        for (PurchasesummaryEntity entity : purchasesummaryEntities) {
            codeList.add(entity.getCode());
        }

        QueryWrapper<PurchasesettlementEntity> wrapper = new QueryWrapper<>();
        wrapper.in("reference_code",codeList);
        List<PurchasesettlementEntity> list = purchasesettlementService.list(wrapper);
        //删除时去掉结算单的引用状态
        if (!list.isEmpty()){
            for (PurchasesettlementEntity entity : list) {
                entity.setIsReference(0);
                entity.setReferenceCode(null);
            }
            //保存结算单
            purchasesettlementService.saveOrUpdateBatch(list);
        }
        service.removeByIds(idList, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchasesummaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PurchasesummaryEntity> page = service.queryPage(param, false);
        IPage<PurchasesummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasesummaryVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<PurchasesummaryEntity> list = service.queryList(param);
        List<PurchasesummaryVO> map = BeanMapper.mapList(list, PurchasesummaryVO.class);
        //todo:字段翻译等等
        int  count = 1;
        for (PurchasesummaryVO entity : map) {
            entity.setSort(String.valueOf(count));
            if (entity.getStatisticalTime()!=null){
                entity.setStatisticalTimeShow(DateUtils.dateSimple2(entity.getStatisticalTime()));
            }

            String billStateStr = entity.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                entity.setBillStateStr(billStateStr);
                count++;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", map);
        ExcelExport.getInstance().export("Purchasesummary-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchasesummaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchasesummaryVO>> refPurchasesummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchasesummaryEntity> page = service.queryPage(param, false);
        IPage<PurchasesummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasesummaryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 物资档案参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchasesettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> refPurchasesettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.get("projectId") != null) {
                //过滤项目
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
                //是否被引用
            }
        }
        param.getParams().put("isReference", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));


        IPage<PurchasesettlementEntity> page = purchasesettlementService.queryPage(param, false);
        IPage<PurchasesettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PurchasesettlementVO> voList = BeanMapper.mapList(page.getRecords(), PurchasesettlementVO.class);
        if (voList != null && voList.size() > 0) {
            for (int i = 0; i < voList.size(); i++) {
                PurchasesettlementVO vo = voList.get(i);
                vo.setSort(String.valueOf(i + 1));
                Long id = vo.getId();
                QueryWrapper<PurchasesettlementdetailEntity> detailWrapper = new QueryWrapper<>();
                detailWrapper.eq("mid", id);
                detailWrapper.eq("dr", 0);
                List<PurchasesettlementdetailEntity> entityList = purchasesettlementdetailService.list(detailWrapper);
                if (entityList != null && entityList.size() > 0) {

                    List<PurchasesettlementdetailVO> detailList = BeanMapper.mapList(entityList, PurchasesettlementdetailVO.class);
                    vo.setPurchasesettlementdetailEntities(detailList);
                }
            }

        }
        pageData.setRecords(voList);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param
     * @Description 查询往期累计数据
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasesummaryVO> pastData(Long id, Long projectId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            PurchasesummaryEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();

        }
        QueryWrapper<PurchasesummaryEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", projectId);
        wrapper.lt("create_time", currentDate);
        wrapper.in("bill_state", 1, 3);
        List<PurchasesummaryEntity> list = service.list(wrapper);
        //累计结算金额(除税)
        BigDecimal settlementTotal = new BigDecimal(0);
        //累计结算(含税)
        BigDecimal taxSettlementTotal = new BigDecimal(0);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                PurchasesummaryEntity purchasesummaryEntity = list.get(i);
                settlementTotal = settlementTotal.add(purchasesummaryEntity.getSettlementAmount());//
                taxSettlementTotal = settlementTotal.add(purchasesummaryEntity.getTaxSettlementAmount());
            }
        }
        PurchasesummaryVO vo = new PurchasesummaryVO();
        vo.setSettlementTotal(settlementTotal);
        vo.setTaxSettlementTotal(taxSettlementTotal);

        return CommonResponse.success("查询往期审批通过的累计数据成功！", vo);
    }

    /**
     * 查询被引用的结算单
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/getSelectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>> getSelectId(Long id) {
        PurchasesummaryEntity purchasesummaryEntity = service.selectById(id);
        String billCode = purchasesummaryEntity.getCode();
        QueryWrapper<PurchasesettlementEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr",0);
        wrapper.eq("reference_code",billCode);
        List<PurchasesettlementEntity> list = purchasesettlementService.list(wrapper);
        List<Long> idList = new ArrayList<>();
        for (PurchasesettlementEntity entity : list) {
            idList.add(entity.getId());
        }

        return CommonResponse.success("查询成功！", idList);
    }
}
