package com.ejianc.business.middlemeasurement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/purchasesettlement")
public class PurchasesettlementApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPurchasesettlementService service;

    /**
     * @Return void
     */
    @RequestMapping(value = "/queryListByCont", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PurchasesettlementVO>> queryListByCont(@RequestParam(value = "contractId") Long contractId) {
        LambdaQueryWrapper<PurchasesettlementEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PurchasesettlementEntity::getContractId, contractId);
        List<PurchasesettlementEntity> list = service.list(queryWrapper);
        List<PurchasesettlementVO> resp = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (PurchasesettlementEntity entity : list) {
                resp.add(BeanMapper.map(service.selectById(entity.getId()), PurchasesettlementVO.class));
            }
        }
        return CommonResponse.success("查询数据成功！", resp);
    }
}
