package com.ejianc.business.middlemeasurement.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 变更状态
 */
public enum OldFlagEnum {

    /**
     */
    上期数据(1, "上期数据"),

    /**
     */
    非上期数据(2, "非上期数据");



    private Integer code;
    private String description;
    private static Map<Integer, OldFlagEnum> enumMap = new HashMap<>();

    OldFlagEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(OldFlagEnum.class).stream().collect(Collectors.toMap(OldFlagEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static OldFlagEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
