package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetotalEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.RevolvingleasesummaryMapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasesummaryEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasesummaryService;

import java.util.List;

/**
 * 月度周转工具租赁费结算汇总
 * 
 * @author generator
 * 
 */
@Service("revolvingleasesummaryService")
public class RevolvingleasesummaryServiceImpl extends BaseServiceImpl<RevolvingleasesummaryMapper, RevolvingleasesummaryEntity> implements IRevolvingleasesummaryService{
    @Autowired
    private  IRevolvingleasesummaryService service;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<RevolvingleasesummaryEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( statistical_time, '%Y-%m' )",monthStr);
        List<RevolvingleasesummaryEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (RevolvingleasesummaryEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<RevolvingleasesummaryEntity> query = new LambdaQueryWrapper<RevolvingleasesummaryEntity>()
                .eq(RevolvingleasesummaryEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(statistical_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(RevolvingleasesummaryEntity::getIsSettlement)
                        .or().eq(RevolvingleasesummaryEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("月度周转工具租赁费结算汇总有往期未归集的数据");
        LambdaQueryWrapper<RevolvingleasesummaryEntity> query1 = new LambdaQueryWrapper<RevolvingleasesummaryEntity>()
                .eq(RevolvingleasesummaryEntity::getProjectId, projectId)
                .ne(RevolvingleasesummaryEntity::getBillState, 3)
                .ne(RevolvingleasesummaryEntity::getBillState, 1)
                .apply("DATE_FORMAT(statistical_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("月度周转工具租赁费结算汇总有本期审批未通过的数据");
        return true;
    }
}
