/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementPayeeDetailEntity;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementPayeeDetailService;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;
import com.ejianc.business.middlemeasurement.utils.BigDecimalUtils;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementPayeeDetailVO;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"engineermeasurement"})
public class EngineermeasurementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "middlemeasurement-engineermeasurement";
    @Autowired
    private IEngineermeasurementService service;
    @Autowired
    private IEngineermeasurementPayeeDetailService payeeDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> saveOrUpdate(@RequestBody EngineermeasurementVO saveorUpdateVO) {
        CommonResponse projectVOCommonResponse;
        String innerCode;
        String[] strs;
        CommonResponse orgVos;
        QueryWrapper queryLastWrapper = new QueryWrapper();
        queryLastWrapper.eq((Object)"contract_id", (Object)saveorUpdateVO.getContractId());
        queryLastWrapper.in((Object)"bill_state", new Object[]{1, 3});
        List lastList = this.service.list((Wrapper)queryLastWrapper);
        BigDecimal lastActualMny = BigDecimal.ZERO;
        BigDecimal lastBatchMny = BigDecimal.ZERO;
        BigDecimal lastCollectionMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)lastList)) {
            lastActualMny = lastList.stream().filter(s -> s.getActualCompletedThisPeriod() != null).map(EngineermeasurementEntity::getActualCompletedThisPeriod).reduce(BigDecimal.ZERO, BigDecimal::add);
            lastBatchMny = lastList.stream().filter(s -> s.getCurrentBatch() != null).map(EngineermeasurementEntity::getCurrentBatch).reduce(BigDecimal.ZERO, BigDecimal::add);
            lastCollectionMny = lastList.stream().filter(s -> s.getCurrentCollection() != null).map(EngineermeasurementEntity::getCurrentCollection).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal actualMny = lastActualMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getActualCompletedThisPeriod()));
        BigDecimal batchMny = lastBatchMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getCurrentBatch()));
        BigDecimal collectionMny = lastCollectionMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getCurrentCollection()));
        if (actualMny.compareTo(BigDecimalUtils.ofNullable(saveorUpdateVO.getCumulativeCompleted())) != 0) {
            throw new BusinessException("\u7d2f\u8ba1\u5b9e\u9645\u5b8c\u6210\u91cf\u8ba1\u7b97\u6709\u8bef, \u65e0\u6cd5\u4fdd\u5b58!");
        }
        if (batchMny.compareTo(BigDecimalUtils.ofNullable(saveorUpdateVO.getCumulativeBatch())) != 0) {
            throw new BusinessException("\u7d2f\u8ba1\u6279\u91cf\u8ba1\u7b97\u6709\u8bef, \u65e0\u6cd5\u4fdd\u5b58!");
        }
        if (collectionMny.compareTo(BigDecimalUtils.ofNullable(saveorUpdateVO.getCumulativeCollection())) != 0) {
            throw new BusinessException("\u7d2f\u8ba1\u6536\u6b3e\u91d1\u989d\u8ba1\u7b97\u6709\u8bef, \u65e0\u6cd5\u4fdd\u5b58!");
        }
        CommonResponse orgVo = this.iOrgApi.detailById(saveorUpdateVO.getProjectDepartmentId());
        if (orgVo.isSuccess() && null != orgVo.getData() && (orgVos = this.iOrgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
            saveorUpdateVO.setOrgStatusOrder(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence());
        }
        if (!(projectVOCommonResponse = this.zjkjProjectApi.queryDetailById(saveorUpdateVO.getProjectId())).isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25");
        }
        ProjectVO projectVO = (ProjectVO)projectVOCommonResponse.getData();
        saveorUpdateVO.setProjectCreateTime(projectVO.getCreateTime());
        EngineermeasurementEntity entity = (EngineermeasurementEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), EngineermeasurementEntity.class));
        this.checkBillStateUniq(entity.getId(), entity.getContractId());
        entity = this.checkBillCodeUniq(entity);
        this.service.saveOrUpdate((Object)entity, false);
        EngineermeasurementVO vo = (EngineermeasurementVO)((Object)BeanMapper.map((Object)((Object)entity), EngineermeasurementVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/savePayeeDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EngineermeasurementPayeeDetailVO> savePayeeDetail(@RequestBody EngineermeasurementPayeeDetailVO saveOrUpdateVO) {
        EngineermeasurementPayeeDetailEntity detailEntity = new EngineermeasurementPayeeDetailEntity();
        detailEntity.setNowPaymentMny(saveOrUpdateVO.getNowPaymentMny());
        detailEntity.setPaymentTime(saveOrUpdateVO.getPaymentTime());
        detailEntity.setPid(saveOrUpdateVO.getId());
        detailEntity.setAdvancePaymentMoney(saveOrUpdateVO.getAdvancePaymentMoney());
        this.payeeDetailService.saveOrUpdate((Object)detailEntity);
        EngineermeasurementEntity entity = (EngineermeasurementEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        entity.setCumulativeCollection(ComputeUtil.safeAdd((BigDecimal)entity.getCumulativeCollection(), (BigDecimal)saveOrUpdateVO.getNowPaymentMny()));
        entity.setCurrentCollection(ComputeUtil.safeAdd((BigDecimal)entity.getCurrentCollection(), (BigDecimal)saveOrUpdateVO.getNowPaymentMny()));
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    private EngineermeasurementEntity handleCumulative(EngineermeasurementEntity entity) {
        BigDecimal cumulativeBatch;
        EngineermeasurementVO pastVo;
        BigDecimal cumulativeCompleted;
        Date currentDate = new Date(System.currentTimeMillis());
        if (entity.getCreateTime() != null) {
            currentDate = entity.getCreateTime();
        }
        if ((cumulativeCompleted = (pastVo = this.getPastTotalData(entity.getContractId(), currentDate)).getCumulativeCompleted()) != null && entity.getActualCompletedThisPeriod() != null) {
            cumulativeCompleted = entity.getActualCompletedThisPeriod().add(cumulativeCompleted);
        }
        if ((cumulativeBatch = pastVo.getCumulativeBatch()) != null && entity.getCurrentBatch() != null) {
            cumulativeBatch = entity.getCurrentBatch().add(pastVo.getCumulativeBatch());
        }
        BigDecimal sumAmountAgreedReceivables = BigDecimal.ZERO;
        BigDecimal sumAmountCollected = BigDecimal.ZERO;
        List<EngineermeasurementdetailEntity> list = entity.getEngineermeasurementdetailEntities();
        if (!list.isEmpty()) {
            for (EngineermeasurementdetailEntity engineermeasurementdetailEntity : list) {
                sumAmountAgreedReceivables = sumAmountAgreedReceivables.add(engineermeasurementdetailEntity.getAmountAgreedReceivables());
                sumAmountCollected = sumAmountCollected.add(engineermeasurementdetailEntity.getAmountCollected());
            }
        }
        entity.setCurrentReceivables(sumAmountAgreedReceivables);
        entity.setCurrentCollection(sumAmountCollected);
        entity.setAccumulatedContractualReceivables(entity.getCurrentReceivables().add(pastVo.getAccumulatedContractualReceivables()));
        entity.setCumulativeCollection(entity.getCurrentCollection().add(pastVo.getCumulativeCollection()));
        entity.setCumulativeCompleted(cumulativeCompleted);
        entity.setCumulativeBatch(cumulativeBatch);
        BigDecimal contractAmount = entity.getContractAmount();
        if (cumulativeCompleted != null && contractAmount != null && contractAmount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal cumulativeCompletedProportion = cumulativeCompleted.divide(contractAmount, 8, 4);
            cumulativeCompletedProportion = cumulativeCompletedProportion.multiply(new BigDecimal(100));
            entity.setCumulativeCompletedProportion(cumulativeCompletedProportion);
        }
        return entity;
    }

    private void checkBillStateUniq(Long id, Long contractId) {
        List pro;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (id != null) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)) != null && pro.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\"\u5de5\u7a0b\u8ba1\u91cf\u53f0\u8d26\u5355\u636e\"!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EngineermeasurementEntity checkBillCodeUniq(EngineermeasurementEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne((Object)"id", (Object)id);
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)) == null || proBillCode.size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> queryDetail(Long id) {
        EngineermeasurementEntity entity = (EngineermeasurementEntity)((Object)this.service.selectById(id));
        EngineermeasurementVO vo = (EngineermeasurementVO)((Object)BeanMapper.map((Object)((Object)entity), EngineermeasurementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EngineermeasurementVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EngineermeasurementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getOrderMap().put("org_status_order", "asc");
        param.getOrderMap().put("project_create_time", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EngineermeasurementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getOrderMap().put("org_status_order", "asc");
        param.getOrderMap().put("project_create_time", "asc");
        List list = this.service.queryList(param);
        List engineermeasurementVOList = BeanMapper.mapList((Iterable)list, EngineermeasurementVO.class);
        for (int i = 0; i < engineermeasurementVOList.size(); ++i) {
            String billStateStr;
            EngineermeasurementVO engineermeasurementVO = (EngineermeasurementVO)((Object)engineermeasurementVOList.get(i));
            engineermeasurementVO.setSort(String.valueOf(i + 1));
            if (engineermeasurementVO.getReportingTime() != null) {
                engineermeasurementVO.setReportingTimeShow(DateUtils.dateSimple2(engineermeasurementVO.getReportingTime()));
            }
            if ((billStateStr = engineermeasurementVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            engineermeasurementVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", engineermeasurementVOList);
        ExcelExport.getInstance().export("EngineermeasurementMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refEngineermeasurementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EngineermeasurementVO>> refEngineermeasurementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EngineermeasurementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/lastTotalMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngineermeasurementEntity> lastTotalMny(Long projectId, Long contractId) {
        List entityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).eq((Object)"contract_id", (Object)contractId)).in((Object)"bill_state", new Object[]{1, 3})).orderByDesc((Object)"create_time")).last("limit 1"));
        EngineermeasurementEntity entity = new EngineermeasurementEntity();
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            Iterator iterator = entityList.iterator();
            while (iterator.hasNext()) {
                EngineermeasurementEntity engineermeasurementEntity;
                entity = engineermeasurementEntity = (EngineermeasurementEntity)((Object)iterator.next());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u4e0a\u671f\u5355\u636e\u6570\u636e\u6210\u529f\uff01", (Object)((Object)entity));
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> pastData(Long id, Long contractId) {
        this.checkBillStateUniq(id, contractId);
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            EngineermeasurementEntity entity = (EngineermeasurementEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate)));
    }

    private EngineermeasurementVO getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        BigDecimal sumCurrentReceivables = BigDecimal.ZERO;
        BigDecimal cumulativeCompleted = new BigDecimal(0);
        BigDecimal cumulativeBatch = new BigDecimal(0);
        BigDecimal cumulativeCollection = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); ++i) {
                EngineermeasurementEntity engineermeasurementEntity = (EngineermeasurementEntity)((Object)proTotal.get(i));
                cumulativeCompleted = cumulativeCompleted.add(engineermeasurementEntity.getActualCompletedThisPeriod());
                cumulativeBatch = cumulativeBatch.add(engineermeasurementEntity.getCurrentBatch());
                cumulativeCollection = cumulativeCollection.add(engineermeasurementEntity.getCurrentCollection());
                sumCurrentReceivables = sumCurrentReceivables.add(engineermeasurementEntity.getCurrentReceivables());
            }
        }
        EngineermeasurementVO vo = new EngineermeasurementVO();
        vo.setCumulativeCompleted(cumulativeCompleted);
        vo.setCumulativeBatch(cumulativeBatch);
        vo.setCumulativeCollection(cumulativeCollection);
        vo.setContractId(contractId);
        vo.setAccumulatedContractualReceivables(sumCurrentReceivables);
        return vo;
    }

    @RequestMapping(value={"/queryOverpayment"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> getTotalAccumulatedOverpayment(@RequestParam(value="contractId") Long contractId, @RequestParam(value="date") String date) throws ParseException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.le((Object)"reporting_time", (Object)date);
        queryWrapper.orderByDesc((Object)"reporting_time");
        List list = this.service.list((Wrapper)queryWrapper);
        BigDecimal sumCurrentCollection = BigDecimal.ZERO;
        if (!list.isEmpty()) {
            for (EngineermeasurementEntity entity : list) {
                sumCurrentCollection = sumCurrentCollection.add(entity.getCurrentCollection());
            }
            EngineermeasurementEntity engineermeasurementEntity = (EngineermeasurementEntity)((Object)list.get(0));
            BigDecimal overpayment = engineermeasurementEntity.getAccumulatedContractualReceivables().subtract(engineermeasurementEntity.getCumulativeCollection());
            map.put("overpayment", overpayment);
        } else {
            map.put("overpayment", BigDecimal.ZERO);
        }
        map.put("sumCurrentCollection", sumCurrentCollection);
        return CommonResponse.success((String)"\u67e5\u8be2\u7d2f\u8ba1\u8d85\uff08\u6ede\uff09\u4ed8\u6b3e\u9879\u603b\u989d\u6210\u529f", map);
    }
}

