/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedataService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.utils.BigDecimalUtils;
import com.ejianc.business.middlemeasurement.vo.MechanicalleaseVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"mechanicallease"})
public class MechanicalleaseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "middlemeasurement-mechanicallease";
    @Autowired
    private IMechanicalleaseService service;
    @Autowired
    private IMechanicalleasedetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMechanicalleasedataService dataService;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> saveOrUpdate(@RequestBody MechanicalleaseVO saveorUpdateVO) {
        List pros;
        List pro;
        CommonResponse projectVOCommonResponse;
        String innerCode;
        String[] strs;
        CommonResponse orgVos;
        QueryWrapper queryLastWrapper = new QueryWrapper();
        queryLastWrapper.eq((Object)"contract_id", (Object)saveorUpdateVO.getContractId());
        queryLastWrapper.in((Object)"bill_state", new Object[]{1, 3});
        List lastList = this.service.list((Wrapper)queryLastWrapper);
        BigDecimal lastMny = BigDecimal.ZERO;
        BigDecimal lastTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)lastList)) {
            lastMny = lastList.stream().filter(s -> s.getExTaxThisMonthTotal() != null).map(MechanicalleaseEntity::getExTaxThisMonthTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            lastTaxMny = lastList.stream().filter(s -> s.getInTaxThisMonthTotal() != null).map(MechanicalleaseEntity::getInTaxThisMonthTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal sumMny = lastMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getExTaxThisMonthTotal()));
        BigDecimal sumTaxMny = lastTaxMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getInTaxThisMonthTotal()));
        if (sumMny.compareTo(BigDecimalUtils.ofNullable(saveorUpdateVO.getExTaxCumulative())) != 0) {
            throw new BusinessException("\u7d2f\u8ba1\u503c(\u65e0\u7a0e)\u8ba1\u7b97\u6709\u8bef, \u65e0\u6cd5\u4fdd\u5b58!");
        }
        if (sumTaxMny.compareTo(BigDecimalUtils.ofNullable(saveorUpdateVO.getInTaxCumulative())) != 0) {
            throw new BusinessException("\u7d2f\u8ba1\u503c(\u542b\u7a0e)\u8ba1\u7b97\u6709\u8bef, \u65e0\u6cd5\u4fdd\u5b58!");
        }
        CommonResponse orgVo = this.iOrgApi.detailById(saveorUpdateVO.getProjectDepartmentId());
        if (orgVo.isSuccess() && null != orgVo.getData() && (orgVos = this.iOrgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
            saveorUpdateVO.setOrgStatusOrder(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence());
        }
        if (!(projectVOCommonResponse = this.zjkjProjectApi.queryDetailById(saveorUpdateVO.getProjectId())).isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25");
        }
        ProjectVO projectVO = (ProjectVO)projectVOCommonResponse.getData();
        saveorUpdateVO.setProjectCreateTime(projectVO.getCreateTime());
        List<MechanicalleasedetailVO> mechanicalleasedetailEntities = saveorUpdateVO.getMechanicalleasedetailEntities();
        if (CollectionUtils.isNotEmpty(mechanicalleasedetailEntities)) {
            mechanicalleasedetailEntities.forEach(s -> s.setOccupyStatus(2));
        }
        saveorUpdateVO.setMechanicalleasedetailEntities(mechanicalleasedetailEntities);
        MechanicalleaseEntity entity = (MechanicalleaseEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), MechanicalleaseEntity.class));
        entity.setSaveTime(new Date());
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                Date currentDate = new Date(System.currentTimeMillis());
                if (saveorUpdateVO.getCreateTime() != null) {
                    currentDate = saveorUpdateVO.getCreateTime();
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setIsReference(0);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)) != null && pro.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\"\u6708\u5ea6\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u5355\"!");
        }
        QueryWrapper queryWrappers = new QueryWrapper();
        queryWrappers.eq((Object)"contract_id", (Object)entity.getContractId());
        queryWrappers.ge((Object)"settlement_time", (Object)entity.getSettlementTime());
        queryWrappers.in((Object)"bill_state", new Object[]{1, 3});
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((pros = this.service.list((Wrapper)queryWrappers)) != null && pros.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u7ed3\u7b97\u6708\u4efd\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u540e\u4e00\u671f\u7684\"\u6708\u5ea6\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u5355\"!");
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (saveorUpdateVO.getCreateTime() != null) {
            currentDate = saveorUpdateVO.getCreateTime();
        }
        entity.setSaveTime(currentDate);
        if (entity.getQuoteFlag() == null) {
            entity.setQuoteFlag(1);
        }
        this.service.saveOrUpdate((Object)entity, false);
        MechanicalleaseVO vo = (MechanicalleaseVO)((Object)BeanMapper.map((Object)((Object)entity), MechanicalleaseVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> queryDetail(Long id) {
        MechanicalleaseEntity entity = (MechanicalleaseEntity)((Object)this.service.selectById(id));
        MechanicalleaseVO vo = (MechanicalleaseVO)((Object)BeanMapper.map((Object)((Object)entity), MechanicalleaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MechanicalleaseVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getPastDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MechanicalleasedetailVO>> getPastDetailData(Long contractId) {
        List<MechanicalleasedetailVO> list = this.service.getPastDetailData(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getOrderMap().put("org_status_order", "asc");
        param.getOrderMap().put("project_create_time", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MechanicalleaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getOrderMap().put("org_status_order", "asc");
        param.getOrderMap().put("project_create_time", "asc");
        List list = this.service.queryList(param);
        List mechanicalleaseVOList = BeanMapper.mapList((Iterable)list, MechanicalleaseVO.class);
        for (int i = 0; i < mechanicalleaseVOList.size(); ++i) {
            String billStateStr;
            MechanicalleaseVO mechanicalleaseVO = (MechanicalleaseVO)((Object)mechanicalleaseVOList.get(i));
            mechanicalleaseVO.setSort(String.valueOf(i + 1));
            if (mechanicalleaseVO.getSettlementTime() != null) {
                mechanicalleaseVO.setSettlementTime((Date)DateUtil.date((Date)mechanicalleaseVO.getSettlementTime()));
            }
            if (mechanicalleaseVO.getBillingStartTime() != null) {
                mechanicalleaseVO.setBillingStartTime((Date)DateUtil.date((Date)mechanicalleaseVO.getBillingStartTime()));
            }
            if (mechanicalleaseVO.getBillingEndTime() != null) {
                mechanicalleaseVO.setBillingEndTime((Date)DateUtil.date((Date)mechanicalleaseVO.getBillingEndTime()));
            }
            if ((billStateStr = mechanicalleaseVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            mechanicalleaseVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", mechanicalleaseVOList);
        ExcelExport.getInstance().export("mechanicalleaseList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMechanicalleaseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> refMechanicalleaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("project_name");
        fuzzyFields.add("supplier_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("bill_code");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("isReference", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List mechanicalleaseVOList = BeanMapper.mapList((Iterable)page.getRecords(), MechanicalleaseVO.class);
        for (int i = 0; i < mechanicalleaseVOList.size(); ++i) {
            MechanicalleaseVO mechanicalleaseVO = (MechanicalleaseVO)((Object)mechanicalleaseVOList.get(i));
            mechanicalleaseVO.setSort(String.valueOf(i + 1));
            QueryWrapper detailWrapper = new QueryWrapper();
            detailWrapper.eq((Object)"mid", (Object)mechanicalleaseVO.getId());
            List entityList = this.detailService.list((Wrapper)detailWrapper);
            if (entityList == null || entityList.size() <= 0) continue;
            List detailList = BeanMapper.mapList((Iterable)entityList, MechanicalleasedetailVO.class);
            mechanicalleaseVO.setMechanicalleasedetailEntities(detailList);
        }
        pageData.setRecords(mechanicalleaseVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refMechanicalleasedetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MechanicalleasedetailVO>> refMechanicalleasedetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6condition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject _con = JSONObject.parseObject((String)condition);
        String projectIdStr = _con.getString("projectId");
        if (StringUtils.isBlank((CharSequence)projectIdStr)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6projectId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String settleTimeStr = _con.getString("settleTime");
        if (StringUtils.isBlank((CharSequence)settleTimeStr)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6settleTime\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long projectId = null;
        if (_con.containsKey((Object)"projectId")) {
            projectId = Long.parseLong(_con.get((Object)"projectId").toString());
        }
        String settleTime = null;
        if (_con.containsKey((Object)"settleTime")) {
            settleTime = _con.get((Object)"settleTime").toString();
        }
        LambdaQueryWrapper mechanicalQuery = new LambdaQueryWrapper();
        mechanicalQuery.eq(MechanicalleaseEntity::getProjectId, (Object)projectId);
        mechanicalQuery.in(MechanicalleaseEntity::getBillState, new Object[]{1, 3});
        mechanicalQuery.apply("DATE_FORMAT(settlement_time, '%Y-%m') <= '" + settleTime + "'", new Object[0]);
        List mechanicalleaseEntities = this.service.list((Wrapper)mechanicalQuery);
        if (CollectionUtils.isNotEmpty((Collection)mechanicalleaseEntities)) {
            List ids = mechanicalleaseEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            param.getParams().put("mid", new Parameter("in", ids));
            param.getParams().put("occupy_status", new Parameter("ne", (Object)1));
        } else {
            param.getParams().put("mid", new Parameter("eq", (Object)1));
        }
        IPage page = this.detailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MechanicalleasedetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> pastData(Long id, Long contractId, Long projectId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            MechanicalleaseEntity mechanicalleaseEntity = (MechanicalleaseEntity)((Object)this.service.selectById(id));
            currentDate = mechanicalleaseEntity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate, projectId)));
    }

    @RequestMapping(value={"/getDataById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> getDataById(@RequestBody MechanicalleaseVO mechanicalleaseVO) {
        MechanicalleaseVO dataById = this.service.getDataById(mechanicalleaseVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.service.getDataById(mechanicalleaseVO)));
    }

    @RequestMapping(value={"/getSumById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MechanicalleasedetailVO> getSumById(MechanicalleasedetailVO mechanicalleasedetailVO) {
        LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(MechanicalleaseEntity::getContractId, (Object)mechanicalleasedetailVO.getContractId());
        listWrapper.in(MechanicalleaseEntity::getBillState, new Object[]{1, 3});
        List mechanicalleaseEntityList = this.service.list((Wrapper)listWrapper);
        List mechanicalleasedetailEntityList = new ArrayList();
        DecimalFormat decimalFormat = new DecimalFormat("0.00000000");
        if (CollectionUtils.isNotEmpty((Collection)mechanicalleaseEntityList)) {
            List ids = mechanicalleaseEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper detailWrapper = Wrappers.lambdaQuery();
            detailWrapper.in(MechanicalleasedetailEntity::getMid, ids);
            detailWrapper.eq(MechanicalleasedetailEntity::getExTaxLeaseUnit, (Object)decimalFormat.format(mechanicalleasedetailVO.getExTaxLeaseUnit()));
            detailWrapper.eq(MechanicalleasedetailEntity::getInTaxLeaseUnit, (Object)decimalFormat.format(mechanicalleasedetailVO.getInTaxLeaseUnit()));
            detailWrapper.eq(MechanicalleasedetailEntity::getEquipmentCode, (Object)mechanicalleasedetailVO.getEquipmentCode());
            mechanicalleasedetailEntityList = this.detailService.list((Wrapper)detailWrapper);
            this.logger.info("mechanicalleasedetailEntityList----" + JSONObject.toJSONString(mechanicalleasedetailEntityList));
        }
        BigDecimal exTaxLeaseUnit = mechanicalleasedetailVO.getExTaxLeaseUnit() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getExTaxLeaseUnit();
        BigDecimal inTaxLeaseUnit = mechanicalleasedetailVO.getInTaxLeaseUnit() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getInTaxLeaseUnit();
        BigDecimal leaseDaysThisTime = mechanicalleasedetailVO.getLeaseDaysThisTime() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getLeaseDaysThisTime();
        BigDecimal leaseNum = mechanicalleasedetailVO.getLeaseNum() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getLeaseNum();
        BigDecimal exTaxRentSettleAmount = leaseDaysThisTime.multiply(exTaxLeaseUnit).multiply(leaseNum);
        BigDecimal inTaxRentSettleAmount = leaseDaysThisTime.multiply(inTaxLeaseUnit).multiply(leaseNum);
        mechanicalleasedetailVO.setExTaxRentSettleAmount(exTaxRentSettleAmount);
        mechanicalleasedetailVO.setInTaxRentSettleAmount(inTaxRentSettleAmount);
        BigDecimal exTaxEntranceExitFee = mechanicalleasedetailVO.getExTaxEntranceExitFee() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getExTaxEntranceExitFee();
        BigDecimal inTaxEntranceExitFee = mechanicalleasedetailVO.getInTaxEntranceExitFee() == null ? BigDecimal.ZERO : mechanicalleasedetailVO.getInTaxEntranceExitFee();
        BigDecimal exTaxEefCurrentSettleAmount = exTaxRentSettleAmount.add(exTaxEntranceExitFee);
        BigDecimal inTaxEefCurrentSettleAmount = inTaxRentSettleAmount.add(inTaxEntranceExitFee);
        mechanicalleasedetailVO.setExTaxEefCurrentSettleAmount(exTaxEefCurrentSettleAmount);
        mechanicalleasedetailVO.setInTaxEefCurrentSettleAmount(inTaxEefCurrentSettleAmount);
        mechanicalleasedetailVO.setExTaxRentCumulative(exTaxRentSettleAmount);
        mechanicalleasedetailVO.setInTaxRentCumulative(inTaxRentSettleAmount);
        mechanicalleasedetailVO.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFee);
        mechanicalleasedetailVO.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFee);
        mechanicalleasedetailVO.setExTaxEefCumulative(exTaxEefCurrentSettleAmount);
        mechanicalleasedetailVO.setInTaxEefCumulative(inTaxEefCurrentSettleAmount);
        if (CollectionUtils.isNotEmpty(mechanicalleasedetailEntityList)) {
            BigDecimal exTaxRentSettleAmountSum = mechanicalleasedetailEntityList.stream().filter(s -> s.getExTaxRentSettleAmount() != null).map(MechanicalleasedetailEntity::getExTaxRentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal inTaxRentSettleAmountSum = mechanicalleasedetailEntityList.stream().filter(s -> s.getInTaxRentSettleAmount() != null).map(MechanicalleasedetailEntity::getInTaxRentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exTaxEntranceExitFeeSum = mechanicalleasedetailEntityList.stream().filter(s -> s.getExTaxEntranceExitFee() != null).map(MechanicalleasedetailEntity::getExTaxEntranceExitFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal inTaxEntranceExitFeeSum = mechanicalleasedetailEntityList.stream().filter(s -> s.getInTaxEntranceExitFee() != null).map(MechanicalleasedetailEntity::getInTaxEntranceExitFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exTaxEefCurrentSettleAmountSum = mechanicalleasedetailEntityList.stream().filter(s -> s.getExTaxEefCurrentSettleAmount() != null).map(MechanicalleasedetailEntity::getExTaxEefCurrentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal inTaxEefCurrentSettleAmountSum = mechanicalleasedetailEntityList.stream().filter(s -> s.getInTaxEefCurrentSettleAmount() != null).map(MechanicalleasedetailEntity::getInTaxEefCurrentSettleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            mechanicalleasedetailVO.setExTaxRentCumulative(exTaxRentSettleAmount.add(exTaxRentSettleAmountSum));
            mechanicalleasedetailVO.setInTaxRentCumulative(inTaxRentSettleAmount.add(inTaxRentSettleAmountSum));
            mechanicalleasedetailVO.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFee.add(exTaxEntranceExitFeeSum));
            mechanicalleasedetailVO.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFee.add(inTaxEntranceExitFeeSum));
            mechanicalleasedetailVO.setExTaxEefCumulative(exTaxEefCurrentSettleAmount.add(exTaxEefCurrentSettleAmountSum));
            mechanicalleasedetailVO.setInTaxEefCumulative(inTaxEefCurrentSettleAmount.add(inTaxEefCurrentSettleAmountSum));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)mechanicalleasedetailVO));
    }

    private MechanicalleaseVO getPastTotal(Long contractId, Date currentDate, boolean isSave) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        queryWrapperTotal.orderByDesc((Object)"create_time");
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        ArrayList mechanicalleasedetailEntityList = new ArrayList();
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        BigDecimal exTaxEntranceExitFeeCumulative = new BigDecimal(0);
        BigDecimal inTaxEntranceExitFeeCumulative = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            MechanicalleaseEntity mechanicalleaseEntity = (MechanicalleaseEntity)((Object)proTotal.get(0));
            occurrenceTotal = occurrenceTotal.add(mechanicalleaseEntity.getExTaxCumulative());
            taxOccurrenceTotal = taxOccurrenceTotal.add(mechanicalleaseEntity.getInTaxCumulative());
            exTaxEntranceExitFeeCumulative = ComputeUtil.safeAdd((BigDecimal)exTaxEntranceExitFeeCumulative, (BigDecimal)mechanicalleaseEntity.getExTaxEntranceExitFeeCumulative());
            inTaxEntranceExitFeeCumulative = ComputeUtil.safeAdd((BigDecimal)inTaxEntranceExitFeeCumulative, (BigDecimal)mechanicalleaseEntity.getInTaxEntranceExitFeeCumulative());
            if (isSave) {
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.eq((Object)"mid", (Object)mechanicalleaseEntity.getId());
                List detailList = this.detailService.list((Wrapper)detailWrapper);
                mechanicalleasedetailEntityList.addAll(detailList);
            }
        }
        MechanicalleaseVO vo = new MechanicalleaseVO();
        vo.setExTaxCumulative(occurrenceTotal);
        vo.setInTaxCumulative(taxOccurrenceTotal);
        vo.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFeeCumulative);
        vo.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFeeCumulative);
        vo.setContractId(contractId);
        vo.setMechanicalleasedetailEntities(BeanMapper.mapList(mechanicalleasedetailEntityList, MechanicalleasedetailVO.class));
        return vo;
    }

    private MechanicalleaseVO getPastTotalData(Long contractId, Date currentDate, Long projectId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        BigDecimal exTaxCumulative = new BigDecimal(0);
        BigDecimal inTaxCumulative = new BigDecimal(0);
        BigDecimal exTaxEntranceExitFeeCumulative = new BigDecimal(0);
        BigDecimal inTaxEntranceExitFeeCumulative = new BigDecimal(0);
        List list = this.service.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MechanicalleaseEntity entitys = (MechanicalleaseEntity)((Object)list.get(i));
                exTaxCumulative = exTaxCumulative.add(entitys.getExTaxThisMonthTotal() == null ? BigDecimal.valueOf(0L) : entitys.getExTaxThisMonthTotal());
                inTaxCumulative = inTaxCumulative.add(entitys.getInTaxThisMonthTotal() == null ? BigDecimal.valueOf(0L) : entitys.getInTaxThisMonthTotal());
                exTaxEntranceExitFeeCumulative = exTaxEntranceExitFeeCumulative.add(entitys.getExTaxEntranceExitFee() == null ? BigDecimal.valueOf(0L) : entitys.getExTaxEntranceExitFee());
                inTaxEntranceExitFeeCumulative = inTaxEntranceExitFeeCumulative.add(entitys.getInTaxEntranceExitFee() == null ? BigDecimal.valueOf(0L) : entitys.getInTaxEntranceExitFee());
            }
        }
        MechanicalleaseVO vo = new MechanicalleaseVO();
        vo.setExTaxCumulative(exTaxCumulative);
        vo.setInTaxCumulative(inTaxCumulative);
        vo.setExTaxEntranceExitFeeCumulative(exTaxEntranceExitFeeCumulative);
        vo.setInTaxEntranceExitFeeCumulative(inTaxEntranceExitFeeCumulative);
        return vo;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

