/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.BigDecimalUtils;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchasesettlement"})
public class PurchasesettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    private static final String BILL_CODE = "middlemeasurement-purchasesettlement";
    @Autowired
    private IPurchasesettlementService service;
    @Autowired
    private IPurchasesettlementdetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> saveOrUpdate(@RequestBody PurchasesettlementVO saveorUpdateVO) {
        CommonResponse projectVOCommonResponse;
        String innerCode;
        String[] strs;
        CommonResponse orgVos;
        QueryWrapper queryLastWrapper = new QueryWrapper();
        queryLastWrapper.eq((Object)"contract_id", (Object)saveorUpdateVO.getContractId());
        queryLastWrapper.in((Object)"bill_state", new Object[]{1, 3});
        List lastList = this.service.list((Wrapper)queryLastWrapper);
        BigDecimal lastMny = BigDecimal.ZERO;
        BigDecimal lastTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)lastList)) {
            lastMny = lastList.stream().filter(s -> s.getMonthlyTotal() != null).map(PurchasesettlementEntity::getMonthlyTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            lastTaxMny = lastList.stream().filter(s -> s.getTaxMonthlyTotal() != null).map(PurchasesettlementEntity::getTaxMonthlyTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal sumMny = lastMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getMonthlyTotal()));
        BigDecimal sumTaxMny = lastTaxMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getTaxMonthlyTotal()));
        if (sumMny.compareTo(BigDecimalUtils.ofNullable(saveorUpdateVO.getOccurrenceTotal())) != 0) {
            throw new BusinessException("\u7d2f\u8ba1\u503c(\u65e0\u7a0e)\u8ba1\u7b97\u6709\u8bef, \u65e0\u6cd5\u4fdd\u5b58!");
        }
        if (sumTaxMny.compareTo(BigDecimalUtils.ofNullable(saveorUpdateVO.getTaxOccurrenceTotal())) != 0) {
            throw new BusinessException("\u7d2f\u8ba1\u503c(\u542b\u7a0e)\u8ba1\u7b97\u6709\u8bef, \u65e0\u6cd5\u4fdd\u5b58!");
        }
        CommonResponse orgVo = this.iOrgApi.detailById(saveorUpdateVO.getProjectDepartmentId());
        if (orgVo.isSuccess() && null != orgVo.getData() && (orgVos = this.iOrgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
            saveorUpdateVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
        }
        if (!(projectVOCommonResponse = this.zjkjProjectApi.queryDetailById(saveorUpdateVO.getProjectId())).isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25");
        }
        ProjectVO projectVO = (ProjectVO)projectVOCommonResponse.getData();
        saveorUpdateVO.setProjectCreateTime(projectVO.getCreateTime());
        PurchasesettlementEntity entity = (PurchasesettlementEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, PurchasesettlementEntity.class));
        entity.setSaveTime(new Date());
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
            queryWrapper.in((Object)"bill_state", new Object[]{0, 2, 4, 5});
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u6708\u5ea6\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355\"!");
            }
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
            queryWrapper.eq((Object)"occurrence_time", (Object)entity.getOccurrenceTime());
            List list = this.service.list((Wrapper)queryWrapper);
            if (pro != null && list.size() > 0) {
                throw new BusinessException("\u76f8\u540c\u5408\u540c\u7684\u53d1\u751f\u65e5\u671f\u4e0d\u5141\u8bb8\u91cd\u590d!");
            }
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (saveorUpdateVO.getCreateTime() != null) {
            currentDate = saveorUpdateVO.getCreateTime();
        }
        entity.setSaveTime(currentDate);
        entity.setIsReference(0);
        this.service.saveOrUpdate((Object)entity, false);
        PurchasesettlementVO vo = (PurchasesettlementVO)BeanMapper.map((Object)((Object)entity), PurchasesettlementVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> queryDetail(Long id) {
        PurchasesettlementEntity entity = (PurchasesettlementEntity)((Object)this.service.selectById(id));
        PurchasesettlementVO vo = (PurchasesettlementVO)BeanMapper.map((Object)((Object)entity), PurchasesettlementVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getSumByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> getSumByContractId(Long contractId) {
        PurchasesettlementVO vo = this.service.getSumByContractId(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getInfoById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesettlementdetailVO> getInfoById(PurchasesettlementdetailVO subcontractingvolumedetailVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)subcontractingvolumedetailVO.getContractId());
        queryWrapper.eq((Object)"bill_code", (Object)subcontractingvolumedetailVO.getBillCode());
        queryWrapper.eq((Object)"settlement_price", (Object)subcontractingvolumedetailVO.getSettlementPrice());
        queryWrapper.eq((Object)"tax_settlement_price", (Object)subcontractingvolumedetailVO.getTaxSettlementPrice());
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)"0");
        List pastDetails = this.detailService.list((Wrapper)queryWrapper);
        BigDecimal examineQuantity = subcontractingvolumedetailVO.getSupplyQuantity() == null ? BigDecimal.ZERO : subcontractingvolumedetailVO.getSupplyQuantity();
        BigDecimal examineUnitprice = subcontractingvolumedetailVO.getSettlementPrice() == null ? BigDecimal.ZERO : subcontractingvolumedetailVO.getSettlementPrice();
        BigDecimal examineTaxUnitprice = subcontractingvolumedetailVO.getTaxSettlementPrice() == null ? BigDecimal.ZERO : subcontractingvolumedetailVO.getTaxSettlementPrice();
        BigDecimal money = examineQuantity.multiply(examineUnitprice);
        BigDecimal moneyTax = examineQuantity.multiply(examineTaxUnitprice);
        subcontractingvolumedetailVO.setSettlementAmount(money);
        subcontractingvolumedetailVO.setTaxSettlementAmount(moneyTax);
        if (pastDetails != null && pastDetails.size() > 0) {
            BigDecimal examineQuantitySum = pastDetails.stream().map(PurchasesettlementdetailEntity::getSupplyQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineAmounts = pastDetails.stream().map(PurchasesettlementdetailEntity::getSettlementPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineTaxAmounts = pastDetails.stream().map(PurchasesettlementdetailEntity::getTaxSettlementPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            subcontractingvolumedetailVO.setSupplyQuantityTotal(examineQuantitySum);
            subcontractingvolumedetailVO.setSettlementTotal(examineAmounts.add(money));
            subcontractingvolumedetailVO.setTaxSettlementTotal(examineTaxAmounts.add(moneyTax));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)subcontractingvolumedetailVO);
    }

    @RequestMapping(value={"/getPastDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PurchasesettlementdetailVO>> getPastDetailData(Long contractId) {
        List<PurchasesettlementdetailVO> list = this.service.getPastDetailData(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/getPurchaseDataById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> getPurchaseDataById(@RequestBody PurchasesettlementVO purchasesettlementVO) {
        PurchasesettlementVO purchaseDataById = this.service.getPurchaseDataById(purchasesettlementVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)purchaseDataById);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasesettlementVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("settlementType");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getOrderMap().put("org_status_order", "asc");
        param.getOrderMap().put("project_create_time", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasesettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("settlementType");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getOrderMap().put("org_status_order", "asc");
        param.getOrderMap().put("project_create_time", "asc");
        List list = this.service.queryList(param);
        int count = 1;
        for (PurchasesettlementEntity entity : list) {
            String billStateStr;
            entity.setSort(String.valueOf(count));
            if (entity.getAgentTime() != null) {
                entity.setAgentTimeShow(DateUtils.dateSimple2(entity.getAgentTime()));
            }
            if (entity.getSettlementStartTime() != null) {
                entity.setSettlementStartTimeShow(DateUtils.dateSimple2(entity.getSettlementStartTime()));
            }
            if (entity.getSettlementDeadline() != null) {
                entity.setSettlementDeadlineShow(DateUtils.dateSimple2(entity.getSettlementDeadline()));
            }
            if (entity.getDepartmentAgentDate() != null) {
                entity.setDepartmentAgentDateShow(DateUtils.dateSimple2(entity.getDepartmentAgentDate()));
            }
            if ((billStateStr = entity.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            entity.setBillStateStr(billStateStr);
            ++count;
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Purchasesettlement-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchasesettlementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> refPurchasesettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        fuzzyFields.add("department_agent_name");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("isReference", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List purchasesettlementVOList = BeanMapper.mapList((Iterable)page.getRecords(), PurchasesettlementVO.class);
        for (int i = 0; i < purchasesettlementVOList.size(); ++i) {
            PurchasesettlementVO purchasesettlementVO = (PurchasesettlementVO)purchasesettlementVOList.get(i);
            purchasesettlementVO.setSort(String.valueOf(i + 1));
            QueryWrapper detailWrapper = new QueryWrapper();
            detailWrapper.eq((Object)"mid", (Object)purchasesettlementVO.getId());
            List entityList = this.detailService.list((Wrapper)detailWrapper);
            if (entityList == null || entityList.size() <= 0) continue;
            List detailList = BeanMapper.mapList((Iterable)entityList, PurchasesettlementdetailVO.class);
            purchasesettlementVO.setPurchasesettlementdetailEntities(detailList);
        }
        pageData.setRecords(purchasesettlementVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            PurchasesettlementEntity entity = (PurchasesettlementEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)this.getPastTotalData(contractId, currentDate));
    }

    private PurchasesettlementVO getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        queryWrapperTotal.eq((Object)"dr", (Object)0);
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); ++i) {
                PurchasesettlementEntity purchasesettlementEntity = (PurchasesettlementEntity)((Object)proTotal.get(i));
                occurrenceTotal = occurrenceTotal.add(purchasesettlementEntity.getMonthlyTotal());
                taxOccurrenceTotal = taxOccurrenceTotal.add(purchasesettlementEntity.getTaxMonthlyTotal());
            }
        }
        PurchasesettlementVO vo = new PurchasesettlementVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);
        vo.setContractId(contractId);
        return vo;
    }

    @RequestMapping(value={"/queryAmount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesettlementVO> queryAmount(Long contractId, Long projectId) {
        BigDecimal exTaxSettlementMonth = new BigDecimal(0);
        BigDecimal inTaxSettlementMonth = new BigDecimal(0);
        BigDecimal exTaxCumulative = new BigDecimal(0);
        BigDecimal inTaxCumulative = new BigDecimal(0);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        List entityList = this.service.list((Wrapper)wrapper);
        for (PurchasesettlementEntity purchasesettlementEntity : entityList) {
            if (purchasesettlementEntity.getOccurrenceTotal() != null) {
                exTaxCumulative = exTaxCumulative.add(purchasesettlementEntity.getMonthlyTotal());
            }
            if (purchasesettlementEntity.getTaxOccurrenceTotal() != null) {
                inTaxCumulative = inTaxCumulative.add(purchasesettlementEntity.getTaxMonthlyTotal());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"mid", (Object)purchasesettlementEntity.getId());
            queryWrapper.eq((Object)"dr", (Object)0);
            List purchasesettlementdetailEntities = this.detailService.list((Wrapper)queryWrapper);
            for (PurchasesettlementdetailEntity purchasesettlementdetailEntity : purchasesettlementdetailEntities) {
                if (purchasesettlementdetailEntity.getSettlementAmount() != null) {
                    exTaxSettlementMonth = exTaxSettlementMonth.add(purchasesettlementdetailEntity.getSettlementAmount());
                }
                if (purchasesettlementdetailEntity.getTaxSettlementAmount() == null) continue;
                inTaxSettlementMonth = inTaxSettlementMonth.add(purchasesettlementdetailEntity.getTaxSettlementAmount());
            }
        }
        PurchasesettlementVO vo = new PurchasesettlementVO();
        vo.setMonthlyTotal(exTaxSettlementMonth);
        vo.setTaxMonthlyTotal(inTaxSettlementMonth);
        vo.setOccurrenceTotal(exTaxCumulative);
        vo.setTaxOccurrenceTotal(inTaxCumulative);
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private PurchasesettlementVO getPastTotal(Long contractId, Date currentDate, boolean isSave) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        ArrayList purchasesettlementdetailEntities = new ArrayList();
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); ++i) {
                PurchasesettlementEntity purchasesettlementEntity = (PurchasesettlementEntity)((Object)proTotal.get(i));
                occurrenceTotal = occurrenceTotal.add(purchasesettlementEntity.getMonthlyTotal());
                taxOccurrenceTotal = taxOccurrenceTotal.add(purchasesettlementEntity.getTaxMonthlyTotal());
                if (!isSave) continue;
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.eq((Object)"mid", (Object)purchasesettlementEntity.getId());
                List detailList = this.detailService.list((Wrapper)detailWrapper);
                purchasesettlementdetailEntities.addAll(detailList);
            }
        }
        PurchasesettlementVO vo = new PurchasesettlementVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);
        vo.setContractId(contractId);
        vo.setPurchasesettlementdetailEntities(BeanMapper.mapList(purchasesettlementdetailEntities, PurchasesettlementdetailVO.class));
        return vo;
    }
}

