package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.BigDecimalUtils;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.CollationElementIterator;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.service.IInterimsettlementService;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;

/**
 * 项目期中结算台账
 *
 * @author generator
 */
@Controller
@RequestMapping("interimsettlement")
public class InterimsettlementController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "middlemeasurement-interimsettlement";//此处需要根据实际修改

    @Autowired
    private IInterimsettlementService service;

    @Autowired
    private IInterimsettlementdetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InterimsettlementVO> saveOrUpdate(@RequestBody InterimsettlementVO saveorUpdateVO) {



        InterimsettlementEntity entity = BeanMapper.map(saveorUpdateVO, InterimsettlementEntity.class);

        //判断“期号”是否有重复
        checkIssueNumberUniq(entity.getInterimsettlementdetailEntities());

        //校验：同一合同，只能存在一份自由态或审批中的单据
        checkBillStateUniq(entity.getId(), entity.getContractId());

        //校验：单据编号唯一性
        entity = checkBillCodeUniq(entity);

        //累计（包含本期）
//        entity = handleCumulative(entity);
        //计算累计值
        getSumData(entity);


////保存校验累计值
////查询该合同下往期数据
//        QueryWrapper<InterimsettlementEntity> queryLastWrapper = new QueryWrapper<>();
//        queryLastWrapper.eq("contract_id", saveorUpdateVO.getContractId());
//        queryLastWrapper.in("bill_state", 1,3);
//        List<InterimsettlementEntity> lastList = service.list(queryLastWrapper);
//        BigDecimal lastMny = BigDecimal.ZERO;
//        if (CollectionUtils.isNotEmpty(lastList)){
//            lastMny = lastList.stream().filter(s->s.getCurrentAmount()!=null).map(InterimsettlementEntity::getCurrentAmount)
//                    .reduce(BigDecimal.ZERO, BigDecimal::add);
//        }
////计算汇总本期值
//        BigDecimal sumMny = lastMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getCurrentAmount()));
////比较前端传的累计值和后台汇总的累计值是否一致
//        if(sumMny.compareTo(BigDecimalUtils.ofNullable(entity.getCumulativeAmount())) != 0){
//            throw new BusinessException("累计结算金额计算有误, 无法保存!");
//        }


        service.saveOrUpdate(entity, false);
        InterimsettlementVO vo = BeanMapper.map(entity, InterimsettlementVO.class);
        List<InterimsettlementdetailVO> interimsettlementdetailEntities = vo.getInterimsettlementdetailEntities();
        if (CollectionUtils.isNotEmpty(interimsettlementdetailEntities)){
            List<InterimsettlementdetailVO> interimsettlementdetailVOS = interimsettlementdetailEntities.stream().sorted(Comparator.comparing(InterimsettlementdetailVO::getIssueNumber).reversed())
                    .collect(Collectors.toList());
            vo.setInterimsettlementdetailEntities(interimsettlementdetailVOS);
        }

        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    private void getSumData(InterimsettlementEntity entity) {
        List<InterimsettlementdetailEntity> interimsettlementdetailEntities = entity.getInterimsettlementdetailEntities();
        if (CollectionUtils.isNotEmpty(interimsettlementdetailEntities)){
            for (InterimsettlementdetailEntity interimsettlementdetailEntity : interimsettlementdetailEntities){
                BigDecimal currentApproval = interimsettlementdetailEntities.stream().filter(s -> s.getRowState() != "del" && s.getIssueNumber() <= interimsettlementdetailEntity.getIssueNumber()).map(InterimsettlementdetailEntity::getCurrentApproval)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                interimsettlementdetailEntity.setCumulativeApproval(currentApproval);

                BigDecimal currentReceivable = interimsettlementdetailEntities.stream().filter(s -> s.getRowState() != "del" && s.getIssueNumber() <= interimsettlementdetailEntity.getIssueNumber()).map(InterimsettlementdetailEntity::getCurrentReceivable)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                interimsettlementdetailEntity.setCumulativeReceivable(currentReceivable);

                BigDecimal currentRetention = interimsettlementdetailEntities.stream().filter(s -> s.getRowState() != "del" && s.getIssueNumber() <= interimsettlementdetailEntity.getIssueNumber()).map(InterimsettlementdetailEntity::getCurrentRetention)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                interimsettlementdetailEntity.setCumulativeRetention(currentRetention);

                BigDecimal currentActual = interimsettlementdetailEntities.stream().filter(s -> s.getRowState() != "del" && s.getIssueNumber() <= interimsettlementdetailEntity.getIssueNumber()).map(InterimsettlementdetailEntity::getCurrentActual)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                interimsettlementdetailEntity.setCumulativeActual(currentActual);

                BigDecimal currentUncollected = interimsettlementdetailEntities.stream().filter(s -> s.getRowState() != "del" && s.getIssueNumber() <= interimsettlementdetailEntity.getIssueNumber()).map(InterimsettlementdetailEntity::getCurrentUncollected)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                interimsettlementdetailEntity.setCumulativeUncollected(currentUncollected);
            }
            //计算表头累计结算金额
            BigDecimal cumulativeAmount = interimsettlementdetailEntities.stream().filter(s -> s.getRowState() != "del" ).map(InterimsettlementdetailEntity::getCurrentApproval)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setCumulativeAmount(cumulativeAmount);
            //计算累计结算比例
            entity.setCumulativeProportion(ComputeUtil.safeDiv(cumulativeAmount, entity.getContractAmount()).multiply(new BigDecimal(100)));
        }
    }

    /**
     * 判断“期号”是否有重复
     * @param detailEntities
     */
    private void checkIssueNumberUniq(List<InterimsettlementdetailEntity> detailEntities) {
        if(detailEntities != null && detailEntities.size() > 0){
            HashMap<Integer, InterimsettlementdetailEntity> map = new HashMap<>();
            for (InterimsettlementdetailEntity detail:
                    detailEntities) {
                if("del".equals(detail.getRowState())){
                    continue;
                }
                if(map.get(detail.getIssueNumber()) == null){
                    map.put(detail.getIssueNumber(), detail);
                }else {
                    throw new BusinessException("期号不允许重复！");
                }
            }
        }
    }

    /**
     * 同一合同，只能存在一份自由态或审批中的单据
     *
     * @param id
     * @param contractId
     */
    private void checkBillStateUniq(Long id, Long contractId) {
        //创建条件构造器
        QueryWrapper<InterimsettlementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
        queryWrapper.eq("dr", "0");
        if (id != null) {
            queryWrapper.ne("id", id);
        }
        List<InterimsettlementEntity> pro = service.list(queryWrapper);
        if (pro != null && pro.size() > 0) {
            throw new BusinessException("同一合同只能存在一份自由态或审批中的\"项目期中结算台账\"!");
        }
    }

    /**
     * 单据编码唯一性校验
     *
     * @param entity
     */
    private InterimsettlementEntity checkBillCodeUniq(InterimsettlementEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //单据编码唯一性
            QueryWrapper<InterimsettlementEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne("id", id);
            }
            List<InterimsettlementEntity> proBillCode = service.list(queryWrapperBillCode);
            if (proBillCode != null && proBillCode.size() > 0) {
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }

        return entity;
    }

    /**
     * 累计（包含本期）
     *
     * @param entity
     * @return
     */
    private InterimsettlementEntity handleCumulative(InterimsettlementEntity entity) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (entity.getCreateTime() != null) {
            currentDate = entity.getCreateTime();
        }

        //获取往期
        InterimsettlementVO pastVo = getPastTotalData(entity.getContractId(), currentDate);
        List<InterimsettlementdetailVO> pastDetailVOList = pastVo.getInterimsettlementdetailEntities();
        List<InterimsettlementdetailEntity> pastDetailList = BeanMapper.mapList(pastDetailVOList, InterimsettlementdetailEntity.class);

        //本期 + 往期
        BigDecimal cumulativeAmount = pastVo.getCumulativeAmount();//累计结算金额
        BigDecimal currentAmount = entity.getCurrentAmount();//本期结算金额
        if (cumulativeAmount != null && entity.getCurrentAmount() != null) {
            cumulativeAmount = currentAmount.add(cumulativeAmount);
        } else {
            cumulativeAmount = currentAmount;
        }
        //主表：累计结算金额
        entity.setCumulativeAmount(cumulativeAmount);

        BigDecimal contractAmount = entity.getContractAmount();//合同金额
        if (cumulativeAmount != null && contractAmount != null && contractAmount.compareTo(BigDecimal.ZERO) != 0) {
            //累计结算比例
            BigDecimal cumulativeProportion = cumulativeAmount.divide(contractAmount, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            entity.setCumulativeProportion(cumulativeProportion);
        }

        //处理子表累计
        List<InterimsettlementdetailEntity> resDetailList = new ArrayList<>();
        //本单据子表
        List<InterimsettlementdetailEntity> currentDetailEntities = entity.getInterimsettlementdetailEntities();
        if (currentDetailEntities != null && currentDetailEntities.size() > 0 && pastDetailList != null && pastDetailList.size() > 0) {
            for (int i = 0; i < currentDetailEntities.size(); i++) {
                InterimsettlementdetailEntity currentDetail = currentDetailEntities.get(i);
                if(currentDetail.getPastFlag() != null && currentDetail.getPastFlag() == 1){//是否为往期数据：1是，0否
                    currentDetail.setRowState("del");
                }
            }
            //本期 + 重新拉取的往期
            resDetailList.addAll(currentDetailEntities);
            if (pastDetailList != null && pastDetailList.size() > 0) {
                resDetailList.addAll(pastDetailList);//拼接往期子表
            }

            InterimsettlementdetailEntity lastDetail = null;
            for (int i = resDetailList.size() - 1; i >= 0; i--) {
                InterimsettlementdetailEntity resDetail = resDetailList.get(i);
                if("del".equals(resDetail.getRowState())){
                    continue;
                }
                resDetail.setSort(String.valueOf(i + 1));
                if(lastDetail == null){//累计 = 本期
                    //累计（批准金额）
                    resDetail.setCumulativeApproval(resDetail.getCurrentApproval());
                    //累计（按照合同约定收款比例应收金额）
                    resDetail.setCumulativeReceivable(resDetail.getCurrentReceivable());
                    //累计（保留金）
                    resDetail.setCumulativeRetention(resDetail.getCurrentRetention());
                    //累计（实际已收金额）
                    resDetail.setCumulativeActual(resDetail.getCurrentActual());
                    //累计（实际未收金额）
                    resDetail.setCumulativeUncollected(resDetail.getCurrentUncollected());
                }else {//累计 = 往期 + 本期
                    //累计（批准金额）
                    BigDecimal lastCumulativeApproval = lastDetail.getCumulativeApproval();
                    resDetail.setCumulativeApproval(lastCumulativeApproval.add(resDetail.getCurrentApproval()));
                    //累计（按照合同约定收款比例应收金额）
                    BigDecimal lastCumulativeReceivable = lastDetail.getCumulativeReceivable();
                    resDetail.setCumulativeReceivable(lastCumulativeReceivable.add(resDetail.getCurrentReceivable()));
                    //累计（保留金）
                    BigDecimal lastCumulativeRetention = lastDetail.getCumulativeRetention();
                    resDetail.setCumulativeRetention(lastCumulativeRetention.add(resDetail.getCurrentRetention()));
                    //累计（实际已收金额）
                    BigDecimal lastCumulativeActual = lastDetail.getCumulativeActual();
                    resDetail.setCumulativeActual(lastCumulativeActual.add(resDetail.getCurrentActual()));
                    //累计（实际未收金额）
                    BigDecimal lastCumulativeUncollected = lastDetail.getCumulativeUncollected();
                    resDetail.setCumulativeUncollected(lastCumulativeUncollected.add(resDetail.getCurrentUncollected()));
                }

                lastDetail = resDetail;
            }
        }else {
            resDetailList = currentDetailEntities;
        }

        entity.setInterimsettlementdetailEntities(resDetailList);
        return entity;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InterimsettlementVO> queryDetail(Long id) {
        InterimsettlementEntity entity = service.selectById(id);
        InterimsettlementVO vo = BeanMapper.map(entity, InterimsettlementVO.class);
        List<InterimsettlementdetailVO> interimsettlementdetailEntities = vo.getInterimsettlementdetailEntities();
        if (CollectionUtils.isNotEmpty(interimsettlementdetailEntities)){
            List<InterimsettlementdetailVO> interimsettlementdetailVOS = interimsettlementdetailEntities.stream().sorted(Comparator.comparing(InterimsettlementdetailVO::getIssueNumber).reversed())
                    .collect(Collectors.toList());
            vo.setInterimsettlementdetailEntities(interimsettlementdetailVOS);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InterimsettlementVO> vos) {
        service.removeByIds(vos.stream().map(InterimsettlementVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InterimsettlementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<InterimsettlementEntity> page = service.queryPage(param, false);
        IPage<InterimsettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InterimsettlementVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<InterimsettlementEntity> list = service.queryList(param);
        //时间转换
        List<InterimsettlementVO> interimsettlementVOList = BeanMapper.mapList(list, InterimsettlementVO.class);
        for (int i = 0; i < interimsettlementVOList.size(); i++) {
            InterimsettlementVO interimsettlementVO = interimsettlementVOList.get(i);
            interimsettlementVO.setSort(String.valueOf(i + 1));
            if (interimsettlementVO.getApplicationTime() != null) {
                interimsettlementVO.setApplicationTime(DateUtil.date(interimsettlementVO.getApplicationTime()));
            }
            if (interimsettlementVO.getApprovalTime() != null) {
                interimsettlementVO.setApprovalTime(DateUtil.date(interimsettlementVO.getApplicationTime()));
            }
            String billStateStr = interimsettlementVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }
                interimsettlementVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", interimsettlementVOList);
        ExcelExport.getInstance().export("interimsettlementList-export.xlsx", beans, response);

    }

    /**
     * 参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return CommonResponse<IPage < InterimsettlementVO>>
     */
    @RequestMapping(value = "/refInterimsettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InterimsettlementVO>> refInterimsettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InterimsettlementEntity> page = service.queryPage(param, false);
        IPage<InterimsettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InterimsettlementVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param contractId
     * @Description 查询详情
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InterimsettlementVO> pastData(Long id, Long contractId) {
        //校验：同一合同，只能存在一份自由态或审批中的单据
        checkBillStateUniq(id, contractId);

        //本期日期
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            InterimsettlementEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId  合同id
     * @param currentDate 本期日期
     */
    private InterimsettlementVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器-该合同下审批通过、最新生效的项目期中结算台账
        QueryWrapper<InterimsettlementEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("dr", 0);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        queryWrapperTotal.orderByDesc("create_time");//
        queryWrapperTotal.last("limit 1");//最新生效的一期
        List<InterimsettlementEntity> list = service.list(queryWrapperTotal);

        //往期：主表
        InterimsettlementVO resVO = new InterimsettlementVO();
        if (list != null && list.size() > 0) {
            resVO = BeanMapper.map(list.get(0), InterimsettlementVO.class);

            //往期：子表
            //查询往期单据子表
            QueryWrapper<InterimsettlementdetailEntity> queryWrapperDetailList = new QueryWrapper<>();
            queryWrapperDetailList.eq("mid", resVO.getId());
            queryWrapperDetailList.eq("dr", "0");
            queryWrapperDetailList.orderByAsc("issue_number");
            List<InterimsettlementdetailEntity> detailList = detailService.list(queryWrapperDetailList);

            if (detailList != null && detailList.size() > 0) {
                for (int i = 0; i < detailList.size(); i++) {
                    detailList.get(i).setId(IdWorker.getId());
                    detailList.get(i).setPastFlag(1);//是否为往期数据：1是，0否
                }
                List<InterimsettlementdetailVO> resDetailList = BeanMapper.mapList(detailList, InterimsettlementdetailVO.class);
                resVO.setInterimsettlementdetailEntities(resDetailList);
            }
        }

        return resVO;
    }
}
