package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.SubcontractEconomicEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractEconomicService;
import com.ejianc.business.middlemeasurement.vo.SubcontractEconomicVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包经济签证单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractEconomic")
public class SubcontractEconomicController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISubcontractEconomicService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubcontractEconomicVO> saveOrUpdate(@RequestBody SubcontractEconomicVO saveOrUpdateVO) {
        //补全二级组织信息
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(saveOrUpdateVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
        if (orgVo.isSuccess() && null != orgVo.getData()) {
            String innerCode = orgVo.getData().getInnerCode();
            String[] strs = innerCode.split("\\|");
            CommonResponse<OrgVO> orgVos = iOrgApi.detailById(Long.parseLong(strs[1]));
            if (orgVos.isSuccess() && null != orgVos.getData()) {
                //二级组织信息
                saveOrUpdateVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
            }
        }

//获取项目创建时间
        CommonResponse<ProjectVO> projectVOCommonResponse = zjkjProjectApi.queryDetailById(saveOrUpdateVO.getProjectId());
        if(!projectVOCommonResponse.isSuccess()){
            throw new BusinessException("获取项目信息失败");
        }
        ProjectVO projectVO = projectVOCommonResponse.getData();
        saveOrUpdateVO.setProjectCreateTime(projectVO.getCreateTime());

        List<String> engineeringOrderIssueList = saveOrUpdateVO.getEngineeringOrderIssueList();
        //多选
        if(engineeringOrderIssueList.size() > 0){
            String engineeringOrderIssue = "";
            for(int i=0;i<engineeringOrderIssueList.size();i++){
                String Issues = engineeringOrderIssueList.get(i);
                if(i==engineeringOrderIssueList.size()-1){
                    engineeringOrderIssue = engineeringOrderIssue + Issues;
                }else {
                    engineeringOrderIssue = engineeringOrderIssue + Issues +',';
                }
            }
            saveOrUpdateVO.setEngineeringOrderIssue(engineeringOrderIssue);
        }
    	SubcontractEconomicEntity entity = BeanMapper.map(saveOrUpdateVO, SubcontractEconomicEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            if (entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())) {
//                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
//                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {

                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	SubcontractEconomicVO vo = BeanMapper.map(entity, SubcontractEconomicVO.class);
        vo.setEngineeringOrderIssueList(engineeringOrderIssueList);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractEconomicVO> queryDetail(Long id) {
    	SubcontractEconomicEntity entity = service.selectById(id);
    	SubcontractEconomicVO vo = BeanMapper.map(entity, SubcontractEconomicVO.class);
        //多选显示
    	String cal = entity.getEngineeringOrderIssue();
        if(cal!= null){
            String[] calim = cal.split(",");
            List<String> cals = new ArrayList<>();
            for (int i = 0; i < calim.length ; i++) {
                String calstr = calim[i];
                cals.add(calstr);

            }
            vo.setEngineeringOrderIssueList(cals);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractEconomicVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SubcontractEconomicVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SubcontractEconomicVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubcontractEconomicVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringOrderIssue");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getOrderMap().put("org_status_order", QueryParam.ASC);
        param.getOrderMap().put("project_create_time", QueryParam.ASC);
        param.getOrderMap().put("create_time", QueryParam.ASC);
        IPage<SubcontractEconomicEntity> page = service.queryPage(param,false);
        IPage<SubcontractEconomicVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractEconomicVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringOrderIssue");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getOrderMap().put("org_status_order", QueryParam.ASC);
        param.getOrderMap().put("project_create_time", QueryParam.ASC);
        param.getOrderMap().put("create_time", QueryParam.ASC);

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubcontractEconomicEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SubcontractEconomicVO> subcontractEconomicVOList = BeanMapper.mapList(list, SubcontractEconomicVO.class);
        for (int i = 0; i < subcontractEconomicVOList.size(); i++) {
            SubcontractEconomicVO subcontractEconomicVO = subcontractEconomicVOList.get(i);
            subcontractEconomicVO.setSort(String.valueOf(i + 1));
            if (subcontractEconomicVO.getSubcontractingSubmissionDate() != null) {
                subcontractEconomicVO.setSubcontractingSubmissionDate(DateUtil.date(subcontractEconomicVO.getSubcontractingSubmissionDate()));
            }
            String billStateStr = subcontractEconomicVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                subcontractEconomicVO.setBillStateStr(billStateStr);
            }

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", subcontractEconomicVOList);
        ExcelExport.getInstance().export("SubcontractEconomic-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSubcontractEconomicData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubcontractEconomicVO>> refSubcontractEconomicData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("contractId")!=null){
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }

            if(_con.get("happenDate")!=null){
                String happenDate = _con.get("happenDate").toString();
                String s = "DATE_FORMAT(subcontracting_submission_date, '%Y-%m') = '" + happenDate + "'";
                param.getParams().put("subcontractingSubmissionDate", new Parameter(QueryParam.SQL, s));
            }

        }

        //审批通过
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        //未删除
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));

        IPage<SubcontractEconomicEntity> page = service.queryPage(param,false);
        IPage<SubcontractEconomicVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractEconomicVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 供方列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refSupplierPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplierPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText){
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

            if(_con.get("projectId")!=null){
                projectId = Long.valueOf(_con.get("projectId").toString());
            }
        }
        List<Long> ids = service.queryIds(projectId);
        List<SupplierVO> supplierVOS = service.querySupplier(ids);
        IPage<SupplierVO> pageData = new Page<>();;
        pageData.setRecords(supplierVOS);
        return CommonResponse.success("查询成功！", pageData);

//        IPage<ProSignReserveEntity> page = service.queryPage(param,false);
//        IPage<ProSignReserveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        List<ProSignReserveVO> proSignReserveVOS = BeanMapper.mapList(page.getRecords(), ProSignReserveVO.class);
//        List<ProSignReserveVO> newList = service.dealData(proSignReserveVOS);
//        pageData.setRecords(newList);
//
//        return CommonResponse.success("查询列表数据成功！",pageData);


    }

}
