package com.ejianc.business.middlemeasurement.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.vo.ContractSupplierVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 分包月度报量及申请报告
 *
 * @author generator
 *
 */
public interface ISubcontractingvolumeService extends IBaseService<SubcontractingvolumeEntity> {
    /**
     * 根据合同id查询以往所有的分包月度报量及申请报告的汇总数据
     * @param contractId 合同id
     * @return
     */
    List<SettlementBookStatementDetailVO> querySubcontractingvolumeDetailByContractId(Long contractId);
    /**
     * 根据合同id查询以往所有的分包月度报量及申请报告的物资超用扣款明细数据
     * @param contractId 合同id
     * @return
     */
    List<SettlementBookMaterialDetailVO> querySubcontractingvolumeMaterialByContractId(Long contractId);
    /**
     * 根据合同id查询以往所有的分包月度报量及申请报告的其他扣款数据
     * @param contractId 合同id
     * @return
     */
    List<SettlementBookOtherDetailVO> querySubcontractingvolumeOtherByContractId(Long contractId);

    /**
     * 更新单据数据的归集状态
     * @param projectId  项目id
     * @param state     状态
     * @return
     */
    boolean updateSettlementState(Long projectId,Integer state,String monthStr);
    /***
     * @Description //TODO 查询单据数据是否被月度成本分析归集
     *
     * @param projectId 项目id
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean queryIsSettlement(Long projectId,String monthStr);
    /***
     * @Description //TODO
     * 查询分包月度报量及申请报告明细往期数据
     * @param contractId 合同id
     * @param monthStr   报量日期  格式化为 yyyy-MM
     * @param code      子表编码
     * @param section   子表区段
     * @return java.util.List<com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO>
     * @createDate 2023/2/3
     * @author yupengjie
     **/
    List<SubcontractingvolumedetailVO> querySubcontractingvolumedetail(String contractId,String monthStr,String code,String section);

    //查询工程分包结算书是否有该项目数据
    List<SubcontractingvolumedetailVO> querySettleBook(Long contractId);


    List<ContractSupplierVO> getContractData(Page param , QueryWrapper wrapper, String startDate, String endDate, Long projectId);
}
