package com.ejianc.business.middlemeasurement.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractaccountEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import net.bytebuddy.description.ByteCodeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service("engineermeasurement") 
public class EngineermeasurementBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IEngineermeasurementService service;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private CostanalysisApi costanalysisApi;
	@Autowired
	private IParamConfigApi paramConfigApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
//		QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
//		queryWrapper.eq("id",billId);
//		EngineermeasurementEntity entity = service.getOne(queryWrapper);
//		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity.getProjectId(), entity.getReportingTime());
//		if(generate.isSuccess() && generate.getData()){
//			return CommonResponse.error("该单据所属项目与月份已生成月度分析报告，不可提交！");
//		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
//		QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
//		queryWrapper.eq("id",billId);
//		EngineermeasurementEntity entity = service.getOne(queryWrapper);
//		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity.getProjectId(), entity.getReportingTime());
//		if(generate.isSuccess() && generate.getData()){
//			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
//		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
//		QueryWrapper<EngineermeasurementEntity> queryWrapper1 = new QueryWrapper<>();
//		queryWrapper1.eq("id",billId);
//		EngineermeasurementEntity entity1 = service.getOne(queryWrapper1);
//		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity1.getProjectId(), entity1.getReportingTime());
//		if(generate.isSuccess() && generate.getData()){
//			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
//		}
		//工程计量台账：本单据
		EngineermeasurementEntity entity = service.selectById(billId);
		Long contractId = entity.getContractId();//合同id

		//只能弃审最新的单据
		QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", contractId);
		queryWrapper.eq("dr", 0);
		queryWrapper.orderByDesc("create_time");
		queryWrapper.last("limit 1");
		List<EngineermeasurementEntity> pro = service.list(queryWrapper);
		if(pro != null && pro.size() > 0){
			EngineermeasurementEntity resEntity = pro.get(0);
			Integer billState = resEntity.getBillState();
			if(!billId.equals(resEntity.getId())){//本单据不是最新
				if(billState == 1 || billState == 3){
					return CommonResponse.error("只能弃审该合同下最后一次做的已生效单据！");
				}else {
					return CommonResponse.error("已存在一个审批中或自由态的最新单据，不允许弃审！");
				}
			}
		}
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if (!resp.isSuccess()) {
			logger.info("工程计量台账【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}", billId, billTypeCode, resp.getMsg());
			return CommonResponse.error(resp.getMsg());
		}

		//报表已生成, 数据已被抓取的不能撤回
		CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode("P-P29C0z0304");
		if (!byCode.isSuccess()){
			throw new BusinessException("获取参数失败");
		}
		ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
		String valueData = paramRegisterSetVO.getValueData();
		logger.info("valueData---"+valueData);
		Date reportingTime = entity.getReportingTime();
		//获取对应数据的报表生成日期
		Calendar calendar = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		calendar.setTime(reportingTime);
		calendar.add(Calendar.MONTH, 1);
		Date date = calendar.getTime();
		String period = sdf.format(date);
		String limit = period + "-"+valueData;
		logger.info("limit---"+valueData);
		SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
		try {
			Date limitDate = ft.parse(limit);
			if (new Date().after(limitDate)){
				return CommonResponse.error("当前单据已生成运营分析报表,不能撤回!");
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
