package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.MechanicalleasedetotalMapper;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetotalEntity;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetotalService;

import java.util.List;

/**
 * 月度机械设备租赁结算汇总
 * 
 * @author generator
 * 
 */
@Service("mechanicalleasedetotalService")
public class MechanicalleasedetotalServiceImpl extends BaseServiceImpl<MechanicalleasedetotalMapper, MechanicalleasedetotalEntity> implements IMechanicalleasedetotalService{
    @Autowired
    private IMechanicalleasedetotalService service;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<MechanicalleasedetotalEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( statistical_time, '%Y-%m' )",monthStr);
        List<MechanicalleasedetotalEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (MechanicalleasedetotalEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<MechanicalleasedetotalEntity> query = new LambdaQueryWrapper<MechanicalleasedetotalEntity>()
                .eq(MechanicalleasedetotalEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(statistical_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(MechanicalleasedetotalEntity::getIsSettlement)
                        .or().eq(MechanicalleasedetotalEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("月度机械设备租赁结算汇总有往期未归集的数据");
        LambdaQueryWrapper<MechanicalleasedetotalEntity> query1 = new LambdaQueryWrapper<MechanicalleasedetotalEntity>()
                .eq(MechanicalleasedetotalEntity::getProjectId, projectId)
                .ne(MechanicalleasedetotalEntity::getBillState, 3)
                .ne(MechanicalleasedetotalEntity::getBillState, 1)
                .apply("DATE_FORMAT(statistical_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("月度机械设备租赁结算汇总有本期审批未通过的数据");
        return true;
    }
}
