package com.ejianc.business.middlemeasurement.service.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.vo.ContractSupplierVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.mapper.SubcontractingvolumeMapper;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.vo.SubcontractaccountPullVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import cn.hutool.core.collection.CollectionUtil;

/**
 * 分包月度报量及申请报告
 *
 * @author generator
 *
 */
@Service("subcontractingvolumeService")
public class SubcontractingvolumeServiceImpl extends BaseServiceImpl<SubcontractingvolumeMapper, SubcontractingvolumeEntity> implements ISubcontractingvolumeService {

	@Autowired
	private IOrgApi iOrgApi;
	@Autowired
	private ISubcontractingvolumeService service;
	@Autowired
	private ISubcontractingvolumedetailService subcontractingvolumedetailService;
	@Autowired
	private IOutcontractApi outcontractApi;
	@Autowired
	private SubcontractingvolumeMapper mapper;

	private void setDefaultValue(SubcontractingvolumedetailEntity entity) {
		if (entity.getQuantity() == null) {
			entity.setQuantity(new BigDecimal(0.0));
		}
		if (entity.getCumulativeQuantity() == null) {
			entity.setCumulativeQuantity(new BigDecimal(0.0));
		}
		if (entity.getCumulativeAmounts() == null) {
			entity.setCumulativeAmounts(new BigDecimal(0.0));
		}
		if (entity.getCumulativeTaxAmounts() == null) {
			entity.setCumulativeTaxAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineQuantity() == null) {
			entity.setExamineQuantity(new BigDecimal(0.0));
		}
		if (entity.getExamineAmounts() == null) {
			entity.setExamineAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineTaxAmounts() == null) {
			entity.setExamineTaxAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineCumulativeQuantity() == null) {
			entity.setExamineCumulativeQuantity(new BigDecimal(0.0));
		}
		if (entity.getExamineCumulativeAmounts() == null) {
			entity.setExamineCumulativeAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineCumulativeTaxAmounts() == null) {
			entity.setExamineCumulativeTaxAmounts(new BigDecimal(0.0));
		}
		BigDecimal cumulativeQuantity = new BigDecimal(0.0);
		BigDecimal cumulativeAmounts = new BigDecimal(0.0);
		BigDecimal cumulativeTaxAmounts = new BigDecimal(0.0);
		BigDecimal examineCumulativeQuantity = new BigDecimal(0.0);
		BigDecimal examineCumulativeAmounts = new BigDecimal(0.0);
		BigDecimal examineCumulativeTaxAmounts = new BigDecimal(0.0);
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper();
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("subitem_code", entity.getSubitemCode());
		List<SubcontractingvolumedetailEntity> list = subcontractingvolumedetailService.list(queryWrapper);
		if (!CollectionUtil.isEmpty(list)) {
			for (SubcontractingvolumedetailEntity subc : list) {
				cumulativeQuantity = cumulativeQuantity.add(subc.getQuantity());
				cumulativeAmounts = cumulativeAmounts.add(subc.getAmounts());
				cumulativeTaxAmounts = cumulativeTaxAmounts.add(subc.getTaxAmounts());
				examineCumulativeQuantity = examineCumulativeQuantity.add(subc.getExamineQuantity());
				examineCumulativeAmounts = examineCumulativeAmounts.add(subc.getExamineAmounts());
				examineCumulativeTaxAmounts = examineCumulativeTaxAmounts.add(subc.getExamineTaxAmounts());
			}
		}
		if (entity.getId() != null && entity.getId() > 0) {// 更新
			SubcontractingvolumedetailEntity oldEntity = subcontractingvolumedetailService.getById(entity.getId());
			cumulativeQuantity = oldEntity.getCumulativeQuantity().add(oldEntity.getQuantity().negate())
					.add(entity.getQuantity());
			cumulativeAmounts = oldEntity.getCumulativeAmounts().add(oldEntity.getAmounts().negate())
					.add(entity.getAmounts());
			cumulativeTaxAmounts = oldEntity.getCumulativeTaxAmounts().add(oldEntity.getTaxAmounts().negate())
					.add(entity.getTaxAmounts());

			examineCumulativeQuantity = oldEntity.getExamineCumulativeQuantity()
					.add(oldEntity.getExamineQuantity().negate()).add(entity.getExamineQuantity());
			examineCumulativeAmounts = oldEntity.getExamineCumulativeAmounts()
					.add(oldEntity.getExamineAmounts().negate()).add(entity.getExamineAmounts());
			examineCumulativeTaxAmounts = oldEntity.getExamineCumulativeTaxAmounts()
					.add(oldEntity.getExamineTaxAmounts().negate()).add(entity.getExamineTaxAmounts());
		} else {// 新增
			cumulativeQuantity = cumulativeQuantity.add(entity.getQuantity());
			cumulativeAmounts = cumulativeAmounts.add(entity.getAmounts());
			cumulativeTaxAmounts = cumulativeTaxAmounts.add(entity.getTaxAmounts());
			examineCumulativeQuantity = examineCumulativeQuantity.add(entity.getExamineQuantity());
			examineCumulativeAmounts = examineCumulativeAmounts.add(entity.getExamineAmounts());
			examineCumulativeTaxAmounts = examineCumulativeTaxAmounts.add(entity.getExamineTaxAmounts());
		}
		entity.setCumulativeQuantity(cumulativeQuantity);
		entity.setCumulativeAmounts(cumulativeAmounts);
		entity.setCumulativeTaxAmounts(cumulativeTaxAmounts);
		entity.setExamineCumulativeQuantity(examineCumulativeQuantity);
		entity.setExamineCumulativeAmounts(examineCumulativeAmounts);
		entity.setExamineCumulativeTaxAmounts(examineCumulativeTaxAmounts);
	}


	@Transactional
	@Override
	public boolean saveOrUpdate(SubcontractingvolumeEntity entity, boolean syncEs) {
		return super.saveOrUpdate(entity, syncEs);
	}

	@Override
	public List<SettlementBookStatementDetailVO> querySubcontractingvolumeDetailByContractId(Long contractId) {
		return mapper.querySubcontractingvolumeDetailByContractId(contractId);
	}

	@Override
	public List<SettlementBookMaterialDetailVO> querySubcontractingvolumeMaterialByContractId(Long contractId) {
		return mapper.querySubcontractingvolumeMaterialByContractId(contractId);
	}

	@Override
	public List<SettlementBookOtherDetailVO> querySubcontractingvolumeOtherByContractId(Long contractId) {
		return mapper.querySubcontractingvolumeOtherByContractId(contractId);
	}

	@Override
	public boolean updateSettlementState(Long projectId, Integer state,String monthStr) {
		boolean flag = true;
		QueryWrapper<SubcontractingvolumeEntity> query = new QueryWrapper();
		query.eq("project_id",projectId);
		query.eq("DATE_FORMAT( reporting_time, '%Y-%m' )",monthStr);
		List<SubcontractingvolumeEntity> list = service.list(query);
		if (!list.isEmpty()){
			for (SubcontractingvolumeEntity entity : list) {
				entity.setIsSettlement(state);
			}
			flag = service.updateBatchById(list);
		}
		return flag;
	}

	@Override
	public boolean queryIsSettlement(Long projectId, String monthStr) {

		LambdaQueryWrapper<SubcontractingvolumeEntity> query = new LambdaQueryWrapper<SubcontractingvolumeEntity>()
				.eq(SubcontractingvolumeEntity::getProjectId, projectId)
				.apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'")
				.and(qw -> qw.isNull(SubcontractingvolumeEntity::getIsSettlement)
						.or().eq(SubcontractingvolumeEntity::getIsSettlement, 0));
		int count = service.count(query);
		if (count > 0) throw new BusinessException("分包中间计量有往期未归集的数据");
		LambdaQueryWrapper<SubcontractingvolumeEntity> query1 = new LambdaQueryWrapper<SubcontractingvolumeEntity>()
				.eq(SubcontractingvolumeEntity::getProjectId, projectId)
				.ne(SubcontractingvolumeEntity::getBillState, 3)
				.ne(SubcontractingvolumeEntity::getBillState, 1)
				.apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'");
		int count1 = service.count(query1);
		if (count1 > 0) throw new BusinessException("分包中间计量有本期审批未通过的数据");
		return true;
	}

	@Override
	public List<SubcontractingvolumedetailVO> querySubcontractingvolumedetail(String contractId, String monthStr, String code, String section) {
		Map<String,String> map = new HashMap<>();
		map.put("contractId",contractId);
		map.put("reportingTime",monthStr);
		map.put("subitemCode",code);
		map.put("section",section);
		return mapper.querySubcontractingvolumedetail(map);
	}

	@Override
	public List<SubcontractingvolumedetailVO> querySettleBook(Long contractId) {
		return mapper.querySettleBook(contractId);
	}


	@Override
	public List<ContractSupplierVO> getContractData(Page param, QueryWrapper wrapper, String startDate, String endDate, Long projectId) {
		List<ContractSupplierVO> list = mapper.getContractData(param,wrapper,startDate,endDate,projectId);
		return list;
	}
}
