package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementPayeeDetailService;
import com.ejianc.business.middlemeasurement.utils.BigDecimalUtils;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementPayeeDetailVO;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;

/**
 * 工程计量台账
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("engineermeasurement")
public class EngineermeasurementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "middlemeasurement-engineermeasurement";//此处需要根据实际修改

    @Autowired
    private IEngineermeasurementService service;

    @Autowired
    private IEngineermeasurementPayeeDetailService payeeDetailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> saveOrUpdate(@RequestBody EngineermeasurementVO saveorUpdateVO) {

        //校验报量时间不能小于上一期生效的日期
        LambdaQueryWrapper<EngineermeasurementEntity> lambda = Wrappers.<EngineermeasurementEntity>lambdaQuery();
        lambda.eq(EngineermeasurementEntity::getProjectId, saveorUpdateVO.getProjectId());
        lambda.eq(EngineermeasurementEntity::getContractId, saveorUpdateVO.getContractId());
        lambda.in(EngineermeasurementEntity::getBillState, 1,3);
        lambda.orderByDesc(EngineermeasurementEntity::getId);
        List<EngineermeasurementEntity> costanalysisEntityList = service.list(lambda);
        if (CollectionUtils.isNotEmpty(costanalysisEntityList)){
            Date reportingTime = costanalysisEntityList.stream().findFirst().get().getReportingTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String formatDate = dateFormat.format(reportingTime);
            if (saveorUpdateVO.getReportingTime().before(reportingTime)){
                throw new BusinessException("报量时间不能小于同一个合同下最近一期生效的报量时间,最近一期生效的时间为:"+formatDate);
            }

        }




        //保存校验累计值
//查询该合同下往期数据
        QueryWrapper<EngineermeasurementEntity> queryLastWrapper = new QueryWrapper<>();
        queryLastWrapper.eq("contract_id", saveorUpdateVO.getContractId());
        queryLastWrapper.in("bill_state", 1,3);
        List<EngineermeasurementEntity> lastList = service.list(queryLastWrapper);
        BigDecimal lastActualMny = BigDecimal.ZERO;
        BigDecimal lastBatchMny = BigDecimal.ZERO;
        BigDecimal lastCollectionMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(lastList)){
            lastActualMny = lastList.stream().filter(s->s.getActualCompletedThisPeriod()!=null).map(EngineermeasurementEntity::getActualCompletedThisPeriod)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            lastBatchMny = lastList.stream().filter(s->s.getCurrentBatch()!=null).map(EngineermeasurementEntity::getCurrentBatch)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            lastCollectionMny = lastList.stream().filter(s->s.getCurrentCollection()!=null).map(EngineermeasurementEntity::getCurrentCollection)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
//计算汇总本期值
        BigDecimal actualMny = lastActualMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getActualCompletedThisPeriod()));
        BigDecimal batchMny = lastBatchMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getCurrentBatch()));
        BigDecimal collectionMny = lastCollectionMny.add(BigDecimalUtils.ofNullable(saveorUpdateVO.getCurrentCollection()));
//比较前端传的累计值和后台汇总的累计值是否一致
        logger.info("actualMny---"+actualMny);
        logger.info("cumulativeCompleted---"+saveorUpdateVO.getCumulativeCompleted());
        if(ComputeUtil.safeSub(actualMny,saveorUpdateVO.getCumulativeCompleted()).compareTo(new BigDecimal(0.1)) == 1){
            throw new BusinessException("累计实际完成量计算有误, 无法保存!");
        }
        if(ComputeUtil.safeSub(batchMny,saveorUpdateVO.getCumulativeBatch()).compareTo(new BigDecimal(0.1)) == 1){
            throw new BusinessException("累计批量计算有误, 无法保存!");
        }
        if(ComputeUtil.safeSub(collectionMny,saveorUpdateVO.getCumulativeCollection()).compareTo(new BigDecimal(0.1)) == 1){
            throw new BusinessException("累计收款金额计算有误, 无法保存!");
        }

        //补全二级组织信息
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(saveorUpdateVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
        if (orgVo.isSuccess() && null != orgVo.getData()) {
            String innerCode = orgVo.getData().getInnerCode();
            String[] strs = innerCode.split("\\|");
            CommonResponse<OrgVO> orgVos = iOrgApi.detailById(Long.parseLong(strs[1]));
            if (orgVos.isSuccess() && null != orgVos.getData()) {
                //二级组织信息
                saveorUpdateVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
            }
        }

//获取项目创建时间
        CommonResponse<ProjectVO> projectVOCommonResponse = zjkjProjectApi.queryDetailById(saveorUpdateVO.getProjectId());
        if(!projectVOCommonResponse.isSuccess()){
            throw new BusinessException("获取项目信息失败");
        }
        ProjectVO projectVO = projectVOCommonResponse.getData();
        saveorUpdateVO.setProjectCreateTime(projectVO.getCreateTime());

    	EngineermeasurementEntity entity = BeanMapper.map(saveorUpdateVO, EngineermeasurementEntity.class);
        //校验：同一合同，只能存在一份自由态或审批中的单据
        checkBillStateUniq(entity.getId(), entity.getContractId());
        //校验：单据编号唯一性
        entity = checkBillCodeUniq(entity);
        //累计（包含本期）
        //entity = handleCumulative(entity);
    	service.saveOrUpdate(entity, false);
    	EngineermeasurementVO vo = BeanMapper.map(entity, EngineermeasurementVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 新增 付款信息
     */
    @RequestMapping(value = "/savePayeeDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EngineermeasurementPayeeDetailVO> savePayeeDetail(@RequestBody EngineermeasurementPayeeDetailVO saveOrUpdateVO){
        EngineermeasurementPayeeDetailEntity detailEntity = new EngineermeasurementPayeeDetailEntity();
        detailEntity.setNowPaymentMny(saveOrUpdateVO.getNowPaymentMny());
        detailEntity.setPaymentTime(saveOrUpdateVO.getPaymentTime());
        detailEntity.setPid(saveOrUpdateVO.getId());
        detailEntity.setAdvancePaymentMoney(saveOrUpdateVO.getAdvancePaymentMoney());
        payeeDetailService.saveOrUpdate(detailEntity);
        EngineermeasurementEntity entity = service.selectById(saveOrUpdateVO.getId());

        //查询所有付款信息数据求和汇总
        LambdaQueryWrapper<EngineermeasurementPayeeDetailEntity> lambda = Wrappers.<EngineermeasurementPayeeDetailEntity>lambdaQuery();
        lambda.eq(EngineermeasurementPayeeDetailEntity::getPid, saveOrUpdateVO.getId());
        List<EngineermeasurementPayeeDetailEntity> engineermeasurementPayeeDetailEntities = payeeDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(engineermeasurementPayeeDetailEntities)){
            BigDecimal nowPaymentMny = engineermeasurementPayeeDetailEntities.stream().filter(s->s.getNowPaymentMny()!=null).map(EngineermeasurementPayeeDetailEntity::getNowPaymentMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setCurrentCollection(nowPaymentMny);
        }

        //设置累计收款金额
        LambdaQueryWrapper<EngineermeasurementEntity> query = new LambdaQueryWrapper<EngineermeasurementEntity>();
        query.eq(EngineermeasurementEntity::getProjectId, entity.getProjectId());
        query.eq(EngineermeasurementEntity::getContractId, entity.getContractId());
        query.ne(EngineermeasurementEntity::getId, entity.getId());
        query.in(EngineermeasurementEntity::getBillState, 1,3);

        List<EngineermeasurementEntity> engineermeasurementEntityList = service.list(query);
        BigDecimal currentCollection = engineermeasurementEntityList.stream().filter(s -> s.getId() < entity.getId() && s.getCurrentCollection() != null).map(EngineermeasurementEntity::getCurrentCollection)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setCumulativeCollection(ComputeUtil.safeAdd(entity.getCurrentCollection(),currentCollection));

        service.saveOrUpdate(entity);

        return CommonResponse.success("保存或修改单据成功！");
    }
    /**
     * @Description saveOrUpdate 查询是否能填写收款信息
     */
    @RequestMapping(value = "/getPayFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> getPayFlag(Long id){

        EngineermeasurementEntity engineermeasurementEntity = service.selectById(id);
        LambdaQueryWrapper<EngineermeasurementEntity> lambda = Wrappers.<EngineermeasurementEntity>lambdaQuery();
        lambda.gt(EngineermeasurementEntity::getId, id);
        lambda.eq(EngineermeasurementEntity::getProjectId, engineermeasurementEntity.getProjectId());
        lambda.eq(EngineermeasurementEntity::getContractId, engineermeasurementEntity.getContractId());
        lambda.in(EngineermeasurementEntity::getBillState, 1,3);
        List<EngineermeasurementEntity> costanalysisEntityList = service.list(lambda);
        Boolean b = true;
        if (CollectionUtils.isNotEmpty(costanalysisEntityList)){
            b = false;
        }
        return CommonResponse.success(b);
    }

    /**
     * 累计（包含本期）
     * @param entity
     * @return
     */
    private EngineermeasurementEntity handleCumulative(EngineermeasurementEntity entity) {
        Date currentDate = new Date(System.currentTimeMillis());
        if(entity.getCreateTime() != null){
            currentDate = entity.getCreateTime();
        }
        //获取往期
        EngineermeasurementVO pastVo = getPastTotalData(entity.getContractId(), currentDate);
        //本期 + 往期
        BigDecimal cumulativeCompleted = pastVo.getCumulativeCompleted();//累计实际完成量
        if(cumulativeCompleted != null && entity.getActualCompletedThisPeriod() != null){
            cumulativeCompleted = entity.getActualCompletedThisPeriod().add(cumulativeCompleted);
        }

        BigDecimal cumulativeBatch = pastVo.getCumulativeBatch();//累计批量
        if(cumulativeBatch != null && entity.getCurrentBatch() != null){
            cumulativeBatch = entity.getCurrentBatch().add(pastVo.getCumulativeBatch());
        }
        //计算本期应收金额 = 汇总子表合同约定应收款金额字段数据
        BigDecimal sumAmountAgreedReceivables = BigDecimal.ZERO;
        BigDecimal sumAmountCollected = BigDecimal.ZERO;
        List<EngineermeasurementdetailEntity> list = entity.getEngineermeasurementdetailEntities();
        if (!list.isEmpty()){
            for (EngineermeasurementdetailEntity engineermeasurementdetailEntity : list) {
                //计算子表合同约定收款金额
                sumAmountAgreedReceivables = sumAmountAgreedReceivables.add(engineermeasurementdetailEntity.getAmountAgreedReceivables());
                //计算子表本期收款金额合计
                sumAmountCollected = sumAmountCollected.add(engineermeasurementdetailEntity.getAmountCollected());
            }
        }
        //写入子表合同约定收款金额到主表合同约定本期应收金额字段
        entity.setCurrentReceivables(sumAmountAgreedReceivables);
        //写入子表本期收款金额合计到主表的本期收款金额字段
        entity.setCurrentCollection(sumAmountCollected);
        //写入累计合同约定应收金额 = 本期合同约定应收金额+往期合同约定应收金额
        entity.setAccumulatedContractualReceivables(entity.getCurrentReceivables().add(pastVo.getAccumulatedContractualReceivables()));
        //写入累计收款金额 = 本期收款金额 + 往期收款金额
        entity.setCumulativeCollection(entity.getCurrentCollection().add(pastVo.getCumulativeCollection()));
        entity.setCumulativeCompleted(cumulativeCompleted);
        entity.setCumulativeBatch(cumulativeBatch);

        //累计完成比例：累计实际完成量/合同额
        BigDecimal contractAmount = entity.getContractAmount();//合同金额
        if(cumulativeCompleted != null && contractAmount != null && contractAmount.compareTo(BigDecimal.ZERO) != 0 ){
            BigDecimal cumulativeCompletedProportion = cumulativeCompleted.divide(contractAmount, 8, BigDecimal.ROUND_HALF_UP);
            cumulativeCompletedProportion = cumulativeCompletedProportion.multiply(new BigDecimal(100));
            entity.setCumulativeCompletedProportion(cumulativeCompletedProportion);
        }

        return entity;
    }

    /**
     * 同一合同，只能存在一份自由态或审批中的单据
     * @param id
     * @param contractId
     */
    private void checkBillStateUniq(Long id, Long contractId) {
        //创建条件构造器
        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
        queryWrapper.eq("dr", "0");
        if(id != null){
            queryWrapper.ne("id", id);
        }
        List<EngineermeasurementEntity> pro = service.list(queryWrapper);
        if(pro != null && pro.size() > 0){
            throw new BusinessException("同一合同只能存在一份自由态或审批中的\"工程计量台账单据\"!");
        }
    }

    /**
     * 单据编码唯一性校验
     * @param entity
     */
    private EngineermeasurementEntity checkBillCodeUniq(EngineermeasurementEntity entity) {
        if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //单据编码唯一性
            QueryWrapper<EngineermeasurementEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            Long id = entity.getId();
            if(id != null){
                queryWrapperBillCode.ne("id", id);
            }
            List<EngineermeasurementEntity> proBillCode = service.list(queryWrapperBillCode);
            if(proBillCode != null && proBillCode.size() > 0){
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }

        return entity;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> queryDetail(Long id) {
    	EngineermeasurementEntity entity = service.selectById(id);
    	EngineermeasurementVO vo = BeanMapper.map(entity, EngineermeasurementVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * 刷新累计数据接口
     *
     */
    @RequestMapping(value = "/updateSumData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateSumData(Long projectId, Long contractId,Integer type) {
        service.updateSumData(projectId,contractId,type);
        return CommonResponse.success("更新成功！");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EngineermeasurementVO> vos) {
        service.removeByIds(vos.stream().map(EngineermeasurementVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EngineermeasurementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getOrderMap().put("org_status_order", QueryParam.ASC);
        param.getOrderMap().put("project_create_time", QueryParam.ASC);
        param.getOrderMap().put("create_time", QueryParam.ASC);

        IPage<EngineermeasurementEntity> page = service.queryPage(param,false);
        IPage<EngineermeasurementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngineermeasurementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getOrderMap().put("org_status_order", QueryParam.ASC);
        param.getOrderMap().put("project_create_time", QueryParam.ASC);
        param.getOrderMap().put("create_time", QueryParam.ASC);
        List<EngineermeasurementEntity> list = service.queryList(param);
        //时间转换
        List<EngineermeasurementVO> engineermeasurementVOList = BeanMapper.mapList(list, EngineermeasurementVO.class);
        for (int i = 0; i < engineermeasurementVOList.size(); i++) {
            EngineermeasurementVO engineermeasurementVO = engineermeasurementVOList.get(i);
            engineermeasurementVO.setSort(String.valueOf(i+1));
            if (engineermeasurementVO.getReportingTime()!=null){
                engineermeasurementVO.setReportingTimeShow(DateUtils.dateSimple2(engineermeasurementVO.getReportingTime()));
            }

            String billStateStr = engineermeasurementVO.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                engineermeasurementVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", engineermeasurementVOList);
        ExcelExport.getInstance().export("EngineermeasurementMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refEngineermeasurementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EngineermeasurementVO>> refEngineermeasurementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EngineermeasurementEntity> page = service.queryPage(param,false);
        IPage<EngineermeasurementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngineermeasurementVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * @Description  查询上期单据
     * @param contractId
     */
    @RequestMapping(value = "/lastTotalMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngineermeasurementEntity> lastTotalMny(Long projectId, Long contractId){
        List<EngineermeasurementEntity> entityList = service.list(new QueryWrapper<EngineermeasurementEntity>().eq("project_id", projectId).eq("contract_id", contractId).in("bill_state",1,3).orderByDesc("create_time").last("limit 1"));
        EngineermeasurementEntity entity = new EngineermeasurementEntity();
        if (CollectionUtils.isNotEmpty(entityList)) {
            for (EngineermeasurementEntity engineermeasurementEntity : entityList) {
                entity = engineermeasurementEntity;
            }
        }
        return CommonResponse.success("查询上期单据数据成功！", entity);
    }

    /**
     * @Description  查询往期
     * @param contractId
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> pastData(Long id, Long contractId) {
        //校验：同一合同，只能存在一份自由态或审批中的单据
        checkBillStateUniq(id, contractId);

        //本期日期
        Date currentDate = new Date(System.currentTimeMillis());
        if(id != null && "".equals(id)){//更新
            EngineermeasurementEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId 合同id
     * @param currentDate 本期日期
     */
    private EngineermeasurementVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器
        QueryWrapper<EngineermeasurementEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<EngineermeasurementEntity> proTotal = service.list(queryWrapperTotal);
        //累计合同约定应收金额
        BigDecimal sumCurrentReceivables = BigDecimal.ZERO;
        //累计实际完成量
        BigDecimal cumulativeCompleted = new BigDecimal(0);
        //累计批量
        BigDecimal cumulativeBatch = new BigDecimal(0);
        //累计收款金额
        BigDecimal cumulativeCollection = new BigDecimal(0);
        if(proTotal != null && proTotal.size() > 0){
            for (int i = 0; i < proTotal.size(); i++) {
                EngineermeasurementEntity engineermeasurementEntity = proTotal.get(i);
                cumulativeCompleted = cumulativeCompleted.add(engineermeasurementEntity.getActualCompletedThisPeriod());
                cumulativeBatch = cumulativeBatch.add(engineermeasurementEntity.getCurrentBatch());
                cumulativeCollection = cumulativeCollection.add(engineermeasurementEntity.getCurrentCollection());
                sumCurrentReceivables = sumCurrentReceivables.add(engineermeasurementEntity.getCurrentReceivables());
            }
        }
        EngineermeasurementVO vo = new EngineermeasurementVO();
        vo.setCumulativeCompleted(cumulativeCompleted);
        vo.setCumulativeBatch(cumulativeBatch);
        vo.setCumulativeCollection(cumulativeCollection);
        vo.setContractId(contractId);
        vo.setAccumulatedContractualReceivables(sumCurrentReceivables);
        return vo;
    }

    /**
     * 查找合同相关的累计超（滞）付款项总额
     * @param contractId
     * @param date
     * @return
     */
    @RequestMapping(value = "/queryOverpayment", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String,BigDecimal>> getTotalAccumulatedOverpayment(@RequestParam(value = "contractId") Long contractId,@RequestParam(value = "date") String date) throws ParseException {
        Map<String,BigDecimal> map = new HashMap<>();
        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("contract_id",contractId);
        queryWrapper.in("bill_state", 1, 3);//3审批通过
        queryWrapper.le("reporting_time",date);
        queryWrapper.orderByDesc("reporting_time");
        List<EngineermeasurementEntity> list = service.list(queryWrapper);
        //汇总累计合同收款金额
        BigDecimal sumCurrentCollection = BigDecimal.ZERO;
        if (!list.isEmpty()){
            for (EngineermeasurementEntity entity : list) {
                sumCurrentCollection = sumCurrentCollection.add(entity.getCurrentCollection());
            }
            EngineermeasurementEntity engineermeasurementEntity = list.get(0);
            //累计超（滞）付款项总额 = 汇总合同约定收款金额  -  汇总收款金额
            BigDecimal overpayment = engineermeasurementEntity.getAccumulatedContractualReceivables()
                    .subtract(engineermeasurementEntity.getCumulativeCollection());
            map.put("overpayment",overpayment);
        }else {
            map.put("overpayment",BigDecimal.ZERO);
        }
        map.put("sumCurrentCollection",sumCurrentCollection);
        return CommonResponse.success("查询累计超（滞）付款项总额成功",map);
    }
}
