package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesummaryEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesummaryService;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("purchasesummary") 
public class PurchasesummaryBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IPurchasesummaryService service;

	@Autowired
	private CostanalysisApi costanalysisApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		QueryWrapper<PurchasesummaryEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("id",billId);
		PurchasesummaryEntity entity = service.getOne(queryWrapper);
		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity.getProjectId(), entity.getStatisticalTime());
		if(generate.isSuccess() && generate.getData()){
			return CommonResponse.error("该单据所属项目与月份已生成月度分析报告，不可提交！");
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		QueryWrapper<PurchasesummaryEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("id",billId);
		PurchasesummaryEntity entity = service.getOne(queryWrapper);
		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity.getProjectId(), entity.getStatisticalTime());
		if(generate.isSuccess() && generate.getData()){
			logger.info("接口调用成功:返回结果为={}" + generate.getData());
			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		QueryWrapper<PurchasesummaryEntity> queryWrapper1 = new QueryWrapper<>();
		queryWrapper1.eq("id",billId);
		PurchasesummaryEntity entity1 = service.getOne(queryWrapper1);
		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity1.getProjectId(), entity1.getStatisticalTime());
		if(generate.isSuccess() && generate.getData()){
			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
		}

		PurchasesummaryEntity entity = service.selectById(billId);
		Long projectId = entity.getProjectId();//合同id

		//只能弃审最新的单据
		QueryWrapper<PurchasesummaryEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		queryWrapper.eq("dr", 0);
		queryWrapper.orderByDesc("create_time");
		queryWrapper.last("limit 1");
		List<PurchasesummaryEntity> pro = service.list(queryWrapper);
		if(pro != null && pro.size() > 0){
			PurchasesummaryEntity resEntity = pro.get(0);
			Integer billState = resEntity.getBillState();
			if(!billId.equals(resEntity.getId())){//本单据不是最新
				if(billState == 1 || billState == 3){
					return CommonResponse.error("只能弃审该合同下最后一次做的已生效单据！");
				}else {
					return CommonResponse.error("已存在一个审批中或自由态的最新单据，不允许弃审！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
