package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasedetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.BigDecimalUtils;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.*;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 月度周转租赁单清单导入导出
 */
@Controller
@RequestMapping("revolvingleaseExport")
public class ExcelRevolvingleaseController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;

    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @Autowired
    private IRevolvingleaseService revolvingleaseService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadRevolvinglease", method = RequestMethod.POST)
    @ResponseBody
    public void downloadRevolvinglease(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "revolvingleasedetail-import.xlsx", "月度周转租赁单清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportRevolvinglease", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportRevolvinglease(HttpServletRequest request, HttpServletResponse response,Long contractId,Long projectId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, RevolvingleasedetailVO> mapVO = new HashMap<>();
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<RevolvingleasedetailVO> successList = new ArrayList<>();
        List<RevolvingleasedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            HashMap<String, String> map = new HashMap<>();

            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    int num1=0;
                    RevolvingleasedetailVO revolvingleasedetailVO = new RevolvingleasedetailVO();
                    CommonResponse<MaterialVO> back = null;
                    List<String> datas = result.get(i);
                    revolvingleasedetailVO.setId(IdWorker.getId());//id
                    revolvingleasedetailVO.setTid(String.valueOf(IdWorker.getId()));//tid

                    String encode = datas.get(0); //编码
                    String section = datas.get(1);// 区段
                    String branch = datas.get(2);//branch 分部分项目名称/子项目名称
                    String subitemDesc = datas.get(3); //子目特征描述

                    if (StringUtils.isBlank(encode)) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'编码'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    }else{
                        revolvingleasedetailVO.setEncode(StringUtils.isNotBlank(encode)?encode:null);
                    }

                    if (StringUtils.isNotBlank(encode)) {
                        revolvingleasedetailVO.setInnercode(encode+ "_" + section);//清单编号确定唯一性
//                        if ("01".equals(encode) && encode != null && encode.contains("装饰")) {
//                            revolvingleasedetailVO.setInnercode("a1"+ "_" + revolvingleasedetailVO.getSection());
//                        }
                        //判断是否是装饰工程的子节点编码
//                        if (encode.length() >= 4) {
//                            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
//                            String code = encode.substring(0, 4);
//                            if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
//                                //若是的话，将内码改为a1xx
//                                revolvingleasedetailVO.setInnercode("a1" + encode.substring(2, encode.length()) + "_" + section);
//                            }
//                        }
                        //1、校验编码是否符合规则--2、4、6、9、9以上
                        if (encode == null || !(encode.length() == 2 || encode.length() == 4 || encode.length() == 6 || encode.length() >= 9)) {
                            revolvingleasedetailVO.setErrorMsg("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则");
                            num1++;
                        }
                        revolvingleasedetailVO.setEncode(encode);
                        //重复性校验
                        RevolvingleasedetailVO reVo = mapVO.get(revolvingleasedetailVO.getInnercode());
                        if (reVo == null) {
                            mapVO.put(revolvingleasedetailVO.getInnercode(), revolvingleasedetailVO);
                        } else {
                            revolvingleasedetailVO.setErrorMsg("清单编号已存在！");
                            num1++;
                        }
                        revolvingleasedetailVO.setEncode(encode);
                    }

                    if (StringUtils.isBlank(section)) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'区段'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    }{
                        revolvingleasedetailVO.setSection(StringUtils.isNotBlank(section)?section:null);
                    }
                    if (StringUtils.isBlank(branch)) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'子目名称'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    }{
                        revolvingleasedetailVO.setBranch(StringUtils.isNotBlank(branch)?branch:null);
                    }
                    if (StringUtils.isBlank(subitemDesc)) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'子目特征描述'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    }{
                        revolvingleasedetailVO.setSubitemDesc(StringUtils.isNotBlank(subitemDesc)?subitemDesc:null);
                    }
                    if (StringUtils.isBlank(datas.get(4))) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'物资编码'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    }

                    //校验库中物资
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(4));
                    MaterialVO back0Data = back0.getData();
                    if (back0.getCode() == 1 || back0Data == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="未查询到该物资编码下的物资详情";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                        errorList.add(revolvingleasedetailVO);
                        continue;
                    }else{
                        revolvingleasedetailVO.setMaterialCode(StringUtils.isNotBlank(datas.get(4))?datas.get(4):null);
                        revolvingleasedetailVO.setLesseeMaterialsName(back0.getData().getName());
                        revolvingleasedetailVO.setSpecifications(back0.getData().getSpec());
                        revolvingleasedetailVO.setMeasurementUnit(back0.getData().getUnitName());
                    }

                    revolvingleasedetailVO.setMaterialCategoryId(back0.getData().getCategoryId());
                    revolvingleasedetailVO.setMaterialCategoryCode(back0.getData().getCode());
                    revolvingleasedetailVO.setMaterialCategoryName(back0.getData().getCategoryName());
                    BigDecimal num = new BigDecimal(0);

                    if (StringUtils.isBlank(datas.get(12)) || datas.get(12) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'租赁数量'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);


                        if (!NumberUtil.isNumber(datas.get(12))) {
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁数量'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);

                        }
                        num1++;
                    } else {
                        num = num.add(new BigDecimal((int) Float.parseFloat(datas.get(12))));
                        revolvingleasedetailVO.setLesseeQuantity(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); //  租赁数量
                    }

                    if (StringUtils.isNotBlank(datas.get(8)) && datas.get(8) != null) {
                        //revolvingleasedetailVO.setSettleTime(DateUtils.Date(datas.get(10))); // 本期计算起始时间
                        if (!DateUtils.grepDate(datas.get(8))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'本期计算起始时间'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else {
                            revolvingleasedetailVO.setSettleTime(DateUtils.Date(datas.get(8))); // 本期计算起始时间

                        }
                    } else {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'本期计算起始时间'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    }

                    if (StringUtils.isNotBlank(datas.get(9)) && datas.get(9) != null) {
//                        revolvingleasedetailVO.setEndTime(DateUtils.Date(datas.get(9))); //本期计算终止时间
                        if (!DateUtils.grepDate(datas.get(9))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'本期计算终止时间'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            revolvingleasedetailVO.setEndTime(DateUtils.Date(datas.get(9))); //本期计算终止时间
                        }
                    } else {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'本期计算终止时间'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    }

                    BigDecimal dayValue = new BigDecimal(0);
                 /*   if (StringUtils.isNotBlank(datas.get(10)) && datas.get(10) != null) {
                        Integer value = Integer.valueOf((int) Float.parseFloat(datas.get(10)));
                        if (!NumberUtil.isNumber(datas.get(10))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'本期租赁期长(天)'输入格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        } else {
                            revolvingleasedetailVO.setLesseeTerm(StringUtils.isNotBlank(datas.get(10)) ? value : null);//  本期租赁期长(天)
                            dayValue = dayValue.add(new BigDecimal(value));
                            revolvingleasedetailVO.setTaxLesseeUnitprice(dayValue);
                        }
                        revolvingleasedetailVO.setLesseeTerm(Integer.valueOf((int) value));
                    } else {
                        if(StringUtils.isNotBlank(datas.get(9)) && datas.get(9) != null&&StringUtils.isNotBlank(datas.get(8)) && datas.get(8) != null){
                        long between = DateUtil.between(DateUtils.Date(datas.get(8)), DateUtils.Date(datas.get(9)), DateUnit.DAY);
                        dayValue = new BigDecimal((int) between);
                        revolvingleasedetailVO.setLesseeTerm(Integer.valueOf((int) between)+1);}
                    }*/
                    DateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
                    try {

                        Date star = dft.parse(DateUtils.ExcelDoubleToDate(datas.get(8)));//开始时间
                        Date endDay=dft.parse(DateUtils.ExcelDoubleToDate(datas.get(9)));//结束时间
                        Long starTime=star.getTime();
                        Long endTime=endDay.getTime();
                        Long nums=endTime-starTime;//时间戳相差的毫秒数
                        Long day = (nums/24/60/60/1000)+1;
                        revolvingleasedetailVO.setLesseeTerm(Integer.parseInt(day.toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }

                    BigDecimal exUnitPrice = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(13)) && datas.get(13) != null) {
                        if (!NumberUtil.isNumber(datas.get(13))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁单价(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            exUnitPrice = exUnitPrice.add(new BigDecimal(datas.get(13)));
                            revolvingleasedetailVO.setLesseeUnitprice(exUnitPrice);// 租赁单价(除税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setLesseeUnitprice(null);
                    }

                    BigDecimal inUnitPrice = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(14)) && datas.get(14) != null) {
                        if (!NumberUtil.isNumber(datas.get(14))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁单价(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            inUnitPrice = inUnitPrice.add(new BigDecimal(datas.get(14)));
                            revolvingleasedetailVO.setTaxLesseeUnitprice(inUnitPrice);// 租赁单价(含税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setTaxLesseeUnitprice(null);
                    }

       /*             BigDecimal exTotal = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(15)) && datas.get(15) != null) {
                        if (!NumberUtil.isNumber(datas.get(15))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁合价(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            exTotal = exTotal.add(num.multiply(dayValue).multiply(inUnitPrice));
                            revolvingleasedetailVO.setLesseeTotalprice(num.multiply(dayValue).multiply(exUnitPrice));// 租赁合价(除税)(元)
                        }
                    }else{

                    } */ //计算租赁合价(除税) = 租赁数量 * 租赁天数 * 租赁单价(除税)
                    BigDecimal lesseeTotalprice = (revolvingleasedetailVO.getLesseeQuantity() == null ? BigDecimal.ZERO : revolvingleasedetailVO.getLesseeQuantity())
                            .multiply(new BigDecimal(revolvingleasedetailVO.getLesseeTerm() == null ? 0 : revolvingleasedetailVO.getLesseeTerm()))
                            .multiply(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getLesseeUnitprice()));
                    revolvingleasedetailVO.setLesseeTotalprice(lesseeTotalprice);

                /*    BigDecimal inTotal = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(16)) && datas.get(16) != null) {
                        if (!NumberUtil.isNumber(datas.get(16))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁合价(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            inTotal = inTotal.add(num.multiply(dayValue).multiply(inUnitPrice));
                            revolvingleasedetailVO.setTaxLesseeTotalprice(num.multiply(dayValue).multiply(inUnitPrice));// 租赁合价(含税)(元)
                        }
                    }else{

                    }*/
                    //计算租赁合价(除税) = 租赁数量 * 租赁天数 * 租赁单价(除税)
                    BigDecimal taxLesseeTotalprice = (revolvingleasedetailVO.getLesseeQuantity() == null ? BigDecimal.ZERO  : revolvingleasedetailVO.getLesseeQuantity())
                                .multiply(new BigDecimal(revolvingleasedetailVO.getLesseeTerm() == null ? 0 : revolvingleasedetailVO.getLesseeTerm()))
                                .multiply(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getTaxLesseeUnitprice()));
                        revolvingleasedetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);

                        BigDecimal findNum = new BigDecimal(0);
                        if (StringUtils.isBlank(datas.get(17)) || datas.get(17) == null) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'丢失损坏量'不能为空";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                    } else {
                        if (!NumberUtil.isNumber(datas.get(17))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'丢失损坏量'输入格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            findNum = findNum.add(new BigDecimal(datas.get(17)));
                            revolvingleasedetailVO.setLossDamage(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : null);// 丢失损坏量
                        }
                    }

                    BigDecimal pexUnitPrice = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(18)) || datas.get(18) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'赔偿单价(除税)(元)'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    } else {
                        if (!NumberUtil.isNumber(datas.get(18))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'赔偿单价(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            pexUnitPrice = pexUnitPrice.add(new BigDecimal(datas.get(18)));
                            revolvingleasedetailVO.setCompensateUnitprice(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : null);// 赔偿单价(除税)(元)
                        }
                     }

                    BigDecimal pinUnitPrice = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(19)) || datas.get(19) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'赔偿单价(含税)(元)'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    } else {
                        if (!NumberUtil.isNumber(datas.get(19))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'赔偿单价(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            pinUnitPrice = pinUnitPrice.add(new BigDecimal(datas.get(19)));
                            revolvingleasedetailVO.setTaxCompensateUnitprice(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) : null);// 赔偿单价(含税)(元)
                        }
                    }

                /*    BigDecimal exAmount = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(20)) || datas.get(20) == null) {
                        exAmount = exAmount.add(findNum.multiply(pexUnitPrice));
                        revolvingleasedetailVO.setCompensateAccount(exAmount);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(20))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'赔偿金额((除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{

                        }
                    }*/

                 /*      BigDecimal inAmount = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(21)) || datas.get(21) == null) {
                        inAmount = inAmount.add(findNum.multiply(pinUnitPrice));
                        revolvingleasedetailVO.setTaxCompensateAccount(inAmount);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(21))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'赔偿金额((含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            revolvingleasedetailVO.setTaxCompensateAccount(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) : null);// 赔偿金额((含税)(元)
                        }
                    }*/
                    revolvingleasedetailVO.setCompensateAccount(ComputeUtil.safeMultiply(revolvingleasedetailVO.getLossDamage() == null ? BigDecimal.ZERO:revolvingleasedetailVO.getLossDamage(),revolvingleasedetailVO.getCompensateUnitprice() == null ? BigDecimal.ZERO:revolvingleasedetailVO.getCompensateUnitprice()));// 赔偿金额((除税)(元)
                    revolvingleasedetailVO.setTaxCompensateAccount(ComputeUtil.safeMultiply(revolvingleasedetailVO.getLossDamage() == null ? BigDecimal.ZERO:revolvingleasedetailVO.getLossDamage(),revolvingleasedetailVO.getTaxCompensateUnitprice() == null ? BigDecimal.ZERO:revolvingleasedetailVO.getTaxCompensateUnitprice()));// 赔偿金额((含税)(元)
                    BigDecimal cleanEx = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(22)) || datas.get(22) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'清理维修费非等其他费用(除税)(元)'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    } else {
                        if (!NumberUtil.isNumber(datas.get(22))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'清理维修费非等其他费用(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            revolvingleasedetailVO.setOtherExpenses(StringUtils.isNotBlank(datas.get(22)) ? new BigDecimal(datas.get(22)) : null);// 清理维修费非等其他费用(除税)(元)
                        }
                    }

                    if (StringUtils.isBlank(datas.get(23)) || datas.get(23) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'清理维修费非等其他费用(含税)(元)'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    } else {
                        if (!NumberUtil.isNumber(datas.get(23))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'清理维修费非等其他费用(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            revolvingleasedetailVO.setTaxOtherExpenses(StringUtils.isNotBlank(datas.get(23)) ? new BigDecimal(datas.get(23)) : null);// 清理维修费非等其他费用(含税)(元)
                        }
                     }

  /*                  if (datas.get(24) != null || StringUtils.isBlank(datas.get(24))) {
                        BigDecimal monthlyExpenses = BigDecimalUtils.ofNullable(revolvingleasedetailVO.getLesseeTotalprice())
                                .add(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getCompensateAccount()))
                                .add(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getOtherExpenses()));
                        revolvingleasedetailVO.setMonthlyExpenses(monthlyExpenses);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(24))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'月度结算费用(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            revolvingleasedetailVO.setMonthlyExpenses(StringUtils.isNotBlank(datas.get(24)) ? new BigDecimal(datas.get(24)) : null);// 月度结算费用(除税)(元)
                        }
                    }*/

          /*          if (datas.get(25) != null || StringUtils.isBlank(datas.get(25))) {
                        BigDecimal taxMonthlyExpenses = BigDecimalUtils.ofNullable(revolvingleasedetailVO.getTaxLesseeTotalprice())
                                .add(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getTaxCompensateAccount()))
                                .add(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getTaxOtherExpenses()));
                        revolvingleasedetailVO.setTaxMonthlyExpenses(taxMonthlyExpenses);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(25))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'月度结算费用(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            revolvingleasedetailVO.setTaxMonthlyExpenses(StringUtils.isNotBlank(datas.get(25)) ? new BigDecimal(datas.get(25)) : null);// 月度结算费用(含税)(元)
                        }
                    }*/
                   //本期结算费用(除税)(元)  monthlyExpenses  本期结算费用(含税)(元) taxMonthlyExpenses
                    revolvingleasedetailVO.setMonthlyExpenses(ComputeUtil.safeAdd(revolvingleasedetailVO.getLesseeTotalprice(),revolvingleasedetailVO.getCompensateAccount(),revolvingleasedetailVO.getOtherExpenses()));
                    revolvingleasedetailVO.setTaxMonthlyExpenses(ComputeUtil.safeAdd(revolvingleasedetailVO.getTaxLesseeTotalprice(),revolvingleasedetailVO.getTaxCompensateAccount(),revolvingleasedetailVO.getTaxOtherExpenses()));// taxLesseeTotalprice   taxCompensateAccount taxOtherExpenses
                    revolvingleasedetailVO.setRemarks(StringUtils.isNotBlank(datas.get(34)) ? String.valueOf(datas.get(34)) : null); // 备注

                    RevolvingleasedetailVO  revolvingleasedetailVO1 = revolvingleaseService.queryDetailList(contractId,revolvingleasedetailVO.getEncode(),revolvingleasedetailVO.getMaterialCode());
                    if(revolvingleasedetailVO1 != null){
                        revolvingleasedetailVO.setSumRentMoney(ComputeUtil.safeAdd(revolvingleasedetailVO1.getSumRentMoney(),revolvingleasedetailVO.getLesseeTotalprice()));
                        revolvingleasedetailVO.setSumRentMoneyTax(ComputeUtil.safeAdd(revolvingleasedetailVO1.getSumRentMoneyTax(),revolvingleasedetailVO.getTaxLesseeTotalprice()));
                        revolvingleasedetailVO.setSumCompensationMoney(ComputeUtil.safeAdd(revolvingleasedetailVO1.getSumCompensationMoney(),revolvingleasedetailVO.getCompensateAccount()));
                        revolvingleasedetailVO.setSumCompensationMoneyTax(ComputeUtil.safeAdd(revolvingleasedetailVO1.getSumCompensationMoneyTax(),revolvingleasedetailVO.getTaxCompensateAccount()));
                        revolvingleasedetailVO.setSumFeeMoney(ComputeUtil.safeAdd(revolvingleasedetailVO1.getSumFeeMoney(),revolvingleasedetailVO.getOtherExpenses()));
                        revolvingleasedetailVO.setSumFeeMoneyTax(ComputeUtil.safeAdd(revolvingleasedetailVO1.getSumFeeMoneyTax(),revolvingleasedetailVO.getTaxOtherExpenses()));
                        revolvingleasedetailVO.setCumulativeAmount(ComputeUtil.safeAdd(revolvingleasedetailVO1.getCumulativeAmount(),revolvingleasedetailVO.getMonthlyExpenses()));
                        revolvingleasedetailVO.setTaxCumulativeAmount(ComputeUtil.safeAdd(revolvingleasedetailVO1.getTaxCumulativeAmount(),revolvingleasedetailVO.getTaxMonthlyExpenses()));
                        revolvingleasedetailVO.setLeaseDaysSumTime(ComputeUtil.safeAdd(revolvingleasedetailVO1.getLeaseDaysSumTime(),new BigDecimal(revolvingleasedetailVO.getLesseeTerm())));
                    }else{
                        revolvingleasedetailVO.setSumRentMoney(revolvingleasedetailVO.getLesseeTotalprice());
                        revolvingleasedetailVO.setSumRentMoneyTax(revolvingleasedetailVO.getTaxLesseeTotalprice());
                        revolvingleasedetailVO.setSumCompensationMoney(revolvingleasedetailVO.getCompensateAccount());
                        revolvingleasedetailVO.setSumCompensationMoneyTax(revolvingleasedetailVO.getTaxCompensateAccount());

                        revolvingleasedetailVO.setSumFeeMoney(revolvingleasedetailVO.getOtherExpenses());
                        revolvingleasedetailVO.setSumFeeMoneyTax(revolvingleasedetailVO.getTaxOtherExpenses());
                        revolvingleasedetailVO.setCumulativeAmount(revolvingleasedetailVO.getMonthlyExpenses());
                        revolvingleasedetailVO.setTaxCumulativeAmount(revolvingleasedetailVO.getTaxMonthlyExpenses());
                        revolvingleasedetailVO.setLeaseDaysSumTime(revolvingleasedetailVO.getLesseeTerm() == null ? BigDecimal.ZERO : new BigDecimal(revolvingleasedetailVO.getLesseeTerm()));
                    }
                    //塞入往期汇总数据
                    revolvingleasedetailVO.setSumRentMoneyPast(revolvingleasedetailVO.getSumRentMoney());
                    revolvingleasedetailVO.setSumRentMoneyTaxPast(revolvingleasedetailVO.getSumRentMoneyTax());
                    revolvingleasedetailVO.setSumCompensationMoneyPast(revolvingleasedetailVO.getSumCompensationMoney());
                    revolvingleasedetailVO.setSumCompensationMoneyTaxPast(revolvingleasedetailVO.getSumCompensationMoneyTax());
                    revolvingleasedetailVO.setSumFeeMoneyPast(revolvingleasedetailVO.getSumFeeMoney());
                    revolvingleasedetailVO.setSumFeeMoneyTaxPast(revolvingleasedetailVO.getSumFeeMoneyTax());
                    revolvingleasedetailVO.setCumulativeAmountPast(revolvingleasedetailVO.getCumulativeAmount());
                    revolvingleasedetailVO.setTaxCumulativeAmountPast(revolvingleasedetailVO.getTaxCumulativeAmount());
                    if (num1 > 0){
                        errorList.add(revolvingleasedetailVO);
                    }else{
                        successList.add(revolvingleasedetailVO);
                    }
                }
            }
        }

        //填充往期数据
        getLastDetail(contractId,successList);

        //按子目编码排序
        Collections.sort(successList, new Comparator<RevolvingleasedetailVO>() {
            @Override
            public int compare(RevolvingleasedetailVO o1, RevolvingleasedetailVO o2) {
                return (o1.getEncode() + o1.getSection()).compareTo(o2.getEncode() + o2.getSection());
            }
        });
        //设置tid和tpid
        List<RevolvingleasedetailVO> resList = setTidAndTpid(successList, mapVO);
        //获取子集,汇总数据
        List<String> tpidList = resList.stream().map(RevolvingleasedetailVO::getTpid).collect(Collectors.toList());
        for(RevolvingleasedetailVO revolvingleasedetailVO : resList){
            List<RevolvingleasedetailVO> detailByPid = getDetailByPid(revolvingleasedetailVO.getTid(), resList);
            if (CollectionUtils.isNotEmpty(detailByPid)){
                revolvingleasedetailVO.setSettleTime(null);
                revolvingleasedetailVO.setSettleTimeShow(null);
                revolvingleasedetailVO.setLesseeTerm(null);
                revolvingleasedetailVO.setLesseeQuantity(null);
                revolvingleasedetailVO.setLesseeUnitprice(null);
                revolvingleasedetailVO.setTaxLesseeUnitprice(null);
                revolvingleasedetailVO.setLossDamage(null);
                revolvingleasedetailVO.setCompensateUnitprice(null);
                revolvingleasedetailVO.setTaxCompensateUnitprice(null);
                revolvingleasedetailVO.setOtherExpenses(null);
                revolvingleasedetailVO.setTaxOtherExpenses(null);
                revolvingleasedetailVO.setEndTimeShow(null);

                BigDecimal lesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeTotalprice() != null).map(RevolvingleasedetailVO::getLesseeTotalprice)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxLesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxLesseeTotalprice() != null).map(RevolvingleasedetailVO::getTaxLesseeTotalprice)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal compensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCompensateAccount() != null).map(RevolvingleasedetailVO::getCompensateAccount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxCompensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCompensateAccount() != null).map(RevolvingleasedetailVO::getTaxCompensateAccount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal monthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getMonthlyExpenses() != null).map(RevolvingleasedetailVO::getMonthlyExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxMonthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxMonthlyExpenses() != null).map(RevolvingleasedetailVO::getTaxMonthlyExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumRentMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoney() != null).map(RevolvingleasedetailVO::getSumRentMoney)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumRentMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoneyTax() != null).map(RevolvingleasedetailVO::getSumRentMoneyTax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumCompensationMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoney() != null).map(RevolvingleasedetailVO::getSumCompensationMoney)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumCompensationMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoneyTax() != null).map(RevolvingleasedetailVO::getSumCompensationMoneyTax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumFeeMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoney() != null).map(RevolvingleasedetailVO::getSumFeeMoney)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumFeeMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoneyTax() != null).map(RevolvingleasedetailVO::getSumFeeMoneyTax)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal cumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCumulativeAmount() != null).map(RevolvingleasedetailVO::getCumulativeAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxCumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCumulativeAmount() != null).map(RevolvingleasedetailVO::getTaxCumulativeAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal otherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getOtherExpenses() != null).map(RevolvingleasedetailVO::getOtherExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxOtherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxOtherExpenses() != null).map(RevolvingleasedetailVO::getTaxOtherExpenses)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);

                revolvingleasedetailVO.setOtherExpenses(otherExpenses);
                revolvingleasedetailVO.setTaxOtherExpenses(taxOtherExpenses);
                revolvingleasedetailVO.setLesseeTotalprice(lesseeTotalprice);
                revolvingleasedetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);
                revolvingleasedetailVO.setCompensateAccount(compensateAccount);
                revolvingleasedetailVO.setTaxCompensateAccount(taxCompensateAccount);
                revolvingleasedetailVO.setMonthlyExpenses(monthlyExpenses);
                revolvingleasedetailVO.setTaxMonthlyExpenses(taxMonthlyExpenses);
                revolvingleasedetailVO.setSumRentMoney(sumRentMoney);
                revolvingleasedetailVO.setSumRentMoneyTax(sumRentMoneyTax);
                revolvingleasedetailVO.setSumCompensationMoney(sumCompensationMoney);
                revolvingleasedetailVO.setSumCompensationMoneyTax(sumCompensationMoneyTax);
                revolvingleasedetailVO.setSumFeeMoney(sumFeeMoney);
                revolvingleasedetailVO.setSumFeeMoneyTax(sumFeeMoneyTax);
                revolvingleasedetailVO.setCumulativeAmount(cumulativeAmount);
                revolvingleasedetailVO.setTaxCumulativeAmount(taxCumulativeAmount);
                subList.clear();
            }
        }
        //构建树
        resList = createTreeData(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", resList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);

    }


    private void getLastDetail(Long contractId, List<RevolvingleasedetailVO> successList) {
        LambdaQueryWrapper<RevolvingleaseEntity> lambdaLast = Wrappers.<RevolvingleaseEntity>lambdaQuery();
        lambdaLast.eq(RevolvingleaseEntity::getContractId, contractId);
        lambdaLast.in(RevolvingleaseEntity::getBillState, 1,3);
        lambdaLast.orderByDesc(RevolvingleaseEntity::getCreateTime);
        List<RevolvingleaseEntity> costanalysisEntityList = revolvingleaseService.list(lambdaLast);
        List<RevolvingleasedetailEntity> subcontractingvolumedetailEntityList = new ArrayList<>();
        Map<String, List<RevolvingleasedetailVO>> groupMap = new HashMap<>();
        Map<String, List<RevolvingleasedetailVO>> groupLastMap = new HashMap<>();
        DecimalFormat decimalFormat  = new DecimalFormat("0.00000000");
        if(CollectionUtils.isNotEmpty(costanalysisEntityList)){
            RevolvingleaseEntity subcontractingvolumeEntityLast = costanalysisEntityList.stream().findFirst().get();
            LambdaQueryWrapper<RevolvingleasedetailEntity> lambdaCostPeople = Wrappers.<RevolvingleasedetailEntity>lambdaQuery();
            lambdaCostPeople.eq(RevolvingleasedetailEntity::getMid, subcontractingvolumeEntityLast.getId());
            subcontractingvolumedetailEntityList = revolvingleasedetailService.list(lambdaCostPeople);
        }

        groupMap = successList.stream().filter(s-> !(s.getRowState() != null && s.getRowState().equals("del"))).collect(
                Collectors.groupingBy(
                        s -> s.getEncode() +'-' + s.getSection()
                ));
        List<RevolvingleasedetailVO> subcontractingvolumedetailVOS = BeanMapper.mapList(subcontractingvolumedetailEntityList, RevolvingleasedetailVO.class);
        List<RevolvingleasedetailVO> collect = subcontractingvolumedetailVOS.stream().filter(s -> s.getLesseeQuantity () != null).collect(Collectors.toList());
        for (RevolvingleasedetailVO subcontractingvolumedetailEntity : collect){
            String key = subcontractingvolumedetailEntity.getEncode() +'-' + subcontractingvolumedetailEntity.getSection();
            if (!groupMap.containsKey(key)) {
                subcontractingvolumedetailEntity.setLesseeQuantity(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setLesseeTotalprice(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxLesseeTotalprice(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setLossDamage(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setCompensateAccount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxCompensateAccount(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setOtherExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxOtherExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setMonthlyExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setTaxMonthlyExpenses(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setId(IdWorker.getId());
                subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.上期数据.getCode());
                subcontractingvolumedetailEntity.setMid(null);

                successList.add(subcontractingvolumedetailEntity);
            }
        }

        groupLastMap = collect.stream().filter(s-> !(s.getRowState() != null && s.getRowState().equals("del"))).collect(
                Collectors.groupingBy(
                        s -> s.getEncode() +'-' + s.getSection()
                ));
        for (RevolvingleasedetailVO subcontractingvolumedetailEntity : successList){
            String key = subcontractingvolumedetailEntity.getEncode() +'-' + subcontractingvolumedetailEntity.getSection();
            if (groupLastMap.containsKey(key)) {
                subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.上期数据.getCode());
            }
        }

    }



    List<RevolvingleasedetailVO> subList = new ArrayList<>();
    private List<RevolvingleasedetailVO> getDetailByPid(String tid, List<RevolvingleasedetailVO> list) {

        for (RevolvingleasedetailVO revolvingleasedetailVO : list) {
            if (tid != null && tid.equals(revolvingleasedetailVO.getTpid())) {
                getDetailByPid(revolvingleasedetailVO.getTid(), list);
                subList.add(revolvingleasedetailVO);
            }
        }
        return subList;
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<RevolvingleasedetailVO> createTreeData(List<RevolvingleasedetailVO> list) {
        List<RevolvingleasedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, RevolvingleasedetailVO> listMap = new HashMap<>();
        for (RevolvingleasedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            RevolvingleasedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            RevolvingleasedetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<RevolvingleasedetailVO> child = (List<RevolvingleasedetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<RevolvingleasedetailVO> children = new ArrayList<RevolvingleasedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }


    /**
     * 设置tid和tpid
     *
     * @param vos
     * @param map
     * @return
     */
    private List<RevolvingleasedetailVO> setTidAndTpid(List<RevolvingleasedetailVO> vos, Map<String, RevolvingleasedetailVO> map) {
        if(vos == null){
            return null;
        }

        for (int i = 0; i < vos.size(); i++) {
            RevolvingleasedetailVO consdrawbudgetdetailVO = vos.get(i);
            //设置父级id
            String innercode = consdrawbudgetdetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }

            Long pid = null;
            if (innercodeSub.length() == 2) {
                //最上级
            } else if (innercodeSub.length() == 4) {
                String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() == 6) {
                String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() > 6) {
                String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            }


            if (pid != null) {
                consdrawbudgetdetailVO.setTpid(pid.toString());
            } else {
                consdrawbudgetdetailVO.setTpid("");
            }
        }

        return vos;
    }


    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, RevolvingleasedetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleaseFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleaseFromDatabase(@RequestBody RevolvingleaseVO revolvingleaseVO, HttpServletResponse response) {
        QueryWrapper<RevolvingleasedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", revolvingleaseVO.getId());
        queryWrapper.eq("dr", 0);
        List<RevolvingleasedetailEntity> list = revolvingleasedetailService.list(queryWrapper);
        List<RevolvingleasedetailVO> revolvingleasedetailVOList = BeanMapper.mapList(list, RevolvingleasedetailVO.class);
        if (revolvingleasedetailVOList != null && revolvingleasedetailVOList.size() > 0) {
            for (int i = 0; i < revolvingleasedetailVOList.size(); i++) {
                RevolvingleasedetailVO revolvingleasedetailVO = revolvingleasedetailVOList.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() != null) {
                    revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", revolvingleasedetailVOList);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleaseFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleaseFromPage(@RequestBody List<RevolvingleasedetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                RevolvingleasedetailVO revolvingleasedetailVO = list.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() != null) {
                    revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId 合同id
     * @param currentDate 本期日期
     * @param isSave true保存 false查询
     * @return
     */
    private RevolvingleaseVO getPastTotalData(Long contractId, Date currentDate, boolean isSave) {
        //创建条件构造器
        QueryWrapper<RevolvingleaseEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<RevolvingleaseEntity> proTotal = revolvingleaseService.list(queryWrapperTotal);
        List<RevolvingleasedetailEntity> revolvingleasedetailEntityList = new ArrayList<>();

        //累计发生(除税)
        BigDecimal occurrenceTotal = new BigDecimal(0);
        //累计发生(含税)
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);

        if(proTotal != null && proTotal.size() > 0){
    /*        for (int i = 0; i < proTotal.size(); i++) {


            }*/
            RevolvingleaseEntity revolvingleaseEntity = proTotal.get(0);
            BigDecimal Total = revolvingleaseEntity.getTotal();
            BigDecimal TaxTotal= revolvingleaseEntity.getTaxTotal();


            if(occurrenceTotal != null && Total != null )
            { occurrenceTotal = occurrenceTotal.add(revolvingleaseEntity.getTotal());}
            if(taxOccurrenceTotal != null && TaxTotal != null )
                taxOccurrenceTotal = taxOccurrenceTotal.add(revolvingleaseEntity.getTaxTotal());

            if (isSave) {
                QueryWrapper<RevolvingleasedetailEntity> detailWrapper = new QueryWrapper<>();
                detailWrapper.eq("mid", revolvingleaseEntity.getId());
                List<RevolvingleasedetailEntity> detailList = revolvingleasedetailService.list(detailWrapper);
                revolvingleasedetailEntityList.addAll(detailList);
            }
        }

        RevolvingleaseVO vo = new RevolvingleaseVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);

        vo.setContractId(contractId);
        //往期所有子表 entity和vo转换
        vo.setRevolvingleasedetailEntities(BeanMapper.mapList(revolvingleasedetailEntityList, RevolvingleasedetailVO.class));

        return vo;
    }


}
