package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.ConsultotherdetailEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetailEntity;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.service.IConsultotherdetailService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleaseVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultotherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinalOtherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinaldetailVO;
import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.ConsultotherMapper;
import com.ejianc.business.middlemeasurement.bean.ConsultotherEntity;
import com.ejianc.business.middlemeasurement.service.IConsultotherService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 咨询及其他类合同过程结算单
 *
 * @author generator
 *
 */
@Service("consultotherService")
public class ConsultotherServiceImpl extends BaseServiceImpl<ConsultotherMapper, ConsultotherEntity> implements IConsultotherService{
    @Autowired
    private ConsultotherMapper mapper;
    @Autowired
    private IConsultotherdetailService consultotherdetailService;
    @Autowired
    private IConsultotherService service;

    @Override
    public List<CostManageVO> queryConsultother(Long projectId,String monthStr) {
        return mapper.queryConsultother(projectId,monthStr);
    }

    @Override
    public List<CostManageVO> queryConsultotherMonth(Long projectId, String monthStr) {
        BigDecimal curExTaxAmount = BigDecimal.ZERO;
        List<CostManageVO> costManageVOS1 = mapper.queryConsultotherMonth(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS1) {
            curExTaxAmount = curExTaxAmount.add(costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice());
        }
        List<CostManageVO> costManageVOS = mapper.queryConsultotherOtherdetailMonth(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS) {
            curExTaxAmount = curExTaxAmount.subtract(costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice());
        }
        CostManageVO costManageVO = new CostManageVO();
        costManageVO.setTotalPrice(curExTaxAmount);
        List<CostManageVO> list = new ArrayList<>();
        list.add(costManageVO);
        return list;
    }

    @Override
    public ConsultotherdetailVO queryConsultotherPastData(ConsultotherdetailVO vo) {
        String rowState = vo.getRowState();
        if("add".equals(rowState)) {
            //查询该清单编码往期累计
            //创建条件构造器
            QueryWrapper<ConsultotherdetailEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id", vo.getContractId());
            queryWrapper.eq("subitem_name", vo.getSubitemName());
            queryWrapper.eq("spec", vo.getSpec());
            queryWrapper.eq("unit", vo.getUnit());
            queryWrapper.eq("unitprice", vo.getUnitprice());
            queryWrapper.eq("tax_unitprice", vo.getTaxUnitprice());
            queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
            queryWrapper.orderByDesc("create_time");//最新往期
            queryWrapper.last("limit 1");
            List<ConsultotherdetailEntity> pastDetails = consultotherdetailService.list(queryWrapper);
            if (pastDetails != null && pastDetails.size() > 0) {
                ConsultotherdetailEntity pastSubcontractingvolumedetail = pastDetails.get(0);
                if (pastSubcontractingvolumedetail.getDr() == 0) {
                    //数量（分包商上报累计）
                    vo.setCumulativeQuantity(pastSubcontractingvolumedetail.getCumulativeQuantity());
                    //除税金额（分包商上报累计）
                    vo.setCumulativeAmounts(pastSubcontractingvolumedetail.getCumulativeAmounts());
                    //含税金额（分包商上报累计）
                    vo.setCumulativeTaxAmounts(pastSubcontractingvolumedetail.getCumulativeTaxAmounts());
                    //数量（项目部审核累计）
                    vo.setExamineCumulativeQuantity(pastSubcontractingvolumedetail.getExamineCumulativeQuantity());
                    //除税金额（项目部审核累计）
                    vo.setExamineCumulativeAmounts(pastSubcontractingvolumedetail.getExamineCumulativeAmounts());
                    //含税金额（项目部审核累计）
                    vo.setExamineCumulativeTaxAmounts(pastSubcontractingvolumedetail.getExamineCumulativeTaxAmounts());
                }
            }
        }
        return vo;
    }

    @Override
    public List<ConsultfinalOtherdetailVO> queryConsultOtherDetailCumPast(Long contractId, String date) {
        return mapper.queryConsultOtherDetailCumPast(contractId,date);
    }

    @Override
    public List<ConsultfinaldetailVO> queryConsultDetailCumPast(Long contractId, String date) {
        return mapper.queryConsultDetailCumPast(contractId,date);
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<ConsultotherEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( reporting_time, '%Y-%m' )",monthStr);
        List<ConsultotherEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (ConsultotherEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<ConsultotherEntity> query = new LambdaQueryWrapper<ConsultotherEntity>()
                .eq(ConsultotherEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(ConsultotherEntity::getIsSettlement)
                        .or().eq(ConsultotherEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("咨询及其它中间计量有往期未归集的数据");
        LambdaQueryWrapper<ConsultotherEntity> query1 = new LambdaQueryWrapper<ConsultotherEntity>()
                .eq(ConsultotherEntity::getProjectId, projectId)
                .ne(ConsultotherEntity::getBillState, 3)
                .ne(ConsultotherEntity::getBillState, 1)
                .apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("咨询及其它中间计量有本期审批未通过的数据");
        return true;
    }

    @Override
    public List<ConsultotherdetailVO> queryConsultotherdetail(String contractId,
                                                              String monthStr,
                                                              String subitemName,
                                                              String spec,
                                                              String unit,
                                                              String unitprice,
                                                              String taxUnitprice) {
        Map<String,String> map = new HashMap<>();
        map.put("contractId",contractId);
        map.put("reportingTime",monthStr);
        map.put("subitemName",subitemName);
        map.put("spec",spec);
        map.put("unit",unit);
        map.put("unitprice",unitprice);
        map.put("taxUnitprice",taxUnitprice);
        return mapper.queryConsultotherdetail(map);
    }

    @Override
    public List<ConsultotherdetailVO> getPastDetailData(Long contractId) {

        //创建条件构造器
        QueryWrapper<ConsultotherEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("dr", 0);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.orderByDesc("create_time");
        queryWrapperTotal.last("limit 1");

        List<ConsultotherEntity> proTotal = service.list(queryWrapperTotal);
        List<ConsultotherdetailVO> subcontractingvolumedetailVOS = new ArrayList<>();
        MechanicalleaseVO vo = new MechanicalleaseVO();
        if(proTotal != null && proTotal.size() > 0){
            ConsultotherEntity pastEntity = proTotal.get(0);
            vo = BeanMapper.map(pastEntity, MechanicalleaseVO.class);
            //查询子表-月度（中间）计量计价明细表数据
            LambdaQueryWrapper<ConsultotherdetailEntity> lambdaCostPeople = Wrappers.<ConsultotherdetailEntity>lambdaQuery();
            lambdaCostPeople.eq(ConsultotherdetailEntity::getMid, pastEntity.getId());
            List<ConsultotherdetailEntity> subcontractingvolumedetailEntities = consultotherdetailService.list(lambdaCostPeople);
            subcontractingvolumedetailVOS = BeanMapper.mapList(subcontractingvolumedetailEntities, ConsultotherdetailVO.class);
            List<ConsultotherdetailVO> collect = subcontractingvolumedetailVOS.stream().filter(s -> s.getExamineQuantity() != null).collect(Collectors.toList());

            for(ConsultotherdetailVO subcontractingvolumedetailEntity : collect){
                subcontractingvolumedetailEntity.setExamineQuantity(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setExamineAmounts(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setExamineTaxAmounts(BigDecimal.ZERO);
                subcontractingvolumedetailEntity.setId(IdWorker.getId());
                subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.上期数据.getCode());
                subcontractingvolumedetailEntity.setMid(null);
            }
        }

        return subcontractingvolumedetailVOS;
    }

}
