package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementPayeeDetailService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.EngineermeasurementMapper;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 工程计量台账
 * 
 * @author generator
 * 
 */
@Service("engineermeasurementService")
public class EngineermeasurementServiceImpl extends BaseServiceImpl<EngineermeasurementMapper, EngineermeasurementEntity> implements IEngineermeasurementService{
    @Autowired
    private IEngineermeasurementService service;
    @Autowired
    private IEngineermeasurementPayeeDetailService payeeDetailService;

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<EngineermeasurementEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( reporting_time, '%Y-%m' )",monthStr);
        List<EngineermeasurementEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (EngineermeasurementEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<EngineermeasurementEntity> query = new LambdaQueryWrapper<EngineermeasurementEntity>()
                .eq(EngineermeasurementEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(EngineermeasurementEntity::getIsSettlement)
                        .or().eq(EngineermeasurementEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("工程计量台账有往期未归集的数据");
        LambdaQueryWrapper<EngineermeasurementEntity> query1 = new LambdaQueryWrapper<EngineermeasurementEntity>()
                .eq(EngineermeasurementEntity::getProjectId, projectId)
                .ne(EngineermeasurementEntity::getBillState, 3)
                .ne(EngineermeasurementEntity::getBillState, 1)
                .apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("工程计量台账有本期审批未通过的数据");
        return true;
    }

    @Override
    public String updateSumData(Long projectId, Long contractId,Integer type) {

        //查询所有付款信息数据求和汇总
        LambdaQueryWrapper<EngineermeasurementPayeeDetailEntity> lambda = Wrappers.<EngineermeasurementPayeeDetailEntity>lambdaQuery();
//        lambda.eq(EngineermeasurementPayeeDetailEntity::getPid, saveOrUpdateVO.getId());
        List<EngineermeasurementPayeeDetailEntity> engineermeasurementPayeeDetailEntities = payeeDetailService.list(lambda);
        Map<Long, BigDecimal> numInMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(engineermeasurementPayeeDetailEntities)){
             numInMap = engineermeasurementPayeeDetailEntities.stream().filter(s -> s.getNowPaymentMny()!=null).collect(Collectors.groupingBy(EngineermeasurementPayeeDetailEntity::getPid,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getNowPaymentMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        LambdaQueryWrapper<EngineermeasurementEntity> query = new LambdaQueryWrapper<EngineermeasurementEntity>();
        query.eq(projectId != null,EngineermeasurementEntity::getProjectId, projectId);
        query.eq(contractId != null,EngineermeasurementEntity::getContractId, contractId);

        List<EngineermeasurementEntity> engineermeasurementEntityList = service.list(query);

        if (CollectionUtils.isNotEmpty(engineermeasurementEntityList)){
//            for (EngineermeasurementEntity interimsettlementdetailEntity : engineermeasurementEntityList) {
//                //刷新本期收款金额
//                if (numInMap.containsKey(interimsettlementdetailEntity.getId())) {
//                    interimsettlementdetailEntity.setCurrentCollection(numInMap.get(interimsettlementdetailEntity.getId()));
//                }
//            }

            for (EngineermeasurementEntity interimsettlementdetailEntity : engineermeasurementEntityList){
//                //刷新本期收款金额
//                if (numInMap.containsKey(interimsettlementdetailEntity.getId())){
//                    interimsettlementdetailEntity.setCurrentCollection(numInMap.get(interimsettlementdetailEntity.getId()));
//                }
                if (type == 1){
                    //刷新累计收款金额
                    BigDecimal currentCollection = engineermeasurementEntityList.stream().filter(s -> s.getId() <= interimsettlementdetailEntity.getId() && s.getContractId().equals(interimsettlementdetailEntity.getContractId()) && s.getCurrentCollection() != null).map(EngineermeasurementEntity::getCurrentCollection)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    interimsettlementdetailEntity.setCumulativeCollection(currentCollection);
                }

                if (type == 2){
                    //刷新累计实际完成量
                    BigDecimal actualCompletedThisPeriod = engineermeasurementEntityList.stream().filter(s -> s.getId() <= interimsettlementdetailEntity.getId() && s.getContractId().equals(interimsettlementdetailEntity.getContractId()) && s.getActualCompletedThisPeriod() != null).map(EngineermeasurementEntity::getActualCompletedThisPeriod)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    interimsettlementdetailEntity.setCumulativeCompleted(actualCompletedThisPeriod);
                }
                if (type == 3){
                    //刷新累计批量
                    BigDecimal currentBatch = engineermeasurementEntityList.stream().filter(s -> s.getId() <= interimsettlementdetailEntity.getId() && s.getContractId().equals(interimsettlementdetailEntity.getContractId()) && s.getCurrentBatch() != null).map(EngineermeasurementEntity::getCurrentBatch)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    interimsettlementdetailEntity.setCumulativeBatch(currentBatch);
                }
                if (type == 4){
                    //刷新累计合同约定应收款金额
                    BigDecimal currentReceivables = engineermeasurementEntityList.stream().filter(s -> s.getId() <= interimsettlementdetailEntity.getId() && s.getContractId().equals(interimsettlementdetailEntity.getContractId()) && s.getCurrentReceivables() != null).map(EngineermeasurementEntity::getCurrentReceivables)
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    interimsettlementdetailEntity.setAccumulatedContractualReceivables(currentReceivables);
                }

            }
            service.updateBatchById(engineermeasurementEntityList);
        }


        return "";
    }
}
